/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.io.Serializable;
import org.alfresco.repo.jscript.Scopeable;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.jscript.ValueConverter;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.mozilla.javascript.Scriptable;
import org.springframework.extensions.surf.util.ParameterCheck;

public class ChildAssociation
implements Scopeable,
Serializable {
    private static final long serialVersionUID = -2122640697340663213L;
    private ServiceRegistry services;
    private Scriptable scope;
    private ChildAssociationRef childAssocRef;

    public ChildAssociation(ServiceRegistry services, ChildAssociationRef childAssocRef) {
        this(services, childAssocRef, null);
    }

    public ChildAssociation(ServiceRegistry services, ChildAssociationRef childAssocRef, Scriptable scope) {
        ParameterCheck.mandatory((String)"Service registry", (Object)services);
        ParameterCheck.mandatory((String)"Child association reference", (Object)childAssocRef);
        this.services = services;
        this.childAssocRef = childAssocRef;
        if (scope != null) {
            this.scope = scope;
        }
    }

    public void setScope(Scriptable scope) {
        this.scope = scope;
    }

    public ChildAssociationRef getChildAssociationRef() {
        return this.childAssocRef;
    }

    public String getType() {
        return this.childAssocRef.getTypeQName().toString();
    }

    public String getName() {
        return this.childAssocRef.getQName().toString();
    }

    public ScriptNode getParent() {
        return (ScriptNode)new ValueConverter().convertValueForScript(this.services, this.scope, null, (Serializable)this.childAssocRef.getParentRef());
    }

    public ScriptNode getChild() {
        return (ScriptNode)new ValueConverter().convertValueForScript(this.services, this.scope, null, (Serializable)this.childAssocRef.getChildRef());
    }

    public boolean isPrimary() {
        return this.childAssocRef.isPrimary();
    }

    public int getNthSibling() {
        return this.childAssocRef.getNthSibling();
    }
}

