/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.util.Collections;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TempFileMarkerInterceptor
implements MethodInterceptor {
    private static Log logger = LogFactory.getLog(TempFileMarkerInterceptor.class);
    private NodeService nodeService;
    private List<String> filterRegularExpressions = Collections.emptyList();

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFilterRegularExpressions(List<String> regexps) {
        this.filterRegularExpressions = regexps;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object ret = invocation.proceed();
        String methodName = invocation.getMethod().getName();
        if (methodName.startsWith("create") || methodName.startsWith("rename") || methodName.startsWith("move") || methodName.startsWith("copy")) {
            FileInfo fileInfo = (FileInfo)ret;
            String filename = fileInfo.getName();
            NodeRef nodeRef = fileInfo.getNodeRef();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Checking filename returned by " + methodName + ": " + filename));
            }
            boolean matched = false;
            for (String regexp : this.filterRegularExpressions) {
                if (!filename.matches(regexp)) continue;
                matched = true;
                this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_TEMPORARY, null);
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Applied temporary marker: " + fileInfo));
                break;
            }
            if (!matched && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TEMPORARY)) {
                this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_TEMPORARY);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Removed temporary marker: " + fileInfo));
                }
            }
        }
        return ret;
    }
}

