/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder.loader;

import java.io.File;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.filefolder.loader.AbstractLoaderThread;
import org.alfresco.repo.model.filefolder.loader.LoaderServerProxy;
import org.alfresco.repo.model.filefolder.loader.LoaderSession;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.springframework.util.FileCopyUtils;

public class LoaderDeleteThread
extends AbstractLoaderThread {
    private FileInfo[] filesInfo;
    private int filesPerIteration;

    public LoaderDeleteThread(LoaderSession loaderSession, String loaderName, long testPeriod, long testTotal, long testLoadDepth, boolean verbose, long filesPerIteration) {
        super(loaderSession, loaderName, testPeriod, testTotal, testLoadDepth, verbose);
        this.filesPerIteration = (int)filesPerIteration;
    }

    protected String doLoading(LoaderServerProxy loaderServerProxy, NodeRef nodeRef) throws Exception {
        loaderServerProxy.fileFolderRemote.delete(loaderServerProxy.ticket, this.getNodesRef(this.filesInfo));
        String msg = String.format("Deleted %d files from folder: %s", this.filesInfo.length, nodeRef.toString());
        return msg;
    }

    protected void doBefore(LoaderServerProxy loaderServerProxy, NodeRef workingRootNodeRef) throws Exception {
        List<String> folderPath = super.chooseFolderPath();
        NodeRef folderNodeRef = this.makeFolders(loaderServerProxy.ticket, loaderServerProxy, workingRootNodeRef, folderPath);
        byte[][] bytes = new byte[this.filesPerIteration][];
        String[] fileNames = new String[this.filesPerIteration];
        NodeRef[] parentNodeRefs = new NodeRef[this.filesPerIteration];
        QName[] types = new QName[this.filesPerIteration];
        for (int i = 0; i < this.filesPerIteration; ++i) {
            File file = this.getFile();
            bytes[i] = FileCopyUtils.copyToByteArray((File)file);
            fileNames[i] = GUID.generate();
            parentNodeRefs[i] = folderNodeRef;
            types[i] = ContentModel.TYPE_CONTENT;
        }
        this.filesInfo = loaderServerProxy.fileFolderRemote.create(loaderServerProxy.ticket, parentNodeRefs, fileNames, types);
        loaderServerProxy.fileFolderRemote.putContent(loaderServerProxy.ticket, this.getNodesRef(this.filesInfo), bytes, fileNames);
    }

    NodeRef[] getNodesRef(FileInfo[] filesInfoList) {
        NodeRef[] nr = new NodeRef[filesInfoList.length];
        for (int i = 0; i < filesInfoList.length; ++i) {
            nr[i] = filesInfoList[i].getNodeRef();
        }
        return nr;
    }

    public String getSummary() {
        String summary = super.getSummary();
        summary = summary + String.format("%d files per iteration", this.filesPerIteration);
        return summary;
    }
}

