/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.module.ModuleDependency;
import org.alfresco.service.cmr.module.ModuleDetails;
import org.alfresco.service.cmr.module.ModuleInstallState;
import org.alfresco.util.Pair;
import org.alfresco.util.VersionNumber;
import org.springframework.extensions.surf.util.ISO8601DateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleDetailsImpl
implements ModuleDetails {
    private static final long serialVersionUID = 5782747774317351424L;
    private String id;
    private List<String> aliases = new ArrayList<String>(0);
    private VersionNumber version;
    private String title;
    private String description;
    private VersionNumber repoVersionMin = VersionNumber.VERSION_ZERO;
    private VersionNumber repoVersionMax = VersionNumber.VERSION_BIG;
    private List<ModuleDependency> dependencies = new ArrayList<ModuleDependency>(0);
    private Date installDate;
    private ModuleInstallState installState = ModuleInstallState.UNKNOWN;

    private ModuleDetailsImpl() {
    }

    public ModuleDetailsImpl(Properties properties) {
        this();
        String aliasesStr;
        Properties trimmedProperties = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String trimmedValue;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null || (trimmedValue = value.trim()).length() == 0) continue;
            trimmedProperties.setProperty(key, trimmedValue);
        }
        ArrayList<String> missingProperties = new ArrayList<String>(1);
        this.id = trimmedProperties.getProperty("module.id");
        if (this.id == null) {
            missingProperties.add("module.id");
        }
        if ((aliasesStr = trimmedProperties.getProperty("module.aliases")) != null) {
            StringTokenizer st = new StringTokenizer(aliasesStr, ",");
            while (st.hasMoreTokens()) {
                String alias = st.nextToken().trim();
                if (alias.length() == 0) continue;
                this.aliases.add(alias);
            }
        }
        if (trimmedProperties.getProperty("module.version") == null) {
            missingProperties.add("module.version");
        } else {
            this.version = new VersionNumber(trimmedProperties.getProperty("module.version"));
        }
        this.title = trimmedProperties.getProperty("module.title");
        if (this.title == null) {
            missingProperties.add("module.title");
        }
        this.description = trimmedProperties.getProperty("module.description");
        if (this.description == null) {
            missingProperties.add("module.description");
        }
        if (trimmedProperties.getProperty("module.repo.version.min") != null) {
            this.repoVersionMin = new VersionNumber(trimmedProperties.getProperty("module.repo.version.min"));
        }
        if (trimmedProperties.getProperty("module.repo.version.max") != null) {
            this.repoVersionMax = new VersionNumber(trimmedProperties.getProperty("module.repo.version.max"));
        }
        this.dependencies = ModuleDetailsImpl.extractDependencies(trimmedProperties);
        if (trimmedProperties.getProperty("module.installDate") != null) {
            String installDateStr = trimmedProperties.getProperty("module.installDate");
            try {
                this.installDate = ISO8601DateFormat.parse((String)installDateStr);
            }
            catch (Throwable e) {
                throw new AlfrescoRuntimeException("Unable to parse install date: " + installDateStr, e);
            }
        }
        if (trimmedProperties.getProperty("module.installState") != null) {
            String installStateStr = trimmedProperties.getProperty("module.installState");
            try {
                this.installState = ModuleInstallState.valueOf(installStateStr);
            }
            catch (Throwable e) {
                throw new AlfrescoRuntimeException("Unable to parse install state: " + installStateStr, e);
            }
        }
        if (missingProperties.size() > 0) {
            throw new AlfrescoRuntimeException("The following module properties need to be defined: " + missingProperties);
        }
        if (this.repoVersionMax.compareTo(this.repoVersionMin) < 0) {
            throw new AlfrescoRuntimeException("The max repo version must be greater than the min repo version:\n   ID:               " + this.id + "\n" + "   Min repo version: " + this.repoVersionMin + "\n" + "   Max repo version: " + this.repoVersionMax);
        }
        if (this.id.matches(".*[^\\w.-].*")) {
            throw new AlfrescoRuntimeException("The module ID '" + this.id + "' is invalid.  It may consist of valid characters, numbers, '.', '_' and '-'");
        }
    }

    public ModuleDetailsImpl(String id, VersionNumber versionNumber, String title, String description) {
        this();
        this.id = id;
        this.version = versionNumber;
        this.title = title;
        this.description = description;
    }

    private static List<ModuleDependency> extractDependencies(Properties properties) {
        int prefixLength = "module.depends.".length();
        ArrayList<ModuleDependency> dependencies = new ArrayList<ModuleDependency>(2);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith("module.depends.") || key.length() == prefixLength) continue;
            String dependencyId = key.substring(prefixLength);
            ModuleDependencyImpl dependency = new ModuleDependencyImpl(dependencyId, value);
            dependencies.add(dependency);
        }
        return dependencies;
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty("module.id", this.id);
        properties.setProperty("module.version", this.version.toString());
        properties.setProperty("module.title", this.title);
        properties.setProperty("module.description", this.description);
        if (this.repoVersionMin != null) {
            properties.setProperty("module.repo.version.min", this.repoVersionMin.toString());
        }
        if (this.repoVersionMax != null) {
            properties.setProperty("module.repo.version.max", this.repoVersionMax.toString());
        }
        if (this.dependencies.size() > 0) {
            for (ModuleDependency dependency : this.dependencies) {
                String key = "module.depends." + dependency.getDependencyId();
                String value = dependency.getVersionString();
                properties.setProperty(key, value);
            }
        }
        if (this.installDate != null) {
            String installDateStr = ISO8601DateFormat.format((Date)this.installDate);
            properties.setProperty("module.installDate", installDateStr);
        }
        if (this.installState != null) {
            String installStateStr = this.installState.toString();
            properties.setProperty("module.installState", installStateStr);
        }
        if (this.aliases.size() > 0) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String oldId : this.aliases) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(oldId);
                first = false;
            }
            properties.setProperty("module.aliases", sb.toString());
        }
        return properties;
    }

    public String toString() {
        return "ModuleDetails[" + this.getProperties() + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    public VersionNumber getVersion() {
        return this.version;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public VersionNumber getRepoVersionMin() {
        return this.repoVersionMin;
    }

    @Override
    public void setRepoVersionMin(VersionNumber repoVersionMin) {
        this.repoVersionMin = repoVersionMin;
    }

    @Override
    public VersionNumber getRepoVersionMax() {
        return this.repoVersionMax;
    }

    @Override
    public void setRepoVersionMax(VersionNumber repoVersionMax) {
        this.repoVersionMax = repoVersionMax;
    }

    @Override
    public List<ModuleDependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public Date getInstallDate() {
        return this.installDate;
    }

    @Override
    public void setInstallDate(Date installDate) {
        this.installDate = installDate;
    }

    @Override
    public ModuleInstallState getInstallState() {
        return this.installState;
    }

    @Override
    public void setInstallState(ModuleInstallState installState) {
        this.installState = installState;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ModuleDependencyImpl
    implements ModuleDependency {
        private static final long serialVersionUID = -6850832632316987487L;
        private String dependencyId;
        private String versionStr;
        private List<Pair<VersionNumber, VersionNumber>> versionRanges;

        private ModuleDependencyImpl(String dependencyId, String versionStr) {
            this.dependencyId = dependencyId;
            this.versionStr = versionStr;
            try {
                this.versionRanges = ModuleDependencyImpl.buildVersionRanges(versionStr);
            }
            catch (Throwable e) {
                throw new AlfrescoRuntimeException("Unable to interpret the module version ranges: " + versionStr, e);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.dependencyId).append(":").append(this.versionStr);
            return sb.toString();
        }

        private static List<Pair<VersionNumber, VersionNumber>> buildVersionRanges(String versionStr) {
            ArrayList<Pair<VersionNumber, VersionNumber>> versionRanges = new ArrayList<Pair<VersionNumber, VersionNumber>>(1);
            StringTokenizer rangesTokenizer = new StringTokenizer(versionStr, ",");
            while (rangesTokenizer.hasMoreTokens()) {
                String range = rangesTokenizer.nextToken().trim();
                if (range.equals("*")) {
                    range = "*-*";
                }
                if (range.startsWith("-")) {
                    range = "*" + range;
                }
                if (range.endsWith("-")) {
                    range = range + "*";
                }
                StringTokenizer rangeTokenizer = new StringTokenizer(range, "-", false);
                VersionNumber versionLower = null;
                VersionNumber versionUpper = null;
                while (rangeTokenizer.hasMoreTokens()) {
                    String version = rangeTokenizer.nextToken();
                    version = version.trim();
                    if (versionLower == null) {
                        if (version.equals("*")) {
                            versionLower = VersionNumber.VERSION_ZERO;
                            continue;
                        }
                        versionLower = new VersionNumber(version);
                        continue;
                    }
                    if (versionUpper != null) continue;
                    if (version.equals("*")) {
                        versionUpper = VersionNumber.VERSION_BIG;
                        continue;
                    }
                    versionUpper = new VersionNumber(version);
                }
                if (versionUpper == null && versionLower == null) {
                    throw new AlfrescoRuntimeException("Valid dependency version ranges are: \n   LOW  - HIGH \n   *    - HIGH \n   LOW  - *    \n   *       ");
                }
                if (versionUpper == null && versionLower != null) {
                    versionUpper = versionLower;
                } else if (versionLower == null && versionUpper != null) {
                    versionLower = versionUpper;
                }
                Pair rangePair = new Pair(versionLower, versionUpper);
                versionRanges.add((Pair<VersionNumber, VersionNumber>)rangePair);
            }
            return versionRanges;
        }

        @Override
        public String getDependencyId() {
            return this.dependencyId;
        }

        @Override
        public String getVersionString() {
            return this.versionStr;
        }

        @Override
        public boolean isValidDependency(ModuleDetails moduleDetails) {
            if (moduleDetails == null) {
                return false;
            }
            if (!moduleDetails.getId().equals(this.dependencyId)) {
                return false;
            }
            VersionNumber checkVersion = moduleDetails.getVersion();
            boolean matched = false;
            for (Pair<VersionNumber, VersionNumber> versionRange : this.versionRanges) {
                VersionNumber versionLower = (VersionNumber)versionRange.getFirst();
                VersionNumber versionUpper = (VersionNumber)versionRange.getSecond();
                if (checkVersion.compareTo(versionLower) < 0 || checkVersion.compareTo(versionUpper) > 0) continue;
                matched = true;
                break;
            }
            return matched;
        }
    }
}

