/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.processor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.processor.Processor;
import org.alfresco.processor.ProcessorExtension;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ScriptProcessor;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.cmr.repository.TemplateProcessor;
import org.alfresco.service.cmr.repository.TemplateService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseProcessor
implements Processor {
    protected String name;
    protected String extension;
    protected ScriptService scriptService;
    protected TemplateService templateService;
    protected ServiceRegistry services;
    protected Map<String, ProcessorExtension> processorExtensions = new HashMap<String, ProcessorExtension>(16);

    public void register() {
        if (this instanceof ScriptProcessor) {
            this.scriptService.registerScriptProcessor((ScriptProcessor)((Object)this));
        }
        if (this instanceof TemplateProcessor) {
            this.templateService.registerTemplateProcessor((TemplateProcessor)((Object)this));
        }
    }

    public void setScriptService(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    public void setTemplateService(TemplateService templateService) {
        this.templateService = templateService;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.services = serviceRegistry;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void registerProcessorExtension(ProcessorExtension processorExtension) {
        this.processorExtensions.put(processorExtension.getExtensionName(), processorExtension);
    }

    public Collection<ProcessorExtension> getProcessorExtensions() {
        return this.processorExtensions.values();
    }
}

