/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.remote;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.remote.RepoRemote;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepoRemoteService
implements RepoRemote {
    private static Log fgLogger = LogFactory.getLog(RepoRemoteService.class);
    private NodeService fNodeService;
    private ContentService fContentService;
    private FileFolderService fFileFolderService;

    public void setNodeService(NodeService service) {
        this.fNodeService = service;
    }

    public void setContentService(ContentService service) {
        this.fContentService = service;
    }

    public void setFileFolderService(FileFolderService service) {
        this.fFileFolderService = service;
    }

    private List<String> splitPath(String path) {
        String[] pathComponents = path.split("/+");
        ArrayList<String> pathList = new ArrayList<String>(pathComponents.length);
        for (String comp : pathComponents) {
            pathList.add(comp);
        }
        return pathList;
    }

    @Override
    public NodeRef createDirectory(NodeRef base, String path) {
        Pair<NodeRef, String> parentChild = this.getParentChildRelative(base, path);
        FileInfo created = this.fFileFolderService.create((NodeRef)parentChild.getFirst(), (String)parentChild.getSecond(), ContentModel.TYPE_FOLDER);
        return created.getNodeRef();
    }

    @Override
    public OutputStream createFile(NodeRef base, String path) {
        Pair<NodeRef, String> parentChild = this.getParentChildRelative(base, path);
        FileInfo info = this.fFileFolderService.create((NodeRef)parentChild.getFirst(), (String)parentChild.getSecond(), ContentModel.TYPE_CONTENT);
        ContentWriter writer = this.fContentService.getWriter(info.getNodeRef(), ContentModel.PROP_CONTENT, true);
        return writer.getContentOutputStream();
    }

    @Override
    public Map<String, Pair<NodeRef, Boolean>> getListing(NodeRef dir) {
        TreeMap<String, Pair<NodeRef, Boolean>> result = new TreeMap<String, Pair<NodeRef, Boolean>>();
        List<FileInfo> listing = this.fFileFolderService.list(dir);
        for (FileInfo info : listing) {
            result.put(info.getName(), (Pair<NodeRef, Boolean>)new Pair((Object)info.getNodeRef(), (Object)info.isFolder()));
        }
        return result;
    }

    @Override
    public NodeRef getRoot() {
        NodeRef storeRoot = this.fNodeService.getRootNode(new StoreRef("workspace", "SpacesStore"));
        List listing = this.fNodeService.getChildAssocs(storeRoot);
        for (ChildAssociationRef child : listing) {
            fgLogger.error((Object)child.getQName().getLocalName());
            if (!child.getQName().getLocalName().equals("company_home")) continue;
            return child.getChildRef();
        }
        throw new AlfrescoRuntimeException("Root Not Found!");
    }

    @Override
    public Pair<NodeRef, Boolean> lookup(NodeRef base, String path) {
        List<String> pathList = this.splitPath(path);
        try {
            FileInfo info = this.fFileFolderService.resolveNamePath(base, pathList);
            return new Pair((Object)info.getNodeRef(), (Object)info.isFolder());
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @Override
    public InputStream readFile(NodeRef fileRef) {
        return this.fContentService.getReader(fileRef, ContentModel.PROP_CONTENT).getContentInputStream();
    }

    @Override
    public InputStream readFile(NodeRef base, String path) {
        NodeRef fileRef = (NodeRef)this.lookup(base, path).getFirst();
        if (fileRef == null) {
            throw new AlfrescoRuntimeException("Not Found: " + path);
        }
        return this.fContentService.getReader(fileRef, ContentModel.PROP_CONTENT).getContentInputStream();
    }

    @Override
    public void removeNode(NodeRef toRemove) {
        this.fNodeService.deleteNode(toRemove);
    }

    @Override
    public void removeNode(NodeRef base, String path) {
        NodeRef toRemove = (NodeRef)this.lookup(base, path).getFirst();
        if (toRemove == null) {
            throw new AlfrescoRuntimeException("Not Found: " + path);
        }
        this.fNodeService.deleteNode(toRemove);
    }

    @Override
    public void rename(NodeRef base, String src, String dst) {
        NodeRef srcRef = (NodeRef)this.lookup(base, src).getFirst();
        if (srcRef == null) {
            throw new AlfrescoRuntimeException("Not Found: " + src);
        }
        Pair<NodeRef, String> parentChild = this.getParentChildRelative(base, dst);
        try {
            this.fFileFolderService.move(srcRef, (NodeRef)parentChild.getFirst(), (String)parentChild.getSecond());
        }
        catch (FileNotFoundException e) {
            throw new AlfrescoRuntimeException("Parent Not Found: " + dst, (Throwable)e);
        }
    }

    @Override
    public OutputStream writeFile(NodeRef base, String path) {
        NodeRef target = (NodeRef)this.lookup(base, path).getFirst();
        return this.fContentService.getWriter(target, ContentModel.PROP_CONTENT, true).getContentOutputStream();
    }

    private Pair<NodeRef, String> getParentChildRelative(NodeRef base, String path) {
        NodeRef parent;
        List<String> pathList = this.splitPath(path);
        String name = null;
        if (pathList.size() == 1) {
            parent = base;
            name = pathList.get(0);
        } else {
            try {
                name = pathList.get(pathList.size() - 1);
                pathList.remove(pathList.size() - 1);
                FileInfo info = this.fFileFolderService.resolveNamePath(base, pathList);
                parent = info.getNodeRef();
            }
            catch (FileNotFoundException e) {
                throw new AlfrescoRuntimeException("Not Found: " + pathList, (Throwable)e);
            }
        }
        return new Pair((Object)parent, (Object)name);
    }
}

