/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition.executer;

import java.util.Collection;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.content.transform.magick.ImageCropOptions;
import org.alfresco.repo.content.transform.magick.ImageResizeOptions;
import org.alfresco.repo.content.transform.magick.ImageTransformationOptions;
import org.alfresco.repo.rendition.executer.AbstractRenderingEngine;
import org.alfresco.repo.rendition.executer.AbstractTransformationRenderingEngine;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.TransformationOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageRenderingEngine
extends AbstractTransformationRenderingEngine {
    public static final String NAME = "imageRenderingEngine";
    public static final String PARAM_RESIZE_WIDTH = "xsize";
    public static final String PARAM_RESIZE_HEIGHT = "ysize";
    public static final String PARAM_IS_PERCENT_RESIZE = "isAbsolute";
    public static final String PARAM_MAINTAIN_ASPECT_RATIO = "maintainAspectRatio";
    public static final String PARAM_RESIZE_TO_THUMBNAIL = "resizeToThumbnail";
    public static final String PARAM_CROP_WIDTH = "crop_width";
    public static final String PARAM_CROP_HEIGHT = "crop_height";
    public static final String PARAM_CROP_X_OFFSET = "crop_x";
    public static final String PARAM_CROP_Y_OFFSET = "crop_y";
    public static final String PARAM_CROP_GRAVITY = "crop_gravity";
    public static final String PARAM_IS_PERCENT_CROP = "percent_crop";
    public static final String PARAM_COMMAND_OPTIONS = "commandOptions";

    @Override
    protected TransformationOptions getTransformOptions(AbstractRenderingEngine.RenderingContext context) {
        String commandOptions = context.getCheckedParam(PARAM_COMMAND_OPTIONS, String.class);
        ImageResizeOptions imageResizeOptions = this.getImageResizeOptions(context);
        ImageCropOptions cropOptions = this.getImageCropOptions(context);
        ImageTransformationOptions imageTransformationOptions = new ImageTransformationOptions();
        imageTransformationOptions.setResizeOptions(imageResizeOptions);
        imageTransformationOptions.setCropOptions(cropOptions);
        if (commandOptions != null) {
            imageTransformationOptions.setCommandOptions(commandOptions);
        }
        return imageTransformationOptions;
    }

    @Override
    protected String getTargetMimeType(AbstractRenderingEngine.RenderingContext context) {
        String sourceMimeType = context.makeContentReader().getMimetype();
        return context.getParamWithDefault("mime-type", sourceMimeType);
    }

    private ImageResizeOptions getImageResizeOptions(AbstractRenderingEngine.RenderingContext context) {
        int newHeight = context.getIntegerParam(PARAM_RESIZE_WIDTH, -1);
        int newWidth = context.getIntegerParam(PARAM_RESIZE_HEIGHT, -1);
        if (newHeight == -1 && newWidth == -1) {
            return null;
        }
        boolean isPercentResize = context.getParamWithDefault(PARAM_IS_PERCENT_RESIZE, false);
        boolean maintainAspectRatio = context.getParamWithDefault(PARAM_MAINTAIN_ASPECT_RATIO, false);
        ImageResizeOptions imageResizeOptions = new ImageResizeOptions();
        imageResizeOptions.setMaintainAspectRatio(maintainAspectRatio);
        imageResizeOptions.setWidth(newHeight);
        imageResizeOptions.setHeight(newWidth);
        imageResizeOptions.setPercentResize(isPercentResize);
        return imageResizeOptions;
    }

    private ImageCropOptions getImageCropOptions(AbstractRenderingEngine.RenderingContext context) {
        int newWidth = context.getIntegerParam(PARAM_CROP_WIDTH, -1);
        int newHeight = context.getIntegerParam(PARAM_CROP_HEIGHT, -1);
        if (newHeight == -1 && newWidth == -1) {
            return null;
        }
        int xOffset = context.getIntegerParam(PARAM_CROP_X_OFFSET, 0);
        int yOffset = context.getIntegerParam(PARAM_CROP_Y_OFFSET, 0);
        boolean isPercentCrop = context.getParamWithDefault(PARAM_IS_PERCENT_CROP, false);
        String gravity = context.getCheckedParam(PARAM_CROP_GRAVITY, String.class);
        ImageCropOptions cropOptions = new ImageCropOptions();
        cropOptions.setGravity(gravity);
        cropOptions.setHeight(newHeight);
        cropOptions.setPercentageCrop(isPercentCrop);
        cropOptions.setWidth(newWidth);
        cropOptions.setXOffset(xOffset);
        cropOptions.setYOffset(yOffset);
        return cropOptions;
    }

    @Override
    protected void checkParameterValues(Action action) {
        this.checkNumericalParameterIsPositive(action, PARAM_RESIZE_WIDTH);
        this.checkNumericalParameterIsPositive(action, PARAM_RESIZE_HEIGHT);
        this.checkNumericalParameterIsPositive(action, PARAM_CROP_HEIGHT);
        this.checkNumericalParameterIsPositive(action, PARAM_CROP_WIDTH);
        String mimeTypeParam = (String)((Object)action.getParameterValue("mime-type"));
        if (mimeTypeParam != null && !mimeTypeParam.startsWith("image")) {
            StringBuilder msg = new StringBuilder();
            msg.append("Parameter ").append("mime-type").append(" had illegal non-image MIME type: ").append(mimeTypeParam);
            throw new IllegalArgumentException(msg.toString());
        }
    }

    private void checkNumericalParameterIsPositive(Action action, String numericalParamName) {
        Number param = (Number)action.getParameterValue(numericalParamName);
        if (param != null && param.longValue() <= 0L) {
            StringBuilder msg = new StringBuilder();
            msg.append("Parameter ").append(numericalParamName).append(" had illegal non-positive value: ").append(param.intValue());
            throw new IllegalArgumentException(msg.toString());
        }
    }

    @Override
    protected Collection<ParameterDefinition> getParameterDefinitions() {
        Collection<ParameterDefinition> paramList = super.getParameterDefinitions();
        paramList.add(new ParameterDefinitionImpl(PARAM_RESIZE_WIDTH, DataTypeDefinition.INT, false, this.getParamDisplayLabel(PARAM_RESIZE_WIDTH)));
        paramList.add(new ParameterDefinitionImpl(PARAM_RESIZE_HEIGHT, DataTypeDefinition.INT, false, this.getParamDisplayLabel(PARAM_RESIZE_HEIGHT)));
        paramList.add(new ParameterDefinitionImpl(PARAM_IS_PERCENT_RESIZE, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_IS_PERCENT_RESIZE)));
        paramList.add(new ParameterDefinitionImpl(PARAM_MAINTAIN_ASPECT_RATIO, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_MAINTAIN_ASPECT_RATIO)));
        paramList.add(new ParameterDefinitionImpl(PARAM_RESIZE_TO_THUMBNAIL, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_RESIZE_TO_THUMBNAIL)));
        paramList.add(new ParameterDefinitionImpl(PARAM_CROP_GRAVITY, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_CROP_GRAVITY)));
        paramList.add(new ParameterDefinitionImpl(PARAM_CROP_HEIGHT, DataTypeDefinition.INT, false, this.getParamDisplayLabel(PARAM_CROP_HEIGHT)));
        paramList.add(new ParameterDefinitionImpl(PARAM_CROP_WIDTH, DataTypeDefinition.INT, false, this.getParamDisplayLabel(PARAM_CROP_WIDTH)));
        paramList.add(new ParameterDefinitionImpl(PARAM_CROP_X_OFFSET, DataTypeDefinition.INT, false, this.getParamDisplayLabel(PARAM_CROP_X_OFFSET)));
        paramList.add(new ParameterDefinitionImpl(PARAM_CROP_Y_OFFSET, DataTypeDefinition.INT, false, this.getParamDisplayLabel(PARAM_CROP_Y_OFFSET)));
        paramList.add(new ParameterDefinitionImpl(PARAM_IS_PERCENT_CROP, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_IS_PERCENT_CROP)));
        paramList.add(new ParameterDefinitionImpl(PARAM_COMMAND_OPTIONS, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_COMMAND_OPTIONS)));
        return paramList;
    }
}

