/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule;

import java.util.List;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.RuleService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReorderRules
extends ActionExecuterAbstractBase {
    public static final String NAME = "reorder-rules";
    public static final String PARAM_RULES = "rules";
    private NodeService nodeService;
    private RuleService ruleService;

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        if (this.nodeService.exists(actionedUponNodeRef) && this.nodeService.hasAspect(actionedUponNodeRef, RuleModel.ASPECT_RULES)) {
            List rules = (List)((Object)action.getParameterValue(PARAM_RULES));
            int index = 0;
            for (NodeRef rule : rules) {
                this.ruleService.setRulePosition(actionedUponNodeRef, rule, index);
                ++index;
            }
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_RULES, DataTypeDefinition.NODE_REF, true, this.getParamDisplayLabel(PARAM_RULES), true));
    }
}

