/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule.ruletrigger;

import java.util.Set;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.rule.ruletrigger.RuleTriggerAbstractBase;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OnCreateChildAssociationRuleTrigger
extends RuleTriggerAbstractBase
implements NodeServicePolicies.OnCreateChildAssociationPolicy {
    private static Log logger = LogFactory.getLog(OnCreateChildAssociationRuleTrigger.class);
    private static final String POLICY_NAME = "onCreateChildAssociation";
    private boolean isClassBehaviour = false;

    public void setIsClassBehaviour(boolean isClassBehaviour) {
        this.isClassBehaviour = isClassBehaviour;
    }

    public void registerRuleTrigger() {
        if (this.isClassBehaviour) {
            this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)POLICY_NAME), this, (Behaviour)new JavaBehaviour(this, POLICY_NAME));
        } else {
            this.policyComponent.bindAssociationBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)POLICY_NAME), this, (Behaviour)new JavaBehaviour(this, POLICY_NAME));
        }
    }

    public void onCreateChildAssociation(ChildAssociationRef childAssocRef, boolean isNewNode) {
        String marker;
        Set nodeRefRenameSet;
        if (isNewNode) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Single child assoc trigger (policy = onCreateChildAssociation) fired for parent node " + childAssocRef.getParentRef() + " and child node " + childAssocRef.getChildRef()));
        }
        if (!(nodeRefRenameSet = TransactionalResourceHelper.getSet("RuleTrigger.NodeSet")).contains(marker = childAssocRef.getChildRef().toString() + "rename")) {
            this.triggerRules(childAssocRef.getParentRef(), childAssocRef.getChildRef());
        } else {
            nodeRefRenameSet.remove(marker);
        }
    }
}

