/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search;

import org.alfresco.repo.search.ResultSetRowIterator;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;

public abstract class AbstractResultSetRowIterator
implements ResultSetRowIterator {
    private ResultSet resultSet;
    private int position = -1;
    private int max;

    public AbstractResultSetRowIterator(ResultSet resultSet) {
        this.resultSet = resultSet;
        this.max = resultSet.length();
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public boolean hasNext() {
        return this.position < this.max - 1;
    }

    public boolean allowsReverse() {
        return true;
    }

    public boolean hasPrevious() {
        return this.position > 0;
    }

    public abstract ResultSetRow next();

    protected int moveToNextPosition() {
        return ++this.position;
    }

    public abstract ResultSetRow previous();

    protected int moveToPreviousPosition() {
        return --this.position;
    }

    public int nextIndex() {
        return this.position + 1;
    }

    public int previousIndex() {
        return this.position - 1;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void set(ResultSetRow o) {
        throw new UnsupportedOperationException();
    }

    public void add(ResultSetRow o) {
        throw new UnsupportedOperationException();
    }
}

