/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.search.IndexerException;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.impl.lucene.ADMLuceneIndexer;
import org.alfresco.repo.search.impl.lucene.ADMLuceneNoActionIndexerImpl;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneIndexerImpl;
import org.alfresco.repo.search.impl.lucene.ClosingIndexSearcher;
import org.alfresco.repo.search.impl.lucene.LuceneConfig;
import org.alfresco.repo.search.impl.lucene.LuceneIndexException;
import org.alfresco.repo.search.impl.lucene.MultiReader;
import org.alfresco.repo.search.impl.lucene.analysis.DateTimeAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.MLTokenDuplicator;
import org.alfresco.repo.search.impl.lucene.analysis.VerbatimAnalyser;
import org.alfresco.repo.search.impl.lucene.fts.FTSIndexerAware;
import org.alfresco.repo.search.impl.lucene.fts.FullTextSearchIndexer;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.CachingDateFormat;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.ISO9075;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADMLuceneIndexerImpl
extends AbstractLuceneIndexerImpl<NodeRef>
implements ADMLuceneIndexer {
    static Log s_logger = LogFactory.getLog(ADMLuceneIndexerImpl.class);
    NodeService nodeService;
    TenantService tenantService;
    ContentService contentService;
    FTSIndexerAware callBack;
    int remainingCount = 0;
    private ArrayList<Helper> toFTSIndex = new ArrayList();
    FullTextSearchIndexer fullTextSearchIndexer;

    ADMLuceneIndexerImpl() {
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    @Override
    public void createNode(ChildAssociationRef relationshipRef) throws LuceneIndexException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Create node " + relationshipRef.getChildRef()));
        }
        this.checkAbleToDoWork(AbstractLuceneIndexerImpl.IndexUpdateStatus.SYNCRONOUS);
        try {
            NodeRef childRef = relationshipRef.getChildRef();
            if (!childRef.getStoreRef().equals((Object)this.store)) {
                throw new LuceneIndexException("Create node failed - node is not in the required store");
            }
            if (relationshipRef.getParentRef() == null && this.tenantService.getBaseName(childRef).equals((Object)this.nodeService.getRootNode(childRef.getStoreRef()))) {
                this.addRootNodesToDeletionList();
                s_logger.warn((Object)"Detected root node addition: deleting all nodes from the index");
            }
            this.index(childRef);
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Create node failed", (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addRootNodesToDeletionList() {
        IndexReader mainReader = null;
        try {
            try {
                mainReader = this.getReader();
                TermDocs td = mainReader.termDocs(new Term("ISROOT", "T"));
                while (td.next()) {
                    int doc = td.doc();
                    Document document = mainReader.document(doc);
                    String id = document.get("ID");
                    NodeRef ref = new NodeRef(id);
                    this.deleteImpl(ref.toString(), AbstractLuceneIndexerImpl.IndexDeleteMode.DELETE, true, mainReader);
                }
            }
            catch (IOException e) {
                throw new LuceneIndexException("Failed to delete all primary nodes", e);
            }
            Object var8_8 = null;
            if (mainReader == null) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (mainReader == null) throw throwable;
            try {
                mainReader.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new LuceneIndexException("Filed to close main reader", e);
            }
        }
        try {
            mainReader.close();
            return;
        }
        catch (IOException e) {
            throw new LuceneIndexException("Filed to close main reader", e);
        }
    }

    @Override
    public void updateNode(NodeRef nodeRef) throws LuceneIndexException {
        nodeRef = this.tenantService.getName(nodeRef);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Update node " + nodeRef));
        }
        this.checkAbleToDoWork(AbstractLuceneIndexerImpl.IndexUpdateStatus.SYNCRONOUS);
        try {
            if (!nodeRef.getStoreRef().equals((Object)this.store)) {
                throw new LuceneIndexException("Update node failed - node is not in the required store");
            }
            this.reindex(nodeRef, false);
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Update node failed", (Throwable)((Object)e));
        }
    }

    @Override
    public void deleteNode(ChildAssociationRef relationshipRef) throws LuceneIndexException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Delete node " + relationshipRef.getChildRef()));
        }
        this.checkAbleToDoWork(AbstractLuceneIndexerImpl.IndexUpdateStatus.SYNCRONOUS);
        try {
            if (!relationshipRef.getChildRef().getStoreRef().equals((Object)this.store)) {
                throw new LuceneIndexException("Delete node failed - node is not in the required store");
            }
            this.delete(relationshipRef.getChildRef());
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Delete node failed", (Throwable)((Object)e));
        }
    }

    @Override
    public void createChildRelationship(ChildAssociationRef relationshipRef) throws LuceneIndexException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Create child " + relationshipRef));
        }
        this.checkAbleToDoWork(AbstractLuceneIndexerImpl.IndexUpdateStatus.SYNCRONOUS);
        try {
            if (!relationshipRef.getChildRef().getStoreRef().equals((Object)this.store)) {
                throw new LuceneIndexException("Create child relationship failed - node is not in the required store");
            }
            this.reindex(relationshipRef.getChildRef(), true);
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Failed to create child relationship", (Throwable)((Object)e));
        }
    }

    @Override
    public void updateChildRelationship(ChildAssociationRef relationshipBeforeRef, ChildAssociationRef relationshipAfterRef) throws LuceneIndexException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Update child " + relationshipBeforeRef + " to " + relationshipAfterRef));
        }
        this.checkAbleToDoWork(AbstractLuceneIndexerImpl.IndexUpdateStatus.SYNCRONOUS);
        try {
            if (!relationshipBeforeRef.getChildRef().getStoreRef().equals((Object)this.store)) {
                throw new LuceneIndexException("Update child relationship failed - node is not in the required store");
            }
            if (!relationshipAfterRef.getChildRef().getStoreRef().equals((Object)this.store)) {
                throw new LuceneIndexException("Update child relationship failed - node is not in the required store");
            }
            if (relationshipBeforeRef.getParentRef() != null) {
                // empty if block
            }
            this.move(relationshipBeforeRef.getChildRef());
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Failed to update child relationship", (Throwable)((Object)e));
        }
    }

    @Override
    public void deleteChildRelationship(ChildAssociationRef relationshipRef) throws LuceneIndexException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Delete child " + relationshipRef));
        }
        this.checkAbleToDoWork(AbstractLuceneIndexerImpl.IndexUpdateStatus.SYNCRONOUS);
        try {
            if (!relationshipRef.getChildRef().getStoreRef().equals((Object)this.store)) {
                throw new LuceneIndexException("Delete child relationship failed - node is not in the required store");
            }
            if (relationshipRef.getParentRef() != null) {
                // empty if block
            }
            this.reindex(relationshipRef.getChildRef(), true);
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Failed to delete child relationship", (Throwable)((Object)e));
        }
    }

    public static ADMLuceneIndexerImpl getUpdateIndexer(StoreRef storeRef, String deltaId, LuceneConfig config) throws LuceneIndexException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)"Creating indexer");
        }
        ADMLuceneIndexerImpl indexer = new ADMLuceneIndexerImpl();
        indexer.setLuceneConfig(config);
        indexer.initialise(storeRef, deltaId);
        return indexer;
    }

    public static ADMLuceneNoActionIndexerImpl getNoActionIndexer(StoreRef storeRef, String deltaId, LuceneConfig config) throws LuceneIndexException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)"Creating indexer");
        }
        ADMLuceneNoActionIndexerImpl indexer = new ADMLuceneNoActionIndexerImpl();
        indexer.setLuceneConfig(config);
        indexer.initialise(storeRef, deltaId);
        return indexer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doFTSIndexCommit() throws LuceneIndexException {
        IndexReader mainReader = null;
        IndexReader deltaReader = null;
        IndexSearcher mainSearcher = null;
        IndexSearcher deltaSearcher = null;
        try {
            try {
                Object e22;
                block25: {
                    try {
                        mainReader = this.getReader();
                        deltaReader = this.getDeltaReader();
                        mainSearcher = new IndexSearcher(mainReader);
                        deltaSearcher = new IndexSearcher(deltaReader);
                        for (Helper helper : this.toFTSIndex) {
                            this.deletions.add(helper.ref);
                        }
                        Object var8_9 = null;
                        if (deltaSearcher == null) break block25;
                    }
                    catch (Throwable throwable) {
                        Object e22;
                        Object var8_10 = null;
                        if (deltaSearcher != null) {
                            try {
                                deltaSearcher.close();
                            }
                            catch (IOException e22) {
                                s_logger.warn((Object)"Failed to close delta searcher", (Throwable)e22);
                            }
                        }
                        if (mainSearcher != null) {
                            try {
                                mainSearcher.close();
                            }
                            catch (IOException e22) {
                                s_logger.warn((Object)"Failed to close main searcher", (Throwable)e22);
                            }
                        }
                        try {
                            this.closeDeltaReader();
                        }
                        catch (LuceneIndexException e22) {
                            s_logger.warn((Object)"Failed to close delta reader", (Throwable)e22);
                        }
                        if (mainReader != null) {
                            try {
                                mainReader.close();
                            }
                            catch (IOException e22) {
                                s_logger.warn((Object)"Failed to close main reader", (Throwable)e22);
                            }
                        }
                        throw throwable;
                    }
                    try {
                        deltaSearcher.close();
                    }
                    catch (IOException e22) {
                        s_logger.warn((Object)"Failed to close delta searcher", (Throwable)e22);
                    }
                }
                if (mainSearcher != null) {
                    try {
                        mainSearcher.close();
                    }
                    catch (IOException e22) {
                        s_logger.warn((Object)"Failed to close main searcher", (Throwable)e22);
                    }
                }
                try {
                    this.closeDeltaReader();
                }
                catch (LuceneIndexException e22) {
                    s_logger.warn((Object)"Failed to close delta reader", (Throwable)e22);
                }
                if (mainReader != null) {
                    try {
                        mainReader.close();
                    }
                    catch (IOException e22) {
                        s_logger.warn((Object)"Failed to close main reader", (Throwable)e22);
                    }
                }
                this.setInfo(this.docs, this.getDeletions(), true);
            }
            catch (IOException e) {
                this.rollback();
                throw new LuceneIndexException("Commit failed", e);
            }
            catch (LuceneIndexException e) {
                this.rollback();
                throw new LuceneIndexException("Commit failed", (Throwable)((Object)e));
            }
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            throw throwable;
        }
    }

    @Override
    public List<Document> createDocuments(final String stringNodeRef, final boolean isNew, final boolean indexAllProperties, final boolean includeDirectoryDocuments) {
        if (this.tenantService.isEnabled() && (AuthenticationUtil.getRunAsUser() == null || AuthenticationUtil.isRunAsUserTheSystemUser())) {
            return (List)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<List<Document>>(){

                public List<Document> doWork() {
                    return ADMLuceneIndexerImpl.this.createDocumentsImpl(stringNodeRef, isNew, indexAllProperties, includeDirectoryDocuments);
                }
            }, (String)this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), this.tenantService.getDomain(new NodeRef(stringNodeRef).getStoreRef().getIdentifier())));
        }
        return this.createDocumentsImpl(stringNodeRef, isNew, indexAllProperties, includeDirectoryDocuments);
    }

    private List<Document> createDocumentsImpl(String stringNodeRef, boolean isNew, boolean indexAllProperties, boolean includeDirectoryDocuments) {
        NodeRef nodeRef = new NodeRef(stringNodeRef);
        Map<ChildAssociationRef, Counter> nodeCounts = this.getNodeCounts(nodeRef);
        ArrayList<Document> docs = new ArrayList<Document>();
        ChildAssociationRef qNameRef = null;
        Map properties = this.nodeService.getProperties(nodeRef);
        NodeRef.Status nodeStatus = this.nodeService.getNodeStatus(nodeRef);
        LinkedHashSet directPaths = new LinkedHashSet(this.nodeService.getPaths(nodeRef, false));
        Collection<Pair<Path, QName>> categoryPaths = this.getCategoryPaths(nodeRef, properties);
        ArrayList<Pair<Path, Object>> paths = new ArrayList<Pair<Path, Object>>(directPaths.size() + categoryPaths.size());
        for (Path path : directPaths) {
            paths.add(new Pair<Path, Object>(path, null));
        }
        paths.addAll(categoryPaths);
        Document xdoc = new Document();
        xdoc.add((Fieldable)new Field("ID", nodeRef.toString(), Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
        xdoc.add((Fieldable)new Field("TX", nodeStatus.getChangeTxnId(), Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
        boolean isAtomic = true;
        for (QName propertyName : properties.keySet()) {
            Serializable value = (Serializable)properties.get(propertyName);
            value = this.convertForMT(propertyName, value);
            if (indexAllProperties) {
                this.indexProperty(nodeRef, propertyName, value, xdoc, false);
                continue;
            }
            isAtomic &= this.indexProperty(nodeRef, propertyName, value, xdoc, true);
        }
        boolean isRoot = nodeRef.equals((Object)this.tenantService.getName(this.nodeService.getRootNode(nodeRef.getStoreRef())));
        boolean mayHaveChildren = includeDirectoryDocuments && this.mayHaveChildren(nodeRef);
        boolean isCategory = this.isCategory(this.getDictionaryService().getType(this.nodeService.getType(nodeRef)));
        StringBuilder qNameBuffer = new StringBuilder(64);
        StringBuilder assocTypeQNameBuffer = new StringBuilder(64);
        for (Pair pair : paths) {
            qNameRef = this.tenantService.getName(this.getLastRefOrNull((Path)pair.getFirst()));
            String pathString = ((Path)pair.getFirst()).toString();
            if (pathString.length() > 0 && pathString.charAt(0) == '/') {
                pathString = pathString.substring(1);
            }
            if (isRoot || ((Path)pair.getFirst()).size() == 1) continue;
            Counter counter = nodeCounts.get(this.tenantService.getBaseName(qNameRef));
            if ((counter == null || counter.getRepeat() < counter.getCountInParent()) && qNameRef != null && qNameRef.getParentRef() != null && qNameRef.getQName() != null) {
                if (qNameBuffer.length() > 0) {
                    qNameBuffer.append(";/");
                    assocTypeQNameBuffer.append(";/");
                }
                qNameBuffer.append(ISO9075.getXPathName((QName)qNameRef.getQName()));
                assocTypeQNameBuffer.append(ISO9075.getXPathName((QName)qNameRef.getTypeQName()));
                xdoc.add((Fieldable)new Field("PARENT", qNameRef.getParentRef().toString(), Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
                xdoc.add((Fieldable)new Field("LINKASPECT", pair.getSecond() == null ? "" : ISO9075.getXPathName((QName)((QName)pair.getSecond())), Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
            }
            if (counter != null) {
                counter.increment();
            }
            if (!mayHaveChildren || !directPaths.contains(pair.getFirst())) continue;
            Document directoryEntry = new Document();
            directoryEntry.add((Fieldable)new Field("ID", nodeRef.toString(), Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
            directoryEntry.add((Fieldable)new Field("PATH", pathString, Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO));
            for (NodeRef parent : this.getParents((Path)pair.getFirst())) {
                directoryEntry.add((Fieldable)new Field("ANCESTOR", this.tenantService.getName(parent).toString(), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
            }
            directoryEntry.add((Fieldable)new Field("ISCONTAINER", "T", Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
            if (isCategory) {
                directoryEntry.add((Fieldable)new Field("ISCATEGORY", "T", Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
            }
            docs.add(directoryEntry);
        }
        if (isRoot) {
            xdoc.add((Fieldable)new Field("ISCONTAINER", "T", Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
            xdoc.add((Fieldable)new Field("PATH", "", Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO));
            xdoc.add((Fieldable)new Field("QNAME", "", Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO));
            xdoc.add((Fieldable)new Field("ISROOT", "T", Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
            xdoc.add((Fieldable)new Field("PRIMARYASSOCTYPEQNAME", ISO9075.getXPathName((QName)ContentModel.ASSOC_CHILDREN), Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO));
            xdoc.add((Fieldable)new Field("ISNODE", "T", Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
            docs.add(xdoc);
        } else {
            xdoc.add((Fieldable)new Field("QNAME", qNameBuffer.toString(), Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO));
            xdoc.add((Fieldable)new Field("ASSOCTYPEQNAME", assocTypeQNameBuffer.toString(), Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO));
            ChildAssociationRef primary = this.nodeService.getPrimaryParent(nodeRef);
            xdoc.add((Fieldable)new Field("PRIMARYPARENT", this.tenantService.getName(primary.getParentRef()).toString(), Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
            xdoc.add((Fieldable)new Field("PRIMARYASSOCTYPEQNAME", ISO9075.getXPathName((QName)primary.getTypeQName()), Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO));
            QName qName = this.nodeService.getType(nodeRef);
            xdoc.add((Fieldable)new Field("TYPE", ISO9075.getXPathName((QName)qName), Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
            for (QName classRef : this.nodeService.getAspects(nodeRef)) {
                xdoc.add((Fieldable)new Field("ASPECT", ISO9075.getXPathName((QName)classRef), Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
            }
            xdoc.add((Fieldable)new Field("ISROOT", "F", Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
            xdoc.add((Fieldable)new Field("ISNODE", "T", Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
            if (isAtomic || indexAllProperties) {
                xdoc.add((Fieldable)new Field("FTSSTATUS", "Clean", Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
            } else if (isNew) {
                xdoc.add((Fieldable)new Field("FTSSTATUS", "New", Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
            } else {
                xdoc.add((Fieldable)new Field("FTSSTATUS", "Dirty", Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
            }
            docs.add(xdoc);
        }
        return docs;
    }

    private Serializable convertForMT(QName propertyName, Serializable inboundValue) {
        if (!this.tenantService.isEnabled()) {
            return inboundValue;
        }
        PropertyDefinition propertyDef = this.getDictionaryService().getProperty(propertyName);
        if (propertyDef != null && (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.NODE_REF) || propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CATEGORY))) {
            if (inboundValue instanceof Collection) {
                Collection in = (Collection)((Object)inboundValue);
                ArrayList<NodeRef> out = new ArrayList<NodeRef>(in.size());
                for (NodeRef o : in) {
                    out.add(this.tenantService.getName(o));
                }
                return out;
            }
            return this.tenantService.getName((NodeRef)inboundValue);
        }
        return inboundValue;
    }

    protected boolean indexProperty(NodeRef nodeRef, QName propertyName, Serializable value, Document doc, boolean indexAtomicPropertiesOnly) {
        String attributeName = "@" + QName.createQName((String)propertyName.getNamespaceURI(), (String)ISO9075.encode((String)propertyName.getLocalName()));
        boolean store = true;
        boolean index = true;
        IndexTokenisationMode tokenise = IndexTokenisationMode.TRUE;
        boolean atomic = true;
        boolean isContent = false;
        boolean isMultiLingual = false;
        boolean isText = false;
        boolean isDateTime = false;
        PropertyDefinition propertyDef = this.getDictionaryService().getProperty(propertyName);
        if (propertyDef != null) {
            index = propertyDef.isIndexed();
            store = propertyDef.isStoredInIndex();
            tokenise = propertyDef.getIndexTokenisationMode();
            atomic = propertyDef.isIndexedAtomically();
            isContent = propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT);
            isMultiLingual = propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.MLTEXT);
            isText = propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.TEXT);
            if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.DATETIME)) {
                DataTypeDefinition dataType = propertyDef.getDataType();
                String analyserClassName = dataType.getAnalyserClassName();
                isDateTime = analyserClassName.equals(DateTimeAnalyser.class.getCanonicalName());
            }
        }
        if (value == null) {
            return true;
        }
        if (indexAtomicPropertiesOnly && !atomic) {
            return false;
        }
        if (!indexAtomicPropertiesOnly) {
            doc.removeFields(propertyName.toString());
        }
        boolean wereAllAtomic = true;
        block34: for (Serializable serializableValue : DefaultTypeConverter.INSTANCE.getCollection(Serializable.class, (Object)value)) {
            Field.Index fieldIndex;
            Field.Store fieldStore;
            StringBuilder builder;
            String strValue = null;
            try {
                strValue = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)serializableValue);
            }
            catch (TypeConversionException e) {
                doc.add((Fieldable)new Field(attributeName, "nintc", Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                continue;
            }
            if (strValue == null) continue;
            if (isContent) {
                Serializable localeProperty;
                ContentData contentData = (ContentData)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)serializableValue);
                if (!index || contentData.getMimetype() == null) continue;
                doc.add((Fieldable)new Field(attributeName + ".mimetype", contentData.getMimetype(), Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                doc.add((Fieldable)new Field(attributeName + ".size", Long.toString(contentData.getSize()), Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.NO));
                Locale locale = contentData.getLocale();
                if (locale == null && (localeProperty = this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCALE)) != null) {
                    locale = (Locale)DefaultTypeConverter.INSTANCE.convert(Locale.class, (Object)localeProperty);
                }
                if (locale == null) {
                    locale = I18NUtil.getLocale();
                }
                doc.add((Fieldable)new Field(attributeName + ".locale", locale.toString().toLowerCase(), Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                ContentReader reader = this.contentService.getReader(nodeRef, propertyName);
                if (reader != null && reader.exists()) {
                    boolean readerReady = true;
                    if (!EqualsHelper.nullSafeEquals((Object)reader.getMimetype(), (Object)"text/plain") || !EqualsHelper.nullSafeEquals((Object)reader.getEncoding(), (Object)"UTF-8")) {
                        ContentTransformer transformer = this.contentService.getTransformer(reader.getMimetype(), "text/plain");
                        if (transformer == null) {
                            if (s_logger.isInfoEnabled()) {
                                s_logger.info((Object)("Not indexed: No transformation: \n   source: " + reader + "\n" + "   target: " + "text/plain" + " at " + this.nodeService.getPath(nodeRef)));
                            }
                            readerReady = false;
                            doc.add((Fieldable)new Field(attributeName, "nint", Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.NO));
                        } else if (indexAtomicPropertiesOnly && transformer.getTransformationTime() > this.maxAtomicTransformationTime) {
                            wereAllAtomic = false;
                            readerReady = false;
                        } else {
                            ContentWriter writer = this.contentService.getTempWriter();
                            writer.setMimetype("text/plain");
                            writer.setEncoding("UTF-8");
                            try {
                                transformer.transform(reader, writer);
                                reader = writer.getReader();
                                if (!reader.exists()) {
                                    throw new ContentIOException("The transformation did not write any content, yet: \n   transformer:     " + transformer + "\n" + "   temp writer:     " + writer);
                                }
                            }
                            catch (ContentIOException e) {
                                if (s_logger.isInfoEnabled()) {
                                    s_logger.info((Object)("Not indexed: Transformation failed at " + this.nodeService.getPath(nodeRef)), (Throwable)e);
                                }
                                readerReady = false;
                                doc.add((Fieldable)new Field(attributeName, "nitf", Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.NO));
                            }
                        }
                    }
                    if (!readerReady) continue;
                    InputStreamReader isr = null;
                    InputStream ris = reader.getReader().getContentInputStream();
                    try {
                        isr = new InputStreamReader(ris, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        isr = new InputStreamReader(ris);
                    }
                    builder = new StringBuilder();
                    builder.append("\u0000").append(locale.toString()).append("\u0000");
                    StringReader prefix = new StringReader(builder.toString());
                    MultiReader multiReader = new MultiReader(prefix, isr);
                    doc.add((Fieldable)new Field(attributeName, (Reader)multiReader, Field.TermVector.NO));
                    continue;
                }
                if (s_logger.isInfoEnabled()) {
                    s_logger.info((Object)("Not indexed: Content Missing \n   node: " + nodeRef + " at " + this.nodeService.getPath(nodeRef) + "\n" + "   reader: " + reader + "\n" + "   content exists: " + (reader == null ? " --- " : Boolean.toString(reader.exists()))));
                }
                doc.add((Fieldable)new Field(attributeName, "nicm", Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.NO));
                continue;
            }
            Field.Store store2 = fieldStore = store ? Field.Store.YES : Field.Store.NO;
            if (index) {
                switch (tokenise) {
                    default: {
                        fieldIndex = Field.Index.TOKENIZED;
                        break;
                    }
                    case FALSE: {
                        fieldIndex = Field.Index.UN_TOKENIZED;
                        break;
                    }
                }
            } else {
                fieldIndex = Field.Index.NO;
            }
            if (fieldIndex == Field.Index.NO && fieldStore == Field.Store.NO) continue;
            if (isMultiLingual) {
                MLText mlText = (MLText)DefaultTypeConverter.INSTANCE.convert(MLText.class, (Object)serializableValue);
                block35: for (Locale locale : mlText.getLocales()) {
                    String localeString = mlText.getValue(locale);
                    if (localeString == null) continue;
                    switch (tokenise) {
                        case TRUE: {
                            builder = new StringBuilder();
                            builder.append("\u0000").append(locale.toString()).append("\u0000").append(localeString);
                            doc.add((Fieldable)new Field(attributeName, builder.toString(), fieldStore, fieldIndex, Field.TermVector.NO));
                            break;
                        }
                        case FALSE: {
                            int end;
                            String localeText;
                            Token t;
                            MLAnalysisMode analysisMode = this.getLuceneConfig().getDefaultMLIndexAnalysisMode();
                            VerbatimAnalyser vba = new VerbatimAnalyser(false);
                            MLTokenDuplicator duplicator = new MLTokenDuplicator(vba.tokenStream(attributeName, (Reader)new StringReader(localeString)), locale, null, analysisMode);
                            try {
                                while ((t = duplicator.next()) != null) {
                                    localeText = "";
                                    if (t.termText().indexOf(123) == 0 && (end = t.termText().indexOf(125, 1)) != -1) {
                                        localeText = t.termText().substring(1, end);
                                    }
                                    if (localeText.length() > 0) {
                                        doc.add((Fieldable)new Field(attributeName + "." + localeText + ".sort", t.termText(), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                                    }
                                    doc.add((Fieldable)new Field(attributeName, t.termText(), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                                }
                                continue block35;
                            }
                            catch (IOException e) {
                                break;
                            }
                        }
                        case BOTH: {
                            int end;
                            String localeText;
                            Token t;
                            builder = new StringBuilder();
                            builder.append("\u0000").append(locale.toString()).append("\u0000").append(localeString);
                            doc.add((Fieldable)new Field(attributeName, builder.toString(), fieldStore, fieldIndex, Field.TermVector.NO));
                            MLAnalysisMode analysisMode = this.getLuceneConfig().getDefaultMLIndexAnalysisMode();
                            VerbatimAnalyser vba = new VerbatimAnalyser(false);
                            MLTokenDuplicator duplicator = new MLTokenDuplicator(vba.tokenStream(attributeName, (Reader)new StringReader(localeString)), locale, null, analysisMode);
                            try {
                                while ((t = duplicator.next()) != null) {
                                    localeText = "";
                                    if (t.termText().indexOf(123) == 0 && (end = t.termText().indexOf(125, 1)) != -1) {
                                        localeText = t.termText().substring(1, end);
                                    }
                                    if (localeText.length() > 0) {
                                        doc.add((Fieldable)new Field(attributeName + "." + localeText + ".sort", t.termText(), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                                        continue;
                                    }
                                    doc.add((Fieldable)new Field(attributeName + ".no_locale", t.termText(), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                                }
                                continue block35;
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                    }
                }
                continue;
            }
            if (isText) {
                if (propertyName.equals((Object)ContentModel.PROP_USER_USERNAME) || propertyName.equals((Object)ContentModel.PROP_USERNAME) || propertyName.equals((Object)ContentModel.PROP_AUTHORITY_NAME)) {
                    doc.add((Fieldable)new Field(attributeName, strValue, fieldStore, fieldIndex, Field.TermVector.NO));
                }
                Locale locale = null;
                Serializable localeProperty = this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCALE);
                if (localeProperty != null) {
                    locale = (Locale)DefaultTypeConverter.INSTANCE.convert(Locale.class, (Object)localeProperty);
                }
                if (locale == null) {
                    locale = I18NUtil.getLocale();
                }
                switch (tokenise) {
                    default: {
                        StringBuilder builder2 = new StringBuilder();
                        builder2.append("\u0000").append(locale.toString()).append("\u0000").append(strValue);
                        doc.add((Fieldable)new Field(attributeName, builder2.toString(), fieldStore, fieldIndex, Field.TermVector.NO));
                        break;
                    }
                    case FALSE: {
                        String localeText;
                        Token t;
                        MLAnalysisMode analysisMode = this.getLuceneConfig().getDefaultMLIndexAnalysisMode();
                        VerbatimAnalyser vba = new VerbatimAnalyser(false);
                        MLTokenDuplicator duplicator = new MLTokenDuplicator(vba.tokenStream(attributeName, (Reader)new StringReader(strValue)), locale, null, analysisMode);
                        try {
                            while ((t = duplicator.next()) != null) {
                                int end;
                                localeText = "";
                                if (t.termText().indexOf(123) == 0 && (end = t.termText().indexOf(125, 1)) != -1) {
                                    localeText = t.termText().substring(1, end);
                                }
                                if (localeText.length() > 0) {
                                    doc.add((Fieldable)new Field(attributeName + "." + localeText + ".sort", t.termText(), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                                }
                                doc.add((Fieldable)new Field(attributeName, t.termText(), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                            }
                            continue block34;
                        }
                        catch (IOException e) {
                            break;
                        }
                    }
                    case BOTH: {
                        String localeText;
                        Token t;
                        StringBuilder builder2 = new StringBuilder();
                        builder2.append("\u0000").append(locale.toString()).append("\u0000").append(strValue);
                        doc.add((Fieldable)new Field(attributeName, builder2.toString(), fieldStore, fieldIndex, Field.TermVector.NO));
                        MLAnalysisMode analysisMode = this.getLuceneConfig().getDefaultMLIndexAnalysisMode();
                        VerbatimAnalyser vba = new VerbatimAnalyser(false);
                        MLTokenDuplicator duplicator = new MLTokenDuplicator(vba.tokenStream(attributeName, (Reader)new StringReader(strValue)), locale, null, analysisMode);
                        try {
                            while ((t = duplicator.next()) != null) {
                                int end;
                                localeText = "";
                                if (t.termText().indexOf(123) == 0 && (end = t.termText().indexOf(125, 1)) != -1) {
                                    localeText = t.termText().substring(1, end);
                                }
                                if (localeText.length() > 0) {
                                    doc.add((Fieldable)new Field(attributeName + "." + localeText + ".sort", t.termText(), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                                    continue;
                                }
                                doc.add((Fieldable)new Field(attributeName + ".no_locale", t.termText(), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                            }
                            continue block34;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
                continue;
            }
            if (isDateTime) {
                switch (tokenise) {
                    default: {
                        doc.add((Fieldable)new Field(attributeName, strValue, fieldStore, fieldIndex, Field.TermVector.NO));
                        break;
                    }
                    case FALSE: {
                        SimpleDateFormat df = CachingDateFormat.getDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (boolean)true);
                        try {
                            Date date = df.parse(strValue);
                            doc.add((Fieldable)new Field(attributeName, df.format(date), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                        }
                        catch (ParseException e) {}
                        break;
                    }
                    case BOTH: {
                        doc.add((Fieldable)new Field(attributeName, strValue, fieldStore, fieldIndex, Field.TermVector.NO));
                        SimpleDateFormat df = CachingDateFormat.getDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (boolean)true);
                        try {
                            Date date = df.parse(strValue);
                            doc.add((Fieldable)new Field(attributeName + ".sort", df.format(date), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                        }
                        catch (ParseException e) {}
                        break;
                    }
                }
                continue;
            }
            doc.add((Fieldable)new Field(attributeName, strValue, fieldStore, fieldIndex, Field.TermVector.NO));
        }
        return wereAllAtomic;
    }

    private boolean mayHaveChildren(NodeRef nodeRef) {
        QName nodeTypeRef = this.nodeService.getType(nodeRef);
        TypeDefinition nodeTypeDef = this.getDictionaryService().getType(nodeTypeRef);
        if (nodeTypeDef != null && nodeTypeDef.getChildAssociations().size() > 0) {
            return true;
        }
        Set aspects = this.nodeService.getAspects(nodeRef);
        for (QName aspect : aspects) {
            AspectDefinition aspectDef = this.getDictionaryService().getAspect(aspect);
            if (aspectDef == null || aspectDef.getChildAssociations().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private ArrayList<NodeRef> getParents(Path path) {
        ArrayList<NodeRef> parentsInDepthOrderStartingWithSelf = new ArrayList<NodeRef>(8);
        for (Path.Element element : path) {
            if (!(element instanceof Path.ChildAssocElement)) {
                throw new IndexerException("Confused path: " + path);
            }
            Path.ChildAssocElement cae = (Path.ChildAssocElement)element;
            parentsInDepthOrderStartingWithSelf.add(0, cae.getRef().getChildRef());
        }
        return parentsInDepthOrderStartingWithSelf;
    }

    private ChildAssociationRef getLastRefOrNull(Path path) {
        if (path.last() instanceof Path.ChildAssocElement) {
            Path.ChildAssocElement cae = (Path.ChildAssocElement)path.last();
            return cae.getRef();
        }
        return null;
    }

    private Map<ChildAssociationRef, Counter> getNodeCounts(NodeRef nodeRef) {
        HashMap<ChildAssociationRef, Counter> nodeCounts = new HashMap<ChildAssociationRef, Counter>(5);
        List parentAssocs = this.nodeService.getParentAssocs(nodeRef);
        for (ChildAssociationRef assoc : parentAssocs) {
            Counter counter = (Counter)nodeCounts.get(assoc);
            if (counter == null) {
                counter = new Counter();
                nodeCounts.put(assoc, counter);
            }
            counter.incrementParentCount();
        }
        return nodeCounts;
    }

    private Collection<Pair<Path, QName>> getCategoryPaths(NodeRef nodeRef, Map<QName, Serializable> properties) {
        ArrayList<Pair<Path, QName>> categoryPaths = new ArrayList<Pair<Path, QName>>();
        Set aspects = this.nodeService.getAspects(nodeRef);
        for (QName qName : aspects) {
            AspectDefinition aspDef = this.getDictionaryService().getAspect(qName);
            if (!this.isCategorised(aspDef)) continue;
            LinkedList<Pair<Path, QName>> aspectPaths = new LinkedList<Pair<Path, QName>>();
            for (PropertyDefinition propDef : aspDef.getProperties().values()) {
                if (!propDef.getDataType().getName().equals((Object)DataTypeDefinition.CATEGORY)) continue;
                for (NodeRef catRef : DefaultTypeConverter.INSTANCE.getCollection(NodeRef.class, (Object)properties.get(propDef.getName()))) {
                    if (catRef == null) continue;
                    catRef = this.tenantService.getName(nodeRef, catRef);
                    try {
                        for (Path path : this.nodeService.getPaths(catRef, false)) {
                            if (path.size() <= 1 || !(path.get(1) instanceof Path.ChildAssocElement)) continue;
                            Path.ChildAssocElement cae = (Path.ChildAssocElement)path.get(1);
                            boolean isFakeRoot = true;
                            for (ChildAssociationRef car : this.nodeService.getParentAssocs(cae.getRef().getChildRef())) {
                                if (!cae.getRef().equals((Object)car)) continue;
                                isFakeRoot = false;
                                break;
                            }
                            if (!isFakeRoot || path.toString().indexOf(aspDef.getName().toString()) == -1) continue;
                            aspectPaths.add(new Pair<Path, QName>(path, aspDef.getName()));
                        }
                    }
                    catch (InvalidNodeRefException e) {
                    }
                }
            }
            categoryPaths.addAll(aspectPaths);
        }
        for (Pair pair : categoryPaths) {
            if (!(((Path)pair.getFirst()).last() instanceof Path.ChildAssocElement)) continue;
            Path.ChildAssocElement cae = (Path.ChildAssocElement)((Path)pair.getFirst()).last();
            ChildAssociationRef assocRef = cae.getRef();
            ((Path)pair.getFirst()).append((Path.Element)new Path.ChildAssocElement(new ChildAssociationRef(assocRef.getTypeQName(), assocRef.getChildRef(), QName.createQName((String)"member"), nodeRef)));
        }
        return categoryPaths;
    }

    private boolean isCategorised(AspectDefinition aspDef) {
        if (aspDef == null) {
            return false;
        }
        AspectDefinition current = aspDef;
        while (current != null) {
            if (current.getName().equals((Object)ContentModel.ASPECT_CLASSIFIABLE)) {
                return true;
            }
            QName parentName = current.getParentName();
            if (parentName == null) break;
            current = this.getDictionaryService().getAspect(parentName);
        }
        return false;
    }

    private boolean isCategory(TypeDefinition typeDef) {
        if (typeDef == null) {
            return false;
        }
        TypeDefinition current = typeDef;
        while (current != null) {
            if (current.getName().equals((Object)ContentModel.TYPE_CATEGORY)) {
                return true;
            }
            QName parentName = current.getParentName();
            if (parentName == null) break;
            current = this.getDictionaryService().getType(parentName);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int updateFullTextSearch(int size) throws LuceneIndexException {
        this.checkAbleToDoWork(AbstractLuceneIndexerImpl.IndexUpdateStatus.ASYNCHRONOUS);
        try {
            int n;
            ClosingIndexSearcher searcher;
            int count;
            NodeRef lastId;
            block22: {
                int n2;
                block21: {
                    lastId = null;
                    this.toFTSIndex = new ArrayList(size);
                    BooleanQuery booleanQuery = new BooleanQuery();
                    booleanQuery.add((Query)new TermQuery(new Term("FTSSTATUS", "Dirty")), BooleanClause.Occur.SHOULD);
                    booleanQuery.add((Query)new TermQuery(new Term("FTSSTATUS", "New")), BooleanClause.Occur.SHOULD);
                    count = 0;
                    searcher = null;
                    try {
                        Hits hits;
                        searcher = this.getSearcher(null);
                        if (searcher == null) {
                            this.remainingCount = size;
                            n2 = 0;
                            Object var11_10 = null;
                            if (searcher == null) return n2;
                            break block21;
                        }
                        try {
                            hits = searcher.search((Query)booleanQuery);
                        }
                        catch (IOException e) {
                            throw new LuceneIndexException("Failed to execute query to find content which needs updating in the index", e);
                        }
                        for (int i = 0; i < hits.length(); ++i) {
                            Document doc = hits.doc(i);
                            Helper helper = new Helper(doc.getField("ID").stringValue(), doc.getField("TX").stringValue());
                            this.toFTSIndex.add(helper);
                            if (++count >= size) break;
                        }
                        count = hits.length();
                        break block22;
                    }
                    catch (Throwable throwable) {
                        Object var11_12 = null;
                        if (searcher == null) throw throwable;
                        try {
                            searcher.close();
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new LuceneIndexException("Failed to close searcher", e);
                        }
                    }
                }
                try {}
                catch (IOException e) {
                    throw new LuceneIndexException("Failed to close searcher", e);
                }
                searcher.close();
                return n2;
            }
            Object var11_11 = null;
            if (searcher != null) {
                try {}
                catch (IOException e) {
                    throw new LuceneIndexException("Failed to close searcher", e);
                }
                searcher.close();
            }
            if (this.toFTSIndex.size() <= 0) return 0;
            this.checkAbleToDoWork(AbstractLuceneIndexerImpl.IndexUpdateStatus.ASYNCHRONOUS);
            IndexWriter writer = null;
            try {
                writer = this.getDeltaWriter();
                for (Helper helper : this.toFTSIndex) {
                    NodeRef ref = new NodeRef(helper.ref);
                    if (!this.nodeService.exists(ref)) continue;
                    List<Document> docs = this.createDocuments(ref.toString(), false, true, false);
                    for (Document doc : docs) {
                        try {
                            writer.addDocument(doc);
                        }
                        catch (IOException e) {
                            throw new LuceneIndexException("Failed to add document while updating fts index", e);
                        }
                    }
                    if (writer.docCount() <= size) continue;
                    if (lastId == null) {
                        lastId = ref;
                    }
                    if (lastId.equals((Object)ref)) continue;
                }
                int done = writer.docCount();
                this.remainingCount = count - done;
                n = done;
                Object var15_27 = null;
                if (writer == null) return n;
            }
            catch (Throwable throwable) {
                Object var15_28 = null;
                if (writer == null) throw throwable;
                this.closeDeltaWriter();
                throw throwable;
            }
            this.closeDeltaWriter();
            return n;
        }
        catch (IOException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Failed FTS update", e);
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Failed FTS update", (Throwable)((Object)e));
        }
    }

    @Override
    public void registerCallBack(FTSIndexerAware callBack) {
        this.callBack = callBack;
    }

    @Override
    public void setFullTextSearchIndexer(FullTextSearchIndexer fullTextSearchIndexer) {
        this.fullTextSearchIndexer = fullTextSearchIndexer;
    }

    @Override
    protected void doPrepare() throws IOException {
        this.saveDelta();
        this.flushPending();
    }

    @Override
    protected void doCommit() throws IOException {
        if (this.indexUpdateStatus == AbstractLuceneIndexerImpl.IndexUpdateStatus.ASYNCHRONOUS) {
            this.doFTSIndexCommit();
        } else {
            this.setInfo(this.docs, this.getDeletions(), false);
            this.fullTextSearchIndexer.requiresIndex(this.store);
        }
        if (this.callBack != null) {
            this.callBack.indexCompleted(this.store, this.remainingCount, null);
        }
    }

    @Override
    protected void doRollBack() throws IOException {
        if (this.callBack != null) {
            this.callBack.indexCompleted(this.store, 0, null);
        }
    }

    @Override
    protected void doSetRollbackOnly() throws IOException {
    }

    @Override
    public void deleteIndex(StoreRef storeRef) {
        this.deleteIndex();
    }

    private static class Helper {
        String ref;
        String tx;

        Helper(String ref, String tx) {
            this.ref = ref;
            this.tx = tx;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Pair<F, S> {
        private F first;
        private S second;

        public Pair(F first, S second) {
            this.first = first;
            this.second = second;
        }

        public F getFirst() {
            return this.first;
        }

        public S getSecond() {
            return this.second;
        }
    }

    static class Counter {
        int countInParent = 0;
        int count = -1;

        Counter() {
        }

        int getCountInParent() {
            return this.countInParent;
        }

        int getRepeat() {
            return this.count / this.countInParent + 1;
        }

        void incrementParentCount() {
            ++this.countInParent;
        }

        void increment() {
            ++this.count;
        }
    }
}

