/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.alfresco.repo.search.IndexerException;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneBase;
import org.alfresco.repo.search.impl.lucene.LuceneIndexException;
import org.alfresco.repo.search.impl.lucene.index.TransactionStatus;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLuceneIndexerImpl<T>
extends AbstractLuceneBase {
    protected long docs;
    public static final String NOT_INDEXED_NO_TRANSFORMATION = "nint";
    public static final String NOT_INDEXED_TRANSFORMATION_FAILED = "nitf";
    public static final String NOT_INDEXED_CONTENT_MISSING = "nicm";
    public static final String NOT_INDEXED_NO_TYPE_CONVERSION = "nintc";
    private static Log s_logger = LogFactory.getLog(AbstractLuceneIndexerImpl.class);
    protected long maxAtomicTransformationTime = 20L;
    protected Set<String> deletions = new LinkedHashSet<String>();
    protected List<Command<T>> commandList = new ArrayList<Command<T>>(10000);
    protected IndexUpdateStatus indexUpdateStatus = IndexUpdateStatus.UNMODIFIED;

    protected static Set<String> deletePrimary(Collection<String> nodeRefs, IndexReader reader, boolean delete) throws LuceneIndexException {
        LinkedHashSet<String> refs = new LinkedHashSet<String>();
        for (String nodeRef : nodeRefs) {
            try {
                TermDocs td = reader.termDocs(new Term("PRIMARYPARENT", nodeRef));
                while (td.next()) {
                    int doc = td.doc();
                    Document document = reader.document(doc);
                    String[] ids = document.getValues("ID");
                    refs.add(ids[ids.length - 1]);
                    if (!delete) continue;
                    reader.deleteDocument(doc);
                }
            }
            catch (IOException e) {
                throw new LuceneIndexException("Failed to delete node by primary parent for " + nodeRef, e);
            }
        }
        return refs;
    }

    protected static Set<String> deleteReference(Collection<String> nodeRefs, IndexReader reader, boolean delete) throws LuceneIndexException {
        LinkedHashSet<String> refs = new LinkedHashSet<String>();
        for (String nodeRef : nodeRefs) {
            try {
                TermDocs td = reader.termDocs(new Term("PARENT", nodeRef));
                while (td.next()) {
                    int doc = td.doc();
                    Document document = reader.document(doc);
                    String[] ids = document.getValues("ID");
                    refs.add(ids[ids.length - 1]);
                    if (!delete) continue;
                    reader.deleteDocument(doc);
                }
            }
            catch (IOException e) {
                throw new LuceneIndexException("Failed to delete node by parent for " + nodeRef, e);
            }
        }
        return refs;
    }

    protected static Set<String> deleteContainerAndBelow(String nodeRef, IndexReader reader, boolean delete, boolean cascade) throws LuceneIndexException {
        LinkedHashSet<String> refs = new LinkedHashSet<String>();
        try {
            if (delete) {
                reader.deleteDocuments(new Term("ID", nodeRef));
            }
            refs.add(nodeRef);
            if (cascade) {
                TermDocs td = reader.termDocs(new Term("ANCESTOR", nodeRef));
                while (td.next()) {
                    int doc = td.doc();
                    Document document = reader.document(doc);
                    String[] ids = document.getValues("ID");
                    refs.add(ids[ids.length - 1]);
                    if (!delete) continue;
                    reader.deleteDocument(doc);
                }
            }
        }
        catch (IOException e) {
            throw new LuceneIndexException("Failed to delete container and below for " + nodeRef, e);
        }
        return refs;
    }

    public void setMaxAtomicTransformationTime(long maxAtomicTransformationTime) {
        this.maxAtomicTransformationTime = maxAtomicTransformationTime;
    }

    protected void checkAbleToDoWork(IndexUpdateStatus indexUpdateStatus) {
        if (this.indexUpdateStatus != IndexUpdateStatus.UNMODIFIED) {
            if (this.indexUpdateStatus == indexUpdateStatus) {
                return;
            }
            throw new IndexerException("Can not mix FTS and transactional updates");
        }
        this.indexUpdateStatus = indexUpdateStatus;
        switch (this.getStatus()) {
            case UNKNOWN: {
                try {
                    this.setStatus(TransactionStatus.ACTIVE);
                    break;
                }
                catch (IOException e) {
                    throw new LuceneIndexException("Failed to set TX active", e);
                }
            }
            case ACTIVE: {
                break;
            }
            default: {
                throw new IndexerException(this.buildErrorString());
            }
        }
    }

    private String buildErrorString() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("The indexer is unable to accept more work: ");
        switch (this.getStatus().getStatus()) {
            case 3: {
                buffer.append("The indexer has been committed");
                break;
            }
            case 8: {
                buffer.append("The indexer is committing");
                break;
            }
            case 1: {
                buffer.append("The indexer is marked for rollback");
                break;
            }
            case 2: {
                buffer.append("The indexer is prepared to commit");
                break;
            }
            case 7: {
                buffer.append("The indexer is preparing to commit");
                break;
            }
            case 4: {
                buffer.append("The indexer has been rolled back");
                break;
            }
            case 9: {
                buffer.append("The indexer is rolling back");
                break;
            }
            case 5: {
                buffer.append("The indexer is in an unknown state");
                break;
            }
        }
        return buffer.toString();
    }

    public void commit() throws LuceneIndexException {
        switch (this.getStatus().getStatus()) {
            case 8: {
                throw new LuceneIndexException("Unable to commit: Transaction is committing");
            }
            case 3: {
                throw new LuceneIndexException("Unable to commit: Transaction is commited ");
            }
            case 9: {
                throw new LuceneIndexException("Unable to commit: Transaction is rolling back");
            }
            case 4: {
                throw new LuceneIndexException("Unable to commit: Transaction is aleady rolled back");
            }
            case 1: {
                throw new LuceneIndexException("Unable to commit: Transaction is marked for roll back");
            }
            case 7: {
                throw new LuceneIndexException("Unable to commit: Transaction is preparing");
            }
            case 0: {
                this.prepare();
            }
        }
        if (this.getStatus().getStatus() != 2) {
            throw new LuceneIndexException("Index must be prepared to commit");
        }
        try {
            try {
                this.setStatus(TransactionStatus.COMMITTING);
                if (this.isModified()) {
                    this.doCommit();
                }
                this.setStatus(TransactionStatus.COMMITTED);
            }
            catch (IOException e) {
                this.rollback();
                throw new LuceneIndexException("Commit failed", e);
            }
            catch (LuceneIndexException e) {
                this.rollback();
                throw new LuceneIndexException("Commit failed", (Throwable)((Object)e));
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            throw throwable;
        }
    }

    public int prepare() throws LuceneIndexException {
        switch (this.getStatus().getStatus()) {
            case 8: {
                throw new IndexerException("Unable to prepare: Transaction is committing");
            }
            case 3: {
                throw new IndexerException("Unable to prepare: Transaction is commited ");
            }
            case 9: {
                throw new IndexerException("Unable to prepare: Transaction is rolling back");
            }
            case 4: {
                throw new IndexerException("Unable to prepare: Transaction is aleady rolled back");
            }
            case 1: {
                throw new IndexerException("Unable to prepare: Transaction is marked for roll back");
            }
            case 7: {
                throw new IndexerException("Unable to prepare: Transaction is already preparing");
            }
            case 2: {
                throw new IndexerException("Unable to prepare: Transaction is already prepared");
            }
        }
        try {
            this.setStatus(TransactionStatus.PREPARING);
            if (this.isModified()) {
                this.doPrepare();
            }
            this.setStatus(TransactionStatus.PREPARED);
            return this.isModified() ? 0 : 3;
        }
        catch (IOException e) {
            this.rollback();
            throw new LuceneIndexException("Commit failed", e);
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Index failed to prepare", (Throwable)((Object)e));
        }
    }

    public boolean isModified() {
        return this.indexUpdateStatus != IndexUpdateStatus.UNMODIFIED;
    }

    public void rollback() throws LuceneIndexException {
        switch (this.getStatus().getStatus()) {
            case 3: {
                throw new IndexerException("Unable to roll back: Transaction is committed ");
            }
            case 9: {
                throw new IndexerException("Unable to roll back: Transaction is rolling back");
            }
            case 4: {
                throw new IndexerException("Unable to roll back: Transaction is already rolled back");
            }
        }
        try {
            this.setStatus(TransactionStatus.ROLLINGBACK);
            this.doRollBack();
            this.setStatus(TransactionStatus.ROLLEDBACK);
        }
        catch (IOException e) {
            throw new LuceneIndexException("rollback failed ", e);
        }
    }

    public void setRollbackOnly() {
        switch (this.getStatus().getStatus()) {
            case 8: {
                throw new IndexerException("Unable to mark for rollback: Transaction is committing");
            }
            case 3: {
                throw new IndexerException("Unable to mark for rollback: Transaction is committed");
            }
        }
        try {
            this.doSetRollbackOnly();
            this.setStatus(TransactionStatus.MARKED_ROLLBACK);
        }
        catch (IOException e) {
            throw new LuceneIndexException("Set rollback only failed ", e);
        }
    }

    protected abstract void doPrepare() throws IOException;

    protected abstract void doCommit() throws IOException;

    protected abstract void doRollBack() throws IOException;

    protected abstract void doSetRollbackOnly() throws IOException;

    protected abstract List<Document> createDocuments(String var1, boolean var2, boolean var3, boolean var4);

    protected Set<String> deleteImpl(String nodeRef, IndexDeleteMode mode, boolean cascade, IndexReader mainReader) throws LuceneIndexException, IOException {
        LinkedHashSet<String> leafrefs = new LinkedHashSet<String>();
        IndexReader deltaReader = null;
        this.getDeltaReader();
        LinkedHashSet<String> refs = new LinkedHashSet<String>();
        Set<String> temp = null;
        switch (mode) {
            case MOVE: {
                temp = AbstractLuceneIndexerImpl.deleteContainerAndBelow(nodeRef, this.getDeltaReader(), true, cascade);
                this.closeDeltaReader();
                refs.addAll(temp);
                this.deletions.addAll(temp);
                temp = AbstractLuceneIndexerImpl.deleteContainerAndBelow(nodeRef, mainReader, false, cascade);
                refs.addAll(temp);
                this.deletions.addAll(temp);
                leafrefs.addAll(AbstractLuceneIndexerImpl.deletePrimary(this.deletions, this.getDeltaReader(), true));
                this.closeDeltaReader();
                leafrefs.addAll(AbstractLuceneIndexerImpl.deleteReference(this.deletions, this.getDeltaReader(), true));
                this.closeDeltaReader();
                refs.addAll(leafrefs);
                this.deletions.addAll(leafrefs);
                deltaReader = this.getDeltaReader();
                for (String id : leafrefs) {
                    deltaReader.deleteDocuments(new Term("ID", id));
                }
                this.closeDeltaReader();
                break;
            }
            case REINDEX: {
                temp = AbstractLuceneIndexerImpl.deleteContainerAndBelow(nodeRef, this.getDeltaReader(), true, cascade);
                this.closeDeltaReader();
                refs.addAll(temp);
                this.deletions.addAll(temp);
                temp = AbstractLuceneIndexerImpl.deleteContainerAndBelow(nodeRef, mainReader, false, cascade);
                refs.addAll(temp);
                this.deletions.addAll(temp);
                break;
            }
            case DELETE: {
                temp = AbstractLuceneIndexerImpl.deleteContainerAndBelow(nodeRef, this.getDeltaReader(), true, cascade);
                this.closeDeltaReader();
                this.deletions.addAll(temp);
                refs.addAll(temp);
                temp = AbstractLuceneIndexerImpl.deleteContainerAndBelow(nodeRef, mainReader, false, cascade);
                this.deletions.addAll(temp);
                refs.addAll(temp);
                leafrefs.clear();
                leafrefs.addAll(AbstractLuceneIndexerImpl.deletePrimary(this.deletions, this.getDeltaReader(), true));
                this.closeDeltaReader();
                leafrefs.addAll(AbstractLuceneIndexerImpl.deletePrimary(this.deletions, mainReader, false));
                leafrefs.addAll(AbstractLuceneIndexerImpl.deleteReference(this.deletions, this.getDeltaReader(), true));
                this.closeDeltaReader();
                leafrefs.addAll(AbstractLuceneIndexerImpl.deleteReference(this.deletions, mainReader, false));
                refs.addAll(leafrefs);
                this.deletions.addAll(leafrefs);
                deltaReader = this.getDeltaReader();
                for (String id : leafrefs) {
                    deltaReader.deleteDocuments(new Term("ID", id));
                }
                this.closeDeltaReader();
            }
        }
        return refs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void indexImpl(String nodeRef, boolean isNew) throws LuceneIndexException, IOException {
        IndexWriter writer = this.getDeltaWriter();
        try {
            List<Document> docs = this.createDocuments(nodeRef, isNew, false, true);
            for (Document doc : docs) {
                try {
                    writer.addDocument(doc);
                }
                catch (IOException e) {
                    throw new LuceneIndexException("Failed to add document to index", e);
                    return;
                }
            }
        }
        catch (InvalidNodeRefException e) {
            return;
        }
    }

    void indexImpl(Set<String> refs, boolean isNew) throws LuceneIndexException, IOException {
        for (String ref : refs) {
            this.indexImpl(ref, isNew);
        }
    }

    protected void index(T ref) throws LuceneIndexException {
        this.addCommand(new Command<T>(ref, Action.INDEX));
    }

    protected void reindex(T ref, boolean cascadeReindexDirectories) throws LuceneIndexException {
        this.addCommand(new Command<T>(ref, cascadeReindexDirectories ? Action.CASCADEREINDEX : Action.REINDEX));
    }

    protected void delete(T ref) throws LuceneIndexException {
        this.addCommand(new Command<T>(ref, Action.DELETE));
    }

    protected void move(T ref) throws LuceneIndexException {
        this.addCommand(new Command<T>(ref, Action.MOVE));
    }

    private void addCommand(Command<T> command) {
        if (this.commandList.size() > 0) {
            Command<T> last = this.commandList.get(this.commandList.size() - 1);
            if (last.action == command.action && last.ref.equals(command.ref)) {
                return;
            }
        }
        this.purgeCommandList(command);
        this.commandList.add(command);
        if (this.commandList.size() > this.getLuceneConfig().getIndexerBatchSize()) {
            this.flushPending();
        }
    }

    private void purgeCommandList(Command<T> command) {
        if (command.action == Action.DELETE) {
            this.removeFromCommandList(command, false);
        } else if (command.action == Action.REINDEX) {
            this.removeFromCommandList(command, true);
        } else if (command.action == Action.INDEX) {
            this.removeFromCommandList(command, true);
        } else if (command.action == Action.CASCADEREINDEX) {
            this.removeFromCommandList(command, true);
        }
    }

    private void removeFromCommandList(Command<T> command, boolean matchExact) {
        ListIterator<Command<T>> it = this.commandList.listIterator(this.commandList.size());
        while (it.hasPrevious()) {
            Command<T> current = it.previous();
            if (matchExact) {
                if (!current.ref.equals(command.ref)) continue;
                if (current.action == command.action) {
                    it.remove();
                    return;
                }
                if (command.action == Action.DELETE || current.action != Action.INDEX) continue;
                it.remove();
                command.action = Action.INDEX;
                continue;
            }
            if (!current.ref.equals(command.ref)) continue;
            it.remove();
        }
    }

    /*
     * Loose catch block
     */
    public void flushPending() throws LuceneIndexException {
        block21: {
            IndexReader mainReader;
            block19: {
                mainReader = null;
                mainReader = this.getReader();
                LinkedHashSet<String> forIndex = new LinkedHashSet<String>();
                for (Command<T> command : this.commandList) {
                    Set<String> set;
                    if (command.action == Action.INDEX) {
                        forIndex.add(command.ref.toString());
                        continue;
                    }
                    if (command.action == Action.REINDEX) {
                        set = this.deleteImpl(command.ref.toString(), IndexDeleteMode.REINDEX, false, mainReader);
                        forIndex.removeAll(set);
                        forIndex.addAll(set);
                        continue;
                    }
                    if (command.action == Action.CASCADEREINDEX) {
                        set = this.deleteImpl(command.ref.toString(), IndexDeleteMode.REINDEX, true, mainReader);
                        forIndex.removeAll(set);
                        forIndex.addAll(set);
                        continue;
                    }
                    if (command.action == Action.DELETE) {
                        set = this.deleteImpl(command.ref.toString(), IndexDeleteMode.DELETE, true, mainReader);
                        forIndex.removeAll(set);
                        forIndex.addAll(set);
                        continue;
                    }
                    if (command.action != Action.MOVE) continue;
                    set = this.deleteImpl(command.ref.toString(), IndexDeleteMode.MOVE, true, mainReader);
                    forIndex.removeAll(set);
                    forIndex.addAll(set);
                }
                this.commandList.clear();
                this.indexImpl(forIndex, false);
                this.docs = this.getDeltaWriter().docCount();
                Object var7_7 = null;
                if (mainReader == null) break block19;
                try {
                    mainReader.close();
                }
                catch (IOException e) {
                    throw new LuceneIndexException("Filed to close main reader", e);
                }
            }
            try {
                this.closeDeltaReader();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.closeDeltaWriter();
            }
            catch (IOException e) {}
            break block21;
            {
                catch (IOException e) {
                    throw new LuceneIndexException("Failed to flush index", e);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (mainReader != null) {
                    try {
                        mainReader.close();
                    }
                    catch (IOException e) {
                        throw new LuceneIndexException("Filed to close main reader", e);
                    }
                }
                try {
                    this.closeDeltaReader();
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    this.closeDeltaWriter();
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public boolean getDeleteOnlyNodes() {
        return this.indexUpdateStatus == IndexUpdateStatus.ASYNCHRONOUS;
    }

    public Set<String> getDeletions() {
        return Collections.unmodifiableSet(this.deletions);
    }

    public void deleteAll() {
        this.deleteAll(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteAll(String prefix) {
        IndexReader mainReader = null;
        try {
            try {
                mainReader = this.getReader();
                for (int doc = 0; doc < mainReader.maxDoc(); ++doc) {
                    if (mainReader.isDeleted(doc)) continue;
                    Document document = mainReader.document(doc);
                    String[] ids = document.getValues("ID");
                    if (prefix != null && !this.nonStartwWith(ids, prefix)) continue;
                    this.deletions.add(ids[ids.length - 1]);
                }
                Object var7_7 = null;
                if (mainReader == null) return;
            }
            catch (IOException e) {
                throw new LuceneIndexException("Failed to delete all entries from the index", e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (mainReader == null) throw throwable;
            try {
                mainReader.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new LuceneIndexException("Filed to close main reader", e);
            }
        }
        try {}
        catch (IOException e) {
            throw new LuceneIndexException("Filed to close main reader", e);
        }
        mainReader.close();
    }

    private boolean nonStartwWith(String[] values, String prefix) {
        for (String value : values) {
            if (!value.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Command<S> {
        S ref;
        Action action;

        Command(S ref, Action action) {
            this.ref = ref;
            this.action = action;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            if (this.action == Action.INDEX) {
                buffer.append("Index ");
            } else if (this.action == Action.DELETE) {
                buffer.append("Delete ");
            } else if (this.action == Action.REINDEX) {
                buffer.append("Reindex ");
            } else {
                buffer.append("Unknown ... ");
            }
            buffer.append(this.ref);
            return buffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum IndexDeleteMode {
        REINDEX,
        DELETE,
        MOVE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum IndexUpdateStatus {
        UNMODIFIED,
        SYNCRONOUS,
        ASYNCHRONOUS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Action {
        INDEX,
        REINDEX,
        DELETE,
        MOVE,
        CASCADEREINDEX;

    }
}

