/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.File;
import java.util.Collections;
import junit.framework.TestCase;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneIndexerAndSearcherFactory;
import org.alfresco.repo.search.impl.lucene.LuceneIndexerAndSearcher;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.TempFileProvider;
import org.springframework.context.ApplicationContext;

public class LuceneIndexBackupComponentTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private AbstractLuceneIndexerAndSearcherFactory.LuceneIndexBackupComponent backupComponent;
    private File tempTargetDir;
    private AuthenticationComponent authenticationComponent;

    public void setUp() throws Exception {
        TransactionService transactionService = (TransactionService)ctx.getBean("transactionComponent");
        NodeService nodeService = (NodeService)ctx.getBean("NodeService");
        LuceneIndexerAndSearcher factory = (LuceneIndexerAndSearcher)ctx.getBean("admLuceneIndexerAndSearcherFactory");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.tempTargetDir = new File(TempFileProvider.getTempDir(), this.getName());
        this.tempTargetDir.mkdir();
        this.backupComponent = new AbstractLuceneIndexerAndSearcherFactory.LuceneIndexBackupComponent();
        this.backupComponent.setTransactionService(transactionService);
        this.backupComponent.setFactories(Collections.singleton(factory));
        this.backupComponent.setNodeService(nodeService);
        this.backupComponent.setTargetLocation(this.tempTargetDir.toString());
    }

    protected void tearDown() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        super.tearDown();
    }

    public void testBackup() {
        this.backupComponent.backup();
        LuceneIndexBackupComponentTest.assertTrue((String)"Target location doesn't exist", (boolean)this.tempTargetDir.exists());
    }
}

