/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.GrantedAuthorityImpl;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import net.sf.acegisecurity.providers.dao.User;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;

public class AuthenticationContextImpl
implements AuthenticationContext {
    private TenantService tenantService;

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public Authentication setUserDetails(UserDetails ud) {
        Authentication authentication;
        try {
            UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)ud, (Object)"", ud.getAuthorities());
            auth.setDetails((Object)ud);
            auth.setAuthenticated(true);
            authentication = this.setCurrentAuthentication((Authentication)auth);
            Object var5_5 = null;
        }
        catch (net.sf.acegisecurity.AuthenticationException ae) {
            try {
                throw new AuthenticationException(ae.getMessage(), (Throwable)ae);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                AuthenticationUtil.logNDC((String)ud.getUsername());
                throw throwable;
            }
        }
        AuthenticationUtil.logNDC((String)ud.getUsername());
        return authentication;
    }

    public Authentication setSystemUserAsCurrentUser() {
        return this.setSystemUserAsCurrentUser("");
    }

    public Authentication setSystemUserAsCurrentUser(String tenantDomain) {
        GrantedAuthority[] gas = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_SYSTEM")};
        return this.setUserDetails((UserDetails)new User(this.getSystemUserName(tenantDomain), "", true, true, true, true, gas));
    }

    public String getSystemUserName() {
        return "System";
    }

    public String getSystemUserName(String tenantDomain) {
        return this.tenantService.getDomainUser(this.getSystemUserName(), tenantDomain);
    }

    public boolean isSystemUserName(String userName) {
        return this.getSystemUserName().equals(this.tenantService.getBaseNameUser(userName));
    }

    public boolean isCurrentUserTheSystemUser() {
        return this.isSystemUserName(this.getCurrentUserName());
    }

    public String getGuestUserName(String tenantDomain) {
        return this.tenantService.getDomainUser(this.getGuestUserName(), tenantDomain);
    }

    public String getGuestUserName() {
        return AuthenticationUtil.getGuestUserName();
    }

    public boolean isGuestUserName(String userName) {
        return AuthenticationUtil.getGuestUserName().equalsIgnoreCase(this.tenantService.getBaseNameUser(userName));
    }

    public Authentication setCurrentAuthentication(Authentication authentication) {
        return AuthenticationUtil.setFullAuthentication((Authentication)authentication);
    }

    public Authentication getCurrentAuthentication() throws AuthenticationException {
        return AuthenticationUtil.getFullAuthentication();
    }

    public String getCurrentUserName() throws AuthenticationException {
        return AuthenticationUtil.getFullyAuthenticatedUser();
    }

    public void clearCurrentSecurityContext() {
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    public String getUserDomain(String userName) {
        return this.tenantService.getUserDomain(userName);
    }
}

