/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.UserTransaction;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sf.acegisecurity.AccountExpiredException;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationManager;
import net.sf.acegisecurity.BadCredentialsException;
import net.sf.acegisecurity.CredentialsExpiredException;
import net.sf.acegisecurity.DisabledException;
import net.sf.acegisecurity.LockedException;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.management.subsystems.ChildApplicationContextManager;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.InMemoryTicketComponentImpl;
import org.alfresco.repo.security.authentication.MD4PasswordEncoder;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.authentication.RepositoryAuthenticationDao;
import org.alfresco.repo.security.authentication.TicketComponent;
import org.alfresco.repo.security.person.UserNameMatcher;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.DynamicNamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private NodeService nodeService;
    private TenantService tenantService;
    private SearchService searchService;
    private NodeRef rootNodeRef;
    private NodeRef systemNodeRef;
    private NodeRef typesNodeRef;
    private NodeRef personAndyNodeRef;
    private DictionaryService dictionaryService;
    private MD4PasswordEncoder passwordEncoder;
    private MutableAuthenticationDao dao;
    private AuthenticationManager authenticationManager;
    private TicketComponent ticketComponent;
    private SimpleCache<String, InMemoryTicketComponentImpl.Ticket> ticketsCache;
    private MutableAuthenticationService authenticationService;
    private MutableAuthenticationService pubAuthenticationService;
    private AuthenticationComponent authenticationComponent;
    private UserTransaction userTransaction;
    private AuthenticationComponent authenticationComponentImpl;
    private TransactionService transactionService;
    private PersonService pubPersonService;
    private PersonService personService;
    private UserNameMatcher userNameMatcher;
    private Dialect dialect;

    public AuthenticationTest() {
    }

    public AuthenticationTest(String arg0) {
        super(arg0);
    }

    public void setUp() throws Exception {
        this.dialect = (Dialect)ctx.getBean("dialect");
        this.nodeService = (NodeService)ctx.getBean("nodeService");
        this.tenantService = (TenantService)ctx.getBean("tenantService");
        this.searchService = (SearchService)ctx.getBean("searchService");
        this.dictionaryService = (DictionaryService)ctx.getBean("dictionaryService");
        this.passwordEncoder = (MD4PasswordEncoder)ctx.getBean("passwordEncoder");
        this.ticketComponent = (TicketComponent)ctx.getBean("ticketComponent");
        this.authenticationService = (MutableAuthenticationService)ctx.getBean("authenticationService");
        this.pubAuthenticationService = (MutableAuthenticationService)ctx.getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.authenticationComponentImpl = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.pubPersonService = (PersonService)ctx.getBean("PersonService");
        this.personService = (PersonService)ctx.getBean("personService");
        this.userNameMatcher = (UserNameMatcher)ctx.getBean("userNameMatcher");
        this.ticketsCache = (SimpleCache)ctx.getBean("ticketsCache");
        this.dao = (MutableAuthenticationDao)ctx.getBean("authenticationDao");
        ChildApplicationContextManager authenticationChain = (ChildApplicationContextManager)ctx.getBean("Authentication");
        ApplicationContext subsystem = authenticationChain.getApplicationContext(authenticationChain.getInstanceIds().iterator().next());
        this.authenticationManager = (AuthenticationManager)subsystem.getBean("authenticationManager");
        this.transactionService = (TransactionService)ctx.getBean(ServiceRegistry.TRANSACTION_SERVICE.getLocalName());
        this.userTransaction = this.transactionService.getUserTransaction();
        this.userTransaction.begin();
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        QName children = ContentModel.ASSOC_CHILDREN;
        QName system = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"system");
        QName container = ContentModel.TYPE_CONTAINER;
        QName types = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"people");
        this.systemNodeRef = this.nodeService.createNode(this.rootNodeRef, children, system, container).getChildRef();
        this.typesNodeRef = this.nodeService.createNode(this.systemNodeRef, children, types, container).getChildRef();
        Map<QName, Serializable> props = this.createPersonProperties("Andy");
        this.personAndyNodeRef = this.nodeService.createNode(this.typesNodeRef, children, ContentModel.TYPE_PERSON, container, props).getChildRef();
        AuthenticationTest.assertNotNull((Object)this.personAndyNodeRef);
        this.deleteAndy();
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    private void deleteAndy() {
        RepositoryAuthenticationDao dao = new RepositoryAuthenticationDao();
        dao.setTenantService(this.tenantService);
        dao.setNodeService(this.nodeService);
        dao.setSearchService(this.searchService);
        dao.setDictionaryService(this.dictionaryService);
        dao.setNamespaceService(this.getNamespacePrefixReolsver(""));
        dao.setPasswordEncoder(this.passwordEncoder);
        dao.setUserNameMatcher(this.userNameMatcher);
        dao.setRetryingTransactionHelper(this.transactionService.getRetryingTransactionHelper());
        if (dao.getUserOrNull("andy") != null) {
            dao.deleteUser("andy");
        }
        if (this.personService.personExists("andy")) {
            this.personService.deletePerson("andy");
        }
    }

    protected void tearDown() throws Exception {
        if (this.userTransaction.getStatus() == 0 || this.userTransaction.getStatus() == 1) {
            this.userTransaction.rollback();
        }
        AuthenticationUtil.clearCurrentSecurityContext();
        super.tearDown();
    }

    private Map<QName, Serializable> createPersonProperties(String userName) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)"Andy"));
        return properties;
    }

    public void testSystemTicket() throws Exception {
        AuthenticationTest.assertNull((Object)AuthenticationUtil.getFullAuthentication());
        AuthenticationTest.assertNull((Object)AuthenticationUtil.getRunAsAuthentication());
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("andy", "andy".toCharArray());
        this.pubAuthenticationService.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)AuthenticationUtil.getFullAuthentication());
        AuthenticationTest.assertNull((Object)AuthenticationUtil.getRunAsAuthentication());
        this.pubAuthenticationService.authenticate("andy", "andy".toCharArray());
        String userName = this.pubAuthenticationService.getCurrentUserName();
        AuthenticationTest.assertEquals((String)"andy", (String)userName);
        String ticket = this.pubAuthenticationService.getCurrentTicket();
        AuthenticationTest.assertEquals((String)"andy", (String)this.ticketComponent.getAuthorityForTicket(ticket));
        userName = this.pubAuthenticationService.getCurrentUserName();
        AuthenticationTest.assertEquals((String)"andy", (String)userName);
        AuthenticationTest.assertTrue((boolean)this.pubPersonService.personExists(userName));
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork(){

            public Object doWork() throws Exception {
                Assert.assertEquals((String)"andy", (String)AuthenticationTest.this.ticketComponent.getAuthorityForTicket(AuthenticationTest.this.pubAuthenticationService.getCurrentTicket()));
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        this.pubPersonService.getPerson(userName);
        AuthenticationTest.assertTrue((boolean)this.pubPersonService.personExists(userName));
        String newticket = this.pubAuthenticationService.getCurrentTicket();
        AuthenticationTest.assertEquals((String)ticket, (String)newticket);
        AuthenticationTest.assertEquals((String)"andy", (String)this.ticketComponent.getAuthorityForTicket(newticket));
        userName = this.pubAuthenticationService.getCurrentUserName();
        AuthenticationTest.assertEquals((String)"andy", (String)userName);
        this.pubAuthenticationService.validate(ticket);
        userName = this.pubAuthenticationService.getCurrentUserName();
        AuthenticationTest.assertEquals((String)"andy", (String)userName);
        this.pubAuthenticationService.validate(newticket);
        userName = this.pubAuthenticationService.getCurrentUserName();
        AuthenticationTest.assertEquals((String)"andy", (String)userName);
    }

    public void xtestScalability() {
        long create = 0L;
        this.authenticationComponent.authenticate(AuthenticationUtil.getAdminUserName(), "admin".toCharArray());
        for (int i = 0; i < 10000; ++i) {
            String id = "TestUser-" + i;
            long start = System.nanoTime();
            this.authenticationService.createAuthentication(id, id.toCharArray());
            long end = System.nanoTime();
            create += end - start;
            if (i <= 0 || i % 100 != 0) continue;
            System.out.println("Count = " + i);
            System.out.println("Average create : " + (float)(create / (long)i) / 1000000.0f);
            start = System.nanoTime();
            this.dao.userExists(id);
            end = System.nanoTime();
            System.out.println("Exists : " + (float)(end - start) / 1000000.0f);
        }
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    public void c() {
        try {
            this.authenticationService.authenticate("", "".toCharArray());
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public void testNewTicketOnLogin() {
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth1".toCharArray());
        String ticket1 = this.pubAuthenticationService.getCurrentTicket();
        this.pubAuthenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertFalse((boolean)ticket1.equals(this.pubAuthenticationService.getCurrentTicket()));
    }

    public void testGuest() {
        this.authenticationService.authenticate(AuthenticationUtil.getGuestUserName(), "".toCharArray());
    }

    public void testCreateUsers() {
        this.authenticationService.createAuthentication(AuthenticationUtil.getGuestUserName(), "".toCharArray());
        this.authenticationService.authenticate(AuthenticationUtil.getGuestUserName(), "".toCharArray());
        AuthenticationTest.assertEquals((String)AuthenticationUtil.getGuestUserName(), (String)this.authenticationService.getCurrentUserName());
        this.authenticationService.createAuthentication("Andy", "".toCharArray());
        this.authenticationService.authenticate("Andy", "".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        if (!this.tenantService.isEnabled()) {
            this.authenticationService.createAuthentication("Mr.Woof.Banana@chocolate.chip.cookie.com", "".toCharArray());
            this.authenticationService.authenticate("Mr.Woof.Banana@chocolate.chip.cookie.com", "".toCharArray());
            AuthenticationTest.assertEquals((String)"Mr.Woof.Banana@chocolate.chip.cookie.com", (String)this.authenticationService.getCurrentUserName());
        }
        this.authenticationService.createAuthentication("Andy_Woof/Domain", "".toCharArray());
        this.authenticationService.authenticate("Andy_Woof/Domain", "".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy_Woof/Domain", (String)this.authenticationService.getCurrentUserName());
        this.authenticationService.createAuthentication("Andy_ Woof/Domain", "".toCharArray());
        this.authenticationService.authenticate("Andy_ Woof/Domain", "".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy_ Woof/Domain", (String)this.authenticationService.getCurrentUserName());
        if (!this.tenantService.isEnabled()) {
            String un = "Andy `\u00ac\u00a6!\u00a3$%^&*()-_=+\t\n\u0000[]{};'#:@~,./<>?|";
            if (this.dialect instanceof PostgreSQLDialect) {
                un = "Andy `\u00ac\u00a6!\u00a3$%^&*()-_=+\t\n[]{};'#:@~,./<>?|";
            }
            this.authenticationService.createAuthentication(un, "".toCharArray());
            this.authenticationService.authenticate(un, "".toCharArray());
            AuthenticationTest.assertEquals((String)un, (String)this.authenticationService.getCurrentUserName());
        }
    }

    public void testCreateAndyUserAndOtherCRUD() throws NoSuchAlgorithmException, UnsupportedEncodingException {
        RepositoryAuthenticationDao dao = new RepositoryAuthenticationDao();
        dao.setTenantService(this.tenantService);
        dao.setNodeService(this.nodeService);
        dao.setSearchService(this.searchService);
        dao.setDictionaryService(this.dictionaryService);
        dao.setNamespaceService(this.getNamespacePrefixReolsver(""));
        dao.setPasswordEncoder(this.passwordEncoder);
        dao.setUserNameMatcher(this.userNameMatcher);
        dao.setRetryingTransactionHelper(this.transactionService.getRetryingTransactionHelper());
        dao.createUser("Andy", "cabbage".toCharArray());
        AuthenticationTest.assertNotNull((Object)dao.getUserOrNull("Andy"));
        byte[] decodedHash = this.passwordEncoder.decodeHash(dao.getMD4HashedPassword("Andy"));
        byte[] testHash = MessageDigest.getInstance("MD4").digest("cabbage".getBytes("UnicodeLittleUnmarked"));
        AuthenticationTest.assertEquals((String)new String(decodedHash), (String)new String(testHash));
        UserDetails AndyDetails = dao.loadUserByUsername("Andy");
        AuthenticationTest.assertNotNull((Object)AndyDetails);
        AuthenticationTest.assertEquals((String)"Andy", (String)AndyDetails.getUsername());
        AuthenticationTest.assertTrue((boolean)AndyDetails.isAccountNonExpired());
        AuthenticationTest.assertTrue((boolean)AndyDetails.isAccountNonLocked());
        AuthenticationTest.assertTrue((boolean)AndyDetails.isCredentialsNonExpired());
        AuthenticationTest.assertTrue((boolean)AndyDetails.isEnabled());
        AuthenticationTest.assertNotSame((Object)"cabbage", (Object)AndyDetails.getPassword());
        AuthenticationTest.assertEquals((String)AndyDetails.getPassword(), (String)this.passwordEncoder.encodePassword("cabbage", dao.getSalt(AndyDetails)));
        AuthenticationTest.assertEquals((int)1, (int)AndyDetails.getAuthorities().length);
        dao.updateUser("Andy", "carrot".toCharArray());
        UserDetails newDetails = dao.loadUserByUsername("Andy");
        AuthenticationTest.assertNotNull((Object)newDetails);
        AuthenticationTest.assertEquals((String)"Andy", (String)newDetails.getUsername());
        AuthenticationTest.assertTrue((boolean)newDetails.isAccountNonExpired());
        AuthenticationTest.assertTrue((boolean)newDetails.isAccountNonLocked());
        AuthenticationTest.assertTrue((boolean)newDetails.isCredentialsNonExpired());
        AuthenticationTest.assertTrue((boolean)newDetails.isEnabled());
        AuthenticationTest.assertNotSame((Object)"carrot", (Object)newDetails.getPassword());
        AuthenticationTest.assertEquals((int)1, (int)newDetails.getAuthorities().length);
        AuthenticationTest.assertNotSame((Object)AndyDetails.getPassword(), (Object)newDetails.getPassword());
        dao.deleteUser("Andy");
        AuthenticationTest.assertNull((Object)dao.getUserOrNull("Andy"));
        try {
            MessageDigest digester = MessageDigest.getInstance("MD4");
            System.out.println("Digester from " + digester.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            System.out.println("No digester");
        }
    }

    public void testAuthentication() {
        this.dao.createUser("GUEST", "".toCharArray());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"GUEST", (Object)"");
        token.setAuthenticated(false);
        Authentication result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.createUser("Andy", "squash".toCharArray());
        token = new UsernamePasswordAuthenticationToken((Object)"Andy", (Object)"squash");
        token.setAuthenticated(false);
        result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.setEnabled("Andy", false);
        try {
            result = this.authenticationManager.authenticate((Authentication)token);
            AuthenticationTest.assertNotNull((Object)result);
            AuthenticationTest.assertNotNull(null);
        }
        catch (DisabledException e) {
            // empty catch block
        }
        this.dao.setEnabled("Andy", true);
        result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.setLocked("Andy", true);
        try {
            result = this.authenticationManager.authenticate((Authentication)token);
            AuthenticationTest.assertNotNull((Object)result);
            AuthenticationTest.assertNotNull(null);
        }
        catch (LockedException e) {
            // empty catch block
        }
        this.dao.setLocked("Andy", false);
        result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.setAccountExpires("Andy", true);
        this.dao.setCredentialsExpire("Andy", true);
        result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.setAccountExpiryDate("Andy", null);
        this.dao.setCredentialsExpiryDate("Andy", null);
        result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.setAccountExpiryDate("Andy", new Date(new Date().getTime() + 10000L));
        this.dao.setCredentialsExpiryDate("Andy", new Date(new Date().getTime() + 10000L));
        result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.setAccountExpiryDate("Andy", new Date(new Date().getTime() - 10000L));
        try {
            result = this.authenticationManager.authenticate((Authentication)token);
            AuthenticationTest.assertNotNull((Object)result);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AccountExpiredException e) {
            // empty catch block
        }
        this.dao.setAccountExpiryDate("Andy", new Date(new Date().getTime() + 10000L));
        result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.setCredentialsExpiryDate("Andy", new Date(new Date().getTime() - 10000L));
        try {
            result = this.authenticationManager.authenticate((Authentication)token);
            AuthenticationTest.assertNotNull((Object)result);
            AuthenticationTest.assertNotNull(null);
        }
        catch (CredentialsExpiredException credentialsExpiredException) {
            // empty catch block
        }
        this.dao.setCredentialsExpiryDate("Andy", new Date(new Date().getTime() + 10000L));
        result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.deleteUser("Andy");
    }

    public void testCreateAuthenticationWhileRunningAsSystem() throws Exception {
        AuthenticationUtil.RunAsWork<Object> authWorkAsMuppet = new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                AuthenticationUtil.RunAsWork<Object> authWorkAsSystem = new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        RetryingTransactionHelper.RetryingTransactionCallback<Object> txnWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                            @Override
                            public Object execute() throws Throwable {
                                AuthenticationTest.this.pubAuthenticationService.createAuthentication("blah", "pwd".toCharArray());
                                AuthenticationTest.this.pubAuthenticationService.deleteAuthentication("blah");
                                return null;
                            }
                        };
                        return AuthenticationTest.this.transactionService.getRetryingTransactionHelper().doInTransaction(txnWork, false, true);
                    }
                };
                return AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)authWorkAsSystem, (String)AuthenticationUtil.getSystemUserName());
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)authWorkAsMuppet, (String)"muppet");
    }

    public void testPushAndPopAuthentication() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)"user1");
        AuthenticationTest.assertEquals((String)"user1", (String)AuthenticationUtil.getFullyAuthenticatedUser());
        AuthenticationTest.assertEquals((String)"user1", (String)AuthenticationUtil.getRunAsUser());
        AuthenticationUtil.setRunAsUser((String)"user2");
        AuthenticationTest.assertEquals((String)"user1", (String)AuthenticationUtil.getFullyAuthenticatedUser());
        AuthenticationTest.assertEquals((String)"user2", (String)AuthenticationUtil.getRunAsUser());
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)"user3");
        AuthenticationUtil.setRunAsUser((String)"user4");
        AuthenticationTest.assertEquals((String)"user3", (String)AuthenticationUtil.getFullyAuthenticatedUser());
        AuthenticationTest.assertEquals((String)"user4", (String)AuthenticationUtil.getRunAsUser());
        AuthenticationUtil.popAuthentication();
        AuthenticationTest.assertEquals((String)"user1", (String)AuthenticationUtil.getFullyAuthenticatedUser());
        AuthenticationTest.assertEquals((String)"user2", (String)AuthenticationUtil.getRunAsUser());
    }

    public void testAuthenticationFailure() {
        this.dao.createUser("Andy", "squash".toCharArray());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Andy", (Object)"turnip");
        token.setAuthenticated(false);
        try {
            Authentication result = this.authenticationManager.authenticate((Authentication)token);
            AuthenticationTest.assertNotNull((Object)result);
            AuthenticationTest.assertNotNull(null);
        }
        catch (BadCredentialsException badCredentialsException) {
            // empty catch block
        }
        this.dao.deleteUser("Andy");
    }

    public void testTicket() {
        this.dao.createUser("Andy", "ticket".toCharArray());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Andy", (Object)"ticket");
        token.setAuthenticated(false);
        Authentication result = this.authenticationManager.authenticate((Authentication)token);
        result.setAuthenticated(true);
        String ticket = this.ticketComponent.getNewTicket(this.getUserName(result));
        String user = this.ticketComponent.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        user = null;
        try {
            user = this.ticketComponent.validateTicket("INVALID");
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException e) {
            AuthenticationTest.assertNull((Object)user);
        }
        this.ticketComponent.invalidateTicketById(ticket);
        try {
            user = this.ticketComponent.validateTicket(ticket);
            AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        this.dao.deleteUser("Andy");
    }

    public void testTicketRepeat() {
        InMemoryTicketComponentImpl tc = new InMemoryTicketComponentImpl();
        tc.setOneOff(false);
        tc.setTicketsExpire(false);
        tc.setValidDuration("P0D");
        tc.setTicketsCache(this.ticketsCache);
        this.dao.createUser("Andy", "ticket".toCharArray());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Andy", (Object)"ticket");
        token.setAuthenticated(false);
        Authentication result = this.authenticationManager.authenticate((Authentication)token);
        result.setAuthenticated(true);
        String ticket = tc.getNewTicket(this.getUserName(result));
        tc.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        tc.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        this.dao.deleteUser("Andy");
    }

    public void testTicketOneOff() {
        InMemoryTicketComponentImpl tc = new InMemoryTicketComponentImpl();
        tc.setOneOff(true);
        tc.setTicketsExpire(false);
        tc.setValidDuration("P0D");
        tc.setTicketsCache(this.ticketsCache);
        this.dao.createUser("Andy", "ticket".toCharArray());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Andy", (Object)"ticket");
        token.setAuthenticated(false);
        Authentication result = this.authenticationManager.authenticate((Authentication)token);
        result.setAuthenticated(true);
        String ticket = tc.getNewTicket(this.getUserName(result));
        tc.validateTicket(ticket);
        AuthenticationTest.assertTrue((!this.ticketComponent.getCurrentTicket("Andy", true).equals(ticket) ? 1 : 0) != 0);
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        this.dao.deleteUser("Andy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTicketExpiryMode() {
        InMemoryTicketComponentImpl tc = new InMemoryTicketComponentImpl();
        tc.setOneOff(false);
        tc.setTicketsExpire(true);
        tc.setValidDuration("P5S");
        tc.setTicketsCache(this.ticketsCache);
        tc.setExpiryMode(InMemoryTicketComponentImpl.ExpiryMode.AFTER_FIXED_TIME.toString());
        this.dao.createUser("Andy", "ticket".toCharArray());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Andy", (Object)"ticket");
        token.setAuthenticated(false);
        Authentication result = this.authenticationManager.authenticate((Authentication)token);
        result.setAuthenticated(true);
        String ticket = tc.getNewTicket(this.getUserName(result));
        tc.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        tc.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        tc.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        AuthenticationTest authenticationTest = this;
        synchronized (authenticationTest) {
            try {
                ((Object)((Object)this)).wait(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        AuthenticationTest e = this;
        synchronized (e) {
            try {
                ((Object)((Object)this)).wait(10000L);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException e2) {
            // empty catch block
        }
        tc.setExpiryMode(InMemoryTicketComponentImpl.ExpiryMode.AFTER_INACTIVITY.toString());
        ticket = tc.getNewTicket(this.getUserName(result));
        for (int i = 0; i < 50; ++i) {
            AuthenticationTest e2 = this;
            synchronized (e2) {
                try {
                    ((Object)((Object)this)).wait(100L);
                }
                catch (InterruptedException e3) {
                    e3.printStackTrace();
                }
                tc.validateTicket(ticket);
                continue;
            }
        }
        AuthenticationTest i = this;
        synchronized (i) {
            try {
                ((Object)((Object)this)).wait(10000L);
            }
            catch (InterruptedException e4) {
                e4.printStackTrace();
            }
        }
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException e3) {
            // empty catch block
        }
        this.dao.deleteUser("Andy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTicketExpires() {
        InMemoryTicketComponentImpl tc = new InMemoryTicketComponentImpl();
        tc.setOneOff(false);
        tc.setTicketsExpire(true);
        tc.setValidDuration("P5S");
        tc.setTicketsCache(this.ticketsCache);
        this.dao.createUser("Andy", "ticket".toCharArray());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Andy", (Object)"ticket");
        token.setAuthenticated(false);
        Authentication result = this.authenticationManager.authenticate((Authentication)token);
        result.setAuthenticated(true);
        String ticket = tc.getNewTicket(this.getUserName(result));
        tc.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        tc.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        tc.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        AuthenticationTest authenticationTest = this;
        synchronized (authenticationTest) {
            try {
                ((Object)((Object)this)).wait(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        AuthenticationTest e = this;
        synchronized (e) {
            try {
                ((Object)((Object)this)).wait(10000L);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException e2) {
            // empty catch block
        }
        this.dao.deleteUser("Andy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTicketDoesNotExpire() {
        InMemoryTicketComponentImpl tc = new InMemoryTicketComponentImpl();
        tc.setOneOff(false);
        tc.setTicketsExpire(true);
        tc.setValidDuration("P1D");
        tc.setTicketsCache(this.ticketsCache);
        this.dao.createUser("Andy", "ticket".toCharArray());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Andy", (Object)"ticket");
        token.setAuthenticated(false);
        Authentication result = this.authenticationManager.authenticate((Authentication)token);
        result.setAuthenticated(true);
        String ticket = tc.getNewTicket(this.getUserName(result));
        tc.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        tc.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        tc.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        AuthenticationTest authenticationTest = this;
        synchronized (authenticationTest) {
            try {
                ((Object)((Object)this)).wait(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        tc.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        this.dao.deleteUser("Andy");
    }

    public void testAuthenticationServiceGetNewTicket() {
        this.authenticationService.createAuthentication("GUEST", "".toCharArray());
        this.authenticationService.authenticate("GUEST", "".toCharArray());
        this.authenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        String ticket1 = this.authenticationService.getCurrentTicket();
        this.authenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        String ticket2 = this.authenticationService.getCurrentTicket();
        AuthenticationTest.assertFalse((boolean)ticket1.equals(ticket2));
    }

    public void testAuthenticationService1() {
        this.authenticationService.createAuthentication("GUEST", "".toCharArray());
        this.authenticationService.authenticate("GUEST", "".toCharArray());
        this.authenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.deleteAuthentication("Andy");
        this.authenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.authenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationService.authenticate("Andy", "auth3".toCharArray());
        try {
            this.authenticationService.authenticate("Andy", "auth1".toCharArray());
            AuthenticationTest.fail((String)"Authentication should have been rejected");
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public void testAuthenticationService2() {
        this.authenticationService.createAuthentication("GUEST", "".toCharArray());
        this.authenticationService.authenticate("GUEST", "".toCharArray());
        this.authenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.deleteAuthentication("Andy");
        this.authenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.authenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationService.authenticate("Andy", "auth3".toCharArray());
        try {
            this.authenticationService.authenticate("Andy", "auth2".toCharArray());
            AuthenticationTest.fail((String)"Authentication should have been rejected");
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public void testAuthenticationService3() {
        this.authenticationService.createAuthentication("GUEST", "".toCharArray());
        this.authenticationService.authenticate("GUEST", "".toCharArray());
        this.authenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.deleteAuthentication("Andy");
        this.authenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.authenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationService.authenticate("Andy", "auth3".toCharArray());
        this.authenticationService.authenticate("Andy", "auth3".toCharArray());
        String ticket = this.authenticationService.getCurrentTicket();
        this.authenticationService.validate(ticket);
        AuthenticationTest.assertEquals((String)ticket, (String)this.authenticationService.getCurrentTicket());
        this.authenticationService.invalidateTicket(ticket);
        try {
            this.authenticationService.validate(ticket);
            AuthenticationTest.fail((String)"Invalid taicket should have been rejected");
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public void testAuthenticationService4() {
        this.authenticationService.createAuthentication("GUEST", "".toCharArray());
        this.authenticationService.authenticate("GUEST", "".toCharArray());
        this.authenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.deleteAuthentication("Andy");
        this.authenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.authenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationService.authenticate("Andy", "auth3".toCharArray());
        this.authenticationService.authenticate("Andy", "auth3".toCharArray());
        String ticket = this.authenticationService.getCurrentTicket();
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.validate(ticket);
        AuthenticationTest.assertEquals((String)ticket, (String)this.authenticationService.getCurrentTicket());
        this.authenticationService.invalidateTicket(ticket);
        Authentication current = this.authenticationComponent.getCurrentAuthentication();
        if (current != null) {
            AuthenticationTest.assertTrue((boolean)current.isAuthenticated());
        }
        try {
            this.authenticationService.validate(ticket);
            AuthenticationTest.fail((String)"Invalid ticket should have been rejected");
        }
        catch (AuthenticationException e) {
            AuthenticationTest.assertNull((Object)this.authenticationComponentImpl.getCurrentAuthentication());
        }
    }

    public void testAuthenticationService() {
        this.authenticationService.createAuthentication("GUEST", "".toCharArray());
        this.authenticationService.authenticate("GUEST", "".toCharArray());
        this.authenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.deleteAuthentication("Andy");
        this.authenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.authenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationService.authenticate("Andy", "auth3".toCharArray());
        this.authenticationService.updateAuthentication("Andy", "auth3".toCharArray(), "auth4".toCharArray());
        this.authenticationService.authenticate("Andy", "auth4".toCharArray());
        this.authenticationService.authenticate("Andy", "auth4".toCharArray());
        String ticket = this.authenticationService.getCurrentTicket();
        this.authenticationService.validate(ticket);
        AuthenticationTest.assertEquals((String)ticket, (String)this.authenticationService.getCurrentTicket());
        this.authenticationService.invalidateTicket(ticket);
        Authentication current = this.authenticationComponent.getCurrentAuthentication();
        if (current != null) {
            AuthenticationTest.assertTrue((boolean)current.isAuthenticated());
        }
        this.authenticationService.authenticate("Andy", "auth4".toCharArray());
        this.authenticationService.updateAuthentication("Andy", "auth4".toCharArray(), "auth5".toCharArray());
        this.authenticationService.authenticate("Andy", "auth5".toCharArray());
        this.authenticationService.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationService.getCurrentUserName());
        this.dao.deleteUser("Andy");
    }

    public void testAuthenticationService0() {
        this.authenticationService.createAuthentication("GUEST", "".toCharArray());
        this.authenticationService.authenticate("GUEST", "".toCharArray());
        this.authenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.deleteAuthentication("Andy");
        this.authenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.authenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationService.authenticate("Andy", "auth3".toCharArray());
        this.authenticationService.updateAuthentication("Andy", "auth3".toCharArray(), "auth4".toCharArray());
        this.authenticationService.authenticate("Andy", "auth4".toCharArray());
        this.authenticationService.authenticate("Andy", "auth4".toCharArray());
        String ticket = this.authenticationService.getCurrentTicket();
        this.authenticationService.validate(ticket);
        AuthenticationTest.assertEquals((String)ticket, (String)this.authenticationService.getCurrentTicket());
        this.authenticationService.invalidateTicket(ticket);
        Authentication current = this.authenticationComponent.getCurrentAuthentication();
        if (current != null) {
            AuthenticationTest.assertTrue((boolean)current.isAuthenticated());
        }
        this.authenticationService.authenticate("Andy", "auth4".toCharArray());
        this.authenticationService.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationService.getCurrentUserName());
        this.dao.deleteUser("Andy");
    }

    public void testPubAuthenticationService1() {
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("GUEST", "".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("GUEST", "".toCharArray());
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        this.pubAuthenticationService.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.deleteAuthentication("Andy");
        this.authenticationComponent.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.pubAuthenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        try {
            this.pubAuthenticationService.authenticate("Andy", "auth1".toCharArray());
            AuthenticationTest.fail((String)"Authentication should fail");
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public void testPubAuthenticationService2() {
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("GUEST", "".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("GUEST", "".toCharArray());
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        this.pubAuthenticationService.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.deleteAuthentication("Andy");
        this.authenticationComponent.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.pubAuthenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        try {
            this.pubAuthenticationService.authenticate("Andy", "auth2".toCharArray());
            AuthenticationTest.fail((String)"Authentication should fail");
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public void testPubAuthenticationService3() {
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("GUEST", "".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("GUEST", "".toCharArray());
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        this.pubAuthenticationService.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.deleteAuthentication("Andy");
        this.authenticationComponent.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.pubAuthenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        String ticket = this.pubAuthenticationService.getCurrentTicket();
        this.authenticationComponent.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.pubAuthenticationService.validate(ticket);
        AuthenticationTest.assertEquals((String)ticket, (String)this.authenticationService.getCurrentTicket());
        this.pubAuthenticationService.invalidateTicket(ticket);
        try {
            this.pubAuthenticationService.validate(ticket);
            AuthenticationTest.fail((String)"Ticket should not validate");
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public void testPubAuthenticationService() {
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("GUEST", "".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.pubAuthenticationService.authenticate("GUEST", "".toCharArray());
        this.pubAuthenticationService.authenticate("GUEST", "".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.pubAuthenticationService.authenticateAsGuest();
        this.authenticationComponent.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        this.pubAuthenticationService.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.deleteAuthentication("Andy");
        this.authenticationComponent.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.pubAuthenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        String ticket = this.pubAuthenticationService.getCurrentTicket();
        this.pubAuthenticationService.validate(ticket);
        AuthenticationTest.assertEquals((String)ticket, (String)this.authenticationService.getCurrentTicket());
        this.pubAuthenticationService.invalidateTicket(ticket);
    }

    public void testPubAuthenticationService0() {
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("GUEST", "".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.pubAuthenticationService.authenticate("GUEST", "".toCharArray());
        this.pubAuthenticationService.authenticate("GUEST", "".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.pubAuthenticationService.authenticateAsGuest();
        this.authenticationComponent.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        this.pubAuthenticationService.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.deleteAuthentication("Andy");
        this.authenticationComponent.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.pubAuthenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        String ticket = this.pubAuthenticationService.getCurrentTicket();
        this.pubAuthenticationService.validate(ticket);
        AuthenticationTest.assertEquals((String)ticket, (String)this.authenticationService.getCurrentTicket());
        this.pubAuthenticationService.invalidateTicket(ticket);
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        this.pubAuthenticationService.updateAuthentication("Andy", "auth3".toCharArray(), "auth4".toCharArray());
        this.pubAuthenticationService.authenticate("Andy", "auth4".toCharArray());
        try {
            this.pubAuthenticationService.updateAuthentication("Andy", "auth3".toCharArray(), "auth4".toCharArray());
            AuthenticationTest.fail((String)"Should not be able to update");
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public void testAbstractAuthenticationComponentGuestUserSupport() {
        this.authenticationComponent.setGuestUserAsCurrentUser();
        AuthenticationTest.assertEquals((String)this.authenticationComponent.getCurrentUserName(), (String)this.authenticationComponent.getGuestUserName());
    }

    public void testPassThroughLogin() {
        this.authenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationComponent.setCurrentUser("Andy");
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
    }

    private String getUserName(Authentication authentication) {
        String username = authentication.getPrincipal().toString();
        if (authentication.getPrincipal() instanceof UserDetails) {
            username = ((UserDetails)authentication.getPrincipal()).getUsername();
        }
        return username;
    }

    private NamespacePrefixResolver getNamespacePrefixReolsver(String defaultURI) {
        DynamicNamespacePrefixResolver nspr = new DynamicNamespacePrefixResolver(null);
        nspr.registerNamespace("sys", "http://www.alfresco.org/model/system/1.0");
        nspr.registerNamespace("cm", "http://www.alfresco.org/model/content/1.0");
        nspr.registerNamespace("usr", "http://www.alfresco.org/model/user/1.0");
        nspr.registerNamespace("namespace", "namespace");
        nspr.registerNamespace("", defaultURI);
        return nspr;
    }
}

