/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.GrantedAuthorityImpl;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.dao.User;
import net.sf.acegisecurity.providers.dao.UsernameNotFoundException;
import net.sf.acegisecurity.providers.encoding.PasswordEncoder;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.person.UserNameMatcher;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.springframework.dao.DataAccessException;
import org.springframework.util.StringUtils;

public class RepositoryAuthenticationDao
implements MutableAuthenticationDao {
    private static final StoreRef STOREREF_USERS = new StoreRef("user", "alfrescoUserStore");
    private NodeService nodeService;
    private TenantService tenantService;
    private NamespacePrefixResolver namespacePrefixResolver;
    private DictionaryService dictionaryService;
    private SearchService searchService;
    private RetryingTransactionHelper retryingTransactionHelper;
    private PasswordEncoder passwordEncoder;
    private UserNameMatcher userNameMatcher;

    public boolean getUserNamesAreCaseSensitive() {
        return this.userNameMatcher.getUserNamesAreCaseSensitive();
    }

    public void setUserNameMatcher(UserNameMatcher userNameMatcher) {
        this.userNameMatcher = userNameMatcher;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRetryingTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public UserDetails loadUserByUsername(String incomingUserName) throws UsernameNotFoundException, DataAccessException {
        NodeRef userRef = this.getUserOrNull(incomingUserName);
        if (userRef == null) {
            throw new UsernameNotFoundException("Could not find user by userName: " + incomingUserName);
        }
        Map properties = this.nodeService.getProperties(userRef);
        String password = (String)DefaultTypeConverter.INSTANCE.convert(String.class, properties.get(ContentModel.PROP_PASSWORD));
        String userName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, properties.get(ContentModel.PROP_USER_USERNAME));
        GrantedAuthority[] gas = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_AUTHENTICATED")};
        User ud = new User(userName, password, this.getEnabled(userRef), !this.getAccountHasExpired(userRef), !this.getCredentialsHaveExpired(userRef), !this.getAccountlocked(userRef), gas);
        return ud;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRef getUserOrNull(String searchUserName) {
        NodeRef nodeRef;
        block9: {
            if (searchUserName == null || searchUserName.length() == 0) {
                return null;
            }
            SearchParameters sp = new SearchParameters();
            sp.setLanguage("lucene");
            sp.setQuery("@usr\\:username:\"" + StringUtils.delete((String)searchUserName, (String)"\"") + "\"");
            try {
                sp.addStore(this.tenantService.getName(searchUserName, STOREREF_USERS));
            }
            catch (AlfrescoRuntimeException e) {
                return null;
            }
            sp.excludeDataInTheCurrentTransaction(false);
            ResultSet rs = null;
            try {
                rs = this.searchService.query(sp);
                NodeRef returnRef = null;
                for (ResultSetRow row : rs) {
                    String realUserName;
                    final NodeRef nodeRef2 = row.getNodeRef();
                    if (!this.nodeService.exists(nodeRef2) || !this.userNameMatcher.matches(realUserName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef2, ContentModel.PROP_USER_USERNAME)), searchUserName)) continue;
                    if (returnRef == null) {
                        returnRef = nodeRef2;
                        continue;
                    }
                    try {
                        this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                            @Override
                            public Object execute() throws Throwable {
                                RepositoryAuthenticationDao.this.nodeService.deleteNode(nodeRef2);
                                return null;
                            }
                        }, false, true);
                    }
                    catch (InvalidNodeRefException exception) {}
                }
                nodeRef = returnRef;
                Object var11_11 = null;
                if (rs == null) break block9;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var11_12 = null;
                    if (rs == null) break block10;
                    rs.close();
                }
                throw throwable;
            }
            rs.close();
        }
        return nodeRef;
    }

    public void createUser(String caseSensitiveUserName, char[] rawPassword) throws AuthenticationException {
        this.tenantService.checkDomainUser(caseSensitiveUserName);
        NodeRef userRef = this.getUserOrNull(caseSensitiveUserName);
        if (userRef != null) {
            throw new AuthenticationException("User already exists: " + caseSensitiveUserName);
        }
        NodeRef typesNode = this.getUserFolderLocation(caseSensitiveUserName);
        HashMap<QName, Object> properties = new HashMap<QName, Object>();
        properties.put(ContentModel.PROP_USER_USERNAME, caseSensitiveUserName);
        Object salt = null;
        properties.put(ContentModel.PROP_SALT, salt);
        properties.put(ContentModel.PROP_PASSWORD, this.passwordEncoder.encodePassword(new String(rawPassword), salt));
        properties.put(ContentModel.PROP_ACCOUNT_EXPIRES, false);
        properties.put(ContentModel.PROP_CREDENTIALS_EXPIRE, false);
        properties.put(ContentModel.PROP_ENABLED, true);
        properties.put(ContentModel.PROP_ACCOUNT_LOCKED, false);
        this.nodeService.createNode(typesNode, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_USER, ContentModel.TYPE_USER, properties);
    }

    private NodeRef getUserFolderLocation(String caseSensitiveUserName) {
        QName qnameAssocSystem = QName.createQName((String)"sys", (String)"system", (NamespacePrefixResolver)this.namespacePrefixResolver);
        QName qnameAssocUsers = QName.createQName((String)"sys", (String)"people", (NamespacePrefixResolver)this.namespacePrefixResolver);
        StoreRef userStoreRef = this.tenantService.getName(caseSensitiveUserName, new StoreRef(STOREREF_USERS.getProtocol(), STOREREF_USERS.getIdentifier()));
        NodeRef rootNode = this.nodeService.getRootNode(userStoreRef);
        List results = this.nodeService.getChildAssocs(rootNode, RegexQNamePattern.MATCH_ALL, (QNamePattern)qnameAssocSystem);
        NodeRef sysNodeRef = null;
        if (results.size() == 0) {
            throw new AlfrescoRuntimeException("Required authority system folder path not found: " + qnameAssocSystem);
        }
        sysNodeRef = ((ChildAssociationRef)results.get(0)).getChildRef();
        results = this.nodeService.getChildAssocs(sysNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)qnameAssocUsers);
        NodeRef userNodeRef = null;
        if (results.size() == 0) {
            throw new AlfrescoRuntimeException("Required user folder path not found: " + qnameAssocUsers);
        }
        userNodeRef = ((ChildAssociationRef)results.get(0)).getChildRef();
        return userNodeRef;
    }

    public void updateUser(String userName, char[] rawPassword) throws AuthenticationException {
        NodeRef userRef = this.getUserOrNull(userName);
        if (userRef == null) {
            throw new AuthenticationException("User name does not exist: " + userName);
        }
        Map properties = this.nodeService.getProperties(userRef);
        Object salt = null;
        properties.remove(ContentModel.PROP_SALT);
        properties.put(ContentModel.PROP_SALT, salt);
        properties.remove(ContentModel.PROP_PASSWORD);
        properties.put(ContentModel.PROP_PASSWORD, this.passwordEncoder.encodePassword(new String(rawPassword), salt));
        this.nodeService.setProperties(userRef, properties);
    }

    public void deleteUser(String userName) throws AuthenticationException {
        NodeRef userRef = this.getUserOrNull(userName);
        if (userRef == null) {
            throw new AuthenticationException("User name does not exist: " + userName);
        }
        this.nodeService.deleteNode(userRef);
    }

    public Object getSalt(UserDetails userDetails) {
        return null;
    }

    public boolean userExists(String userName) {
        return this.getUserOrNull(userName) != null;
    }

    public boolean getAccountExpires(String userName) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            return false;
        }
        Serializable ser = this.nodeService.getProperty(userNode, ContentModel.PROP_ACCOUNT_EXPIRES);
        if (ser == null) {
            return false;
        }
        return DefaultTypeConverter.INSTANCE.booleanValue((Object)ser);
    }

    public Date getAccountExpiryDate(String userName) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            return null;
        }
        if (DefaultTypeConverter.INSTANCE.booleanValue((Object)this.nodeService.getProperty(userNode, ContentModel.PROP_ACCOUNT_EXPIRES))) {
            return (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.nodeService.getProperty(userNode, ContentModel.PROP_ACCOUNT_EXPIRY_DATE));
        }
        return null;
    }

    public boolean getAccountHasExpired(String userName) {
        return this.getAccountHasExpired(this.getUserOrNull(userName));
    }

    private boolean getAccountHasExpired(NodeRef userNode) {
        if (userNode == null) {
            return false;
        }
        if (DefaultTypeConverter.INSTANCE.booleanValue((Object)this.nodeService.getProperty(userNode, ContentModel.PROP_ACCOUNT_EXPIRES))) {
            Date date = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.nodeService.getProperty(userNode, ContentModel.PROP_ACCOUNT_EXPIRY_DATE));
            if (date == null) {
                return false;
            }
            return date.compareTo(new Date()) < 1;
        }
        return false;
    }

    public boolean getAccountlocked(String userName) {
        return this.getAccountlocked(this.getUserOrNull(userName));
    }

    private boolean getAccountlocked(NodeRef userNode) {
        if (userNode == null) {
            return false;
        }
        Serializable ser = this.nodeService.getProperty(userNode, ContentModel.PROP_ACCOUNT_LOCKED);
        if (ser == null) {
            return false;
        }
        return DefaultTypeConverter.INSTANCE.booleanValue((Object)ser);
    }

    public boolean getCredentialsExpire(String userName) {
        return this.getCredentialsExpired(this.getUserOrNull(userName));
    }

    private boolean getCredentialsExpired(NodeRef userNode) {
        if (userNode == null) {
            return false;
        }
        Serializable ser = this.nodeService.getProperty(userNode, ContentModel.PROP_CREDENTIALS_EXPIRE);
        if (ser == null) {
            return false;
        }
        return DefaultTypeConverter.INSTANCE.booleanValue((Object)ser);
    }

    public Date getCredentialsExpiryDate(String userName) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            return null;
        }
        if (DefaultTypeConverter.INSTANCE.booleanValue((Object)this.nodeService.getProperty(userNode, ContentModel.PROP_CREDENTIALS_EXPIRE))) {
            return (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.nodeService.getProperty(userNode, ContentModel.PROP_CREDENTIALS_EXPIRY_DATE));
        }
        return null;
    }

    public boolean getCredentialsHaveExpired(String userName) {
        return this.getCredentialsHaveExpired(this.getUserOrNull(userName));
    }

    private boolean getCredentialsHaveExpired(NodeRef userNode) {
        if (userNode == null) {
            return false;
        }
        if (DefaultTypeConverter.INSTANCE.booleanValue((Object)this.nodeService.getProperty(userNode, ContentModel.PROP_CREDENTIALS_EXPIRE))) {
            Date date = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.nodeService.getProperty(userNode, ContentModel.PROP_CREDENTIALS_EXPIRY_DATE));
            if (date == null) {
                return false;
            }
            return date.compareTo(new Date()) < 1;
        }
        return false;
    }

    public boolean getEnabled(String userName) {
        return this.getEnabled(this.getUserOrNull(userName));
    }

    private boolean getEnabled(NodeRef userNode) {
        if (userNode == null) {
            return false;
        }
        Serializable ser = this.nodeService.getProperty(userNode, ContentModel.PROP_ENABLED);
        if (ser == null) {
            return true;
        }
        return DefaultTypeConverter.INSTANCE.booleanValue((Object)ser);
    }

    public void setAccountExpires(String userName, boolean expires) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            throw new AuthenticationException("User not found: " + userName);
        }
        this.nodeService.setProperty(userNode, ContentModel.PROP_ACCOUNT_EXPIRES, (Serializable)Boolean.valueOf(expires));
    }

    public void setAccountExpiryDate(String userName, Date exipryDate) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            throw new AuthenticationException("User not found: " + userName);
        }
        this.nodeService.setProperty(userNode, ContentModel.PROP_ACCOUNT_EXPIRY_DATE, (Serializable)exipryDate);
    }

    public void setCredentialsExpire(String userName, boolean expires) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            throw new AuthenticationException("User not found: " + userName);
        }
        this.nodeService.setProperty(userNode, ContentModel.PROP_CREDENTIALS_EXPIRE, (Serializable)Boolean.valueOf(expires));
    }

    public void setCredentialsExpiryDate(String userName, Date exipryDate) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            throw new AuthenticationException("User not found: " + userName);
        }
        this.nodeService.setProperty(userNode, ContentModel.PROP_CREDENTIALS_EXPIRY_DATE, (Serializable)exipryDate);
    }

    public void setEnabled(String userName, boolean enabled) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            throw new AuthenticationException("User not found: " + userName);
        }
        this.nodeService.setProperty(userNode, ContentModel.PROP_ENABLED, (Serializable)Boolean.valueOf(enabled));
    }

    public void setLocked(String userName, boolean locked) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            throw new AuthenticationException("User not found: " + userName);
        }
        this.nodeService.setProperty(userNode, ContentModel.PROP_ACCOUNT_LOCKED, (Serializable)Boolean.valueOf(locked));
    }

    public String getMD4HashedPassword(String userName) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            return null;
        }
        String password = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(userNode, ContentModel.PROP_PASSWORD));
        return password;
    }
}

