/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.subsystems;

import java.util.LinkedList;
import java.util.List;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.management.subsystems.ChildApplicationContextManager;
import org.alfresco.repo.security.authentication.AbstractChainingAuthenticationService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubsystemChainingAuthenticationService
extends AbstractChainingAuthenticationService {
    private ChildApplicationContextManager applicationContextManager;
    private String sourceBeanName;

    public void setApplicationContextManager(ChildApplicationContextManager applicationContextManager) {
        this.applicationContextManager = applicationContextManager;
    }

    public void setSourceBeanName(String sourceBeanName) {
        this.sourceBeanName = sourceBeanName;
    }

    @Override
    public MutableAuthenticationService getMutableAuthenticationService() {
        for (String instance : this.applicationContextManager.getInstanceIds()) {
            ApplicationContext context = this.applicationContextManager.getApplicationContext(instance);
            try {
                AuthenticationService authenticationService = (AuthenticationService)context.getBean(this.sourceBeanName);
                if (!(authenticationService instanceof MutableAuthenticationService) || authenticationService instanceof ActivateableBean && !((ActivateableBean)((Object)authenticationService)).isActive()) continue;
                return (MutableAuthenticationService)authenticationService;
            }
            catch (NoSuchBeanDefinitionException e) {
            }
        }
        return null;
    }

    @Override
    protected List<AuthenticationService> getUsableAuthenticationServices() {
        LinkedList<AuthenticationService> result = new LinkedList<AuthenticationService>();
        for (String instance : this.applicationContextManager.getInstanceIds()) {
            ApplicationContext context = this.applicationContextManager.getApplicationContext(instance);
            try {
                AuthenticationService authenticationService = (AuthenticationService)context.getBean(this.sourceBeanName);
                if (authenticationService instanceof ActivateableBean && !((ActivateableBean)((Object)authenticationService)).isActive()) continue;
                result.add(authenticationService);
            }
            catch (NoSuchBeanDefinitionException e) {}
        }
        return result;
    }
}

