/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.authority.AuthorityException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorityServiceTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private AuthenticationComponent authenticationComponent;
    private AuthenticationComponent authenticationComponentImpl;
    private MutableAuthenticationService authenticationService;
    private MutableAuthenticationDao authenticationDAO;
    private AuthorityService authorityService;
    private AuthorityService pubAuthorityService;
    private PersonService personService;
    private UserTransaction tx;
    private AclDAO aclDaoComponent;
    private NodeService nodeService;

    public void setUp() throws Exception {
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.authenticationComponentImpl = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.authenticationService = (MutableAuthenticationService)ctx.getBean("authenticationService");
        this.authorityService = (AuthorityService)ctx.getBean("authorityService");
        this.pubAuthorityService = (AuthorityService)ctx.getBean("AuthorityService");
        this.personService = (PersonService)ctx.getBean("personService");
        this.authenticationDAO = (MutableAuthenticationDao)ctx.getBean("authenticationDao");
        this.aclDaoComponent = (AclDAO)ctx.getBean("aclDAO");
        this.nodeService = (NodeService)ctx.getBean("nodeService");
        this.authenticationComponentImpl.setSystemUserAsCurrentUser();
        TransactionService transactionService = (TransactionService)ctx.getBean(ServiceRegistry.TRANSACTION_SERVICE.getLocalName());
        this.tx = transactionService.getUserTransaction();
        this.tx.begin();
        for (String user : this.pubAuthorityService.getAllAuthorities(AuthorityType.USER)) {
            if (user.equals(AuthenticationUtil.getGuestUserName()) || user.equals(AuthenticationUtil.getAdminUserName())) continue;
            if (this.personService.personExists(user)) {
                NodeRef person = this.personService.getPerson(user);
                NodeRef hf = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)this.nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER));
                if (hf != null) {
                    this.nodeService.deleteNode(hf);
                }
                this.aclDaoComponent.deleteAccessControlEntries(user);
                this.personService.deletePerson(user);
            }
            if (!this.authenticationDAO.userExists(user)) continue;
            this.authenticationDAO.deleteUser(user);
        }
        this.tx.commit();
        this.tx = transactionService.getUserTransaction();
        this.tx.begin();
        if (!this.authenticationDAO.userExists("andy")) {
            this.authenticationService.createAuthentication("andy", "andy".toCharArray());
        }
        if (!this.authenticationDAO.userExists(AuthenticationUtil.getAdminUserName())) {
            this.authenticationService.createAuthentication(AuthenticationUtil.getAdminUserName(), "admin".toCharArray());
        }
        if (!this.authenticationDAO.userExists("administrator")) {
            this.authenticationService.createAuthentication("administrator", "administrator".toCharArray());
        }
    }

    protected void tearDown() throws Exception {
        if (this.tx.getStatus() == 0 || this.tx.getStatus() == 1) {
            this.tx.rollback();
        }
        AuthenticationUtil.clearCurrentSecurityContext();
        super.tearDown();
    }

    public void testZones() {
        AuthorityServiceTest.assertNull(this.pubAuthorityService.getAuthorityZones("GROUP_DEFAULT"));
        AuthorityServiceTest.assertNull(this.pubAuthorityService.getAuthorityZones("GROUP_NULL"));
        AuthorityServiceTest.assertNull(this.pubAuthorityService.getAuthorityZones("GROUP_EMPTY"));
        AuthorityServiceTest.assertNull(this.pubAuthorityService.getAuthorityZones("GROUP_1"));
        AuthorityServiceTest.assertNull(this.pubAuthorityService.getAuthorityZones("GROUP_2"));
        AuthorityServiceTest.assertNull(this.pubAuthorityService.getAuthorityZones("GROUP_3"));
        this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "DEFAULT");
        Set<String> zones = this.pubAuthorityService.getAuthorityZones("GROUP_DEFAULT");
        AuthorityServiceTest.assertEquals((int)2, (int)zones.size());
        this.pubAuthorityService.removeAuthorityFromZones("GROUP_DEFAULT", zones);
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAuthorityZones("GROUP_DEFAULT").size());
        this.pubAuthorityService.addAuthorityToZones("GROUP_DEFAULT", zones);
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAuthorityZones("GROUP_DEFAULT").size());
        HashSet<String> newZones = null;
        this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "NULL", "NULL", newZones);
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAuthorityZones("GROUP_NULL").size());
        newZones = new HashSet<String>();
        this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "EMPTY", "EMPTY", newZones);
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAuthorityZones("GROUP_EMPTY").size());
        newZones.add("One");
        this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "1", "1", newZones);
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAuthorityZones("GROUP_1").size());
        newZones.add("Two");
        this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "2", "2", newZones);
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAuthorityZones("GROUP_2").size());
        newZones.add("Three");
        this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "3", "3", newZones);
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAuthorityZones("GROUP_3").size());
        HashSet<String> toRemove = null;
        this.pubAuthorityService.removeAuthorityFromZones("GROUP_3", toRemove);
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAuthorityZones("GROUP_3").size());
        toRemove = new HashSet<String>();
        this.pubAuthorityService.removeAuthorityFromZones("GROUP_3", toRemove);
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAuthorityZones("GROUP_3").size());
        toRemove.add("Three");
        this.pubAuthorityService.removeAuthorityFromZones("GROUP_3", toRemove);
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAuthorityZones("GROUP_3").size());
        toRemove.add("Two");
        this.pubAuthorityService.removeAuthorityFromZones("GROUP_3", toRemove);
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAuthorityZones("GROUP_3").size());
        toRemove.add("One");
        this.pubAuthorityService.removeAuthorityFromZones("GROUP_3", toRemove);
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAuthorityZones("GROUP_3").size());
        this.pubAuthorityService.addAuthorityToZones("GROUP_3", newZones);
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAuthorityZones("GROUP_3").size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllAuthoritiesInZone("One", null).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthoritiesInZone("Two", null).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllAuthoritiesInZone("Three", null).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllAuthoritiesInZone("One", AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthoritiesInZone("Two", AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllAuthoritiesInZone("Three", AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllRootAuthoritiesInZone("One", null).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthoritiesInZone("Two", null).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllRootAuthoritiesInZone("Three", null).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllRootAuthoritiesInZone("One", AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthoritiesInZone("Two", AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllRootAuthoritiesInZone("Three", AuthorityType.GROUP).size());
        this.pubAuthorityService.addAuthority("GROUP_1", "GROUP_2");
        this.pubAuthorityService.addAuthority("GROUP_1", "GROUP_3");
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllRootAuthoritiesInZone("One", null).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthoritiesInZone("Two", null).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllRootAuthoritiesInZone("Three", null).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllRootAuthoritiesInZone("One", AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthoritiesInZone("Two", AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllRootAuthoritiesInZone("Three", AuthorityType.GROUP).size());
    }

    public void test_ETWOTWO_400() {
        String auth = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "wo\"of");
        Set<String> authorities = this.pubAuthorityService.findAuthorities(AuthorityType.GROUP, null, true, "wo\"of*", "APP.DEFAULT");
        AuthorityServiceTest.assertEquals((int)1, (int)authorities.size());
    }

    public void testGroupWildcards() {
        String[] zones;
        int end = 100;
        for (String zone : zones = new String[]{null, "ONE", "TWO", "THREE"}) {
            for (char i = 'a'; i <= end; i = (char)((char)(i + 1))) {
                for (char j = 'a'; j <= end; j = (char)((char)(j + 1))) {
                    for (char k = 'a'; k <= end; k = (char)(k + '\u0001')) {
                        StringBuilder name = new StringBuilder();
                        name.append("__").append(zone).append("__").append(i).append(j).append(k);
                        if (zone == null) {
                            this.pubAuthorityService.createAuthority(AuthorityType.GROUP, name.toString());
                            continue;
                        }
                        this.pubAuthorityService.createAuthority(AuthorityType.GROUP, name.toString(), name.toString(), Collections.singleton(zone));
                    }
                }
            }
        }
        int size = end - 97 + 1;
        long before = System.nanoTime();
        Set<String> matches = this.pubAuthorityService.findAuthorities(AuthorityType.GROUP, null, false, "__*__a*", null);
        long after = System.nanoTime();
        System.out.println("GROUP___a* in " + (float)(after - before) / 1.0E9f);
        AuthorityServiceTest.assertEquals((int)(size * size * zones.length), (int)matches.size());
        before = System.nanoTime();
        matches = this.pubAuthorityService.findAuthorities(AuthorityType.GROUP, null, false, "__*__aa*", null);
        after = System.nanoTime();
        System.out.println("GROUP___aa* in " + (float)(after - before) / 1.0E9f);
        AuthorityServiceTest.assertEquals((int)(size * zones.length), (int)matches.size());
        before = System.nanoTime();
        matches = this.pubAuthorityService.findAuthorities(AuthorityType.GROUP, null, false, "__*__*aa", null);
        after = System.nanoTime();
        System.out.println("GROUP___*aa in " + (float)(after - before) / 1.0E9f);
        AuthorityServiceTest.assertEquals((int)(size * zones.length), (int)matches.size());
        before = System.nanoTime();
        matches = this.pubAuthorityService.findAuthorities(AuthorityType.GROUP, null, false, "__*__*a", null);
        after = System.nanoTime();
        System.out.println("GROUP___*a in " + (float)(after - before) / 1.0E9f);
        AuthorityServiceTest.assertEquals((int)(size * size * zones.length), (int)matches.size());
        for (String zone : zones) {
            if (zone == null) continue;
            before = System.nanoTime();
            matches = this.pubAuthorityService.findAuthorities(AuthorityType.GROUP, null, false, "__*__a*", zone);
            after = System.nanoTime();
            System.out.println("GROUP___a* in " + (float)(after - before) / 1.0E9f);
            AuthorityServiceTest.assertEquals((int)(size * size), (int)matches.size());
            before = System.nanoTime();
            matches = this.pubAuthorityService.findAuthorities(AuthorityType.GROUP, null, false, "__*__aa*", zone);
            after = System.nanoTime();
            System.out.println("GROUP___aa* in " + (float)(after - before) / 1.0E9f);
            AuthorityServiceTest.assertEquals((int)size, (int)matches.size());
            before = System.nanoTime();
            matches = this.pubAuthorityService.findAuthorities(AuthorityType.GROUP, null, false, "__*__*aa", zone);
            after = System.nanoTime();
            System.out.println("GROUP___*aa in " + (float)(after - before) / 1.0E9f);
            AuthorityServiceTest.assertEquals((int)size, (int)matches.size());
            before = System.nanoTime();
            matches = this.pubAuthorityService.findAuthorities(AuthorityType.GROUP, null, false, "__*__*a", zone);
            after = System.nanoTime();
            System.out.println("GROUP___*a in " + (float)(after - before) / 1.0E9f);
            AuthorityServiceTest.assertEquals((int)(size * size), (int)matches.size());
        }
    }

    public void testNonAdminUser() {
        this.authenticationComponent.setCurrentUser("andy");
        AuthorityServiceTest.assertFalse((boolean)this.authorityService.hasAdminAuthority());
        AuthorityServiceTest.assertFalse((boolean)this.pubAuthorityService.hasAdminAuthority());
        AuthorityServiceTest.assertEquals((int)1, (int)this.authorityService.getAuthorities().size());
    }

    public void testAdminUser() {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        AuthorityServiceTest.assertTrue((boolean)this.authorityService.hasAdminAuthority());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.hasAdminAuthority());
        Set<String> authorities = this.authorityService.getAuthorities();
        AuthorityServiceTest.assertEquals((String)("Unexpected result: " + authorities), (int)4, (int)this.authorityService.getAuthorities().size());
    }

    public void testAuthorities() {
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ADMIN).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getAllAuthorities(AuthorityType.ADMIN).contains("ROLE_ADMINISTRATOR"));
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.EVERYONE).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getAllAuthorities(AuthorityType.EVERYONE).contains("GROUP_EVERYONE"));
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertFalse((boolean)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).contains("GROUP_EVERYONE"));
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GUEST).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getAllAuthorities(AuthorityType.GUEST).contains("ROLE_GUEST"));
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.OWNER).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)this.personService.getAllPeople().size(), (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.USER).size());
    }

    public void testCreateAdminAuth() {
        try {
            this.pubAuthorityService.createAuthority(AuthorityType.ADMIN, "woof");
            AuthorityServiceTest.fail((String)"Should not be able to create an admin authority");
        }
        catch (AuthorityException authorityException) {
            // empty catch block
        }
    }

    public void testCreateEveryoneAuth() {
        try {
            this.pubAuthorityService.createAuthority(AuthorityType.EVERYONE, "woof");
            AuthorityServiceTest.fail((String)"Should not be able to create an everyone authority");
        }
        catch (AuthorityException authorityException) {
            // empty catch block
        }
    }

    public void testCreateGuestAuth() {
        try {
            this.pubAuthorityService.createAuthority(AuthorityType.GUEST, "woof");
            AuthorityServiceTest.fail((String)"Should not be able to create an guest authority");
        }
        catch (AuthorityException authorityException) {
            // empty catch block
        }
    }

    public void testCreateOwnerAuth() {
        try {
            this.pubAuthorityService.createAuthority(AuthorityType.OWNER, "woof");
            AuthorityServiceTest.fail((String)"Should not be able to create an owner authority");
        }
        catch (AuthorityException authorityException) {
            // empty catch block
        }
    }

    public void testCreateUserAuth() {
        try {
            this.pubAuthorityService.createAuthority(AuthorityType.USER, "woof");
            AuthorityServiceTest.fail((String)"Should not be able to create an user authority");
        }
        catch (AuthorityException authorityException) {
            // empty catch block
        }
    }

    public void testCreateRootAuth() {
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "woof");
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        this.pubAuthorityService.deleteAuthority(auth);
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
        auth = this.pubAuthorityService.createAuthority(AuthorityType.ROLE, "woof");
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
        this.pubAuthorityService.deleteAuthority(auth);
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
    }

    public void testCreateAuth() {
        AuthorityServiceTest.assertFalse((boolean)this.pubAuthorityService.authorityExists(this.pubAuthorityService.getName(AuthorityType.GROUP, "one")));
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth1 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "one");
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.authorityExists(auth1));
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth2 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "two");
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth3 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "three");
        this.pubAuthorityService.addAuthority(auth1, auth3);
        AuthorityServiceTest.assertEquals((int)5, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth4 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "four");
        this.pubAuthorityService.addAuthority(auth1, auth4);
        AuthorityServiceTest.assertEquals((int)6, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth5 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "five");
        this.pubAuthorityService.addAuthority(auth2, auth5);
        AuthorityServiceTest.assertEquals((int)7, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        this.pubAuthorityService.deleteAuthority(auth5);
        AuthorityServiceTest.assertEquals((int)6, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        this.pubAuthorityService.deleteAuthority(auth4);
        AuthorityServiceTest.assertEquals((int)5, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        this.pubAuthorityService.deleteAuthority(auth3);
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        this.pubAuthorityService.deleteAuthority(auth2);
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        this.pubAuthorityService.deleteAuthority(auth1);
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
        auth1 = this.pubAuthorityService.createAuthority(AuthorityType.ROLE, "one");
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
        auth2 = this.pubAuthorityService.createAuthority(AuthorityType.ROLE, "two");
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
        auth3 = this.pubAuthorityService.createAuthority(AuthorityType.ROLE, "three");
        this.pubAuthorityService.addAuthority(auth1, auth3);
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
        auth4 = this.pubAuthorityService.createAuthority(AuthorityType.ROLE, "four");
        this.pubAuthorityService.addAuthority(auth1, auth4);
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
        auth5 = this.pubAuthorityService.createAuthority(AuthorityType.ROLE, "five");
        this.pubAuthorityService.addAuthority(auth2, auth5);
        AuthorityServiceTest.assertEquals((int)5, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
        this.pubAuthorityService.deleteAuthority(auth5);
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
        this.pubAuthorityService.deleteAuthority(auth4);
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
        this.pubAuthorityService.deleteAuthority(auth3);
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
        this.pubAuthorityService.deleteAuthority(auth2);
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
        this.pubAuthorityService.deleteAuthority(auth1);
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
    }

    private void checkAuthorityCollectionSize(int expected, Set<String> actual, AuthorityType type) {
        if (actual.size() != expected) {
            String msg = "Incorrect number of authorities.\n   Type:           " + type + "\n" + "   Expected Count: " + expected + "\n" + "   Actual Count:   " + actual.size() + "\n" + "   Authorities:    " + actual;
            AuthorityServiceTest.fail((String)msg);
        }
    }

    public void testCreateAuthTree() {
        this.personService.getPerson("andy");
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth1 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "one");
        AuthorityServiceTest.assertEquals((String)"GROUP_one", (String)auth1);
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth2 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "two");
        AuthorityServiceTest.assertEquals((String)"GROUP_two", (String)auth2);
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth3 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "three");
        this.pubAuthorityService.addAuthority(auth1, auth3);
        AuthorityServiceTest.assertEquals((String)"GROUP_three", (String)auth3);
        AuthorityServiceTest.assertEquals((int)5, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth4 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "four");
        this.pubAuthorityService.addAuthority(auth1, auth4);
        AuthorityServiceTest.assertEquals((String)"GROUP_four", (String)auth4);
        AuthorityServiceTest.assertEquals((int)6, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth5 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "five");
        this.pubAuthorityService.addAuthority(auth2, auth5);
        AuthorityServiceTest.assertEquals((String)"GROUP_five", (String)auth5);
        AuthorityServiceTest.assertEquals((int)7, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        this.checkAuthorityCollectionSize(3, this.pubAuthorityService.getAllAuthorities(AuthorityType.USER), AuthorityType.USER);
        this.pubAuthorityService.addAuthority(auth5, "andy");
        AuthorityServiceTest.assertEquals((int)7, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        this.checkAuthorityCollectionSize(3, this.pubAuthorityService.getAllAuthorities(AuthorityType.USER), AuthorityType.USER);
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth5));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth2));
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(null, auth5, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, auth5, false).contains(auth2));
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).contains(auth5));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).contains("andy"));
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainedAuthorities(null, auth5, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth5, false).contains("andy"));
        this.pubAuthorityService.removeAuthority(auth5, "andy");
        AuthorityServiceTest.assertEquals((int)7, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        this.checkAuthorityCollectionSize(3, this.pubAuthorityService.getAllAuthorities(AuthorityType.USER), AuthorityType.USER);
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(null, auth5, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, auth5, false).contains(auth2));
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).contains(auth5));
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainedAuthorities(null, auth5, false).size());
    }

    public void testCreateAuthNet() {
        this.personService.getPerson("andy");
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth1 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "one");
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth2 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "two");
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth3 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "three");
        this.pubAuthorityService.addAuthority(auth1, auth3);
        AuthorityServiceTest.assertEquals((int)5, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth4 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "four");
        this.pubAuthorityService.addAuthority(auth1, auth4);
        AuthorityServiceTest.assertEquals((int)6, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth5 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "five");
        this.pubAuthorityService.addAuthority(auth2, auth5);
        AuthorityServiceTest.assertEquals((int)7, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.USER).size());
        this.pubAuthorityService.addAuthority(auth5, "andy");
        this.pubAuthorityService.addAuthority(auth1, "andy");
        AuthorityServiceTest.assertEquals((int)7, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        this.checkAuthorityCollectionSize(3, this.pubAuthorityService.getAllAuthorities(AuthorityType.USER), AuthorityType.USER);
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth5));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth2));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth1));
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).contains(auth5));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).contains("andy"));
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains(auth3));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains(auth4));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains("andy"));
        this.pubAuthorityService.removeAuthority(auth1, "andy");
        AuthorityServiceTest.assertEquals((int)7, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        this.checkAuthorityCollectionSize(3, this.pubAuthorityService.getAllAuthorities(AuthorityType.USER), AuthorityType.USER);
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth5));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth2));
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).contains(auth5));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).contains("andy"));
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains(auth3));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains(auth4));
    }

    public void testCreateAuthNet2() {
        this.personService.getPerson("andy");
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth1 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "one");
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth2 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "two");
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth3 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "three");
        this.pubAuthorityService.addAuthority(auth1, auth3);
        AuthorityServiceTest.assertEquals((int)5, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth4 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "four");
        this.pubAuthorityService.addAuthority(auth1, auth4);
        AuthorityServiceTest.assertEquals((int)6, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth5 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "five");
        this.pubAuthorityService.addAuthority(auth2, auth5);
        AuthorityServiceTest.assertEquals((int)7, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        this.checkAuthorityCollectionSize(3, this.pubAuthorityService.getAllAuthorities(AuthorityType.USER), AuthorityType.USER);
        this.pubAuthorityService.addAuthority(auth5, "andy");
        this.pubAuthorityService.addAuthority(auth1, "andy");
        AuthorityServiceTest.assertEquals((int)7, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        this.checkAuthorityCollectionSize(3, this.pubAuthorityService.getAllAuthorities(AuthorityType.USER), AuthorityType.USER);
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth5));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth2));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth1));
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).contains(auth5));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).contains("andy"));
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains(auth3));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains(auth4));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains("andy"));
        this.pubAuthorityService.addAuthority(auth3, auth2);
        AuthorityServiceTest.assertEquals((int)7, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        this.checkAuthorityCollectionSize(3, this.pubAuthorityService.getAllAuthorities(AuthorityType.USER), AuthorityType.USER);
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth5));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth2));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth1));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth3));
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).contains(auth5));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).contains("andy"));
        AuthorityServiceTest.assertEquals((int)5, (int)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains(auth3));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains(auth4));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains(auth2));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains(auth5));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains("andy"));
    }

    public void test_AR_1510() {
        this.personService.getPerson("andy1");
        this.personService.getPerson("andy2");
        this.personService.getPerson("andy3");
        this.personService.getPerson("andy4");
        this.personService.getPerson("andy5");
        this.personService.getPerson("andy6");
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth1 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "one");
        this.pubAuthorityService.addAuthority(auth1, "andy1");
        String auth2 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "two");
        this.pubAuthorityService.addAuthority(auth1, auth2);
        this.pubAuthorityService.addAuthority(auth2, "andy1");
        this.pubAuthorityService.addAuthority(auth2, "andy2");
        String auth3 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "three");
        this.pubAuthorityService.addAuthority(auth2, auth3);
        this.pubAuthorityService.addAuthority(auth3, "andy3");
        String auth4 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "four");
        this.pubAuthorityService.addAuthority(auth3, auth4);
        this.pubAuthorityService.addAuthority(auth4, "andy1");
        this.pubAuthorityService.addAuthority(auth4, "andy4");
        String auth5 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "five");
        this.pubAuthorityService.addAuthority(auth4, auth5);
        this.pubAuthorityService.addAuthority(auth5, "andy1");
        this.pubAuthorityService.addAuthority(auth5, "andy5");
        String auth6 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "six");
        this.pubAuthorityService.addAuthority(auth3, auth6);
        this.pubAuthorityService.addAuthority(auth6, "andy1");
        this.pubAuthorityService.addAuthority(auth6, "andy5");
        this.pubAuthorityService.addAuthority(auth6, "andy6");
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainedAuthorities(null, auth1, true).size());
        AuthorityServiceTest.assertEquals((int)11, (int)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainedAuthorities(null, auth2, true).size());
        AuthorityServiceTest.assertEquals((int)10, (int)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainedAuthorities(null, auth3, true).size());
        AuthorityServiceTest.assertEquals((int)8, (int)this.pubAuthorityService.getContainedAuthorities(null, auth3, false).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainedAuthorities(null, auth4, true).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getContainedAuthorities(null, auth4, false).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainedAuthorities(null, auth5, true).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainedAuthorities(null, auth5, false).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainedAuthorities(null, auth6, true).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainedAuthorities(null, auth6, false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainedAuthorities(null, "andy1", true).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainedAuthorities(null, "andy1", false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainedAuthorities(null, "andy2", true).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainedAuthorities(null, "andy2", false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainedAuthorities(null, "andy3", true).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainedAuthorities(null, "andy3", false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainedAuthorities(null, "andy4", true).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainedAuthorities(null, "andy4", false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainedAuthorities(null, "andy5", true).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainedAuthorities(null, "andy5", false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainedAuthorities(null, "andy6", true).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainedAuthorities(null, "andy6", false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, auth1, true).size());
        AuthorityServiceTest.assertEquals((int)5, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, auth1, false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, auth2, true).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, auth2, false).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, auth3, true).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, auth3, false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, auth4, true).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, auth4, false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, auth5, true).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, auth5, false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, auth6, true).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, auth6, false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.USER, auth1, true).size());
        AuthorityServiceTest.assertEquals((int)6, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.USER, auth1, false).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.USER, auth2, true).size());
        AuthorityServiceTest.assertEquals((int)6, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.USER, auth2, false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.USER, auth3, true).size());
        AuthorityServiceTest.assertEquals((int)5, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.USER, auth3, false).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.USER, auth4, true).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.USER, auth4, false).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.USER, auth5, true).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.USER, auth5, false).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.USER, auth6, true).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.USER, auth6, false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(null, auth1, true).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(null, auth1, false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(null, auth2, true).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(null, auth2, false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(null, auth3, true).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainingAuthorities(null, auth3, false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(null, auth4, true).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainingAuthorities(null, auth4, false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(null, auth5, true).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getContainingAuthorities(null, auth5, false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(null, auth6, true).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainingAuthorities(null, auth6, false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.GROUP, auth1, true).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.GROUP, auth1, false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.GROUP, auth2, true).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.GROUP, auth2, false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.GROUP, auth3, true).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.GROUP, auth3, false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.GROUP, auth4, true).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.GROUP, auth4, false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.GROUP, auth5, true).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.GROUP, auth5, false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.GROUP, auth6, true).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.GROUP, auth6, false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.USER, auth1, true).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.USER, auth1, false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.USER, auth2, true).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.USER, auth2, false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.USER, auth3, true).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.USER, auth3, false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.USER, auth4, true).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.USER, auth4, false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.USER, auth5, true).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.USER, auth5, false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.USER, auth6, true).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.USER, auth6, false).size());
        AuthorityServiceTest.assertEquals((int)5, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy1", true).size());
        AuthorityServiceTest.assertEquals((int)6, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy1", false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy2", true).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy2", false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy3", true).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy3", false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy4", true).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy4", false).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy5", true).size());
        AuthorityServiceTest.assertEquals((int)6, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy5", false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy6", true).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy6", false).size());
        AuthorityServiceTest.assertEquals((int)5, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.GROUP, "andy1", true).size());
        AuthorityServiceTest.assertEquals((int)6, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.GROUP, "andy1", false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.GROUP, "andy2", true).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.GROUP, "andy2", false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.GROUP, "andy3", true).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.GROUP, "andy3", false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.GROUP, "andy4", true).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.GROUP, "andy4", false).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.GROUP, "andy5", true).size());
        AuthorityServiceTest.assertEquals((int)6, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.GROUP, "andy5", false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.GROUP, "andy6", true).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.GROUP, "andy6", false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.USER, "andy1", true).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.USER, "andy1", false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.USER, "andy2", true).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.USER, "andy2", false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.USER, "andy3", true).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.USER, "andy3", false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.USER, "andy4", true).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.USER, "andy4", false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.USER, "andy5", true).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.USER, "andy5", false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.USER, "andy6", true).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(AuthorityType.USER, "andy6", false).size());
    }

    public void test_AR_1517__AND__AR_1411() {
        this.personService.getPerson("1234");
        AuthorityServiceTest.assertTrue((boolean)this.personService.personExists("1234"));
        this.personService.getPerson("Loon");
        AuthorityServiceTest.assertTrue((boolean)this.personService.personExists("Loon"));
        this.personService.getPerson("andy");
        AuthorityServiceTest.assertTrue((boolean)this.personService.personExists("andy"));
        this.personService.createPerson(this.createDefaultProperties("Novalike", "Nova", "Like", "Nove@Like", "Sun", null));
        AuthorityServiceTest.assertTrue((boolean)this.personService.personExists("Novalike"));
        this.personService.getPerson("1andy");
        AuthorityServiceTest.assertTrue((boolean)this.personService.personExists("1andy"));
        this.personService.getPerson("andy2");
        AuthorityServiceTest.assertTrue((boolean)this.personService.personExists("andy2"));
        this.personService.getPerson("an3dy");
        AuthorityServiceTest.assertTrue((boolean)this.personService.personExists("an3dy"));
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth1 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "one");
        this.pubAuthorityService.addAuthority(auth1, "1234");
        String auth2 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "two");
        this.pubAuthorityService.addAuthority(auth2, "andy");
        String auth3 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "three");
        this.pubAuthorityService.addAuthority(auth3, "Novalike");
        String auth4 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "four");
        this.pubAuthorityService.addAuthority(auth4, "1andy");
        String auth5 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "five");
        this.pubAuthorityService.addAuthority(auth5, "andy2");
        String auth6 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "six");
        this.pubAuthorityService.addAuthority(auth6, "an3dy");
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainedAuthorities(null, auth1, true).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, true).contains("1234"));
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainedAuthorities(null, auth2, true).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth2, true).contains("andy"));
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainedAuthorities(null, auth3, true).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth3, true).contains("Novalike"));
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainedAuthorities(null, auth4, true).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth4, true).contains("1andy"));
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainedAuthorities(null, auth5, true).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth5, true).contains("andy2"));
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainedAuthorities(null, auth6, true).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth6, true).contains("an3dy"));
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(null, "1234", false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "1234", false).contains(auth1));
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth2));
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(null, "Novalike", false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "Novalike", false).contains(auth3));
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(null, "1andy", false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "1andy", false).contains(auth4));
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy2", false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy2", false).contains(auth5));
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(null, "an3dy", false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "an3dy", false).contains(auth6));
    }

    public void testGroupNameTokenisation() {
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth1234 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "1234");
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, auth1234, false).size());
        String authC1 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "circle");
        this.pubAuthorityService.addAuthority(auth1234, authC1);
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, auth1234, false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, authC1, false).size());
        String authC2 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "bigCircle");
        this.pubAuthorityService.addAuthority(authC1, authC2);
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, auth1234, false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, authC1, false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, authC2, false).size());
        String authStuff = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "|<>?~@:}{+_)(*&^%$\u00a3!\u00ac`,./#';][=-0987654321 1234556678 '");
        this.pubAuthorityService.addAuthority(authC2, authStuff);
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, auth1234, false).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, authC1, false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, authC2, false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, authStuff, false).size());
        String authSpace = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "  Circles     ");
        this.pubAuthorityService.addAuthority(authStuff, authSpace);
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, auth1234, false).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, authC1, false).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, authC2, false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, authStuff, false).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainedAuthorities(AuthorityType.GROUP, authSpace, false).size());
        this.pubAuthorityService.deleteAuthority(authSpace);
        this.pubAuthorityService.deleteAuthority(authStuff);
        this.pubAuthorityService.deleteAuthority(authC2);
        this.pubAuthorityService.deleteAuthority(authC1);
        this.pubAuthorityService.deleteAuthority(auth1234);
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
    }

    public void testAdminGroup() {
        this.personService.getPerson("andy");
        String adminGroup = this.pubAuthorityService.getName(AuthorityType.GROUP, "ALFRESCO_ADMINISTRATORS");
        this.pubAuthorityService.removeAuthority(adminGroup, "andy");
        AuthorityServiceTest.assertFalse((boolean)this.pubAuthorityService.isAdminAuthority("andy"));
        this.pubAuthorityService.addAuthority(adminGroup, "andy");
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.isAdminAuthority("andy"));
        this.pubAuthorityService.removeAuthority(adminGroup, "andy");
        AuthorityServiceTest.assertFalse((boolean)this.pubAuthorityService.isAdminAuthority("andy"));
    }

    private Map<QName, Serializable> createDefaultProperties(String userName, String firstName, String lastName, String email, String orgId, NodeRef home) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
        properties.put(ContentModel.PROP_HOMEFOLDER, (Serializable)home);
        properties.put(ContentModel.PROP_FIRSTNAME, (Serializable)((Object)firstName));
        properties.put(ContentModel.PROP_LASTNAME, (Serializable)((Object)lastName));
        properties.put(ContentModel.PROP_EMAIL, (Serializable)((Object)email));
        properties.put(ContentModel.PROP_ORGID, (Serializable)((Object)orgId));
        return properties;
    }

    public void testAuthorityDisplayNames() {
        String authOne = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "One");
        AuthorityServiceTest.assertEquals((String)this.pubAuthorityService.getAuthorityDisplayName(authOne), (String)"One");
        this.pubAuthorityService.setAuthorityDisplayName(authOne, "Selfish Crocodile");
        AuthorityServiceTest.assertEquals((String)this.pubAuthorityService.getAuthorityDisplayName(authOne), (String)"Selfish Crocodile");
        String authTwo = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, "Two", "Lamp posts", this.authorityService.getDefaultZones());
        AuthorityServiceTest.assertEquals((String)this.pubAuthorityService.getAuthorityDisplayName(authTwo), (String)"Lamp posts");
        this.pubAuthorityService.setAuthorityDisplayName(authTwo, "Happy Hippos");
        AuthorityServiceTest.assertEquals((String)this.pubAuthorityService.getAuthorityDisplayName(authTwo), (String)"Happy Hippos");
        AuthorityServiceTest.assertEquals((String)this.pubAuthorityService.getAuthorityDisplayName("GROUP_Loon"), (String)"Loon");
        AuthorityServiceTest.assertEquals((String)this.pubAuthorityService.getAuthorityDisplayName("ROLE_Gibbon"), (String)"Gibbon");
        AuthorityServiceTest.assertEquals((String)this.pubAuthorityService.getAuthorityDisplayName("Monkey"), (String)"Monkey");
        this.authenticationComponent.setCurrentUser("andy");
        AuthorityServiceTest.assertEquals((String)this.pubAuthorityService.getAuthorityDisplayName(authOne), (String)"Selfish Crocodile");
        AuthorityServiceTest.assertEquals((String)this.pubAuthorityService.getAuthorityDisplayName(authTwo), (String)"Happy Hippos");
        AuthorityServiceTest.assertEquals((String)this.pubAuthorityService.getAuthorityDisplayName("GROUP_Loon"), (String)"Loon");
        AuthorityServiceTest.assertEquals((String)this.pubAuthorityService.getAuthorityDisplayName("GROUP_Loon"), (String)"Loon");
        AuthorityServiceTest.assertEquals((String)this.pubAuthorityService.getAuthorityDisplayName("ROLE_Gibbon"), (String)"Gibbon");
        AuthorityServiceTest.assertEquals((String)this.pubAuthorityService.getAuthorityDisplayName("Monkey"), (String)"Monkey");
    }
}

