/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tagging;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.audit.AuditComponent;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.tagging.TagDetailsImpl;
import org.alfresco.repo.tagging.TagScopeImpl;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.tagging.TagDetails;
import org.alfresco.service.cmr.tagging.TagScope;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggingServiceImpl
implements TaggingService,
TransactionListener,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnMoveNodePolicy,
CopyServicePolicies.OnCopyCompletePolicy,
CopyServicePolicies.BeforeCopyPolicy {
    protected static final String TAGGING_AUDIT_APPLICATION_NAME = "Alfresco Tagging Service";
    protected static final String TAGGING_AUDIT_ROOT_PATH = "/tagging";
    protected static final String TAGGING_AUDIT_KEY_NODEREF = "node";
    protected static final String TAGGING_AUDIT_KEY_TAGS = "tags";
    private static Log logger = LogFactory.getLog(TaggingServiceImpl.class);
    private NodeService nodeService;
    private CategoryService categoryService;
    private SearchService searchService;
    private ActionService actionService;
    private ContentService contentService;
    private NamespaceService namespaceService;
    private PolicyComponent policyComponent;
    private AuditService auditService;
    private AuditComponent auditComponent;
    private static final String TAG_DETAILS_DELIMITER = "|";
    private JavaBehaviour updateTagBehaviour;
    private JavaBehaviour createTagBehaviour;
    public static final String TAG_UPDATES = "tagUpdates";

    public void setCategoryService(CategoryService categoryService) {
        this.categoryService = categoryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    public void setAuditComponent(AuditComponent auditComponent) {
        this.auditComponent = auditComponent;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"beforeDeleteNode"), ContentModel.ASPECT_TAGGABLE, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.createTagBehaviour = new JavaBehaviour(this, "createTags", Behaviour.NotificationFrequency.FIRST_EVENT);
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnCreateNodePolicy.QNAME, ContentModel.ASPECT_TAGGABLE, (Behaviour)this.createTagBehaviour);
        this.updateTagBehaviour = new JavaBehaviour(this, "updateTags", Behaviour.NotificationFrequency.EVERY_EVENT);
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, ContentModel.TYPE_CONTENT, (Behaviour)this.updateTagBehaviour);
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, ContentModel.TYPE_FOLDER, (Behaviour)this.updateTagBehaviour);
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnMoveNodePolicy.QNAME, ContentModel.ASPECT_TAGGABLE, (Behaviour)new JavaBehaviour(this, "onMoveNode", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.BeforeCopyPolicy.QNAME, ContentModel.ASPECT_TAGGABLE, (Behaviour)new JavaBehaviour(this, "beforeCopy", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyCompletePolicy.QNAME, ContentModel.ASPECT_TAGGABLE, (Behaviour)new JavaBehaviour(this, "onCopyComplete", Behaviour.NotificationFrequency.EVERY_EVENT));
    }

    private void updateAllScopeTags(NodeRef nodeRef, Boolean isAdd) {
        ChildAssociationRef assocRef = this.nodeService.getPrimaryParent(nodeRef);
        if (assocRef != null) {
            this.updateAllScopeTags(nodeRef, assocRef.getParentRef(), isAdd);
        }
    }

    private void updateAllScopeTags(NodeRef nodeRef, NodeRef parentNodeRef, Boolean isAdd) {
        if (parentNodeRef != null) {
            Map allQueuedUpdates = (Map)AlfrescoTransactionSupport.getResource(TAG_UPDATES);
            Map nodeQueuedUpdates = null;
            if (allQueuedUpdates != null) {
                nodeQueuedUpdates = (Map)allQueuedUpdates.get(nodeRef);
            }
            List<String> tags = this.getTags(nodeRef);
            HashMap<String, Boolean> tagUpdates = new HashMap<String, Boolean>(tags.size());
            for (String tag : tags) {
                Boolean queuedOp;
                tagUpdates.put(tag, isAdd);
                if (nodeQueuedUpdates == null || (queuedOp = (Boolean)nodeQueuedUpdates.get(tag)) == null || queuedOp.booleanValue() != isAdd.booleanValue()) continue;
                nodeQueuedUpdates.remove(tag);
            }
            this.updateTagScope(parentNodeRef, tagUpdates);
        }
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        if (this.nodeService.exists(nodeRef) && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TAGGABLE)) {
            this.updateAllScopeTags(nodeRef, Boolean.FALSE);
        }
    }

    @Override
    public void beforeCopy(QName classRef, NodeRef sourceNodeRef, NodeRef targetNodeRef) {
        if (this.nodeService.hasAspect(targetNodeRef, ContentModel.ASPECT_TAGGABLE)) {
            this.updateAllScopeTags(targetNodeRef, Boolean.FALSE);
        }
    }

    @Override
    public void onCopyComplete(QName classRef, NodeRef sourceNodeRef, NodeRef targetNodeRef, boolean copyToNewNode, Map<NodeRef, NodeRef> copyMap) {
        if (this.nodeService.hasAspect(targetNodeRef, ContentModel.ASPECT_TAGGABLE)) {
            this.updateAllScopeTags(targetNodeRef, Boolean.TRUE);
        }
    }

    @Override
    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        ChildAssociationRef scopeParent;
        NodeRef oldRef = oldChildAssocRef.getChildRef();
        NodeRef oldParent = oldChildAssocRef.getParentRef();
        NodeRef newRef = newChildAssocRef.getChildRef();
        NodeRef newParent = newChildAssocRef.getParentRef();
        if (oldParent.equals((Object)newParent)) {
            return;
        }
        if (this.nodeService.hasAspect(oldRef, ContentModel.ASPECT_TAGGABLE) && (scopeParent = oldChildAssocRef.isPrimary() ? oldChildAssocRef : this.nodeService.getPrimaryParent(oldParent)) != null) {
            this.updateAllScopeTags(oldRef, scopeParent.getParentRef(), Boolean.FALSE);
        }
        if (this.nodeService.hasAspect(newRef, ContentModel.ASPECT_TAGGABLE)) {
            this.updateAllScopeTags(newRef, Boolean.TRUE);
        }
    }

    public void createTags(ChildAssociationRef childAssocRef) {
        NodeRef nodeRef = childAssocRef.getChildRef();
        HashMap<QName, Serializable> before = new HashMap<QName, Serializable>(0);
        Map after = this.nodeService.getProperties(nodeRef);
        this.updateTags(nodeRef, before, after);
    }

    public void updateTags(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        block6: {
            String tagName;
            ArrayList afterNodeRefs;
            List beforeNodeRefs;
            block7: {
                block5: {
                    beforeNodeRefs = (List)((Object)before.get(ContentModel.PROP_TAGS));
                    afterNodeRefs = (ArrayList)after.get(ContentModel.PROP_TAGS);
                    if (beforeNodeRefs != null || afterNodeRefs == null) break block5;
                    for (NodeRef afterNodeRef : afterNodeRefs) {
                        String tagName2 = this.getTagName(afterNodeRef);
                        this.queueTagUpdate(nodeRef, tagName2, true);
                    }
                    break block6;
                }
                if (afterNodeRefs != null || beforeNodeRefs == null) break block7;
                for (NodeRef beforeNodeRef : beforeNodeRefs) {
                    String tagName3 = this.getTagName(beforeNodeRef);
                    this.queueTagUpdate(nodeRef, tagName3, false);
                }
                break block6;
            }
            if (afterNodeRefs == null || beforeNodeRefs == null) break block6;
            afterNodeRefs = new ArrayList(afterNodeRefs);
            for (NodeRef beforeNodeRef : beforeNodeRefs) {
                if (afterNodeRefs.contains(beforeNodeRef)) {
                    afterNodeRefs.remove(beforeNodeRef);
                    continue;
                }
                tagName = this.getTagName(beforeNodeRef);
                this.queueTagUpdate(nodeRef, tagName, false);
            }
            for (NodeRef afterNodeRef : afterNodeRefs) {
                tagName = this.getTagName(afterNodeRef);
                this.queueTagUpdate(nodeRef, tagName, true);
            }
        }
    }

    private String getTagName(NodeRef nodeRef) {
        return (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
    }

    @Override
    public boolean isTag(StoreRef storeRef, String tag) {
        return this.getTagNodeRef(storeRef, tag.toLowerCase()) != null;
    }

    @Override
    public NodeRef createTag(StoreRef storeRef, String tag) {
        tag = tag.toLowerCase();
        return this.getTagNodeRef(storeRef, tag, true);
    }

    @Override
    public void deleteTag(StoreRef storeRef, String tag) {
        NodeRef tagNodeRef = this.getTagNodeRef(storeRef, tag = tag.toLowerCase());
        if (tagNodeRef != null) {
            this.categoryService.deleteCategory(tagNodeRef);
        }
    }

    @Override
    public List<String> getTags(StoreRef storeRef) {
        Collection<ChildAssociationRef> rootCategories = this.categoryService.getRootCategories(storeRef, ContentModel.ASPECT_TAGGABLE);
        ArrayList<String> result = new ArrayList<String>(rootCategories.size());
        for (ChildAssociationRef rootCategory : rootCategories) {
            String name = (String)((Object)this.nodeService.getProperty(rootCategory.getChildRef(), ContentModel.PROP_NAME));
            result.add(name);
        }
        return result;
    }

    @Override
    public List<String> getTags(StoreRef storeRef, String filter) {
        Collection<ChildAssociationRef> rootCategories = this.categoryService.getRootCategories(storeRef, ContentModel.ASPECT_TAGGABLE);
        ArrayList<String> result = new ArrayList<String>(rootCategories.size());
        for (ChildAssociationRef rootCategory : rootCategories) {
            String name = (String)((Object)this.nodeService.getProperty(rootCategory.getChildRef(), ContentModel.PROP_NAME));
            if (!name.contains(filter.toLowerCase())) continue;
            result.add(name);
        }
        return result;
    }

    @Override
    public boolean hasTag(NodeRef nodeRef, String tag) {
        List<String> tags = this.getTags(nodeRef);
        return tags.contains(tag.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTag(NodeRef nodeRef, String tagName) {
        this.updateTagBehaviour.disable();
        this.createTagBehaviour.disable();
        try {
            String tag = tagName.toLowerCase();
            NodeRef newTagNodeRef = this.getTagNodeRef(nodeRef.getStoreRef(), tag, true);
            List<NodeRef> tagNodeRefs = new ArrayList(5);
            if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TAGGABLE)) {
                this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_TAGGABLE, null);
            } else {
                List currentTagNodes = (List)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_TAGS));
                if (currentTagNodes != null) {
                    tagNodeRefs = currentTagNodes;
                }
            }
            if (!tagNodeRefs.contains(newTagNodeRef)) {
                tagNodeRefs.add(newTagNodeRef);
                this.nodeService.setProperty(nodeRef, ContentModel.PROP_TAGS, (Serializable)((Object)tagNodeRefs));
                this.queueTagUpdate(nodeRef, tag, true);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.updateTagBehaviour.enable();
            this.createTagBehaviour.enable();
            throw throwable;
        }
        this.updateTagBehaviour.enable();
        this.createTagBehaviour.enable();
    }

    @Override
    public void addTags(NodeRef nodeRef, List<String> tags) {
        for (String tag : tags) {
            this.addTag(nodeRef, tag);
        }
    }

    @Override
    public NodeRef getTagNodeRef(StoreRef storeRef, String tag) {
        return this.getTagNodeRef(storeRef, tag, false);
    }

    private NodeRef getTagNodeRef(StoreRef storeRef, String tag, boolean create) {
        NodeRef tagNodeRef = null;
        Collection<ChildAssociationRef> results = this.categoryService.getRootCategories(storeRef, ContentModel.ASPECT_TAGGABLE, tag, create);
        if (!results.isEmpty()) {
            tagNodeRef = results.iterator().next().getChildRef();
        }
        return tagNodeRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTag(NodeRef nodeRef, String tag) {
        this.updateTagBehaviour.disable();
        this.createTagBehaviour.disable();
        try {
            List currentTagNodes;
            NodeRef newTagNodeRef;
            tag = tag.toLowerCase();
            if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TAGGABLE) && (newTagNodeRef = this.getTagNodeRef(nodeRef.getStoreRef(), tag)) != null && (currentTagNodes = (List)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_TAGS))) != null && currentTagNodes.size() != 0 && currentTagNodes.contains(newTagNodeRef)) {
                currentTagNodes.remove(newTagNodeRef);
                this.nodeService.setProperty(nodeRef, ContentModel.PROP_TAGS, (Serializable)((Object)currentTagNodes));
                this.queueTagUpdate(nodeRef, tag, false);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.updateTagBehaviour.enable();
            this.createTagBehaviour.enable();
            throw throwable;
        }
        this.updateTagBehaviour.enable();
        this.createTagBehaviour.enable();
    }

    @Override
    public void removeTags(NodeRef nodeRef, List<String> tags) {
        for (String tag : tags) {
            this.removeTag(nodeRef, tag);
        }
    }

    @Override
    public List<String> getTags(NodeRef nodeRef) {
        List currentTagNodes;
        ArrayList<String> result = new ArrayList<String>(10);
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TAGGABLE) && (currentTagNodes = (List)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_TAGS))) != null) {
            for (NodeRef currentTagNode : currentTagNodes) {
                String tag = (String)((Object)this.nodeService.getProperty(currentTagNode, ContentModel.PROP_NAME));
                result.add(tag);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTags(NodeRef nodeRef, List<String> tags) {
        this.updateTagBehaviour.disable();
        this.createTagBehaviour.disable();
        try {
            ArrayList<NodeRef> tagNodeRefs = new ArrayList<NodeRef>(tags.size());
            if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TAGGABLE)) {
                this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_TAGGABLE, null);
            }
            List<String> oldTags = this.getTags(nodeRef);
            for (String tag : tags) {
                tag = tag.toLowerCase();
                NodeRef newTagNodeRef = this.getTagNodeRef(nodeRef.getStoreRef(), tag, true);
                if (tagNodeRefs.contains(newTagNodeRef)) continue;
                tagNodeRefs.add(newTagNodeRef);
                if (!oldTags.contains(tag)) {
                    this.queueTagUpdate(nodeRef, tag, true);
                    continue;
                }
                oldTags.remove(tag);
            }
            for (String oldTag : oldTags) {
                this.queueTagUpdate(nodeRef, oldTag, false);
            }
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_TAGS, (Serializable)tagNodeRefs);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.updateTagBehaviour.enable();
            this.createTagBehaviour.enable();
            throw throwable;
        }
        this.updateTagBehaviour.enable();
        this.createTagBehaviour.enable();
    }

    @Override
    public void clearTags(NodeRef nodeRef) {
        this.setTags(nodeRef, Collections.<String>emptyList());
    }

    @Override
    public boolean isTagScope(NodeRef nodeRef) {
        return this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TAGSCOPE);
    }

    @Override
    public void addTagScope(NodeRef nodeRef) {
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TAGSCOPE)) {
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_TAGSCOPE, null);
            this.refreshTagScope(nodeRef, false);
        }
    }

    @Override
    public void refreshTagScope(NodeRef nodeRef, boolean async) {
        if (this.nodeService.exists(nodeRef) && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TAGSCOPE)) {
            Action action = this.actionService.createAction("refresh-tagscope");
            this.actionService.executeAction(action, nodeRef, false, async);
        }
    }

    @Override
    public void removeTagScope(NodeRef nodeRef) {
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TAGSCOPE)) {
            this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_TAGSCOPE);
        }
    }

    @Override
    public TagScope findTagScope(NodeRef nodeRef) {
        TagScopeImpl tagScope = null;
        if (this.nodeService.exists(nodeRef)) {
            ArrayList<NodeRef> tagScopeNodeRefs = new ArrayList<NodeRef>(3);
            this.getTagScopes(nodeRef, tagScopeNodeRefs, true);
            if (tagScopeNodeRefs.size() != 0) {
                tagScope = new TagScopeImpl((NodeRef)tagScopeNodeRefs.get(0), this.getTagDetails((NodeRef)tagScopeNodeRefs.get(0)));
            }
        }
        return tagScope;
    }

    private List<TagDetails> getTagDetails(NodeRef nodeRef) {
        List<TagDetails> tagDetails = new ArrayList<TagDetails>(13);
        ContentReader reader = this.contentService.getReader(nodeRef, ContentModel.PROP_TAGSCOPE_CACHE);
        if (reader != null) {
            tagDetails = TaggingServiceImpl.readTagDetails(reader.getContentInputStream());
        }
        return tagDetails;
    }

    @Override
    public List<TagScope> findAllTagScopes(NodeRef nodeRef) {
        List result = null;
        if (this.nodeService.exists(nodeRef)) {
            ArrayList<NodeRef> tagScopeNodeRefs = new ArrayList<NodeRef>(3);
            this.getTagScopes(nodeRef, tagScopeNodeRefs);
            if (tagScopeNodeRefs.size() != 0) {
                result = new ArrayList(tagScopeNodeRefs.size());
                for (NodeRef tagScopeNodeRef : tagScopeNodeRefs) {
                    result.add(new TagScopeImpl(tagScopeNodeRef, this.getTagDetails(tagScopeNodeRef)));
                }
            } else {
                result = Collections.emptyList();
            }
        }
        return result;
    }

    private void getTagScopes(NodeRef nodeRef, List<NodeRef> tagScopes) {
        this.getTagScopes(nodeRef, tagScopes, false);
    }

    private void getTagScopes(NodeRef nodeRef, List<NodeRef> tagScopes, boolean firstOnly) {
        NodeRef parent;
        ChildAssociationRef assoc;
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TAGSCOPE)) {
            tagScopes.add(nodeRef);
            if (firstOnly) {
                return;
            }
        }
        if ((assoc = this.nodeService.getPrimaryParent(nodeRef)) != null && (parent = assoc.getParentRef()) != null) {
            this.getTagScopes(parent, tagScopes, firstOnly);
        }
    }

    @Override
    public List<NodeRef> findTaggedNodes(StoreRef storeRef, String tag) {
        tag = tag.toLowerCase();
        ResultSet resultSet = this.searchService.query(storeRef, "lucene", "+PATH:\"/cm:taggable/cm:" + ISO9075.encode((String)tag) + "/member\"");
        List nodeRefs = resultSet.getNodeRefs();
        resultSet.close();
        return nodeRefs;
    }

    @Override
    public List<NodeRef> findTaggedNodes(StoreRef storeRef, String tag, NodeRef nodeRef) {
        tag = tag.toLowerCase();
        Path nodePath = this.nodeService.getPath(nodeRef);
        String pathString = nodePath.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        ResultSet resultSet = this.searchService.query(storeRef, "lucene", "+PATH:\"" + pathString + "//*\" +PATH:\"/cm:taggable/cm:" + ISO9075.encode((String)tag) + "/member\"");
        List nodeRefs = resultSet.getNodeRefs();
        resultSet.close();
        return nodeRefs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<TagDetails> readTagDetails(InputStream is) {
        ArrayList<TagDetails> result = new ArrayList<TagDetails>(25);
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                String nextLine = reader.readLine();
                while (nextLine != null) {
                    String[] values = nextLine.split("\\|");
                    result.add(new TagDetailsImpl(values[0], Integer.parseInt(values[1])));
                    nextLine = reader.readLine();
                }
                Object var6_6 = null;
            }
            catch (IOException exception) {
                throw new AlfrescoRuntimeException("Unable to read tag details", (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                reader.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        reader.close();
        return result;
    }

    static String tagDetailsToString(List<TagDetails> tagDetails) {
        StringBuffer result = new StringBuffer(255);
        boolean bFirst = true;
        for (TagDetails details : tagDetails) {
            if (!bFirst) {
                result.append("\n");
            } else {
                bFirst = false;
            }
            result.append(details.getName());
            result.append(TAG_DETAILS_DELIMITER);
            result.append(details.getCount());
        }
        return result.toString();
    }

    private void updateTagScope(NodeRef nodeRef, Map<String, Boolean> updates) {
        if (!this.auditService.isAuditEnabled(TAGGING_AUDIT_APPLICATION_NAME, TAGGING_AUDIT_ROOT_PATH)) {
            logger.warn((Object)"Tag updates won't propogate to the TagScope caches as auditing is disabled");
            return;
        }
        ArrayList<NodeRef> tagScopeNodeRefs = new ArrayList<NodeRef>(3);
        this.getTagScopes(nodeRef, tagScopeNodeRefs);
        if (tagScopeNodeRefs.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No tag scopes found for " + nodeRef + " so no scope updates needed"));
            }
            return;
        }
        HashMap<String, Integer> changes = new HashMap<String, Integer>(updates.size());
        for (String tag : updates.keySet()) {
            int val = -1;
            if (updates.get(tag).booleanValue()) {
                val = 1;
            }
            changes.put(tag, val);
        }
        for (NodeRef tagScopeNode : tagScopeNodeRefs) {
            HashMap<String, Serializable> auditValues = new HashMap<String, Serializable>();
            auditValues.put(TAGGING_AUDIT_KEY_TAGS, changes);
            auditValues.put(TAGGING_AUDIT_KEY_NODEREF, (Serializable)((Object)tagScopeNode.toString()));
            this.auditComponent.recordAuditValues(TAGGING_AUDIT_ROOT_PATH, auditValues);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Queueing async tag scope updates to tag scopes " + tagScopeNodeRefs + " of " + changes));
        }
        Action action = this.actionService.createAction("update-tagscope");
        action.setParameterValue("tag_scopes", tagScopeNodeRefs);
        this.actionService.executeAction(action, null, false, true);
    }

    private void queueTagUpdate(NodeRef nodeRef, String tag, boolean add) {
        HashMap<String, Boolean> nodeDetails;
        HashMap updates = (HashMap)AlfrescoTransactionSupport.getResource(TAG_UPDATES);
        if (updates == null) {
            updates = new HashMap(10);
            AlfrescoTransactionSupport.bindResource(TAG_UPDATES, updates);
            AlfrescoTransactionSupport.bindListener(this);
        }
        if ((nodeDetails = (HashMap<String, Boolean>)updates.get(nodeRef)) == null) {
            nodeDetails = new HashMap<String, Boolean>(10);
            nodeDetails.put(tag, add);
            updates.put(nodeRef, nodeDetails);
        } else {
            Boolean currentValue = (Boolean)nodeDetails.get(tag);
            if (currentValue == null) {
                nodeDetails.put(tag, add);
                updates.put(nodeRef, nodeDetails);
            } else if (currentValue != add) {
                updates.remove(tag);
            }
        }
    }

    @Override
    public void afterCommit() {
    }

    @Override
    public void afterRollback() {
    }

    @Override
    public void beforeCommit(boolean readOnly) {
        Map updates = (Map)AlfrescoTransactionSupport.getResource(TAG_UPDATES);
        if (updates != null) {
            for (NodeRef nodeRef : updates.keySet()) {
                Map tagUpdates = (Map)updates.get(nodeRef);
                if (tagUpdates == null || tagUpdates.size() == 0) continue;
                this.updateTagScope(nodeRef, tagUpdates);
            }
        }
    }

    @Override
    public void beforeCompletion() {
    }

    @Override
    public void flush() {
    }
}

