/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tenant;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.usage.UsageService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ApplicationContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class MultiTDemoTest
extends TestCase {
    private static Log logger = LogFactory.getLog(MultiTDemoTest.class);
    private static ApplicationContext ctx = new ClassPathXmlApplicationContext(new String[]{ApplicationContextHelper.CONFIG_LOCATIONS[0], "classpath:tenant/mt-*context.xml"});
    private NodeService nodeService;
    private MutableAuthenticationService authenticationService;
    private PersonService personService;
    private SearchService searchService;
    private ContentService contentService;
    private PermissionService permissionService;
    private OwnableService ownableService;
    private TenantAdminService tenantAdminService;
    private TenantService tenantService;
    private AuthorityService authorityService;
    private CategoryService categoryService;
    private CheckOutCheckInService cociService;
    private RepoAdminService repoAdminService;
    private DictionaryService dictionaryService;
    private UsageService usageService;
    public static int NUM_TENANTS = 2;
    public static final String TEST_RUN = System.currentTimeMillis() + "";
    public static final String TEST_TENANT_DOMAIN = TEST_RUN + ".my.test";
    public static final String TEST_TENANT_DOMAIN2 = TEST_TENANT_DOMAIN + "2";
    public static List<String> tenants = new ArrayList<String>(NUM_TENANTS);
    public static final String ROOT_DIR = "./tenantstores";
    public static final String DEFAULT_ADMIN_PW = "admin";
    public static final String DEFAULT_GUEST_UN = "guest";
    public static final String DEFAULT_GUEST_PW = "thiscanbeanything";
    public static final String TEST_USER1 = "alice";
    public static final String TEST_USER2 = "bob";
    public static final String TEST_USER3 = "eve";
    public static final String TEST_USER4 = "fred";
    private static final int DEFAULT_STORE_COUNT = 7;
    public static StoreRef SPACES_STORE;

    protected void setUp() throws Exception {
        super.setUp();
        this.nodeService = (NodeService)ctx.getBean("NodeService");
        this.authenticationService = (MutableAuthenticationService)ctx.getBean("AuthenticationService");
        this.tenantAdminService = (TenantAdminService)ctx.getBean("tenantAdminService");
        this.tenantService = (TenantService)ctx.getBean("tenantService");
        this.personService = (PersonService)ctx.getBean("PersonService");
        this.searchService = (SearchService)ctx.getBean("SearchService");
        this.contentService = (ContentService)ctx.getBean("ContentService");
        this.permissionService = (PermissionService)ctx.getBean("PermissionService");
        this.ownableService = (OwnableService)ctx.getBean("OwnableService");
        this.authorityService = (AuthorityService)ctx.getBean("AuthorityService");
        this.categoryService = (CategoryService)ctx.getBean("CategoryService");
        this.cociService = (CheckOutCheckInService)ctx.getBean("CheckoutCheckinService");
        this.repoAdminService = (RepoAdminService)ctx.getBean("RepoAdminService");
        this.dictionaryService = (DictionaryService)ctx.getBean("DictionaryService");
        this.usageService = (UsageService)ctx.getBean("usageService");
        this.createTenants();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private void createTenants() {
        for (String tenantDomain : tenants) {
            this.createTenant(tenantDomain);
        }
    }

    public void testCreateTenants() throws Throwable {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        logger.info((Object)"Create tenants");
        Set<NodeRef> personRefs = this.personService.getAllPeople();
        for (NodeRef personRef : personRefs) {
            String userName = (String)((Object)this.nodeService.getProperty(personRef, ContentModel.PROP_USERNAME));
            for (String tenantDomain : tenants) {
                MultiTDemoTest.assertFalse((String)("Unexpected (tenant) user: " + userName), (boolean)userName.endsWith(tenantDomain));
            }
        }
    }

    private void createTenant(final String tenantDomain) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                if (!MultiTDemoTest.this.tenantAdminService.existsTenant(tenantDomain)) {
                    MultiTDemoTest.this.tenantAdminService.createTenant(tenantDomain, ("admin " + tenantDomain).toCharArray(), null);
                    logger.info((Object)("Created tenant " + tenantDomain));
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    public void test_ETHREEOH_2015() {
        final String tenantDomain1 = TEST_RUN + ".one.ethreeoh2015";
        String tenantDomain2 = TEST_RUN + ".two.ethreeoh2015";
        this.clearUsage(AuthenticationUtil.getAdminUserName());
        this.createTenant(tenantDomain1);
        String tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain1);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                MultiTDemoTest.this.createUser(MultiTDemoTest.TEST_USER1, tenantDomain1, "alice " + tenantDomain1);
                return null;
            }
        }, (String)tenantAdminName);
        this.createTenant(tenantDomain2);
    }

    private void clearUsage(String userName) {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        NodeRef personNodeRef = this.personService.getPerson(userName);
        this.nodeService.setProperty(personNodeRef, ContentModel.PROP_SIZE_CURRENT, null);
        this.usageService.deleteDeltas(personNodeRef);
    }

    public void testCreateUsers() throws Throwable {
        logger.info((Object)"Create demo users");
        Set<NodeRef> personRefs = this.personService.getAllPeople();
        for (NodeRef personRef : personRefs) {
            String userName = (String)((Object)this.nodeService.getProperty(personRef, ContentModel.PROP_USERNAME));
            for (String tenantDomain : tenants) {
                MultiTDemoTest.assertFalse((String)("Unexpected (tenant) user: " + userName), (boolean)userName.endsWith(tenantDomain));
            }
        }
        try {
            String tenantAdminName;
            for (final String tenantDomain : tenants) {
                tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain);
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        MultiTDemoTest.this.createUser(MultiTDemoTest.TEST_USER1, tenantDomain, "alice " + tenantDomain);
                        MultiTDemoTest.this.createUser(MultiTDemoTest.TEST_USER2, tenantDomain, "bob " + tenantDomain);
                        if (tenantDomain.equals(TEST_TENANT_DOMAIN2)) {
                            MultiTDemoTest.this.createUser(MultiTDemoTest.TEST_USER3, tenantDomain, "eve " + tenantDomain);
                        }
                        return null;
                    }
                }, (String)tenantAdminName);
            }
            for (final String tenantDomain : tenants) {
                tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain);
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        Set<NodeRef> personRefs = MultiTDemoTest.this.personService.getAllPeople();
                        for (NodeRef personRef : personRefs) {
                            String userName = (String)((Object)MultiTDemoTest.this.nodeService.getProperty(personRef, ContentModel.PROP_USERNAME));
                            Assert.assertTrue((boolean)userName.endsWith(tenantDomain));
                            logger.info((Object)("Create users: get all people - found user: " + userName));
                            NodeRef homeSpaceRef = (NodeRef)MultiTDemoTest.this.nodeService.getProperty(personRef, ContentModel.PROP_HOMEFOLDER);
                            Assert.assertNotNull((Object)homeSpaceRef);
                        }
                        if (tenantDomain.equals(TEST_TENANT_DOMAIN2)) {
                            Assert.assertEquals((int)5, (int)personRefs.size());
                        } else {
                            Assert.assertEquals((int)4, (int)personRefs.size());
                        }
                        return null;
                    }
                }, (String)tenantAdminName);
            }
        }
        catch (Throwable t) {
            StringWriter stackTrace = new StringWriter();
            t.printStackTrace(new PrintWriter(stackTrace));
            System.err.println(stackTrace.toString());
            throw t;
        }
    }

    public void testLoginTenantUsers() throws Throwable {
        logger.info((Object)"Login tenant users");
        try {
            AuthenticationUtil.clearCurrentSecurityContext();
            for (String tenantDomain : tenants) {
                this.loginLogoutUser(this.tenantService.getDomainUser(TEST_USER1, tenantDomain), "alice " + tenantDomain);
                this.loginLogoutUser(this.tenantService.getDomainUser(TEST_USER2, tenantDomain), "bob " + tenantDomain);
                if (!tenantDomain.equals(TEST_TENANT_DOMAIN2)) continue;
                this.loginLogoutUser(this.tenantService.getDomainUser(TEST_USER3, tenantDomain), "eve " + tenantDomain);
            }
        }
        catch (Throwable t) {
            StringWriter stackTrace = new StringWriter();
            t.printStackTrace(new PrintWriter(stackTrace));
            System.err.println(stackTrace.toString());
            throw t;
        }
    }

    public void testLoginTenantGuests() throws Throwable {
        logger.info((Object)"Login tenant guests");
        try {
            AuthenticationUtil.clearCurrentSecurityContext();
            for (String tenantDomain : tenants) {
                this.loginLogoutUser(this.tenantService.getDomainUser(DEFAULT_GUEST_UN, tenantDomain), DEFAULT_GUEST_UN);
            }
        }
        catch (Throwable t) {
            StringWriter stackTrace = new StringWriter();
            t.printStackTrace(new PrintWriter(stackTrace));
            System.err.println(stackTrace.toString());
            throw t;
        }
    }

    public void testLoginTenantAdmin() throws Throwable {
        logger.info((Object)"Login tenant admins");
        try {
            AuthenticationUtil.clearCurrentSecurityContext();
            for (String tenantDomain : tenants) {
                this.loginLogoutUser(this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain), "admin " + tenantDomain);
            }
        }
        catch (Throwable t) {
            StringWriter stackTrace = new StringWriter();
            t.printStackTrace(new PrintWriter(stackTrace));
            System.err.println(stackTrace.toString());
            throw t;
        }
    }

    public void testCreateGroups() {
        String tenantAdminName;
        logger.info((Object)"Create demo groups");
        MultiTDemoTest.assertTrue((tenants.size() > 0 ? 1 : 0) != 0);
        final int rootGrpsOrigCnt = (Integer)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Integer>(){

            public Integer doWork() throws Exception {
                return MultiTDemoTest.this.authorityService.getAllRootAuthorities(AuthorityType.GROUP).size();
            }
        }, (String)this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenants.get(0)));
        for (final String tenantDomain : tenants) {
            tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain);
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    MultiTDemoTest.this.createGroup("GrpA", null);
                    MultiTDemoTest.this.createGroup("SubGrpA", "GrpA");
                    MultiTDemoTest.this.createGroup("GrpB", null);
                    MultiTDemoTest.this.createGroup("GrpC", null);
                    if (tenantDomain.equals(TEST_TENANT_DOMAIN2)) {
                        MultiTDemoTest.this.createGroup("SubGrpC", "GrpC");
                    }
                    MultiTDemoTest.this.createGroup("GrpD", null);
                    MultiTDemoTest.this.addToGroup("GrpD", tenantAdminName);
                    return null;
                }
            }, (String)tenantAdminName);
        }
        for (final String tenantDomain : tenants) {
            tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain);
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    Set<String> rootGrps = MultiTDemoTest.this.authorityService.getAllRootAuthorities(AuthorityType.GROUP);
                    Assert.assertEquals((int)(rootGrpsOrigCnt + 4), (int)rootGrps.size());
                    Set<String> auths = MultiTDemoTest.this.authorityService.getContainedAuthorities(null, "GROUP_GrpA", true);
                    Assert.assertEquals((int)1, (int)auths.size());
                    auths = MultiTDemoTest.this.authorityService.getContainedAuthorities(null, "GROUP_GrpB", true);
                    Assert.assertEquals((int)0, (int)auths.size());
                    auths = MultiTDemoTest.this.authorityService.getContainedAuthorities(null, "GROUP_GrpC", true);
                    if (tenantDomain.equals(TEST_TENANT_DOMAIN2)) {
                        Assert.assertEquals((int)1, (int)auths.size());
                    } else {
                        Assert.assertEquals((int)0, (int)auths.size());
                    }
                    auths = MultiTDemoTest.this.authorityService.getContainedAuthorities(null, "GROUP_GrpD", true);
                    Assert.assertEquals((int)1, (int)auths.size());
                    Assert.assertTrue((boolean)auths.toArray()[0].equals(tenantAdminName));
                    return null;
                }
            }, (String)tenantAdminName);
        }
    }

    public void testCreateCategories() {
        logger.info((Object)"Create demo categories");
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                logger.info((Object)"Create demo categories - super tenant");
                MultiTDemoTest.this.createCategoriesImpl("");
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
        for (final String tenantDomain : tenants) {
            String tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain);
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    logger.info((Object)("Create demo categories - " + tenantDomain));
                    MultiTDemoTest.this.createCategoriesImpl(tenantDomain);
                    return null;
                }
            }, (String)tenantAdminName);
        }
    }

    private void createCategoriesImpl(String tenantDomain) {
        if (tenantDomain.equals("")) {
            Collection<ChildAssociationRef> childAssocs = this.categoryService.getRootCategories(SPACES_STORE, ContentModel.ASPECT_GEN_CLASSIFIABLE);
            for (ChildAssociationRef childAssoc : childAssocs) {
                if (!this.nodeService.getProperty(childAssoc.getChildRef(), ContentModel.PROP_NAME).equals("CatA")) continue;
                return;
            }
        }
        String query = "PATH:\"/cm:generalclassifiable/*\"";
        ResultSet resultSet = this.searchService.query(SPACES_STORE, "lucene", query);
        int cnt = resultSet.length();
        NodeRef catA = this.createCategory(SPACES_STORE, null, "CatA", "CatA-" + tenantDomain);
        this.createCategory(SPACES_STORE, catA, "SubCatA", "SubCatA-" + tenantDomain);
        NodeRef catB = this.createCategory(SPACES_STORE, null, "CatB", "CatB-" + tenantDomain);
        this.createCategory(SPACES_STORE, catB, "SubCatB", "SubCatB-" + tenantDomain);
        cnt += 2;
        if (tenantDomain.equals(TEST_TENANT_DOMAIN2)) {
            NodeRef catC = this.createCategory(SPACES_STORE, null, "CatC", "CatC-" + tenantDomain);
            this.createCategory(SPACES_STORE, catC, "SubCatC", "SubCatC-" + tenantDomain);
            ++cnt;
        }
        resultSet.close();
        resultSet = this.searchService.query(SPACES_STORE, "lucene", query);
        MultiTDemoTest.assertEquals((int)cnt, (int)resultSet.length());
        resultSet.close();
        String queryMembers = "PATH:\"/cm:generalclassifiable//cm:catA/member\"";
        resultSet = this.searchService.query(SPACES_STORE, "lucene", queryMembers);
        MultiTDemoTest.assertEquals((int)0, (int)resultSet.length());
        resultSet.close();
        NodeRef homeSpaceRef = this.getHomeSpaceFolderNode(AuthenticationUtil.getRunAsUser());
        NodeRef contentRef = this.addContent(homeSpaceRef, "tqbfjotld.txt", "The quick brown fox jumps over the lazy dog (tenant " + tenantDomain + ")", "text/plain");
        MultiTDemoTest.assertFalse((boolean)this.nodeService.hasAspect(contentRef, ContentModel.ASPECT_GEN_CLASSIFIABLE));
        List categories = (ArrayList<NodeRef>)this.nodeService.getProperty(contentRef, ContentModel.PROP_CATEGORIES);
        MultiTDemoTest.assertNull((Object)categories);
        categories = new ArrayList<NodeRef>(1);
        categories.add(catA);
        HashMap<QName, Serializable> catProps = new HashMap<QName, Serializable>();
        catProps.put(ContentModel.PROP_CATEGORIES, (Serializable)((Object)categories));
        this.nodeService.addAspect(contentRef, ContentModel.ASPECT_GEN_CLASSIFIABLE, catProps);
        MultiTDemoTest.assertTrue((boolean)this.nodeService.hasAspect(contentRef, ContentModel.ASPECT_GEN_CLASSIFIABLE));
        categories = (List)((Object)this.nodeService.getProperty(contentRef, ContentModel.PROP_CATEGORIES));
        MultiTDemoTest.assertEquals((int)1, (int)categories.size());
        queryMembers = "PATH:\"/cm:generalclassifiable//cm:CatA/member\"";
        resultSet = this.searchService.query(SPACES_STORE, "lucene", queryMembers);
        MultiTDemoTest.assertEquals((int)1, (int)resultSet.length());
        resultSet.close();
    }

    public void testCreateFolders() {
        logger.info((Object)"Create demo folders");
        ArrayList<String> users = new ArrayList<String>(3);
        users.add(TEST_USER1);
        users.add(TEST_USER2);
        users.add(TEST_USER3);
        for (final String tenantDomain : tenants) {
            for (String baseUserName : users) {
                if (baseUserName.equals(TEST_USER3) && !tenantDomain.equals(TEST_TENANT_DOMAIN2)) continue;
                final String tenantUserName = this.tenantService.getDomainUser(baseUserName, tenantDomain);
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        NodeRef homeSpaceRef = MultiTDemoTest.this.getHomeSpaceFolderNode(tenantUserName);
                        NodeRef folderRef = MultiTDemoTest.this.createFolderNode(homeSpaceRef, "myfolder1");
                        MultiTDemoTest.this.createFolderNode(folderRef, "mysubfolder1");
                        folderRef = MultiTDemoTest.this.createFolderNode(homeSpaceRef, "myfolder2");
                        MultiTDemoTest.this.createFolderNode(folderRef, "mysubfolder2");
                        if (tenantDomain.equals(TEST_TENANT_DOMAIN2)) {
                            folderRef = MultiTDemoTest.this.createFolderNode(homeSpaceRef, "myfolder3");
                            MultiTDemoTest.this.createFolderNode(folderRef, "mysubfolder3");
                        }
                        return null;
                    }
                }, (String)tenantUserName);
            }
        }
    }

    public void testCreateVersionableUserContent() {
        logger.info((Object)"Create demo content");
        ArrayList<String> users = new ArrayList<String>(3);
        users.add(TEST_USER1);
        users.add(TEST_USER2);
        users.add(TEST_USER3);
        for (final String tenantDomain : tenants) {
            for (String baseUserName : users) {
                if (baseUserName.equals(TEST_USER3) && !tenantDomain.equals(TEST_TENANT_DOMAIN2)) continue;
                final String tenantUserName = this.tenantService.getDomainUser(baseUserName, tenantDomain);
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        NodeRef homeSpaceRef = MultiTDemoTest.this.getHomeSpaceFolderNode(tenantUserName);
                        NodeRef contentRef = MultiTDemoTest.this.addContent(homeSpaceRef, tenantUserName + " quick brown fox.txt", "The quick brown fox jumps over the lazy dog (tenant " + tenantDomain + ")", "text/plain");
                        MultiTDemoTest.this.nodeService.addAspect(contentRef, ContentModel.ASPECT_VERSIONABLE, null);
                        if (tenantDomain.equals(TEST_TENANT_DOMAIN2)) {
                            contentRef = MultiTDemoTest.this.addContent(homeSpaceRef, tenantUserName + " quick brown fox ANO.txt", "The quick brown fox jumps over the lazy dog ANO (tenant " + tenantDomain + ")", "text/plain");
                            MultiTDemoTest.this.nodeService.addAspect(contentRef, ContentModel.ASPECT_VERSIONABLE, null);
                        }
                        return null;
                    }
                }, (String)tenantUserName);
            }
        }
    }

    public void testGetStores() {
        logger.info((Object)"Get tenant stores");
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                for (StoreRef storeRef : MultiTDemoTest.this.nodeService.getStores()) {
                    System.out.println("StoreRef: " + storeRef);
                }
                Assert.assertTrue((String)("System: " + MultiTDemoTest.this.nodeService.getStores().size() + ", " + (tenants.size() + 1)), (MultiTDemoTest.this.nodeService.getStores().size() >= 7 * (tenants.size() + 1) ? 1 : 0) != 0);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                Assert.assertTrue((String)("Super admin: " + MultiTDemoTest.this.nodeService.getStores().size()), (MultiTDemoTest.this.nodeService.getStores().size() >= 7 ? 1 : 0) != 0);
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
        for (final String tenantDomain : tenants) {
            String tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain);
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    Assert.assertEquals((String)("Tenant: " + tenantDomain), (int)7, (int)MultiTDemoTest.this.nodeService.getStores().size());
                    return null;
                }
            }, (String)tenantAdminName);
        }
    }

    public void testGetProperty() {
        logger.info((Object)"Test get property");
        for (final String tenantDomain : tenants) {
            String tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain);
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    NodeRef personNodeRef = MultiTDemoTest.this.createUser(MultiTDemoTest.TEST_USER4, tenantDomain, "fred " + tenantDomain);
                    NodeRef homeFolderNodeRef = (NodeRef)MultiTDemoTest.this.nodeService.getProperty(personNodeRef, ContentModel.PROP_HOMEFOLDER);
                    Assert.assertFalse((boolean)homeFolderNodeRef.toString().contains(tenantDomain));
                    Map props = MultiTDemoTest.this.nodeService.getProperties(personNodeRef);
                    Assert.assertFalse((boolean)((Serializable)props.get(ContentModel.PROP_HOMEFOLDER)).toString().contains(tenantDomain));
                    String storeId = (String)((Object)MultiTDemoTest.this.nodeService.getProperty(personNodeRef, ContentModel.PROP_STORE_IDENTIFIER));
                    Assert.assertFalse((boolean)storeId.contains(tenantDomain));
                    Assert.assertFalse((boolean)((Serializable)props.get(ContentModel.PROP_STORE_IDENTIFIER)).toString().contains(tenantDomain));
                    return null;
                }
            }, (String)tenantAdminName);
        }
    }

    public void testCOCIandSearch() {
        logger.info((Object)"Test checkout/checkin and search");
        for (String tenantDomain : tenants) {
            final String tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain);
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    String origText = "You have been invited to";
                    String query = "+PATH:\"/app:company_home/app:dictionary/app:email_templates/app:invite_email_templates/*\" +TEXT:\"" + origText + "\"";
                    ResultSet resultSet = MultiTDemoTest.this.searchService.query(SPACES_STORE, "lucene", query);
                    Assert.assertEquals((int)1, (int)resultSet.length());
                    NodeRef nodeRef = resultSet.getNodeRef(0);
                    resultSet.close();
                    NodeRef workingCopyNodeRef = MultiTDemoTest.this.cociService.checkout(nodeRef);
                    ContentWriter writer = MultiTDemoTest.this.contentService.getWriter(workingCopyNodeRef, ContentModel.PROP_CONTENT, true);
                    writer.setMimetype("text/plain");
                    writer.setEncoding("UTF-8");
                    String updateText = "Updated by " + tenantAdminName;
                    writer.putContent(updateText);
                    MultiTDemoTest.this.cociService.checkin(workingCopyNodeRef, null);
                    query = "+PATH:\"/app:company_home/app:dictionary/app:email_templates/app:invite_email_templates/*\" +TEXT:\"" + origText + "\"";
                    resultSet = MultiTDemoTest.this.searchService.query(SPACES_STORE, "lucene", query);
                    Assert.assertEquals((int)0, (int)resultSet.length());
                    resultSet.close();
                    query = "+PATH:\"/app:company_home/app:dictionary/app:email_templates/app:invite_email_templates/*\" +TEXT:\"" + updateText + "\"";
                    resultSet = MultiTDemoTest.this.searchService.query(SPACES_STORE, "lucene", query);
                    Assert.assertEquals((int)1, (int)resultSet.length());
                    resultSet.close();
                    return null;
                }
            }, (String)tenantAdminName);
        }
    }

    public void testDeleteArchiveAndRestoreContent() {
        logger.info((Object)"test delete/archive & restore content");
        for (final String tenantDomain : tenants) {
            final String tenantUserName = this.tenantService.getDomainUser(TEST_USER1, tenantDomain);
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    NodeRef homeSpaceRef = MultiTDemoTest.this.getHomeSpaceFolderNode(tenantUserName);
                    NodeRef contentRef = MultiTDemoTest.this.addContent(homeSpaceRef, tenantUserName + " tqbfjotld.txt", "The quick brown fox jumps over the lazy dog (tenant " + tenantDomain + ")", "text/plain");
                    NodeRef storeArchiveNode = MultiTDemoTest.this.nodeService.getStoreArchiveNode(contentRef.getStoreRef());
                    MultiTDemoTest.this.nodeService.deleteNode(contentRef);
                    StoreRef archiveStoreRef = storeArchiveNode.getStoreRef();
                    NodeRef archivedContentRef = new NodeRef(archiveStoreRef, contentRef.getId());
                    MultiTDemoTest.this.nodeService.restoreNode(archivedContentRef, null, null, null);
                    return null;
                }
            }, (String)tenantUserName);
        }
    }

    public void testCustomModels() {
        logger.info((Object)"test custom models");
        final int defaultModelCnt = this.dictionaryService.getAllModels().size();
        for (String tenantDomain : tenants) {
            String tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain);
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    Assert.assertEquals((int)0, (int)MultiTDemoTest.this.repoAdminService.getModels().size());
                    Assert.assertEquals((int)defaultModelCnt, (int)MultiTDemoTest.this.dictionaryService.getAllModels().size());
                    Assert.assertNull((Object)MultiTDemoTest.this.dictionaryService.getClass(QName.createQName((String)"{my.new.model}sop")));
                    InputStream modelStream = this.getClass().getClassLoader().getResourceAsStream("tenant/exampleModel.xml");
                    MultiTDemoTest.this.repoAdminService.deployModel(modelStream, "exampleModel.xml");
                    Assert.assertEquals((int)1, (int)MultiTDemoTest.this.repoAdminService.getModels().size());
                    Assert.assertEquals((int)(defaultModelCnt + 1), (int)MultiTDemoTest.this.dictionaryService.getAllModels().size());
                    ClassDefinition myType = MultiTDemoTest.this.dictionaryService.getClass(QName.createQName((String)"{my.new.model}sop"));
                    Assert.assertNotNull((Object)myType);
                    Assert.assertEquals((Object)QName.createQName((String)"{my.new.model}mynewmodel"), (Object)myType.getModel().getName());
                    MultiTDemoTest.this.repoAdminService.deactivateModel("exampleModel.xml");
                    Assert.assertEquals((int)1, (int)MultiTDemoTest.this.repoAdminService.getModels().size());
                    Assert.assertEquals((int)defaultModelCnt, (int)MultiTDemoTest.this.dictionaryService.getAllModels().size());
                    Assert.assertNull((Object)MultiTDemoTest.this.dictionaryService.getClass(QName.createQName((String)"{my.new.model}sop")));
                    MultiTDemoTest.this.repoAdminService.activateModel("exampleModel.xml");
                    Assert.assertEquals((int)1, (int)MultiTDemoTest.this.repoAdminService.getModels().size());
                    Assert.assertEquals((int)(defaultModelCnt + 1), (int)MultiTDemoTest.this.dictionaryService.getAllModels().size());
                    myType = MultiTDemoTest.this.dictionaryService.getClass(QName.createQName((String)"{my.new.model}sop"));
                    Assert.assertNotNull((Object)myType);
                    Assert.assertEquals((Object)QName.createQName((String)"{my.new.model}mynewmodel"), (Object)myType.getModel().getName());
                    return null;
                }
            }, (String)tenantAdminName);
        }
    }

    public void testAddCustomWebClient() {
        logger.info((Object)"test add custom web client config");
        for (String tenantDomain : tenants) {
            String tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain);
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    NodeRef webClientExtFolder = MultiTDemoTest.this.getWebClientExtensionNodeRef(SPACES_STORE);
                    InputStream is = this.getClass().getClassLoader().getResourceAsStream("tenant/webclient.properties");
                    MultiTDemoTest.this.addContent(webClientExtFolder, "webclient.properties", is, "text/plain");
                    is = this.getClass().getClassLoader().getResourceAsStream("tenant/web-client-config-custom.xml");
                    MultiTDemoTest.this.addContent(webClientExtFolder, "web-client-config-custom.xml", is, "text/xml");
                    return null;
                }
            }, (String)tenantAdminName);
        }
    }

    private void createGroup(String shortName, String parentShortName) {
        String groupName = this.authorityService.getName(AuthorityType.GROUP, shortName);
        if (!this.authorityService.authorityExists(groupName)) {
            String parentGroupName = null;
            if (parentShortName != null && !this.authorityService.authorityExists(parentGroupName = this.authorityService.getName(AuthorityType.GROUP, parentShortName))) {
                logger.warn((Object)("Parent group does not exist: " + parentShortName));
                return;
            }
            this.authorityService.createAuthority(AuthorityType.GROUP, shortName);
            if (parentGroupName != null) {
                this.addToGroup(parentShortName, groupName);
            }
        } else {
            logger.warn((Object)("Group already exists: " + shortName));
        }
    }

    private void addToGroup(String parentGroupShortName, String authorityName) {
        String parentGroupName = this.authorityService.getName(AuthorityType.GROUP, parentGroupShortName);
        this.authorityService.addAuthority(parentGroupName, authorityName);
    }

    private NodeRef createUser(String baseUserName, String tenantDomain, String password) {
        String userName = this.tenantService.getDomainUser(baseUserName, tenantDomain);
        NodeRef personNodeRef = null;
        if (!this.authenticationService.authenticationExists(userName)) {
            NodeRef baseHomeFolder = this.getUserHomesNodeRef(SPACES_STORE);
            NodeRef homeFolder = this.createHomeSpaceFolderNode(baseHomeFolder, baseUserName, userName);
            this.authenticationService.createAuthentication(userName, password.toCharArray());
            HashMap<QName, Serializable> personProperties = new HashMap<QName, Serializable>();
            personProperties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
            personProperties.put(ContentModel.PROP_HOMEFOLDER, (Serializable)homeFolder);
            personProperties.put(ContentModel.PROP_FIRSTNAME, (Serializable)((Object)baseUserName));
            personProperties.put(ContentModel.PROP_LASTNAME, (Serializable)((Object)(baseUserName + "-" + tenantDomain)));
            personProperties.put(ContentModel.PROP_EMAIL, (Serializable)((Object)userName));
            personNodeRef = this.personService.createPerson(personProperties);
            this.permissionService.setPermission(personNodeRef, userName, this.permissionService.getAllPermission(), true);
            NodeRef checkHomeSpaceRef = (NodeRef)this.nodeService.getProperty(personNodeRef, ContentModel.PROP_HOMEFOLDER);
            MultiTDemoTest.assertNotNull((Object)checkHomeSpaceRef);
            logger.info((Object)("Created user " + userName));
        } else {
            personNodeRef = this.personService.getPerson(userName);
            logger.info((Object)("Found existing user " + userName));
        }
        return personNodeRef;
    }

    private void loginLogoutUser(String username, String password) {
        this.authenticationService.authenticate(username, password.toCharArray());
        username = this.authenticationService.getCurrentUserName();
        NodeRef personRef = this.personService.getPerson(username);
        NodeRef homeSpaceRef = (NodeRef)this.nodeService.getProperty(personRef, ContentModel.PROP_HOMEFOLDER);
        if (!this.nodeService.exists(homeSpaceRef)) {
            throw new InvalidNodeRefException(homeSpaceRef);
        }
        this.authenticationService.clearCurrentSecurityContext();
    }

    private NodeRef getUserHomesNodeRef(StoreRef storeRef) {
        return this.findFolderNodeRef(storeRef, "/app:company_home/app:user_homes");
    }

    private NodeRef getWebClientExtensionNodeRef(StoreRef storeRef) {
        return this.findFolderNodeRef(storeRef, "/app:company_home/app:dictionary/app:webclient_extension");
    }

    private NodeRef findFolderNodeRef(StoreRef storeRef, String folderXPath) {
        ResultSet rs = this.searchService.query(storeRef, "xpath", folderXPath);
        NodeRef folderNodeRef = null;
        if (rs.length() != 1) {
            throw new AlfrescoRuntimeException("Cannot find folder location: " + folderXPath);
        }
        folderNodeRef = rs.getNodeRef(0);
        rs.close();
        return folderNodeRef;
    }

    private NodeRef createFolderNode(NodeRef parentFolderNodeRef, String nameValue) {
        if (nameValue != null) {
            HashMap<QName, String> folderProps = new HashMap<QName, String>();
            folderProps.put(ContentModel.PROP_NAME, nameValue);
            return this.nodeService.createNode(parentFolderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)nameValue), ContentModel.TYPE_FOLDER, folderProps).getChildRef();
        }
        return null;
    }

    private NodeRef createCategory(StoreRef storeRef, NodeRef parentCategoryRef, String name, String description) {
        NodeRef ref = parentCategoryRef == null ? this.categoryService.createRootCategory(storeRef, ContentModel.ASPECT_GEN_CLASSIFIABLE, name) : this.categoryService.createCategory(parentCategoryRef, name);
        HashMap<QName, String> titledProps = new HashMap<QName, String>(1, 1.0f);
        titledProps.put(ContentModel.PROP_DESCRIPTION, description);
        this.nodeService.addAspect(ref, ContentModel.ASPECT_TITLED, titledProps);
        return ref;
    }

    private NodeRef createHomeSpaceFolderNode(NodeRef folderNodeRef, String spaceName, String userName) {
        if (spaceName != null) {
            HashMap<QName, String> folderProps = new HashMap<QName, String>();
            folderProps.put(ContentModel.PROP_NAME, spaceName);
            NodeRef nodeRef = this.nodeService.createNode(folderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)spaceName), ContentModel.TYPE_FOLDER, folderProps).getChildRef();
            HashMap<QName, String> uiFacetsProps = new HashMap<QName, String>(3);
            uiFacetsProps.put(ApplicationModel.PROP_ICON, "space-icon-default");
            uiFacetsProps.put(ContentModel.PROP_TITLE, spaceName);
            this.nodeService.addAspect(nodeRef, ApplicationModel.ASPECT_UIFACETS, uiFacetsProps);
            this.setupHomeSpacePermissions(nodeRef, userName);
            return nodeRef;
        }
        return null;
    }

    private void setupHomeSpacePermissions(NodeRef homeSpaceRef, String userName) {
        this.permissionService.setPermission(homeSpaceRef, userName, this.permissionService.getAllPermission(), true);
        String permission = "Consumer";
        if (permission != null && permission.length() != 0) {
            this.permissionService.setPermission(homeSpaceRef, this.permissionService.getAllAuthorities(), permission, true);
        }
        this.ownableService.setOwner(homeSpaceRef, userName);
        this.permissionService.setPermission(homeSpaceRef, this.permissionService.getOwnerAuthority(), this.permissionService.getAllPermission(), true);
        this.permissionService.setInheritParentPermissions(homeSpaceRef, false);
    }

    private NodeRef getHomeSpaceFolderNode(String userName) {
        return (NodeRef)this.nodeService.getProperty(this.personService.getPerson(userName), ContentModel.PROP_HOMEFOLDER);
    }

    private NodeRef addContent(NodeRef spaceRef, String name, String textData, String mimeType) {
        HashMap<QName, String> contentProps = new HashMap<QName, String>();
        contentProps.put(ContentModel.PROP_NAME, name);
        ChildAssociationRef association = this.nodeService.createNode(spaceRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), ContentModel.TYPE_CONTENT, contentProps);
        NodeRef content = association.getChildRef();
        HashMap<QName, String> titledProps = new HashMap<QName, String>();
        titledProps.put(ContentModel.PROP_TITLE, name);
        titledProps.put(ContentModel.PROP_DESCRIPTION, name);
        this.nodeService.addAspect(content, ContentModel.ASPECT_TITLED, titledProps);
        ContentWriter writer = this.contentService.getWriter(content, ContentModel.PROP_CONTENT, true);
        writer.setMimetype(mimeType);
        writer.setEncoding("UTF-8");
        writer.putContent(textData);
        return content;
    }

    private NodeRef addContent(NodeRef spaceRef, String name, InputStream is, String mimeType) {
        HashMap<QName, String> contentProps = new HashMap<QName, String>();
        contentProps.put(ContentModel.PROP_NAME, name);
        ChildAssociationRef association = this.nodeService.createNode(spaceRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), ContentModel.TYPE_CONTENT, contentProps);
        NodeRef content = association.getChildRef();
        HashMap<QName, String> titledProps = new HashMap<QName, String>();
        titledProps.put(ContentModel.PROP_TITLE, name);
        titledProps.put(ContentModel.PROP_DESCRIPTION, name);
        this.nodeService.addAspect(content, ContentModel.ASPECT_TITLED, titledProps);
        ContentWriter writer = this.contentService.getWriter(content, ContentModel.PROP_CONTENT, true);
        writer.setMimetype(mimeType);
        writer.setEncoding("UTF-8");
        writer.putContent(is);
        return content;
    }

    static {
        for (int i = 1; i <= NUM_TENANTS; ++i) {
            tenants.add(TEST_TENANT_DOMAIN + i);
        }
        SPACES_STORE = new StoreRef("workspace", "SpacesStore");
    }
}

