/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import java.io.Serializable;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.transaction.UserTransaction;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.error.ExceptionStackUtil;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TooBusyException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.Pair;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLInnoDBDialect;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryingTransactionHelperTest
extends TestCase {
    private static Log logger = LogFactory.getLog((String)"org.alfresco.repo.transaction.RetryingTransactionHelperTest");
    private static final QName PROP_CHECK_VALUE = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"check_value");
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private ServiceRegistry serviceRegistry;
    private AuthenticationComponent authenticationComponent;
    private TransactionService transactionService;
    private NodeService nodeService;
    private RetryingTransactionHelper txnHelper;
    private Dialect dialect;
    private NodeRef rootNodeRef;
    private NodeRef workingNodeRef;

    public void setUp() throws Exception {
        this.dialect = (Dialect)ctx.getBean("dialect");
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.transactionService = this.serviceRegistry.getTransactionService();
        this.nodeService = this.serviceRegistry.getNodeService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        StoreRef storeRef = this.nodeService.createStore("workspace", "test-" + this.getName() + "-" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        this.workingNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)this.getName()), ContentModel.TYPE_CMOBJECT).getChildRef();
    }

    public void tearDown() throws Exception {
        try {
            this.authenticationComponent.clearCurrentSecurityContext();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void testSetUp() throws Exception {
        RetryingTransactionHelperTest.assertNotNull((Object)this.rootNodeRef);
        RetryingTransactionHelperTest.assertNotNull((Object)this.workingNodeRef);
    }

    private Long getCheckValue() {
        Long checkValue = (Long)this.nodeService.getProperty(this.workingNodeRef, PROP_CHECK_VALUE);
        if (checkValue == null) {
            checkValue = new Long(0L);
            this.nodeService.setProperty(this.workingNodeRef, PROP_CHECK_VALUE, (Serializable)checkValue);
        }
        return checkValue;
    }

    private Long incrementCheckValue() {
        Long checkValue = this.getCheckValue();
        checkValue = new Long(checkValue + 1L);
        this.nodeService.setProperty(this.workingNodeRef, PROP_CHECK_VALUE, (Serializable)checkValue);
        return checkValue;
    }

    private Long blowUp() {
        NodeRef invalidNodeRef = new NodeRef(this.workingNodeRef.getStoreRef(), "BOGUS");
        this.nodeService.setProperty(invalidNodeRef, PROP_CHECK_VALUE, null);
        RetryingTransactionHelperTest.fail((String)"Expected to generate an InvalidNodeRefException");
        return null;
    }

    public void testSuccessNoRetry() {
        long beforeValue = this.getCheckValue();
        RetryingTransactionHelper.RetryingTransactionCallback<Long> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            @Override
            public Long execute() throws Throwable {
                return RetryingTransactionHelperTest.this.incrementCheckValue();
            }
        };
        long txnValue = this.txnHelper.doInTransaction(callback);
        long afterValue = this.getCheckValue();
        RetryingTransactionHelperTest.assertEquals((String)"The value must have increased", (long)(beforeValue + 1L), (long)afterValue);
        RetryingTransactionHelperTest.assertEquals((String)"The txn value must be the same as the value after", (long)afterValue, (long)txnValue);
    }

    public void testUserTransactionStatus() {
        UserTransaction txnBefore = RetryingTransactionHelper.getActiveUserTransaction();
        RetryingTransactionHelperTest.assertNull((String)"Did not expect to get an active UserTransaction", (Object)txnBefore);
        RetryingTransactionHelper.RetryingTransactionCallback<Long> callbackOuter = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            @Override
            public Long execute() throws Throwable {
                UserTransaction txnOuter = RetryingTransactionHelper.getActiveUserTransaction();
                Assert.assertNotNull((String)"Expected an active UserTransaction", (Object)txnOuter);
                Assert.assertEquals((String)"Should be read-write txn", (Object)((Object)AlfrescoTransactionSupport.TxnReadState.TXN_READ_WRITE), (Object)((Object)AlfrescoTransactionSupport.getTransactionReadState()));
                Assert.assertEquals((String)"Expected state is active", (int)0, (int)txnOuter.getStatus());
                RetryingTransactionHelper.RetryingTransactionCallback<Long> callbackInner = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                    @Override
                    public Long execute() throws Throwable {
                        UserTransaction txnInner = RetryingTransactionHelper.getActiveUserTransaction();
                        Assert.assertNotNull((String)"Expected an active UserTransaction", (Object)txnInner);
                        Assert.assertEquals((String)"Should be read-only txn", (Object)((Object)AlfrescoTransactionSupport.TxnReadState.TXN_READ_ONLY), (Object)((Object)AlfrescoTransactionSupport.getTransactionReadState()));
                        Assert.assertEquals((String)"Expected state is active", (int)0, (int)txnInner.getStatus());
                        try {
                            txnInner.commit();
                            Assert.fail((String)"Should not be able to commit the UserTransaction.  It is for info only.");
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        txnInner.setRollbackOnly();
                        return null;
                    }
                };
                return RetryingTransactionHelperTest.this.txnHelper.doInTransaction(callbackInner, true, true);
            }
        };
        this.txnHelper.doInTransaction(callbackOuter);
        UserTransaction txnAfter = RetryingTransactionHelper.getActiveUserTransaction();
        RetryingTransactionHelperTest.assertNull((String)"Did not expect to get an active UserTransaction", (Object)txnAfter);
    }

    public void testSuccessWithRetry() {
        RetryingTransactionHelper.RetryingTransactionCallback<Long> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){
            private int maxCalls = 3;
            private int callCount = 0;

            @Override
            public Long execute() throws Throwable {
                ++this.callCount;
                Long checkValue = RetryingTransactionHelperTest.this.incrementCheckValue();
                if (this.callCount == this.maxCalls) {
                    return checkValue;
                }
                throw new ConcurrencyFailureException("Testing");
            }
        };
        long txnValue = this.txnHelper.doInTransaction(callback);
        RetryingTransactionHelperTest.assertEquals((String)"Only one increment expected", (long)1L, (long)txnValue);
    }

    public void testNonRetryingFailure() {
        RetryingTransactionHelper.RetryingTransactionCallback<Long> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            @Override
            public Long execute() throws Throwable {
                RetryingTransactionHelperTest.this.incrementCheckValue();
                return RetryingTransactionHelperTest.this.blowUp();
            }
        };
        try {
            this.txnHelper.doInTransaction(callback);
            RetryingTransactionHelperTest.fail((String)"Wrapper didn't generate an exception");
        }
        catch (InvalidNodeRefException e) {
        }
        catch (Throwable e) {
            RetryingTransactionHelperTest.fail((String)("Incorrect exception from wrapper: " + e));
        }
        long checkValue = this.getCheckValue();
        RetryingTransactionHelperTest.assertEquals((String)"Check value should not have changed", (long)0L, (long)checkValue);
    }

    public void testNonRetryingSilentRollback() {
        RetryingTransactionHelper.RetryingTransactionCallback<Long> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            @Override
            public Long execute() throws Throwable {
                RetryingTransactionHelperTest.this.incrementCheckValue();
                try {
                    return RetryingTransactionHelperTest.this.blowUp();
                }
                catch (InvalidNodeRefException invalidNodeRefException) {
                    return null;
                }
            }
        };
        this.txnHelper.doInTransaction(callback);
        long checkValue = this.getCheckValue();
        RetryingTransactionHelperTest.assertEquals((String)"Check value should not have changed", (long)0L, (long)checkValue);
    }

    public void testNestedWithPropogation() {
        RetryingTransactionHelper.RetryingTransactionCallback<Long> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            @Override
            public Long execute() throws Throwable {
                RetryingTransactionHelper.RetryingTransactionCallback<Long> callbackInner = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                    @Override
                    public Long execute() throws Throwable {
                        RetryingTransactionHelperTest.this.incrementCheckValue();
                        RetryingTransactionHelperTest.this.incrementCheckValue();
                        return RetryingTransactionHelperTest.this.getCheckValue();
                    }
                };
                RetryingTransactionHelperTest.this.txnHelper.doInTransaction(callbackInner, false, false);
                RetryingTransactionHelperTest.this.incrementCheckValue();
                RetryingTransactionHelperTest.this.incrementCheckValue();
                return RetryingTransactionHelperTest.this.getCheckValue();
            }
        };
        long checkValue = this.txnHelper.doInTransaction(callback);
        RetryingTransactionHelperTest.assertEquals((String)"Nesting requiresNew==false didn't work", (long)4L, (long)checkValue);
    }

    public void testNestedWithoutPropogation() {
        RetryingTransactionHelper.RetryingTransactionCallback<Long> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            @Override
            public Long execute() throws Throwable {
                RetryingTransactionHelper.RetryingTransactionCallback<Long> callbackInner = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                    @Override
                    public Long execute() throws Throwable {
                        RetryingTransactionHelperTest.this.incrementCheckValue();
                        RetryingTransactionHelperTest.this.incrementCheckValue();
                        return RetryingTransactionHelperTest.this.getCheckValue();
                    }
                };
                RetryingTransactionHelperTest.this.txnHelper.doInTransaction(callbackInner, false, true);
                RetryingTransactionHelperTest.this.incrementCheckValue();
                RetryingTransactionHelperTest.this.incrementCheckValue();
                return RetryingTransactionHelperTest.this.getCheckValue();
            }
        };
        long checkValue = this.txnHelper.doInTransaction(callback);
        RetryingTransactionHelperTest.assertEquals((String)"Nesting requiresNew==true didn't work", (long)4L, (long)checkValue);
    }

    public void testNestedWithoutPropogationConcurrentUntilFailureMySQL() throws InterruptedException {
        final RetryingTransactionHelper txnHelperForTest = this.transactionService.getRetryingTransactionHelper();
        txnHelperForTest.setMaxRetries(1);
        if (!(this.dialect instanceof MySQLInnoDBDialect)) {
            logger.warn((Object)("NOTE: Skipping testNestedWithoutPropogationConcurrentUntilFailureMySQLOnly for dialect: " + this.dialect));
        } else {
            RetryingTransactionHelper.RetryingTransactionCallback<Long> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                @Override
                public Long execute() throws Throwable {
                    RetryingTransactionHelper.RetryingTransactionCallback<Long> callbackInner = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                        @Override
                        public Long execute() throws Throwable {
                            RetryingTransactionHelperTest.this.incrementCheckValue();
                            return RetryingTransactionHelperTest.this.getCheckValue();
                        }
                    };
                    RetryingTransactionHelperTest.this.incrementCheckValue();
                    txnHelperForTest.doInTransaction(callbackInner, false, true);
                    return RetryingTransactionHelperTest.this.getCheckValue();
                }
            };
            try {
                txnHelperForTest.doInTransaction(callback);
                RetryingTransactionHelperTest.fail((String)"Concurrent nested access not leading to failure");
            }
            catch (Throwable e) {
                Throwable validCause = ExceptionStackUtil.getCause((Throwable)e, (Class[])RetryingTransactionHelper.RETRY_EXCEPTIONS);
                RetryingTransactionHelperTest.assertNotNull((String)"Unexpected cause of the failure", (Object)validCause);
            }
        }
    }

    public void testConcurrencyRetryingNoFailure() throws InterruptedException {
        Thread t1 = new Thread(new ConcurrentTransaction(5000L));
        t1.start();
        Thread.sleep(1000L);
        Thread t2 = new Thread(new ConcurrentTransaction(10L));
        t2.start();
        t1.join();
        t2.join();
    }

    public void testLostConnectionRecovery() {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> killConnectionCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){
            private boolean killed = false;

            @Override
            public Object execute() throws Throwable {
                RetryingTransactionHelperTest.this.nodeService.deleteNode(RetryingTransactionHelperTest.this.workingNodeRef);
                if (this.killed) {
                    return null;
                }
                HibernateConnectionKiller killer = new HibernateConnectionKiller();
                killer.setSessionFactory((SessionFactory)ctx.getBean("sessionFactory"));
                killer.killConnection();
                this.killed = true;
                return null;
            }
        };
        this.txnHelper.doInTransaction(killConnectionCallback);
    }

    public void testZeroAndNegativeRetries() {
        final MutableInt callCount = new MutableInt(0);
        RetryingTransactionHelper.RetryingTransactionCallback<Long> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            @Override
            public Long execute() throws Throwable {
                callCount.setValue(callCount.intValue() + 1);
                throw new ConcurrentModificationException();
            }
        };
        callCount.setValue(0);
        this.txnHelper.setMaxRetries(0);
        try {
            this.txnHelper.doInTransaction(callback);
        }
        catch (ConcurrentModificationException e) {
            // empty catch block
        }
        RetryingTransactionHelperTest.assertEquals((String)"Should have been called exactly once", (int)1, (int)callCount.intValue());
        callCount.setValue(0);
        this.txnHelper.setMaxRetries(-1);
        try {
            this.txnHelper.doInTransaction(callback);
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        RetryingTransactionHelperTest.assertEquals((String)"Should have been called exactly once", (int)1, (int)callCount.intValue());
    }

    public void testTimeLimit() {
        RetryingTransactionHelper txnHelper = new RetryingTransactionHelper();
        txnHelper.setTransactionService(this.transactionService);
        txnHelper.setMaxExecutionMs(3000L);
        List<Throwable> caughtExceptions = Collections.synchronizedList(new LinkedList());
        this.runThreads(txnHelper, caughtExceptions, new Pair((Object)0, (Object)1000), new Pair((Object)0, (Object)5000), new Pair((Object)4000, (Object)1000));
        RetryingTransactionHelperTest.assertEquals((String)"Expected 1 exception", (int)1, (int)caughtExceptions.size());
        RetryingTransactionHelperTest.assertTrue((String)"Excpected TooBusyException", (boolean)(caughtExceptions.get(0) instanceof TooBusyException));
        caughtExceptions.clear();
        this.runThreads(txnHelper, caughtExceptions, new Pair((Object)0, (Object)1000), new Pair((Object)0, (Object)2000), new Pair((Object)0, (Object)1000), new Pair((Object)1000, (Object)1000), new Pair((Object)1000, (Object)2000), new Pair((Object)2000, (Object)1000));
        if (caughtExceptions.size() > 0) {
            throw new RuntimeException("Unexpected exception", caughtExceptions.get(0));
        }
    }

    private void runThreads(final RetryingTransactionHelper txnHelper, final List<Throwable> caughtExceptions, Pair<Integer, Integer> ... startDurationPairs) {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(10, 10, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        long startTime = System.currentTimeMillis();
        long currentStart = 0L;
        for (Pair<Integer, Integer> pair : startDurationPairs) {
            long now;
            int start = (Integer)pair.getFirst();
            long then = startTime + (long)start;
            if (then > (now = System.currentTimeMillis())) {
                try {
                    Thread.sleep(then - now);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                currentStart = start;
            }
            CountDownLatch startLatch = new CountDownLatch(1);
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Work
            implements Runnable {
                private final CountDownLatch startLatch;
                private final long endTime;

                public Work(CountDownLatch startLatch, long endTime) {
                    this.startLatch = startLatch;
                    this.endTime = endTime;
                }

                @Override
                public void run() {
                    block2: {
                        try {
                            txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                                @Override
                                public Void execute() throws Throwable {
                                    startLatch.countDown();
                                    long duration = endTime - System.currentTimeMillis();
                                    if (duration > 0L) {
                                        Thread.sleep(duration);
                                    }
                                    return null;
                                }
                            });
                        }
                        catch (Throwable e) {
                            caughtExceptions.add(e);
                            if (this.startLatch.getCount() <= 0L) break block2;
                            this.startLatch.countDown();
                        }
                    }
                }
            }
            Work work = new Work(startLatch, startTime + currentStart + (long)((Integer)pair.getSecond()).intValue());
            executorService.execute(work);
            try {
                startLatch.await(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    private class HibernateConnectionKiller
    extends HibernateDaoSupport {
        private HibernateConnectionKiller() {
        }

        private void killConnection() throws Exception {
            this.getSession().connection().rollback();
        }
    }

    private class ConcurrentTransaction
    implements Runnable {
        private long wait;

        public ConcurrentTransaction(long wait) {
            this.wait = wait;
        }

        public void run() {
            AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
            RetryingTransactionHelper txnHelperForTest = RetryingTransactionHelperTest.this.transactionService.getRetryingTransactionHelper();
            RetryingTransactionHelper.RetryingTransactionCallback<Long> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                @Override
                public Long execute() throws Throwable {
                    RetryingTransactionHelperTest.this.incrementCheckValue();
                    System.out.println("Wait started: " + Thread.currentThread() + " (" + ConcurrentTransaction.this.wait + ")");
                    Thread.sleep(ConcurrentTransaction.this.wait);
                    System.out.println("Wait finished: " + Thread.currentThread() + " (" + ConcurrentTransaction.this.wait + ")");
                    return RetryingTransactionHelperTest.this.getCheckValue();
                }
            };
            try {
                System.out.println("Txn start: " + Thread.currentThread() + " (" + this.wait + ")");
                txnHelperForTest.doInTransaction(callback);
                System.out.println("Txn finish: " + Thread.currentThread() + " (" + this.wait + ")");
            }
            catch (Throwable e) {
                Throwable validCause = ExceptionStackUtil.getCause((Throwable)e, (Class[])RetryingTransactionHelper.RETRY_EXCEPTIONS);
                Assert.assertNotNull((String)"Unexpected cause of the failure", (Object)validCause);
            }
        }
    }
}

