/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.transaction.TransactionService;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class RetryingTransactionInterceptor
extends TransactionAspectSupport
implements MethodInterceptor {
    private TransactionService transactionService;

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public Object invoke(final MethodInvocation target) throws Throwable {
        if (null != target && null != target.getThis() && null != target.getMethod()) {
            final Method method = target.getMethod();
            TransactionAttribute transactionAttribute = this.getTransactionAttributeSource().getTransactionAttribute(method, target.getThis().getClass());
            if (null != transactionAttribute) {
                return this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    @Override
                    public Object execute() throws Throwable {
                        try {
                            return method.invoke(target.getThis(), target.getArguments());
                        }
                        catch (InvocationTargetException e) {
                            if (null != e.getTargetException()) {
                                throw e.getTargetException();
                            }
                            throw new AlfrescoRuntimeException(e.getMessage(), (Throwable)e);
                        }
                    }
                }, transactionAttribute.isReadOnly(), 3 == transactionAttribute.getPropagationBehavior());
            }
            return method.invoke(target.getThis(), target.getArguments());
        }
        throw new AlfrescoRuntimeException("Invalid undefined MethodInvocation instance");
    }
}

