/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import javax.transaction.UserTransaction;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.VmShutdownListener;
import org.alfresco.util.transaction.SpringAwareUserTransaction;
import org.springframework.transaction.PlatformTransactionManager;

public class TransactionServiceImpl
implements TransactionService {
    private static VmShutdownListener shutdownListener = new VmShutdownListener("TransactionService");
    private PlatformTransactionManager transactionManager;
    private AuthenticationContext authenticationContext;
    private int maxRetries = -1;
    private int minRetryWaitMs = -1;
    private int maxRetryWaitMs = -1;
    private int retryWaitIncrementMs = -1;
    private SysAdminParams sysAdminParams;
    private boolean allowWrite;

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public void setAllowWrite(boolean allowWrite) {
        this.allowWrite = allowWrite;
    }

    public boolean isReadOnly() {
        if (shutdownListener.isVmShuttingDown()) {
            return true;
        }
        return !this.allowWrite || !this.authenticationContext.isCurrentUserTheSystemUser() && !this.sysAdminParams.getAllowWrite();
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setMinRetryWaitMs(int minRetryWaitMs) {
        this.minRetryWaitMs = minRetryWaitMs;
    }

    public void setMaxRetryWaitMs(int maxRetryWaitMs) {
        this.maxRetryWaitMs = maxRetryWaitMs;
    }

    public void setRetryWaitIncrementMs(int retryWaitIncrementMs) {
        this.retryWaitIncrementMs = retryWaitIncrementMs;
    }

    public UserTransaction getUserTransaction() {
        SpringAwareUserTransaction txn = new SpringAwareUserTransaction(this.transactionManager, this.isReadOnly(), -1, 0, -1);
        return txn;
    }

    public UserTransaction getUserTransaction(boolean readOnly) {
        SpringAwareUserTransaction txn = new SpringAwareUserTransaction(this.transactionManager, readOnly | this.isReadOnly(), -1, 0, -1);
        return txn;
    }

    public UserTransaction getNonPropagatingUserTransaction() {
        SpringAwareUserTransaction txn = new SpringAwareUserTransaction(this.transactionManager, this.isReadOnly(), -1, 3, -1);
        return txn;
    }

    public UserTransaction getNonPropagatingUserTransaction(boolean readOnly) {
        SpringAwareUserTransaction txn = new SpringAwareUserTransaction(this.transactionManager, readOnly | this.isReadOnly(), -1, 3, -1);
        return txn;
    }

    public RetryingTransactionHelper getRetryingTransactionHelper() {
        RetryingTransactionHelper helper = new RetryingTransactionHelper();
        helper.setTransactionService(this);
        helper.setReadOnly(this.isReadOnly());
        if (this.maxRetries >= 0) {
            helper.setMaxRetries(this.maxRetries);
        }
        if (this.minRetryWaitMs > 0) {
            helper.setMinRetryWaitMs(this.minRetryWaitMs);
        }
        if (this.maxRetryWaitMs > 0) {
            helper.setMaxRetryWaitMs(this.maxRetryWaitMs);
        }
        if (this.retryWaitIncrementMs > 0) {
            helper.setRetryWaitIncrementMs(this.retryWaitIncrementMs);
        }
        return helper;
    }
}

