/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transfer.Transfer;
import org.alfresco.repo.transfer.TransferCommons;
import org.alfresco.repo.transfer.TransferTransmitter;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferProgress;
import org.alfresco.service.cmr.transfer.TransferReceiver;
import org.alfresco.service.cmr.transfer.TransferTarget;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitTestInProcessTransmitterImpl
implements TransferTransmitter {
    private static final Log log = LogFactory.getLog(UnitTestInProcessTransmitterImpl.class);
    private TransferReceiver receiver;
    private ContentService contentService;
    private TransactionService transactionService;

    public UnitTestInProcessTransmitterImpl(TransferReceiver receiver, ContentService contentService, TransactionService transactionService) {
        this.receiver = receiver;
        this.contentService = contentService;
        this.transactionService = transactionService;
    }

    @Override
    public Transfer begin(final TransferTarget target) throws TransferException {
        return this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Transfer>(){

            @Override
            public Transfer execute() throws Throwable {
                Transfer transfer = new Transfer();
                String transferId = UnitTestInProcessTransmitterImpl.this.receiver.start();
                transfer.setTransferId(transferId);
                transfer.setTransferTarget(target);
                return transfer;
            }
        }, false, true);
    }

    @Override
    public void abort(final Transfer transfer) throws TransferException {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Transfer>(){

            @Override
            public Transfer execute() throws Throwable {
                String transferId = transfer.getTransferId();
                UnitTestInProcessTransmitterImpl.this.receiver.cancel(transferId);
                return null;
            }
        }, false, true);
    }

    @Override
    public void commit(final Transfer transfer) throws TransferException {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Transfer>(){

            @Override
            public Transfer execute() throws Throwable {
                String transferId = transfer.getTransferId();
                UnitTestInProcessTransmitterImpl.this.receiver.commit(transferId);
                return null;
            }
        }, false, true);
    }

    @Override
    public void prepare(Transfer transfer) throws TransferException {
        String transferId = transfer.getTransferId();
        this.receiver.prepare(transferId);
    }

    @Override
    public void sendContent(Transfer transfer, Set<ContentData> data) {
        String transferId = transfer.getTransferId();
        for (ContentData content : data) {
            String contentUrl = content.getContentUrl();
            String fileName = TransferCommons.URLToPartName(contentUrl);
            InputStream contentStream = this.getContentService().getRawReader(contentUrl).getContentInputStream();
            this.receiver.saveContent(transferId, fileName, contentStream);
        }
    }

    @Override
    public void sendManifest(Transfer transfer, File manifest, OutputStream result) throws TransferException {
        try {
            String transferId = transfer.getTransferId();
            FileInputStream fs = new FileInputStream(manifest);
            this.receiver.saveSnapshot(transferId, fs);
            try {
                this.receiver.generateRequsite(transferId, result);
                result.close();
                return;
            }
            catch (IOException ie) {
                log.error((Object)"Error in unit test code: should not get this", (Throwable)ie);
                return;
            }
        }
        catch (FileNotFoundException error) {
            throw new TransferException("test error", error);
        }
    }

    @Override
    public void verifyTarget(TransferTarget target) throws TransferException {
    }

    @Override
    public TransferProgress getStatus(Transfer transfer) throws TransferException {
        String transferId = transfer.getTransferId();
        return this.receiver.getStatus(transferId);
    }

    public void setReceiver(TransferReceiver receiver) {
        this.receiver = receiver;
    }

    public TransferReceiver getReceiver() {
        return this.receiver;
    }

    private ContentService getContentService() {
        return this.contentService;
    }

    @Override
    public void getTransferReport(Transfer transfer, OutputStream results) {
        String transferId = transfer.getTransferId();
        InputStream is = this.receiver.getTransferReport(transferId);
        try {
            BufferedInputStream br = new BufferedInputStream(is);
            byte[] buffer = new byte[1000];
            int i = br.read(buffer);
            while (i > 0) {
                results.write(buffer, 0, i);
                i = br.read(buffer);
            }
            results.flush();
            results.close();
        }
        catch (IOException ie) {
            log.error((Object)"Error in unit test code: should not get this", (Throwable)ie);
            return;
        }
    }
}

