/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer.report;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.transfer.report.XMLTransferEventFormatter;
import org.alfresco.service.cmr.transfer.TransferEvent;
import org.alfresco.service.cmr.transfer.TransferEventBegin;
import org.alfresco.service.cmr.transfer.TransferEventCancelled;
import org.alfresco.service.cmr.transfer.TransferEventCommittingStatus;
import org.alfresco.service.cmr.transfer.TransferEventEndState;
import org.alfresco.service.cmr.transfer.TransferEventEnterState;
import org.alfresco.service.cmr.transfer.TransferEventError;
import org.alfresco.service.cmr.transfer.TransferEventReport;
import org.alfresco.service.cmr.transfer.TransferEventSendingContent;
import org.alfresco.service.cmr.transfer.TransferEventSendingSnapshot;
import org.alfresco.service.cmr.transfer.TransferEventSentContent;
import org.alfresco.service.cmr.transfer.TransferEventSuccess;
import org.springframework.extensions.surf.util.ISO8601DateFormat;
import org.xml.sax.helpers.AttributesImpl;

public class XMLTransferEventFormatterFactory {
    private static XMLTransferEventFormatter defaultFormatter = new XMLTransferEventFormatter(){

        public AttributesImpl getAttributes(TransferEvent event) {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "date", "date", "dateTime", ISO8601DateFormat.format((Date)event.getTime()));
            return attributes;
        }

        public String getElementName(TransferEvent event) {
            return "event";
        }

        public String getMessage(TransferEvent event) {
            return event.getMessage();
        }
    };
    private static XMLTransferEventFormatter eventEnterStateFormatter = new XMLTransferEventFormatter(){

        public AttributesImpl getAttributes(TransferEvent event) {
            TransferEventEnterState s = (TransferEventEnterState)event;
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "date", "date", "dateTime", ISO8601DateFormat.format((Date)event.getTime()));
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "state", "state", "string", s.getTransferState().toString());
            return attributes;
        }

        public String getElementName(TransferEvent event) {
            return "eventStartState";
        }

        public String getMessage(TransferEvent event) {
            return event.getMessage();
        }
    };
    private static XMLTransferEventFormatter eventReportFormatter = new XMLTransferEventFormatter(){

        public AttributesImpl getAttributes(TransferEvent event) {
            TransferEventReport s = (TransferEventReport)event;
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "date", "date", "dateTime", ISO8601DateFormat.format((Date)event.getTime()));
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "nodeRef", "nodeRef", "string", s.getNodeRef().toString());
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "reportType", "reportType", "string", s.getReportType().toString());
            return attributes;
        }

        public String getElementName(TransferEvent event) {
            return "eventReport";
        }

        public String getMessage(TransferEvent event) {
            return null;
        }
    };
    private static XMLTransferEventFormatter eventSendingContentFormatter = new XMLTransferEventFormatter(){

        public AttributesImpl getAttributes(TransferEvent event) {
            TransferEventSendingContent s = (TransferEventSendingContent)event;
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "date", "date", "dateTime", ISO8601DateFormat.format((Date)event.getTime()));
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "position", "position", "string", String.valueOf(s.getPosition()));
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "range", "range", "string", String.valueOf(s.getRange()));
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "size", "size", "string", String.valueOf(s.getSize()));
            return attributes;
        }

        public String getElementName(TransferEvent event) {
            return "eventSendContent";
        }

        public String getMessage(TransferEvent event) {
            return null;
        }
    };
    private static XMLTransferEventFormatter eventSendingSnapshotFormatter = new XMLTransferEventFormatter(){

        public AttributesImpl getAttributes(TransferEvent event) {
            TransferEventSendingSnapshot s = (TransferEventSendingSnapshot)event;
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "date", "date", "dateTime", ISO8601DateFormat.format((Date)event.getTime()));
            return attributes;
        }

        public String getElementName(TransferEvent event) {
            return "eventSendSnapshot";
        }

        public String getMessage(TransferEvent event) {
            return null;
        }
    };
    private static XMLTransferEventFormatter eventBeginFormatter = new XMLTransferEventFormatter(){

        public AttributesImpl getAttributes(TransferEvent event) {
            TransferEventBegin s = (TransferEventBegin)event;
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "date", "date", "dateTime", ISO8601DateFormat.format((Date)event.getTime()));
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "transferId", "transferId", "string", s.getTransferId());
            return attributes;
        }

        public String getElementName(TransferEvent event) {
            return "eventBegin";
        }

        public String getMessage(TransferEvent event) {
            return event.getMessage();
        }
    };
    private static XMLTransferEventFormatter eventEndStateFormatter = new XMLTransferEventFormatter(){

        public AttributesImpl getAttributes(TransferEvent event) {
            TransferEventEndState s = (TransferEventEndState)event;
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "date", "date", "dateTime", ISO8601DateFormat.format((Date)event.getTime()));
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "state", "state", "string", s.getTransferState().toString());
            return attributes;
        }

        public String getElementName(TransferEvent event) {
            return "eventEndState";
        }

        public String getMessage(TransferEvent event) {
            return null;
        }
    };
    private static XMLTransferEventFormatter eventCommittingStatus = new XMLTransferEventFormatter(){

        public AttributesImpl getAttributes(TransferEvent event) {
            TransferEventCommittingStatus s = (TransferEventCommittingStatus)event;
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "date", "date", "dateTime", ISO8601DateFormat.format((Date)event.getTime()));
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "position", "position", "string", String.valueOf(s.getPosition()));
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "range", "range", "string", String.valueOf(s.getRange()));
            return attributes;
        }

        public String getElementName(TransferEvent event) {
            return "eventCommittingStatus";
        }

        public String getMessage(TransferEvent event) {
            return event.getMessage();
        }
    };
    private static XMLTransferEventFormatter eventCancelled = new XMLTransferEventFormatter(){

        public AttributesImpl getAttributes(TransferEvent event) {
            TransferEventCancelled s = (TransferEventCancelled)event;
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "date", "date", "dateTime", ISO8601DateFormat.format((Date)event.getTime()));
            return attributes;
        }

        public String getElementName(TransferEvent event) {
            return "eventCancelled";
        }

        public String getMessage(TransferEvent event) {
            return event.getMessage();
        }
    };
    private static XMLTransferEventFormatter eventSuccess = new XMLTransferEventFormatter(){

        public AttributesImpl getAttributes(TransferEvent event) {
            TransferEventSuccess s = (TransferEventSuccess)event;
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "date", "date", "dateTime", ISO8601DateFormat.format((Date)event.getTime()));
            return attributes;
        }

        public String getElementName(TransferEvent event) {
            return "eventSuccess";
        }

        public String getMessage(TransferEvent event) {
            return event.getMessage();
        }
    };
    private static XMLTransferEventFormatter eventSentContent = new XMLTransferEventFormatter(){

        public AttributesImpl getAttributes(TransferEvent event) {
            TransferEventSentContent s = (TransferEventSentContent)event;
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "date", "date", "dateTime", ISO8601DateFormat.format((Date)event.getTime()));
            return attributes;
        }

        public String getElementName(TransferEvent event) {
            return "eventSentContent";
        }

        public String getMessage(TransferEvent event) {
            return event.getMessage();
        }
    };
    private static XMLTransferEventFormatter eventError = new XMLTransferEventFormatter(){

        public AttributesImpl getAttributes(TransferEvent event) {
            TransferEventError s = (TransferEventError)event;
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "date", "date", "dateTime", ISO8601DateFormat.format((Date)event.getTime()));
            return attributes;
        }

        public String getElementName(TransferEvent event) {
            return "eventError";
        }

        public String getMessage(TransferEvent event) {
            TransferEventError s = (TransferEventError)event;
            return s.getException().getMessage();
        }
    };
    protected static Map<Class<?>, XMLTransferEventFormatter> formatters = new HashMap(29);

    public static XMLTransferEventFormatter getFormatter(TransferEvent event) {
        XMLTransferEventFormatter formatter = formatters.get(event.getClass());
        if (formatter == null) {
            return defaultFormatter;
        }
        return formatter;
    }

    static {
        formatters.put(TransferEventEnterState.class, eventEnterStateFormatter);
        formatters.put(TransferEventEndState.class, eventEndStateFormatter);
        formatters.put(TransferEventReport.class, eventReportFormatter);
        formatters.put(TransferEventSendingContent.class, eventSendingContentFormatter);
        formatters.put(TransferEventSendingSnapshot.class, eventSendingSnapshotFormatter);
        formatters.put(TransferEventBegin.class, eventBeginFormatter);
        formatters.put(TransferEventCommittingStatus.class, eventCommittingStatus);
        formatters.put(TransferEventCancelled.class, eventCancelled);
        formatters.put(TransferEventError.class, eventError);
        formatters.put(TransferEventSuccess.class, eventSuccess);
        formatters.put(TransferEventSentContent.class, eventSentContent);
    }
}

