/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.BaseInterpreter;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.cmr.workflow.WorkflowTimer;
import org.alfresco.service.cmr.workflow.WorkflowTransition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.io.ClassPathResource;
import org.springframework.extensions.surf.util.I18NUtil;

public class WorkflowInterpreter
extends BaseInterpreter {
    private WorkflowService workflowService;
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private AuthorityDAO authorityDAO;
    private AVMService avmService;
    private AVMSyncService avmSyncService;
    private PersonService personService;
    private FileFolderService fileFolderService;
    private TenantService tenantService;
    private WorkflowDefinition currentWorkflowDef = null;
    private WorkflowPath currentPath = null;
    private String currentDeploy = null;
    private Map<QName, Serializable> vars = new HashMap<QName, Serializable>();

    protected void onBootstrap(ApplicationEvent event) {
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setAVMService(AVMService avmService) {
        this.avmService = avmService;
    }

    public void setAVMSyncService(AVMSyncService avmSyncService) {
        this.avmSyncService = avmSyncService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setAuthorityDAO(AuthorityDAO authorityDAO) {
        this.authorityDAO = authorityDAO;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public static void main(String[] args) {
        WorkflowInterpreter.runMain("workflowInterpreter");
    }

    protected boolean hasAuthority(String username) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String executeCommand(String line) throws IOException {
        PrintStream out;
        ByteArrayOutputStream bout;
        block208: {
            String[] command = line.split(" ");
            if (command.length == 0) {
                command = new String[]{line};
            }
            bout = new ByteArrayOutputStream();
            out = new PrintStream(bout);
            if (command[0].equals("r")) {
                if (this.lastCommand != null) return "repeating command " + this.lastCommand + "\n\n" + this.executeCommand(this.lastCommand);
                return "No command entered yet.";
            }
            this.lastCommand = line;
            if (command[0].equals("help")) {
                String helpFile = I18NUtil.getMessage((String)"workflow_console.help");
                ClassPathResource helpResource = new ClassPathResource(helpFile);
                byte[] helpBytes = new byte[500];
                InputStream helpStream = helpResource.getInputStream();
                try {
                    int read = helpStream.read(helpBytes);
                    while (read != -1) {
                        bout.write(helpBytes, 0, read);
                        read = helpStream.read(helpBytes);
                    }
                    Object var11_129 = null;
                }
                catch (Throwable throwable) {
                    Object var11_130 = null;
                    helpStream.close();
                    throw throwable;
                }
                helpStream.close();
                {
                    break block208;
                }
            }
            if (command[0].equals("show")) {
                if (command.length < 2) {
                    return "Syntax Error.\n";
                }
                if (command[1].equals("file")) {
                    if (command.length != 3) {
                        return "Syntax Error.\n";
                    }
                    ClassPathResource file = new ClassPathResource(command[2]);
                    InputStream fileStream = file.getInputStream();
                    byte[] fileBytes = new byte[500];
                    try {
                        int read = fileStream.read(fileBytes);
                        while (read != -1) {
                            bout.write(fileBytes, 0, read);
                            read = fileStream.read(fileBytes);
                        }
                        Object var13_152 = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_153 = null;
                        fileStream.close();
                        throw throwable;
                    }
                    fileStream.close();
                    out.println();
                } else if (command[1].equals("definitions")) {
                    List<WorkflowDefinition> defs = null;
                    if (command.length == 3) {
                        if (!command[2].equals("all")) return "Syntax Error.\n";
                        defs = this.workflowService.getAllDefinitions();
                    } else {
                        defs = this.workflowService.getDefinitions();
                    }
                    for (WorkflowDefinition def : defs) {
                        out.println("id: " + def.id + " , name: " + def.name + " , title: " + def.title + " , version: " + def.version);
                    }
                } else if (command[1].equals("workflows")) {
                    String id;
                    String string = id = this.currentWorkflowDef != null ? this.currentWorkflowDef.id : null;
                    if (id == null && command.length == 2) {
                        return "workflow definition not in use.  Enter command 'show workflows all' or 'use <workflowDefId>'.\n";
                    }
                    if (command.length == 3) {
                        if (!command[2].equals("all")) return "Syntax Error.\n";
                        id = "all";
                    }
                    if (id.equals("all")) {
                        for (WorkflowDefinition def : this.workflowService.getAllDefinitions()) {
                            List<WorkflowInstance> workflows = this.workflowService.getActiveWorkflows(def.id);
                            for (WorkflowInstance workflow : workflows) {
                                out.println("id: " + workflow.id + " , desc: " + workflow.description + " , start date: " + workflow.startDate + " , def: " + workflow.definition.name + " v" + workflow.definition.version);
                            }
                        }
                    } else {
                        List<WorkflowInstance> workflows = this.workflowService.getActiveWorkflows(id);
                        for (WorkflowInstance workflow : workflows) {
                            out.println("id: " + workflow.id + " , desc: " + workflow.description + " , start date: " + workflow.startDate + " , def: " + workflow.definition.name);
                        }
                    }
                } else if (command[1].equals("paths")) {
                    String workflowId;
                    String string;
                    if (command.length == 3) {
                        string = command[2];
                    } else {
                        if (this.currentPath == null) {
                            return "Syntax Error.  Workflow Id not specified.\n";
                        }
                        string = workflowId = this.currentPath.instance.id;
                    }
                    if (workflowId == null) {
                        return "Syntax Error.  Workflow Id not specified.\n";
                    }
                    List<WorkflowPath> paths = this.workflowService.getWorkflowPaths(workflowId);
                    for (WorkflowPath path : paths) {
                        out.println("path id: " + path.id + " , node: " + path.node.name);
                    }
                } else if (command[1].equals("tasks")) {
                    String pathId;
                    String string;
                    if (command.length == 3) {
                        string = command[2];
                    } else {
                        if (this.currentPath == null) {
                            return "Syntax Error.  Path Id not specified.\n";
                        }
                        string = pathId = this.currentPath.id;
                    }
                    if (pathId == null) {
                        return "Syntax Error.  Path Id not specified.\n";
                    }
                    List<WorkflowTask> tasks = this.workflowService.getTasksForWorkflowPath(pathId);
                    for (WorkflowTask task : tasks) {
                        out.println("task id: " + task.id + " , name: " + task.name + " , properties: " + task.properties.size());
                    }
                } else if (command[1].equals("transitions")) {
                    String workflowId;
                    String string;
                    if (command.length == 3) {
                        string = command[2];
                    } else {
                        if (this.currentPath == null) {
                            return "Syntax Error.  Workflow Id not specified.\n";
                        }
                        string = workflowId = this.currentPath.instance.id;
                    }
                    if (workflowId == null) {
                        return "Syntax Error.  Workflow Id not specified.\n";
                    }
                    List<WorkflowPath> paths = this.workflowService.getWorkflowPaths(workflowId);
                    if (paths.size() == 0) {
                        out.println("no further transitions");
                    }
                    for (WorkflowPath path : paths) {
                        out.println("path: " + path.id + " , node: " + path.node.name + " , active: " + path.active);
                        List<WorkflowTask> tasks = this.workflowService.getTasksForWorkflowPath(path.id);
                        for (WorkflowTask task : tasks) {
                            out.println(" task id: " + task.id + " , name: " + task.name + ", title: " + task.title + " , desc: " + task.description + " , properties: " + task.properties.size());
                        }
                        for (WorkflowTransition transition : path.node.transitions) {
                            out.println(" transition id: " + (transition.id == null || transition.id.equals("") ? "[default]" : transition.id) + " , title: " + transition.title);
                        }
                    }
                } else if (command[1].equals("timers")) {
                    String id;
                    String string = id = this.currentWorkflowDef != null ? this.currentWorkflowDef.id : null;
                    if (id == null && command.length == 2) {
                        return "workflow definition not in use.  Enter command 'show timers all' or 'use <workflowDefId>'.\n";
                    }
                    if (command.length == 3) {
                        if (!command[2].equals("all")) return "Syntax Error.\n";
                        id = "all";
                    }
                    ArrayList<WorkflowTimer> timers = new ArrayList<WorkflowTimer>();
                    if (id.equals("all")) {
                        for (WorkflowDefinition def : this.workflowService.getAllDefinitions()) {
                            List<WorkflowInstance> workflows = this.workflowService.getActiveWorkflows(def.id);
                            for (WorkflowInstance workflow : workflows) {
                                timers.addAll(this.workflowService.getTimers(workflow.id));
                            }
                        }
                    } else {
                        List<WorkflowInstance> workflows = this.workflowService.getActiveWorkflows(id);
                        for (WorkflowInstance workflow : workflows) {
                            timers.addAll(this.workflowService.getTimers(workflow.id));
                        }
                    }
                    for (WorkflowTimer timer : timers) {
                        out.print("id: " + timer.id + " , name: " + timer.name + " , due date: " + timer.dueDate + " , path: " + timer.path.id + " , node: " + timer.path.node.name + " , process: " + timer.path.instance.id);
                        if (timer.task != null) {
                            out.print(" , task: " + timer.task.name + "(" + timer.task.id + ")");
                        }
                        out.println();
                        if (timer.error == null) continue;
                        out.println("error executing timer id " + timer.id);
                        out.println(timer.error);
                    }
                } else {
                    if (!command[1].equals("my")) return "Syntax Error.\n";
                    if (command.length != 3) {
                        return "Syntax Error.\n";
                    }
                    if (command[2].equals("tasks")) {
                        out.println(AuthenticationUtil.getRunAsUser() + ":");
                        List<WorkflowTask> tasks = this.workflowService.getAssignedTasks(AuthenticationUtil.getRunAsUser(), WorkflowTaskState.IN_PROGRESS);
                        for (WorkflowTask task : tasks) {
                            out.println("id: " + task.id + " , name: " + task.name + " , properties: " + task.properties.size() + " , workflow: " + task.path.instance.id + " , path: " + task.path.id);
                        }
                    } else if (command[2].equals("completed")) {
                        out.println(AuthenticationUtil.getRunAsUser() + ":");
                        List<WorkflowTask> tasks = this.workflowService.getAssignedTasks(AuthenticationUtil.getRunAsUser(), WorkflowTaskState.COMPLETED);
                        for (WorkflowTask task : tasks) {
                            out.println("id: " + task.id + " , name " + task.name + " , properties: " + task.properties.size() + " , workflow: " + task.path.instance.id + " , path: " + task.path.id);
                        }
                    } else {
                        if (!command[2].equals("pooled")) return "Syntax Error.\n";
                        out.println(AuthenticationUtil.getRunAsUser() + ":");
                        List<WorkflowTask> tasks = this.workflowService.getPooledTasks(AuthenticationUtil.getRunAsUser());
                        for (WorkflowTask task : tasks) {
                            out.println("id: " + task.id + " , name " + task.name + " , properties: " + task.properties.size() + " , workflow: " + task.path.instance.id + " , path: " + task.path.id);
                        }
                    }
                }
            } else if (command[0].equals("desc")) {
                if (command.length < 2) {
                    return "Syntax Error.\n";
                }
                if (command[1].equals("task")) {
                    if (command.length != 3) {
                        return "Syntax Error.\n";
                    }
                    WorkflowTask task = this.workflowService.getTaskById(command[2]);
                    out.println("id: " + task.id);
                    out.println("name: " + task.name);
                    out.println("title: " + task.title);
                    out.println("description: " + task.description);
                    out.println("state: " + (Object)((Object)task.state));
                    out.println("path: " + task.path.id);
                    out.println("transitions: " + task.definition.node.transitions.length);
                    for (WorkflowTransition transition : task.definition.node.transitions) {
                        out.println(" transition: " + (transition.id == null || transition.id.equals("") ? "[default]" : transition.id) + " , title: " + transition.title + " , desc: " + transition.description);
                    }
                    out.println("properties: " + task.properties.size());
                    for (Map.Entry<QName, Serializable> prop : task.properties.entrySet()) {
                        out.println(" " + prop.getKey() + " = " + prop.getValue());
                    }
                } else if (command[1].equals("workflow")) {
                    if (command.length != 3) {
                        return "Syntax Error.\n";
                    }
                    WorkflowInstance workflow = this.workflowService.getWorkflowById(command[2]);
                    out.println("definition: " + workflow.definition.name);
                    out.println("id: " + workflow.id);
                    out.println("description: " + workflow.description);
                    out.println("active: " + workflow.active);
                    out.println("start date: " + workflow.startDate);
                    out.println("end date: " + workflow.endDate);
                    out.println("initiator: " + workflow.initiator);
                    out.println("context: " + workflow.context);
                    out.println("package: " + workflow.workflowPackage);
                } else {
                    if (!command[1].equals("path")) return "Syntax Error.\n";
                    if (command.length != 3) {
                        return "Syntax Error.\n";
                    }
                    Map<QName, Serializable> properties = this.workflowService.getPathProperties(command[2]);
                    out.println("path: " + command[1]);
                    out.println("properties: " + properties.size());
                    for (Map.Entry<QName, Serializable> prop : properties.entrySet()) {
                        out.println(" " + prop.getKey() + " = " + prop.getValue());
                    }
                }
            } else if (command[0].equals("query")) {
                if (command.length < 2) {
                    return "Syntax Error.\n";
                }
                if (!command[1].equals("task")) return "Syntax Error.\n";
                WorkflowTaskQuery query = new WorkflowTaskQuery();
                HashMap<QName, Object> taskProps = new HashMap<QName, Object>();
                HashMap<QName, Object> procProps = new HashMap<QName, Object>();
                for (int i = 2; i < command.length; ++i) {
                    String[] predicate = command[i].split("=");
                    if (predicate.length == 1) {
                        return "Syntax Error.\n";
                    }
                    String[] predicateName = predicate[0].split("\\.");
                    if (predicateName.length == 1) {
                        if (predicate[0].equals("taskId")) {
                            query.setTaskId(predicate[1]);
                            continue;
                        }
                        if (predicate[0].equals("taskState")) {
                            WorkflowTaskState state = WorkflowTaskState.valueOf(predicate[1]);
                            if (state == null) {
                                return "Syntax Error.  Unknown task state\n";
                            }
                            query.setTaskState(state);
                            continue;
                        }
                        if (predicate[0].equals("taskName")) {
                            query.setTaskName(QName.createQName((String)predicate[1], (NamespacePrefixResolver)this.namespaceService));
                            continue;
                        }
                        if (predicate[0].equals("taskActor")) {
                            query.setActorId(predicate[1]);
                            continue;
                        }
                        if (predicate[0].equals("processId")) {
                            query.setProcessId(predicate[1]);
                            continue;
                        }
                        if (predicate[0].equals("processName")) {
                            query.setProcessName(QName.createQName((String)predicate[1], (NamespacePrefixResolver)this.namespaceService));
                            continue;
                        }
                        if (predicate[0].equals("processActive")) {
                            Boolean active = Boolean.valueOf(predicate[1]);
                            query.setActive(active);
                            continue;
                        }
                        if (!predicate[0].equals("orderBy")) return "Syntax Error.  Unknown query predicate.\n";
                        String[] orderBy = predicate[1].split(",");
                        WorkflowTaskQuery.OrderBy[] queryOrderBy = new WorkflowTaskQuery.OrderBy[orderBy.length];
                        for (int iOrderBy = 0; iOrderBy < orderBy.length; ++iOrderBy) {
                            queryOrderBy[iOrderBy] = WorkflowTaskQuery.OrderBy.valueOf(orderBy[iOrderBy]);
                            if (queryOrderBy[iOrderBy] != null) continue;
                            return "Syntax Error.  Unknown orderBy.\n";
                        }
                        query.setOrderBy(queryOrderBy);
                        continue;
                    }
                    if (predicateName.length != 2) return "Syntax Error.\n";
                    if (predicateName[0].equals("task")) {
                        taskProps.put(QName.createQName((String)predicateName[1], (NamespacePrefixResolver)this.namespaceService), predicate[1]);
                        continue;
                    }
                    if (!predicateName[0].equals("process")) return "Syntax Error.  Unknown query predicate.\n";
                    procProps.put(QName.createQName((String)predicateName[1], (NamespacePrefixResolver)this.namespaceService), predicate[1]);
                }
                if (taskProps.size() > 0) {
                    query.setTaskCustomProps(taskProps);
                }
                if (procProps.size() > 0) {
                    query.setProcessCustomProps(procProps);
                }
                List<WorkflowTask> tasks = this.workflowService.queryTasks(query);
                out.println("found " + tasks.size() + " tasks.");
                for (WorkflowTask task : tasks) {
                    out.println("task id: " + task.id + " , name: " + task.name + " , properties: " + task.properties.size() + ", process id: " + task.path.instance);
                }
            } else if (command[0].equals("deploy")) {
                if (command.length != 2) {
                    return "Syntax Error.\n";
                }
                ClassPathResource workflowDef = new ClassPathResource(command[1]);
                WorkflowDeployment deployment = this.workflowService.deployDefinition("jbpm", workflowDef.getInputStream(), "text/xml");
                WorkflowDefinition def = deployment.definition;
                for (String problem : deployment.problems) {
                    out.println(problem);
                }
                out.println("deployed definition id: " + def.id + " , name: " + def.name + " , title: " + def.title + " , version: " + def.version);
                this.currentDeploy = command[1];
                out.print(this.executeCommand("use definition " + def.id));
            } else if (command[0].equals("redeploy")) {
                if (this.currentDeploy == null) {
                    return "nothing to redeploy\n";
                }
                out.print(this.executeCommand("deploy " + this.currentDeploy));
            } else if (command[0].equals("undeploy")) {
                if (command.length < 2) {
                    return "Syntax Error.\n";
                }
                if (!command[1].equals("definition")) return "Syntax Error.\n";
                if (command.length == 3) {
                    this.workflowService.undeployDefinition(command[2]);
                    this.currentWorkflowDef = null;
                    this.currentPath = null;
                    out.print(this.executeCommand("show definitions"));
                } else {
                    if (command.length != 4) return "Syntax Error.\n";
                    if (!command[2].equals("name")) return "Syntax Error.\n";
                    out.print("undeploying...");
                    List<WorkflowDefinition> defs = this.workflowService.getAllDefinitionsByName(command[3]);
                    for (WorkflowDefinition def : defs) {
                        this.workflowService.undeployDefinition(def.id);
                        out.print(" v" + def.version);
                    }
                    out.println("");
                    this.currentWorkflowDef = null;
                    this.currentPath = null;
                    out.print(this.executeCommand("show definitions all"));
                }
            } else if (command[0].equals("use")) {
                if (command.length == 1) {
                    out.println("definition: " + (this.currentWorkflowDef == null ? "None" : this.currentWorkflowDef.id + " , name: " + this.currentWorkflowDef.title + " , version: " + this.currentWorkflowDef.version));
                    out.println("workflow: " + (this.currentPath == null ? "None" : this.currentPath.instance.id + " , active: " + this.currentPath.instance.active));
                    out.println("path: " + (this.currentPath == null ? "None" : this.currentPath.id + " , node: " + this.currentPath.node.title));
                } else if (command.length > 1) {
                    if (command[1].equals("definition")) {
                        if (command.length != 3) {
                            return "Syntax Error.\n";
                        }
                        WorkflowDefinition def = this.workflowService.getDefinitionById(command[2]);
                        if (def == null) {
                            return "Not found.\n";
                        }
                        this.currentWorkflowDef = def;
                        this.currentPath = null;
                        out.print(this.executeCommand("use"));
                    } else {
                        if (!command[1].equals("workflow")) return "Syntax Error.\n";
                        if (command.length != 3) {
                            return "Syntax Error.\n";
                        }
                        WorkflowInstance instance = this.workflowService.getWorkflowById(command[2]);
                        this.currentWorkflowDef = instance.definition;
                        this.currentPath = this.workflowService.getWorkflowPaths(instance.id).get(0);
                        out.print(this.executeCommand("use"));
                    }
                }
            } else if (command[0].equals("user")) {
                if (command.length == 2) {
                    if (this.tenantService.isEnabled()) {
                        this.tenantService.checkDomainUser(command[1]);
                    }
                    this.setCurrentUserName(command[1]);
                }
                out.println("using user " + this.getCurrentUserName());
            } else if (command[0].equals("start")) {
                HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
                for (int i = 1; i < command.length; ++i) {
                    String[] param = command[i].split("=");
                    QName qname = QName.createQName((String)param[0], (NamespacePrefixResolver)this.namespaceService);
                    if (param.length == 1) {
                        if (!this.vars.containsKey(qname)) {
                            return "var " + qname + " not found.\n";
                        }
                        params.put(qname, this.vars.get(qname));
                        continue;
                    }
                    if (param.length != 2) return "Syntax Error.\n";
                    params.put(qname, (Serializable)((Object)param[1]));
                }
                if (this.currentWorkflowDef == null) {
                    return "Workflow definition not selected.\n";
                }
                WorkflowPath path = this.workflowService.startWorkflow(this.currentWorkflowDef.id, params);
                out.println("started workflow id: " + path.instance.id + " , def: " + path.instance.definition.title);
                this.currentPath = path;
                out.print(this.interpretCommand("show transitions"));
            } else if (command[0].equals("update")) {
                if (command.length < 3) {
                    return "Syntax Error.\n";
                }
                if (!command[1].equals("task")) return "Syntax Error.\n";
                if (command.length < 4) {
                    return "Syntax Error.\n";
                }
                HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
                for (int i = 3; i < command.length; ++i) {
                    String[] param = command[i].split("=");
                    QName qname = QName.createQName((String)param[0], (NamespacePrefixResolver)this.namespaceService);
                    if (param.length == 1) {
                        if (!this.vars.containsKey(qname)) {
                            return "var " + qname + " not found.\n";
                        }
                        params.put(qname, this.vars.get(qname));
                        continue;
                    }
                    if (param.length != 2) return "Syntax Error.\n";
                    params.put(qname, (Serializable)((Object)param[1]));
                }
                WorkflowTask task = this.workflowService.updateTask(command[2], params, null, null);
                out.println("updated task id: " + command[2] + ", properties: " + task.properties.size());
            } else if (command[0].equals("signal")) {
                if (command.length < 2) {
                    return "Syntax Error.\n";
                }
                WorkflowPath path = this.workflowService.signal(command[1], command.length == 3 ? command[2] : null);
                out.println("signal sent - path id: " + path.id);
                out.print(this.interpretCommand("show transitions"));
            } else if (command[0].equals("event")) {
                if (command.length < 3) {
                    return "Syntax Error.\n";
                }
                WorkflowPath path = this.workflowService.fireEvent(command[1], command[2]);
                out.println("event " + command[2] + " fired - path id: " + path.id);
                out.print(this.interpretCommand("show transitions"));
            } else if (command[0].equals("end")) {
                if (command.length < 3) {
                    return "Syntax Error.\n";
                }
                if (command[1].equals("task")) {
                    WorkflowTask task = this.workflowService.endTask(command[2], command.length == 4 ? command[3] : null);
                    out.println("signal sent - path id: " + task.path.id);
                    out.print(this.interpretCommand("show transitions"));
                } else {
                    String workflowId;
                    String string;
                    if (!command[1].equals("workflow")) return "Syntax Error.\n";
                    if (command.length == 3) {
                        string = command[2];
                    } else {
                        if (this.currentPath == null) {
                            return "Syntax Error.  Workflow Id not specified.\n";
                        }
                        string = workflowId = this.currentPath.instance.id;
                    }
                    if (workflowId == null) {
                        return "Syntax Error.  Workflow Id not specified.\n";
                    }
                    this.workflowService.cancelWorkflow(workflowId);
                    out.println("workflow " + workflowId + " cancelled.");
                }
            } else if (command[0].equals("delete")) {
                if (command.length < 2) {
                    return "Syntax Error.\n";
                }
                if (command[1].equals("workflow")) {
                    String workflowId;
                    String string;
                    if (command.length == 3) {
                        string = command[2];
                    } else {
                        if (this.currentPath == null) {
                            return "Syntax Error.  Workflow Id not specified.\n";
                        }
                        string = workflowId = this.currentPath.instance.id;
                    }
                    if (workflowId == null) {
                        return "Syntax Error.  Workflow Id not specified.\n";
                    }
                    this.workflowService.deleteWorkflow(workflowId);
                    out.println("workflow " + workflowId + " deleted.");
                } else {
                    if (!command[1].equals("all")) return "Syntax Error.\n";
                    if (command.length < 3) {
                        return "Syntax Error.\n";
                    }
                    if (!command[2].equals("workflows")) return "Syntax Error.\n";
                    if (command.length < 4) {
                        return "Enter the command 'delete all workflows imeanit' to really delete all workflows\n";
                    }
                    if (!command[3].equals("imeanit")) return "Syntax Error.\n";
                    for (WorkflowDefinition def : this.workflowService.getAllDefinitions()) {
                        List<WorkflowInstance> workflows = this.workflowService.getActiveWorkflows(def.id);
                        for (WorkflowInstance workflow : workflows) {
                            this.workflowService.deleteWorkflow(workflow.id);
                            out.println("workflow " + workflow.id + " deleted.");
                        }
                    }
                }
            } else {
                if (!command[0].equals("var")) return "Syntax Error.\n";
                if (command.length == 1) {
                    for (Map.Entry<QName, Serializable> entry : this.vars.entrySet()) {
                        out.println(entry.getKey() + " = " + entry.getValue());
                    }
                } else if (command.length == 2) {
                    String[] param = command[1].split("=");
                    if (param.length == 0) {
                        return "Syntax Error.\n";
                    }
                    if (param.length == 1) {
                        QName qname = QName.createQName((String)param[0], (NamespacePrefixResolver)this.namespaceService);
                        this.vars.remove(qname);
                        out.println("deleted var " + qname);
                    } else {
                        if (param.length != 2) return "Syntax Error.\n";
                        boolean multi = false;
                        if (param[0].endsWith("*")) {
                            param[0] = param[0].substring(0, param[0].length() - 1);
                            multi = true;
                        }
                        QName qname = QName.createQName((String)param[0], (NamespacePrefixResolver)this.namespaceService);
                        String[] strValues = param[1].split(",");
                        if (!multi && strValues.length > 1) {
                            return "Syntax Error.\n";
                        }
                        if (!multi) {
                            this.vars.put(qname, (Serializable)((Object)strValues[0]));
                        } else {
                            ArrayList<String> values = new ArrayList<String>();
                            for (String strValue : strValues) {
                                values.add(strValue);
                            }
                            this.vars.put(qname, values);
                        }
                        out.println("set var " + qname + " = " + this.vars.get(qname));
                    }
                } else {
                    if (command.length != 4) return "Syntax Error.\n";
                    if (command[2].equals("person")) {
                        boolean multi = false;
                        if (command[1].endsWith("*")) {
                            command[1] = command[1].substring(0, command[1].length() - 1);
                            multi = true;
                        }
                        QName qname = QName.createQName((String)command[1], (NamespacePrefixResolver)this.namespaceService);
                        String[] strValues = command[3].split(",");
                        if (!multi && strValues.length > 1) {
                            return "Syntax Error.\n";
                        }
                        if (!multi) {
                            NodeRef auth = this.personService.getPerson(strValues[0]);
                            this.vars.put(qname, (Serializable)auth);
                        } else {
                            ArrayList<NodeRef> values = new ArrayList<NodeRef>();
                            for (String strValue : strValues) {
                                NodeRef auth = this.personService.getPerson(strValue);
                                values.add(auth);
                            }
                            this.vars.put(qname, values);
                        }
                        out.println("set var " + qname + " = " + this.vars.get(qname));
                    } else if (command[2].equals("group")) {
                        boolean multi = false;
                        if (command[1].endsWith("*")) {
                            command[1] = command[1].substring(0, command[1].length() - 1);
                            multi = true;
                        }
                        QName qname = QName.createQName((String)command[1], (NamespacePrefixResolver)this.namespaceService);
                        String[] strValues = command[3].split(",");
                        if (!multi && strValues.length > 1) {
                            return "Syntax Error.\n";
                        }
                        if (!multi) {
                            NodeRef auth = this.authorityDAO.getAuthorityNodeRefOrNull(strValues[0]);
                            if (auth == null) {
                                throw new WorkflowException("Group " + strValues[0] + " does not exist.");
                            }
                            this.vars.put(qname, (Serializable)auth);
                        } else {
                            ArrayList<NodeRef> values = new ArrayList<NodeRef>();
                            for (String strValue : strValues) {
                                NodeRef auth = this.authorityDAO.getAuthorityNodeRefOrNull(strValue);
                                if (auth == null) {
                                    throw new WorkflowException("Group " + strValue + " does not exist.");
                                }
                                values.add(auth);
                            }
                            this.vars.put(qname, values);
                        }
                        out.println("set var " + qname + " = " + this.vars.get(qname));
                    } else if (command[2].equals("avmpackage")) {
                        AVMNodeDescriptor avmSource = this.avmService.lookup(-1, command[3]);
                        if (avmSource == null) return command[3] + " must refer to a directory.";
                        if (!avmSource.isDirectory()) {
                            return command[3] + " must refer to a directory.";
                        }
                        String packagesPath = "workflow-system:/packages";
                        AVMNodeDescriptor packagesDesc = this.avmService.lookup(-1, packagesPath);
                        if (packagesDesc == null) {
                            this.avmService.createStore("workflow-system");
                            this.avmService.createDirectory("workflow-system:/", "packages");
                        }
                        String packageName = GUID.generate();
                        String avmSourceIndirection = avmSource.getIndirection();
                        if (avmSourceIndirection != null) {
                            this.avmService.createLayeredDirectory(avmSourceIndirection, packagesPath, packageName);
                            List<AVMDifference> diff = this.avmSyncService.compare(-1, avmSource.getPath(), -1, packagesPath + "/" + packageName, null);
                            this.avmSyncService.update(diff, null, true, true, false, false, null, null);
                        } else {
                            this.avmService.copy(-1, avmSource.getPath(), packagesPath, packageName);
                        }
                        AVMNodeDescriptor packageDesc = this.avmService.lookup(-1, packagesPath + "/" + packageName);
                        NodeRef packageNodeRef = this.workflowService.createPackage(AVMNodeConverter.ToNodeRef(-1, packageDesc.getPath()));
                        this.nodeService.setProperty(packageNodeRef, WorkflowModel.PROP_IS_SYSTEM_PACKAGE, (Serializable)Boolean.valueOf(true));
                        QName qname = QName.createQName((String)command[1], (NamespacePrefixResolver)this.namespaceService);
                        this.vars.put(qname, (Serializable)packageNodeRef);
                        out.println("set var " + qname + " = " + this.vars.get(qname));
                    } else {
                        if (!command[2].equals("package")) return "Syntax Error.\n";
                        QName qname = QName.createQName((String)command[1], (NamespacePrefixResolver)this.namespaceService);
                        int number = new Integer(command[3]);
                        NodeRef packageNodeRef = this.workflowService.createPackage(null);
                        for (int i = 0; i < number; ++i) {
                            FileInfo fileInfo = this.fileFolderService.create(packageNodeRef, "Content" + i, ContentModel.TYPE_CONTENT);
                            ContentWriter writer = this.fileFolderService.getWriter(fileInfo.getNodeRef());
                            writer.putContent("Content" + i);
                        }
                        this.vars.put(qname, (Serializable)packageNodeRef);
                        out.println("set var " + qname + " = " + this.vars.get(qname));
                    }
                }
            }
        }
        out.flush();
        String retVal = new String(bout.toByteArray());
        out.close();
        return retVal;
    }

    public WorkflowDefinition getCurrentWorkflowDef() {
        return this.currentWorkflowDef;
    }
}

