/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.person.TestPersonManager;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;

public class WorkflowServiceImplTest
extends BaseSpringTest {
    private static final String USER1 = "WFUser1" + GUID.generate();
    private static final String USER2 = "WFUser2" + GUID.generate();
    private static final String USER3 = "WFUser3" + GUID.generate();
    private static final String GROUP = "WFGroup" + GUID.generate();
    private static final String SUB_GROUP = "WFSubGroup" + GUID.generate();
    private WorkflowService workflowService;
    private NodeService nodeService;
    private SearchService searchService;
    private AuthenticationComponent authenticationComponent;
    private MutableAuthenticationService authenticationService;
    private AuthorityService authorityService;
    private PersonService personService;
    private TestPersonManager personManager;

    protected void onSetUpInTransaction() throws Exception {
        this.workflowService = (WorkflowService)this.applicationContext.getBean(ServiceRegistry.WORKFLOW_SERVICE.getLocalName());
        this.nodeService = (NodeService)this.applicationContext.getBean(ServiceRegistry.NODE_SERVICE.getLocalName());
        this.searchService = (SearchService)this.applicationContext.getBean(ServiceRegistry.SEARCH_SERVICE.getLocalName());
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean(ServiceRegistry.AUTHENTICATION_SERVICE.getLocalName());
        this.authorityService = (AuthorityService)this.applicationContext.getBean(ServiceRegistry.AUTHORITY_SERVICE.getLocalName());
        this.personService = (PersonService)this.applicationContext.getBean(ServiceRegistry.PERSON_SERVICE.getLocalName());
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.personManager = new TestPersonManager(this.authenticationService, this.personService, this.nodeService);
        this.personManager.createPerson(USER1);
        this.personManager.createPerson(USER2);
        this.personManager.createPerson(USER3);
        this.createGroup(null, GROUP);
        this.createGroup(GROUP, SUB_GROUP);
        this.addUserToGroup(GROUP, USER1);
        this.addUserToGroup(SUB_GROUP, USER2);
    }

    protected void onTearDownInTransaction() throws Exception {
        super.onTearDownInTransaction();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.deleteGroup(SUB_GROUP);
        this.deleteGroup(GROUP);
        this.personManager.clearPeople();
    }

    protected void createGroup(String parentGroupShortName, String groupShortName) {
        if (parentGroupShortName != null) {
            String parentGroupFullName = this.authorityService.getName(AuthorityType.GROUP, parentGroupShortName);
            if (this.authorityService.authorityExists(parentGroupFullName)) {
                this.authorityService.createAuthority(AuthorityType.GROUP, groupShortName, groupShortName, null);
                String groupFullName = this.authorityService.getName(AuthorityType.GROUP, groupShortName);
                this.authorityService.addAuthority(parentGroupFullName, groupFullName);
            }
        } else {
            this.authorityService.createAuthority(AuthorityType.GROUP, groupShortName, groupShortName, null);
        }
    }

    protected void addUserToGroup(String groupName, String userName) {
        String fullGroupName = this.authorityService.getName(AuthorityType.GROUP, groupName);
        if (!this.authorityService.authorityExists(fullGroupName)) {
            this.authorityService.createAuthority(AuthorityType.GROUP, fullGroupName);
        }
        this.authorityService.addAuthority(fullGroupName, userName);
    }

    protected void deleteGroup(String groupShortName) {
        String groupFullName = this.authorityService.getName(AuthorityType.GROUP, groupShortName);
        if (this.authorityService.authorityExists(groupFullName)) {
            this.authorityService.deleteAuthority(groupFullName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected NodeRef findGroup(String shortGroupName) {
        NodeRef group = null;
        String query = "+TYPE:\"cm:authorityContainer\" AND @cm\\:authorityName:*" + shortGroupName;
        ResultSet results = null;
        try {
            results = this.searchService.query(new StoreRef("workspace", "SpacesStore"), "lucene", query);
            if (results.length() > 0) {
                group = (NodeRef)results.getNodeRefs().get(0);
            }
            Object var6_5 = null;
            if (results == null) return group;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (results == null) throw throwable;
            results.close();
            throw throwable;
        }
        results.close();
        return group;
    }

    public void testGetWorkflowDefinitions() {
        List<WorkflowDefinition> workflowDefs = this.workflowService.getDefinitions();
        WorkflowServiceImplTest.assertNotNull(workflowDefs);
        WorkflowServiceImplTest.assertTrue((workflowDefs.size() > 0 ? 1 : 0) != 0);
    }

    public void testStartWorkflow() {
        List<WorkflowDefinition> workflowDefs = this.workflowService.getDefinitions();
        WorkflowServiceImplTest.assertNotNull(workflowDefs);
        WorkflowServiceImplTest.assertTrue((workflowDefs.size() > 0 ? 1 : 0) != 0);
        WorkflowDefinition workflowDef = workflowDefs.get(0);
        WorkflowPath path = this.workflowService.startWorkflow(workflowDef.id, null);
        WorkflowServiceImplTest.assertNotNull((Object)path);
        WorkflowServiceImplTest.assertTrue((boolean)path.active);
        WorkflowServiceImplTest.assertNotNull((Object)path.node);
        WorkflowServiceImplTest.assertNotNull((Object)path.instance);
        WorkflowServiceImplTest.assertEquals((String)workflowDef.id, (String)path.instance.definition.id);
    }

    public void testWorkflowPackage() {
        NodeRef nodeRef = this.workflowService.createPackage(null);
        WorkflowServiceImplTest.assertNotNull((Object)nodeRef);
        WorkflowServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(nodeRef, WorkflowModel.ASPECT_WORKFLOW_PACKAGE));
    }

    public void testQueryTasks() {
        WorkflowTaskQuery filter = new WorkflowTaskQuery();
        filter.setTaskName(QName.createQName((String)"{http://www.alfresco.org/model/wcmworkflow/1.0}submitpendingTask"));
        filter.setTaskState(WorkflowTaskState.COMPLETED);
        HashMap<QName, Object> taskProps = new HashMap<QName, Object>();
        taskProps.put(QName.createQName((String)"{http://www.alfresco.org/model/bpm/1.0}workflowDescription"), "Test5");
        filter.setTaskCustomProps(taskProps);
        filter.setProcessId("jbpm$48");
        filter.setProcessName(QName.createQName((String)"{http://www.alfresco.org/model/wcmworkflow/1.0}submit"));
        HashMap<QName, Object> procProps = new HashMap<QName, Object>();
        procProps.put(QName.createQName((String)"{http://www.alfresco.org/model/bpm/1.0}workflowDescription"), "Test5");
        procProps.put(QName.createQName((String)"companyhome"), new NodeRef("workspace://SpacesStore/3df8a9d0-ff04-11db-98da-a3c3f3149ea5"));
        filter.setProcessCustomProps(procProps);
        filter.setOrderBy(new WorkflowTaskQuery.OrderBy[]{WorkflowTaskQuery.OrderBy.TaskName_Asc, WorkflowTaskQuery.OrderBy.TaskState_Asc});
        List<WorkflowTask> tasks = this.workflowService.queryTasks(filter);
        System.out.println("Found " + tasks.size() + " tasks.");
        for (WorkflowTask task : tasks) {
            System.out.println(task.toString());
        }
    }

    public void testAssociateWorkflowPackage() {
        NodeRef rootRef = this.nodeService.getRootNode(new StoreRef("workspace", "SpacesStore"));
        NodeRef nodeRef = this.workflowService.createPackage(null);
        WorkflowServiceImplTest.assertNotNull((Object)nodeRef);
        WorkflowServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(nodeRef, WorkflowModel.ASPECT_WORKFLOW_PACKAGE));
        ChildAssociationRef childAssoc = this.nodeService.createNode(rootRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"cm", (String)"test"), ContentModel.TYPE_CONTENT, null);
        List<WorkflowInstance> exisingInstances = this.workflowService.getWorkflowsForContent(childAssoc.getChildRef(), true);
        int size = 0;
        if (exisingInstances != null) {
            size = exisingInstances.size();
        }
        this.nodeService.addChild(nodeRef, childAssoc.getChildRef(), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"cm", (String)"test123"));
        List<WorkflowDefinition> workflowDefs = this.workflowService.getDefinitions();
        WorkflowServiceImplTest.assertNotNull(workflowDefs);
        WorkflowServiceImplTest.assertTrue((workflowDefs.size() > 0 ? 1 : 0) != 0);
        WorkflowDefinition workflowDef = workflowDefs.get(0);
        HashMap<QName, Serializable> parameters = new HashMap<QName, Serializable>();
        parameters.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)nodeRef);
        WorkflowPath path = this.workflowService.startWorkflow(workflowDef.id, parameters);
        WorkflowServiceImplTest.assertNotNull((Object)path);
        WorkflowServiceImplTest.assertTrue((boolean)path.active);
        WorkflowServiceImplTest.assertNotNull((Object)path.node);
        WorkflowServiceImplTest.assertNotNull((Object)path.instance);
        WorkflowServiceImplTest.assertEquals((String)workflowDef.id, (String)path.instance.definition.id);
        String workflowDefId = (String)((Object)this.nodeService.getProperty(nodeRef, WorkflowModel.PROP_WORKFLOW_DEFINITION_ID));
        WorkflowServiceImplTest.assertEquals((String)workflowDefId, (String)workflowDef.id);
        String workflowDefName = (String)((Object)this.nodeService.getProperty(nodeRef, WorkflowModel.PROP_WORKFLOW_DEFINITION_NAME));
        WorkflowServiceImplTest.assertEquals((String)workflowDefName, (String)workflowDef.name);
        String workflowInstanceId = (String)((Object)this.nodeService.getProperty(nodeRef, WorkflowModel.PROP_WORKFLOW_INSTANCE_ID));
        WorkflowServiceImplTest.assertEquals((String)workflowInstanceId, (String)path.instance.id);
        List<WorkflowInstance> instances = this.workflowService.getWorkflowsForContent(childAssoc.getChildRef(), true);
        WorkflowServiceImplTest.assertNotNull(instances);
        WorkflowServiceImplTest.assertEquals((int)(size + 1), (int)instances.size());
        for (WorkflowInstance instance : instances) {
            boolean fNew = true;
            Iterator<WorkflowInstance> i$ = exisingInstances.iterator();
            if (i$.hasNext()) {
                WorkflowInstance exisingInstance = i$.next();
                fNew = !instance.id.equals(exisingInstance.id);
            }
            if (!fNew) continue;
            WorkflowServiceImplTest.assertEquals((String)instance.id, (String)path.instance.id);
        }
        List<WorkflowInstance> completedInstances = this.workflowService.getWorkflowsForContent(childAssoc.getChildRef(), false);
        WorkflowServiceImplTest.assertNotNull(completedInstances);
        WorkflowServiceImplTest.assertEquals((int)0, (int)completedInstances.size());
    }

    public void testGetWorkflowTaskDefinitions() {
        List<WorkflowDefinition> workflowDefs = this.workflowService.getDefinitions();
        WorkflowServiceImplTest.assertNotNull(workflowDefs);
        WorkflowServiceImplTest.assertTrue((workflowDefs.size() > 0 ? 1 : 0) != 0);
        for (WorkflowDefinition workflowDef : workflowDefs) {
            List<WorkflowTaskDefinition> workflowTaskDefs = this.workflowService.getTaskDefinitions(workflowDef.getId());
            WorkflowServiceImplTest.assertNotNull(workflowTaskDefs);
            WorkflowServiceImplTest.assertTrue((workflowTaskDefs.size() > 0 ? 1 : 0) != 0);
        }
    }

    public void testTaskCapabilities() {
        this.personManager.setUser(USER1);
        WorkflowDefinition workflowDef = this.workflowService.getDefinitionByName("jbpm$wf:adhoc");
        WorkflowServiceImplTest.assertNotNull((Object)workflowDef);
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        NodeRef wfPackage = this.workflowService.createPackage(null);
        params.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)wfPackage);
        Date dueDate = new Date();
        params.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_WORKFLOW_PRIORITY, Integer.valueOf(1));
        NodeRef assignee = this.personService.getPerson(USER2);
        params.put(WorkflowModel.ASSOC_ASSIGNEE, (Serializable)assignee);
        WorkflowPath path = this.workflowService.startWorkflow(workflowDef.getId(), params);
        WorkflowServiceImplTest.assertNotNull((Object)path);
        WorkflowServiceImplTest.assertTrue((boolean)path.isActive());
        String workflowInstanceId = path.getInstance().getId();
        List<WorkflowTask> tasks = this.workflowService.getTasksForWorkflowPath(path.getId());
        WorkflowServiceImplTest.assertEquals((int)1, (int)tasks.size());
        WorkflowTask startTask = tasks.get(0);
        String startTaskId = startTask.getId();
        this.workflowService.endTask(startTaskId, null);
        startTask = this.workflowService.getTaskById(startTaskId);
        WorkflowServiceImplTest.assertNotNull((Object)startTask);
        WorkflowServiceImplTest.assertEquals((Object)((Object)startTask.getState()), (Object)((Object)WorkflowTaskState.COMPLETED));
        WorkflowServiceImplTest.assertFalse((boolean)this.workflowService.isTaskClaimable(startTask, USER1));
        WorkflowServiceImplTest.assertFalse((boolean)this.workflowService.isTaskEditable(startTask, USER1));
        WorkflowServiceImplTest.assertFalse((boolean)this.workflowService.isTaskReassignable(startTask, USER1));
        WorkflowServiceImplTest.assertFalse((boolean)this.workflowService.isTaskReleasable(startTask, USER1));
        List<WorkflowPath> paths = this.workflowService.getWorkflowPaths(workflowInstanceId);
        WorkflowServiceImplTest.assertNotNull(paths);
        WorkflowServiceImplTest.assertEquals((int)1, (int)paths.size());
        tasks = this.workflowService.getTasksForWorkflowPath(path.getId());
        WorkflowServiceImplTest.assertEquals((int)1, (int)tasks.size());
        WorkflowTask currentTask = tasks.get(0);
        WorkflowServiceImplTest.assertEquals((Object)((Object)currentTask.getState()), (Object)((Object)WorkflowTaskState.IN_PROGRESS));
        WorkflowServiceImplTest.assertEquals((Object)currentTask.getProperties().get(ContentModel.PROP_OWNER), (Object)USER2);
        WorkflowServiceImplTest.assertFalse((boolean)this.workflowService.isTaskClaimable(currentTask, USER1));
        WorkflowServiceImplTest.assertFalse((boolean)this.workflowService.isTaskClaimable(currentTask, USER2));
        WorkflowServiceImplTest.assertFalse((boolean)this.workflowService.isTaskClaimable(currentTask, USER3));
        WorkflowServiceImplTest.assertFalse((boolean)this.workflowService.isTaskReleasable(currentTask, USER1));
        WorkflowServiceImplTest.assertFalse((boolean)this.workflowService.isTaskReleasable(currentTask, USER2));
        WorkflowServiceImplTest.assertFalse((boolean)this.workflowService.isTaskReleasable(currentTask, USER3));
        WorkflowServiceImplTest.assertTrue((boolean)this.workflowService.isTaskEditable(currentTask, USER1));
        WorkflowServiceImplTest.assertTrue((boolean)this.workflowService.isTaskEditable(currentTask, USER2));
        WorkflowServiceImplTest.assertTrue((boolean)this.workflowService.isTaskReassignable(currentTask, USER1));
        WorkflowServiceImplTest.assertTrue((boolean)this.workflowService.isTaskReassignable(currentTask, USER2));
        WorkflowServiceImplTest.assertFalse((boolean)this.workflowService.isTaskEditable(currentTask, USER3));
        WorkflowServiceImplTest.assertFalse((boolean)this.workflowService.isTaskReassignable(currentTask, USER3));
        this.workflowService.cancelWorkflow(workflowInstanceId);
        WorkflowServiceImplTest.assertNull((Object)this.workflowService.getWorkflowById(workflowInstanceId));
    }

    public void testPooledTaskCapabilities() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        WorkflowDefinition workflowDef = this.workflowService.getDefinitionByName("jbpm$wf:reviewpooled");
        WorkflowServiceImplTest.assertNotNull((Object)workflowDef);
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        NodeRef wfPackage = this.workflowService.createPackage(null);
        params.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)wfPackage);
        Date dueDate = new Date();
        params.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_WORKFLOW_PRIORITY, Integer.valueOf(1));
        NodeRef group = this.findGroup(GROUP);
        WorkflowServiceImplTest.assertNotNull((Object)group);
        params.put(WorkflowModel.ASSOC_GROUP_ASSIGNEE, (Serializable)group);
        WorkflowPath path = this.workflowService.startWorkflow(workflowDef.getId(), params);
        WorkflowServiceImplTest.assertNotNull((Object)path);
        WorkflowServiceImplTest.assertTrue((boolean)path.isActive());
        String workflowInstanceId = path.getInstance().getId();
        List<WorkflowTask> tasks = this.workflowService.getTasksForWorkflowPath(path.getId());
        WorkflowServiceImplTest.assertEquals((int)1, (int)tasks.size());
        WorkflowTask startTask = tasks.get(0);
        String startTaskId = startTask.getId();
        this.workflowService.endTask(startTaskId, null);
        List<WorkflowPath> paths = this.workflowService.getWorkflowPaths(workflowInstanceId);
        WorkflowServiceImplTest.assertNotNull(paths);
        WorkflowServiceImplTest.assertEquals((int)1, (int)paths.size());
        tasks = this.workflowService.getTasksForWorkflowPath(path.getId());
        WorkflowServiceImplTest.assertEquals((int)1, (int)tasks.size());
        WorkflowTask currentTask = tasks.get(0);
        WorkflowServiceImplTest.assertEquals((Object)((Object)currentTask.getState()), (Object)((Object)WorkflowTaskState.IN_PROGRESS));
        WorkflowServiceImplTest.assertNull((Object)currentTask.getProperties().get(ContentModel.PROP_OWNER));
        WorkflowServiceImplTest.assertFalse((boolean)this.workflowService.isTaskReassignable(currentTask, USER1));
        WorkflowServiceImplTest.assertFalse((boolean)this.workflowService.isTaskReassignable(currentTask, USER2));
        WorkflowServiceImplTest.assertFalse((boolean)this.workflowService.isTaskReassignable(currentTask, USER3));
        WorkflowServiceImplTest.assertFalse((boolean)this.workflowService.isTaskReleasable(currentTask, USER1));
        WorkflowServiceImplTest.assertFalse((boolean)this.workflowService.isTaskReleasable(currentTask, USER2));
        WorkflowServiceImplTest.assertFalse((boolean)this.workflowService.isTaskReleasable(currentTask, USER3));
        WorkflowServiceImplTest.assertTrue((boolean)this.workflowService.isTaskClaimable(currentTask, USER1));
        WorkflowServiceImplTest.assertTrue((boolean)this.workflowService.isTaskClaimable(currentTask, USER2));
        WorkflowServiceImplTest.assertFalse((boolean)this.workflowService.isTaskClaimable(currentTask, USER3));
        WorkflowServiceImplTest.assertTrue((boolean)this.workflowService.isTaskEditable(currentTask, USER1));
        WorkflowServiceImplTest.assertTrue((boolean)this.workflowService.isTaskEditable(currentTask, USER2));
        WorkflowServiceImplTest.assertFalse((boolean)this.workflowService.isTaskEditable(currentTask, USER3));
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(8);
        properties.put(ContentModel.PROP_OWNER, (Serializable)((Object)USER1));
        this.workflowService.updateTask(currentTask.getId(), properties, null, null);
        currentTask = this.workflowService.getTaskById(currentTask.getId());
        WorkflowServiceImplTest.assertFalse((boolean)this.workflowService.isTaskClaimable(currentTask, USER1));
        WorkflowServiceImplTest.assertTrue((boolean)this.workflowService.isTaskReleasable(currentTask, USER1));
        WorkflowServiceImplTest.assertTrue((boolean)this.workflowService.isTaskEditable(currentTask, USER1));
        WorkflowServiceImplTest.assertFalse((boolean)this.workflowService.isTaskReassignable(currentTask, USER1));
        WorkflowServiceImplTest.assertFalse((boolean)this.workflowService.isTaskClaimable(currentTask, USER2));
        WorkflowServiceImplTest.assertFalse((boolean)this.workflowService.isTaskEditable(currentTask, USER2));
        this.workflowService.cancelWorkflow(workflowInstanceId);
        WorkflowServiceImplTest.assertNull((Object)this.workflowService.getWorkflowById(workflowInstanceId));
    }
}

