/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.workflow.BPMEngineRegistry;
import org.alfresco.repo.workflow.TaskComponent;
import org.alfresco.repo.workflow.WorkflowComponent;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.springframework.core.io.ClassPathResource;

public class NodeListConverterTest
extends BaseSpringTest {
    AuthenticationComponent authenticationComponent;
    PersonService personService;
    WorkflowComponent workflowComponent;
    TaskComponent taskComponent;
    WorkflowDefinition testWorkflowDef;
    NodeRef testNodeRef;
    private static String taskId = null;

    protected void onSetUpInTransaction() throws Exception {
        this.personService = (PersonService)this.applicationContext.getBean("personService");
        BPMEngineRegistry registry = (BPMEngineRegistry)this.applicationContext.getBean("bpm_engineRegistry");
        this.workflowComponent = registry.getWorkflowComponent("jbpm");
        this.taskComponent = registry.getTaskComponent("jbpm");
        ClassPathResource processDef = new ClassPathResource("alfresco/workflow/review_processdefinition.xml");
        WorkflowDeployment deployment = this.workflowComponent.deployDefinition(processDef.getInputStream(), "text/xml");
        this.testWorkflowDef = deployment.definition;
        NodeListConverterTest.assertNotNull((Object)this.testWorkflowDef);
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        NodeService nodeService = (NodeService)this.applicationContext.getBean(ServiceRegistry.NODE_SERVICE.getLocalName());
        this.testNodeRef = nodeService.getRootNode(new StoreRef("workspace", "SpacesStore"));
    }

    public void testStep1Start() {
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        params.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)this.testNodeRef);
        Date reviewDueDate = new Date();
        params.put(QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"reviewDueDate"), reviewDueDate);
        NodeRef reviewer = this.personService.getPerson(AuthenticationUtil.getAdminUserName());
        params.put(QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"reviewer"), (Serializable)reviewer);
        WorkflowPath path = this.workflowComponent.startWorkflow(this.testWorkflowDef.id, params);
        NodeListConverterTest.assertNotNull((Object)path);
        List<WorkflowTask> tasks1 = this.workflowComponent.getTasksForWorkflowPath(path.id);
        NodeListConverterTest.assertNotNull(tasks1);
        NodeListConverterTest.assertEquals((int)1, (int)tasks1.size());
        this.setComplete();
        taskId = tasks1.get((int)0).id;
    }

    public void testSetNodeRefList() {
        ArrayList<NodeRef> nodeRefs = new ArrayList<NodeRef>();
        nodeRefs.add(this.testNodeRef);
        nodeRefs.add(this.testNodeRef);
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        params.put(WorkflowModel.PROP_COMPLETED_ITEMS, nodeRefs);
        WorkflowTask task = this.taskComponent.getTaskById(taskId);
        NodeListConverterTest.assertNull((Object)task.properties.get(WorkflowModel.PROP_COMPLETED_ITEMS));
        WorkflowTask updatedTask = this.taskComponent.updateTask(taskId, params, null, null);
        NodeListConverterTest.assertNotNull((Object)updatedTask);
        NodeListConverterTest.assertTrue((boolean)updatedTask.properties.containsKey(WorkflowModel.PROP_COMPLETED_ITEMS));
        NodeListConverterTest.assertEquals((int)2, (int)((List)((Object)updatedTask.properties.get(WorkflowModel.PROP_COMPLETED_ITEMS))).size());
        this.setComplete();
    }

    public void testUpdateNodeRefList() {
        ArrayList nodeRefs = new ArrayList();
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        params.put(WorkflowModel.PROP_COMPLETED_ITEMS, nodeRefs);
        WorkflowTask updatedTask = this.taskComponent.updateTask(taskId, params, null, null);
        NodeListConverterTest.assertNotNull((Object)updatedTask);
        NodeListConverterTest.assertTrue((boolean)updatedTask.properties.containsKey(WorkflowModel.PROP_COMPLETED_ITEMS));
        NodeListConverterTest.assertEquals((int)0, (int)((List)((Object)updatedTask.properties.get(WorkflowModel.PROP_COMPLETED_ITEMS))).size());
        this.setComplete();
    }
}

