/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jscript;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.alfresco.repo.jscript.ValueConverter;
import org.alfresco.repo.workflow.jscript.JscriptWorkflowPath;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.mozilla.javascript.Scriptable;

public class JscriptWorkflowInstance
implements Serializable {
    static final long serialVersionUID = 1015996328908978487L;
    private final ServiceRegistry serviceRegistry;
    private final Scriptable scope;
    private final String id;
    private final String description;
    private final Date startDate;
    private final Date endDate;
    private final boolean active;

    public JscriptWorkflowInstance(String id, String description, Date startDate, ServiceRegistry serviceRegistry, Scriptable scope) {
        this.id = id;
        this.description = description;
        this.active = true;
        this.startDate = startDate;
        this.endDate = null;
        this.serviceRegistry = serviceRegistry;
        this.scope = scope;
    }

    public JscriptWorkflowInstance(WorkflowInstance cmrWorkflowInstance, ServiceRegistry serviceRegistry, Scriptable scope) {
        this.id = cmrWorkflowInstance.id;
        this.description = cmrWorkflowInstance.description;
        this.active = cmrWorkflowInstance.active;
        this.startDate = cmrWorkflowInstance.startDate;
        this.endDate = cmrWorkflowInstance.endDate;
        this.serviceRegistry = serviceRegistry;
        this.scope = scope;
    }

    public Scriptable getPaths() {
        WorkflowService workflowService = this.serviceRegistry.getWorkflowService();
        List<WorkflowPath> cmrPaths = workflowService.getWorkflowPaths(this.id);
        ArrayList<JscriptWorkflowPath> paths = new ArrayList<JscriptWorkflowPath>();
        for (WorkflowPath cmrPath : cmrPaths) {
            paths.add(new JscriptWorkflowPath(cmrPath, this.serviceRegistry, this.scope));
        }
        Scriptable pathsScriptable = (Scriptable)new ValueConverter().convertValueForScript(this.serviceRegistry, this.scope, null, paths);
        return pathsScriptable;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isActive() {
        return this.active;
    }

    public Scriptable getStartDate() {
        return (Scriptable)new ValueConverter().convertValueForScript(this.serviceRegistry, this.scope, null, this.startDate);
    }

    public Scriptable getEndDate() {
        return (Scriptable)new ValueConverter().convertValueForScript(this.serviceRegistry, this.scope, null, this.endDate);
    }

    public void cancel() {
        this.serviceRegistry.getWorkflowService().cancelWorkflow(this.id);
    }

    public void delete() {
        this.serviceRegistry.getWorkflowService().deleteWorkflow(this.id);
    }
}

