/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.filefolder.FileFolderServiceImpl;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.config.RepositoryPathConfigBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryFolderConfigBean
extends RepositoryPathConfigBean {
    private List<String> folderPath = Collections.emptyList();

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Folder Path: ").append(super.getStoreRef()).append(super.getRootPath());
        for (String folder : this.folderPath) {
            sb.append("/").append(folder);
        }
        return sb.toString();
    }

    public List<String> getFolderNames() {
        return this.folderPath;
    }

    public String getFolderPath() {
        StringBuilder sb = new StringBuilder(56);
        for (String pathElement : this.folderPath) {
            sb.append("/").append(pathElement);
        }
        return sb.toString();
    }

    public void setFolderPath(String folderPath) {
        if (!PropertyCheck.isValidPropertyString((String)folderPath)) {
            folderPath = "";
        }
        this.folderPath = new ArrayList<String>(5);
        StringTokenizer tokenizer = new StringTokenizer(folderPath, "/");
        while (tokenizer.hasMoreTokens()) {
            String folderName = tokenizer.nextToken();
            if (folderName.length() == 0) {
                throw new IllegalArgumentException("Invalid folder name path for property 'folderPath': " + folderPath);
            }
            this.folderPath.add(folderName);
        }
    }

    public NodeRef getFolderPath(NamespaceService namespaceService, NodeService nodeService, SearchService searchService, FileFolderService fileFolderService) {
        NodeRef pathStartNodeRef = super.resolveNodePath(namespaceService, nodeService, searchService);
        if (pathStartNodeRef == null) {
            throw new AlfrescoRuntimeException("Folder path resolution requires an existing base path. \n   Base path: " + this.getRootPath());
        }
        if (this.folderPath.size() == 0) {
            return pathStartNodeRef;
        }
        try {
            FileInfo folderInfo = fileFolderService.resolveNamePath(pathStartNodeRef, this.folderPath);
            if (!folderInfo.isFolder()) {
                throw new AlfrescoRuntimeException("Not a folder: " + this);
            }
            return folderInfo.getNodeRef();
        }
        catch (FileNotFoundException e) {
            throw new AlfrescoRuntimeException("Folder not found: " + this);
        }
    }

    public NodeRef getOrCreateFolderPath(NamespaceService namespaceService, NodeService nodeService, SearchService searchService, FileFolderService fileFolderService) {
        NodeRef pathStartNodeRef = super.resolveNodePath(namespaceService, nodeService, searchService);
        if (pathStartNodeRef == null) {
            throw new AlfrescoRuntimeException("Folder path resolution requires an existing base path. \n   Base path: " + this.getRootPath());
        }
        if (this.folderPath.size() == 0) {
            return pathStartNodeRef;
        }
        FileInfo folderInfo = FileFolderServiceImpl.makeFolders(fileFolderService, pathStartNodeRef, this.folderPath, ContentModel.TYPE_FOLDER);
        return folderInfo.getNodeRef();
    }
}

