/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.remote;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import org.alfresco.util.remote.server.RemoteInputStreamServer;
import org.alfresco.util.remote.server.RmiRemoteInputStreamServer;

public class RemotableInputStream
extends InputStream
implements Serializable {
    private static final long serialVersionUID = 2434858590717000057L;
    private int port;
    private String host;
    private String name;
    private transient RemoteInputStreamServer inputStreamServer;

    public RemotableInputStream(String host, int port, InputStream inputStream) {
        this.host = host;
        this.port = port;
        this.inputStreamServer = new RmiRemoteInputStreamServer(inputStream);
    }

    public void close() throws IOException {
        this.inputStreamServer.close();
    }

    public int read() throws IOException {
        return this.inputStreamServer.read();
    }

    public int read(byte[] bytes) throws IOException {
        return this.inputStreamServer.read(bytes);
    }

    public int read(byte[] bytes, int off, int len) throws IOException {
        return this.inputStreamServer.read(bytes, off, len);
    }

    public long skip(long n) throws IOException {
        return this.inputStreamServer.skip(n);
    }

    public int available() throws IOException {
        return this.inputStreamServer.available();
    }

    public void mark(int readlimit) {
        this.inputStreamServer.mark(readlimit);
    }

    public boolean markSupported() {
        return this.inputStreamServer.markSupported();
    }

    public void reset() throws IOException {
        this.inputStreamServer.reset();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.name = this.inputStreamServer.start(this.host, this.port);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.inputStreamServer = RmiRemoteInputStreamServer.obtain(this.host, this.port, this.name);
    }

    public static void main(String[] args) throws Exception {
        RemotableInputStream remotableInputStream = new RemotableInputStream(InetAddress.getLocalHost().getHostName(), 7777, new ByteArrayInputStream("test".getBytes()));
        int b = -1;
        while ((b = remotableInputStream.read()) != -1) {
            System.out.println((char)b);
        }
        remotableInputStream = new RemotableInputStream(InetAddress.getLocalHost().getHostName(), 7777, new ByteArrayInputStream("test".getBytes()));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(remotableInputStream);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        remotableInputStream = (RemotableInputStream)ois.readObject();
        int b2 = -1;
        while ((b2 = remotableInputStream.read()) != -1) {
            System.out.println((char)b2);
        }
        remotableInputStream.close();
    }
}

