/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.remote.server;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.UUID;
import org.alfresco.util.remote.server.AbstractRemoteInputStreamServer;
import org.alfresco.util.remote.server.RemoteInputStreamServer;
import org.springframework.remoting.rmi.RmiProxyFactoryBean;
import org.springframework.remoting.rmi.RmiServiceExporter;

public class RmiRemoteInputStreamServer
extends AbstractRemoteInputStreamServer {
    private RmiServiceExporter rmiServiceExporter;

    public RmiRemoteInputStreamServer(InputStream inputStream) {
        super(inputStream);
    }

    public String start(String host, int port) throws RemoteException {
        String name = this.inputStream.getClass().getName() + UUID.randomUUID();
        this.rmiServiceExporter = new RmiServiceExporter();
        this.rmiServiceExporter.setServiceName(name);
        this.rmiServiceExporter.setRegistryPort(port);
        this.rmiServiceExporter.setRegistryHost(host);
        this.rmiServiceExporter.setServiceInterface(RemoteInputStreamServer.class);
        this.rmiServiceExporter.setService((Object)this);
        this.rmiServiceExporter.afterPropertiesSet();
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws IOException {
        try {
            this.inputStream.close();
            Object var2_1 = null;
            if (this.rmiServiceExporter == null) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.rmiServiceExporter == null) throw throwable;
            try {
                this.rmiServiceExporter.destroy();
                throw throwable;
            }
            catch (Throwable e) {
                throw new IOException(e.getMessage());
            }
        }
        try {
            this.rmiServiceExporter.destroy();
            return;
        }
        catch (Throwable e) {
            throw new IOException(e.getMessage());
        }
    }

    public static RemoteInputStreamServer obtain(String host, int port, String name) throws RemoteException {
        RmiProxyFactoryBean rmiProxyFactoryBean = new RmiProxyFactoryBean();
        rmiProxyFactoryBean.setServiceUrl("rmi://" + host + ":" + port + "/" + name);
        rmiProxyFactoryBean.setServiceInterface(RemoteInputStreamServer.class);
        rmiProxyFactoryBean.setRefreshStubOnConnectFailure(true);
        try {
            rmiProxyFactoryBean.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new RemoteException("Error create rmi proxy");
        }
        return (RemoteInputStreamServer)rmiProxyFactoryBean.getObject();
    }
}

