/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.asset;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.namespace.QName;
import org.alfresco.wcm.AbstractWCMServiceImplTest;
import org.alfresco.wcm.asset.AssetInfo;
import org.alfresco.wcm.sandbox.SandboxInfo;
import org.alfresco.wcm.webproject.WebProjectInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AssetServiceImplTest
extends AbstractWCMServiceImplTest {
    private static Log logger = LogFactory.getLog(AssetServiceImplTest.class);
    private static final String PREFIX = "created-by-admin-";
    private static final String FILE = "This is file1 - admin";

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private void checkAssetInfo(AssetInfo assetInfo, String expectedName, String expectedPath, String expectedCreator, boolean expectedIsFile, boolean expectedIsFolder, boolean expectedIsDeleted, boolean expectedIsLocked, String expectedLockOwner) {
        AssetServiceImplTest.assertNotNull((Object)assetInfo);
        AssetServiceImplTest.assertEquals((String)expectedName, (String)assetInfo.getName());
        AssetServiceImplTest.assertEquals((String)expectedPath, (String)assetInfo.getPath());
        AssetServiceImplTest.assertEquals((String)expectedCreator, (String)assetInfo.getCreator());
        AssetServiceImplTest.assertEquals((boolean)expectedIsFile, (boolean)assetInfo.isFile());
        AssetServiceImplTest.assertEquals((boolean)expectedIsFolder, (boolean)assetInfo.isFolder());
        AssetServiceImplTest.assertEquals((boolean)expectedIsDeleted, (boolean)assetInfo.isDeleted());
        AssetServiceImplTest.assertNotNull((Object)assetInfo.getCreatedDate());
        AssetServiceImplTest.assertEquals((boolean)expectedIsLocked, (boolean)assetInfo.isLocked());
        AssetServiceImplTest.assertEquals((String)expectedLockOwner, (String)assetInfo.getLockOwner());
    }

    public void testSimple() {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-assetSimple", TEST_WEBPROJ_NAME + "-assetSimple", "This is my title", "This is my description", "ROOT", false, null);
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpInfo.getStoreId());
        String sbStoreId = sbInfo.getSandboxId();
        String path = sbInfo.getSandboxRootPath() + "/" + wpInfo.getDefaultWebApp();
        this.assetService.createFolder(sbStoreId, path, "myFolder1", null);
        this.assetService.createFile(sbStoreId, path + "/myFolder1", "myFile1", null);
        AssetInfo myFolder1Asset = this.assetService.getAsset(sbStoreId, path + "/myFolder1");
        this.checkAssetInfo(myFolder1Asset, "myFolder1", path + "/myFolder1", AuthenticationUtil.getAdminUserName(), false, true, false, false, null);
        AssetInfo myFile1Asset = this.assetService.getAsset(sbStoreId, path + "/myFolder1/myFile1");
        this.checkAssetInfo(myFile1Asset, "myFile1", path + "/myFolder1/myFile1", AuthenticationUtil.getAdminUserName(), true, false, false, true, AuthenticationUtil.getAdminUserName());
        this.assetService.deleteAsset(myFolder1Asset);
        myFolder1Asset = this.assetService.getAsset(sbStoreId, -1, path + "/myFolder1", true);
        AssetServiceImplTest.assertNull((Object)myFolder1Asset);
        myFile1Asset = this.assetService.getAsset(sbStoreId, -1, path + "/myFolder1/myFile1", true);
        AssetServiceImplTest.assertNull((Object)myFile1Asset);
    }

    public void testCRUD() throws IOException {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-crud", TEST_WEBPROJ_NAME + "-crud", "This is my title", "This is my description", "ROOT", false, null);
        String defaultWebApp = wpInfo.getDefaultWebApp();
        this.wpService.inviteWebUser(wpInfo.getStoreId(), USER_ONE, "ContentManager", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpInfo.getStoreId());
        String sbStoreId = sbInfo.getSandboxId();
        String path = sbInfo.getSandboxRootPath() + "/" + defaultWebApp;
        AssetServiceImplTest.assertNull((Object)this.assetService.getAsset(sbStoreId, path + "/myFolder1"));
        AssetServiceImplTest.assertNull((Object)this.assetService.getAsset(sbStoreId, path + "/myFile1"));
        AssetServiceImplTest.assertNull((Object)this.assetService.getAsset(sbStoreId, path + "/myFolder1/myFile2"));
        AssetServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(sbStoreId, path, false).size());
        this.assetService.createFolder(sbStoreId, path, "myFolder1", null);
        AssetServiceImplTest.assertEquals((int)1, (int)this.assetService.listAssets(sbStoreId, path, false).size());
        AssetServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(sbStoreId, path + "/myFolder1", false).size());
        String MYFILE1 = "This is myFile1";
        ContentWriter writer = this.assetService.createFile(sbStoreId, path, "myFile1", null);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is myFile1");
        AssetServiceImplTest.assertEquals((int)2, (int)this.assetService.listAssets(sbStoreId, path, false).size());
        String MYFILE2 = "This is myFile2";
        writer = this.assetService.createFile(sbStoreId, path + "/myFolder1", "myFile2", null);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is myFile2");
        AssetServiceImplTest.assertEquals((int)1, (int)this.assetService.listAssets(sbStoreId, path + "/myFolder1", false).size());
        AssetInfo myFolder1Asset = this.assetService.getAsset(sbStoreId, path + "/myFolder1");
        this.checkAssetInfo(myFolder1Asset, "myFolder1", path + "/myFolder1", USER_ONE, false, true, false, false, null);
        AssetInfo myFile1Asset = this.assetService.getAsset(sbStoreId, path + "/myFile1");
        this.checkAssetInfo(myFile1Asset, "myFile1", path + "/myFile1", USER_ONE, true, false, false, true, USER_ONE);
        ContentReader reader = this.assetService.getContentReader(myFile1Asset);
        InputStream in = reader.getContentInputStream();
        byte[] buff = new byte[1024];
        in.read(buff);
        in.close();
        AssetServiceImplTest.assertEquals((String)"This is myFile1", (String)new String(buff, 0, "This is myFile1".length()));
        AssetInfo myFile2Asset = this.assetService.getAsset(sbStoreId, path + "/myFolder1/myFile2");
        this.checkAssetInfo(myFile2Asset, "myFile2", path + "/myFolder1/myFile2", USER_ONE, true, false, false, true, USER_ONE);
        reader = this.assetService.getContentReader(myFile2Asset);
        in = reader.getContentInputStream();
        buff = new byte[1024];
        in.read(buff);
        in.close();
        AssetServiceImplTest.assertEquals((String)"This is myFile2", (String)new String(buff, 0, "This is myFile2".length()));
        String MYFILE2_MODIFIED = "This is myFile2 ... modified";
        writer = this.assetService.getContentWriter(myFile2Asset);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is myFile2 ... modified");
        reader = this.assetService.getContentReader(myFile2Asset);
        in = reader.getContentInputStream();
        buff = new byte[1024];
        in.read(buff);
        in.close();
        AssetServiceImplTest.assertEquals((String)"This is myFile2 ... modified", (String)new String(buff, 0, "This is myFile2 ... modified".length()));
        this.assetService.deleteAsset(myFile1Asset);
        this.assetService.deleteAsset(myFolder1Asset);
        myFolder1Asset = this.assetService.getAsset(sbStoreId, -1, path + "/myFolder1", true);
        this.checkAssetInfo(myFolder1Asset, "myFolder1", path + "/myFolder1", USER_ONE, false, true, true, false, null);
        myFile1Asset = this.assetService.getAsset(sbStoreId, -1, path + "/myFile1", true);
        AssetServiceImplTest.assertNull((Object)myFile1Asset);
        myFile2Asset = this.assetService.getAsset(sbStoreId, -1, path + "/myFolder1/myFile2", true);
        AssetServiceImplTest.assertNull((Object)myFile2Asset);
        AssetServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(sbStoreId, path, false).size());
        try {
            AssetServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(sbStoreId, path + "/myFolder1", false).size());
            AssetServiceImplTest.fail((String)"Cannot list assets within non-existant folder");
        }
        catch (AVMNotFoundException nfe) {
            // empty catch block
        }
    }

    public void testCRUDinWebApp() throws IOException {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-crudwebapp", TEST_WEBPROJ_NAME + "-crudwebapp", "This is my title", "This is my description", "ROOT", false, null);
        String myWebApp1 = "myWebApp1";
        this.wpService.createWebApp(wpInfo.getStoreId(), myWebApp1, null);
        this.wpService.inviteWebUser(wpInfo.getStoreId(), USER_ONE, "ContentManager", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpInfo.getStoreId());
        String sbStoreId = sbInfo.getSandboxId();
        AssetServiceImplTest.assertNull((Object)this.assetService.getAssetWebApp(sbStoreId, myWebApp1, "/myFolder1"));
        AssetServiceImplTest.assertNull((Object)this.assetService.getAssetWebApp(sbStoreId, myWebApp1, "/myFile1"));
        AssetServiceImplTest.assertNull((Object)this.assetService.getAssetWebApp(sbStoreId, myWebApp1, "/myFolder1/myFile2"));
        AssetServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssetsWebApp(sbStoreId, myWebApp1, "/", false).size());
        this.assetService.createFolderWebApp(sbStoreId, myWebApp1, "/", "myFolder1");
        AssetServiceImplTest.assertEquals((int)1, (int)this.assetService.listAssetsWebApp(sbStoreId, myWebApp1, "/", false).size());
        AssetServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssetsWebApp(sbStoreId, myWebApp1, "/myFolder1", false).size());
        String MYFILE1 = "This is myFile1";
        ContentWriter writer = this.assetService.createFileWebApp(sbStoreId, myWebApp1, "/", "myFile1");
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is myFile1");
        AssetServiceImplTest.assertEquals((int)2, (int)this.assetService.listAssetsWebApp(sbStoreId, myWebApp1, "/", false).size());
        String MYFILE2 = "This is myFile2";
        writer = this.assetService.createFileWebApp(sbStoreId, myWebApp1, "/myFolder1", "myFile2");
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is myFile2");
        AssetServiceImplTest.assertEquals((int)1, (int)this.assetService.listAssetsWebApp(sbStoreId, myWebApp1, "/myFolder1", false).size());
        String path = sbInfo.getSandboxRootPath() + "/" + myWebApp1;
        AssetInfo myFolder1Asset = this.assetService.getAssetWebApp(sbStoreId, myWebApp1, "/myFolder1");
        this.checkAssetInfo(myFolder1Asset, "myFolder1", path + "/myFolder1", USER_ONE, false, true, false, false, null);
        AssetInfo myFile1Asset = this.assetService.getAssetWebApp(sbStoreId, myWebApp1, "/myFile1");
        this.checkAssetInfo(myFile1Asset, "myFile1", path + "/myFile1", USER_ONE, true, false, false, true, USER_ONE);
        ContentReader reader = this.assetService.getContentReader(myFile1Asset);
        InputStream in = reader.getContentInputStream();
        byte[] buff = new byte[1024];
        in.read(buff);
        in.close();
        AssetServiceImplTest.assertEquals((String)"This is myFile1", (String)new String(buff, 0, "This is myFile1".length()));
        AssetInfo myFile2Asset = this.assetService.getAssetWebApp(sbStoreId, myWebApp1, "/myFolder1/myFile2");
        this.checkAssetInfo(myFile2Asset, "myFile2", path + "/myFolder1/myFile2", USER_ONE, true, false, false, true, USER_ONE);
        reader = this.assetService.getContentReader(myFile2Asset);
        in = reader.getContentInputStream();
        buff = new byte[1024];
        in.read(buff);
        in.close();
        AssetServiceImplTest.assertEquals((String)"This is myFile2", (String)new String(buff, 0, "This is myFile2".length()));
        String MYFILE2_MODIFIED = "This is myFile2 ... modified";
        writer = this.assetService.getContentWriter(myFile2Asset);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is myFile2 ... modified");
        reader = this.assetService.getContentReader(myFile2Asset);
        in = reader.getContentInputStream();
        buff = new byte[1024];
        in.read(buff);
        in.close();
        AssetServiceImplTest.assertEquals((String)"This is myFile2 ... modified", (String)new String(buff, 0, "This is myFile2 ... modified".length()));
        this.assetService.deleteAsset(myFile1Asset);
        this.assetService.deleteAsset(myFolder1Asset);
        myFolder1Asset = this.assetService.getAssetWebApp(sbStoreId, myWebApp1, "/myFolder1", true);
        this.checkAssetInfo(myFolder1Asset, "myFolder1", path + "/myFolder1", USER_ONE, false, true, true, false, null);
        myFile1Asset = this.assetService.getAssetWebApp(sbStoreId, myWebApp1, "/myFile1", true);
        AssetServiceImplTest.assertNull((Object)myFile1Asset);
        myFile2Asset = this.assetService.getAssetWebApp(sbStoreId, myWebApp1, "/myFolder1/myFile2", true);
        AssetServiceImplTest.assertNull((Object)myFile2Asset);
        AssetServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssetsWebApp(sbStoreId, myWebApp1, "/", false).size());
        try {
            AssetServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssetsWebApp(sbStoreId, myWebApp1, "/myFolder1", false).size());
            AssetServiceImplTest.fail((String)"Cannot list assets within non-existant folder");
        }
        catch (AVMNotFoundException nfe) {
            // empty catch block
        }
    }

    public void testCRUDforRoles() throws IOException, InterruptedException {
        String[] users;
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-crudroles", TEST_WEBPROJ_NAME + "-crudroles", "This is my title", "This is my description", "ROOT", false, null);
        String wpStoreId = wpInfo.getStoreId();
        String defaultWebApp = wpInfo.getDefaultWebApp();
        String stagingStoreId = wpInfo.getStagingStoreName();
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
        String sbStoreId = sbInfo.getSandboxId();
        for (String user : users = new String[]{USER_ONE, USER_TWO, USER_THREE, USER_FOUR}) {
            this.assetService.createFolderWebApp(sbStoreId, defaultWebApp, "/", PREFIX + user);
            ContentWriter writer = this.assetService.createFileWebApp(sbStoreId, defaultWebApp, "/created-by-admin-" + user, "fileA");
            writer.setMimetype("text/plain");
            writer.setEncoding("UTF-8");
            writer.putContent(FILE);
        }
        this.sbService.submitWebApp(sbStoreId, defaultWebApp, "some existing folders and files", null);
        this.pollForSnapshotCount(stagingStoreId, 1);
        this.runCRUDforRoles(USER_ONE, "ContentManager", wpStoreId, defaultWebApp, true, true, true);
        this.runCRUDforRoles(USER_TWO, "ContentPublisher", wpStoreId, defaultWebApp, true, true, false);
        this.runCRUDforRoles(USER_THREE, "ContentReviewer", wpStoreId, defaultWebApp, false, true, false);
        this.runCRUDforRoles(USER_FOUR, "ContentContributor", wpStoreId, defaultWebApp, true, false, false);
    }

    private void runCRUDforRoles(String user, String role, String wpStoreId, String defaultWebApp, boolean canCreate, boolean canUpdateExisting, boolean canDeleteExisting) throws IOException, InterruptedException {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.wpService.inviteWebUser(wpStoreId, user, role, true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)user);
        String stagingStoreId = this.sbService.getStagingSandbox(wpStoreId).getSandboxId();
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
        String sbStoreId = sbInfo.getSandboxId();
        String path = sbInfo.getSandboxRootPath() + "/" + defaultWebApp;
        if (canCreate) {
            this.assetService.createFolderWebApp(sbStoreId, defaultWebApp, "/", user);
            String MYFILE1 = "This is myFile1 - " + user;
            ContentWriter writer = this.assetService.createFileWebApp(sbStoreId, defaultWebApp, "/" + user, "fileA");
            writer.setMimetype("text/plain");
            writer.setEncoding("UTF-8");
            writer.putContent(MYFILE1);
            AssetServiceImplTest.assertEquals((int)1, (int)this.assetService.listAssetsWebApp(sbStoreId, defaultWebApp, "/" + user, false).size());
            AssetInfo myFolder1Asset = this.assetService.getAssetWebApp(sbStoreId, defaultWebApp, "/" + user);
            this.checkAssetInfo(myFolder1Asset, user, path + "/" + user, user, false, true, false, false, null);
            AssetInfo myFile1Asset = this.assetService.getAssetWebApp(sbStoreId, defaultWebApp, "/" + user + "/fileA");
            this.checkAssetInfo(myFile1Asset, "fileA", path + "/" + user + "/fileA", user, true, false, false, true, user);
            ContentReader reader = this.assetService.getContentReader(myFile1Asset);
            InputStream in = reader.getContentInputStream();
            byte[] buff = new byte[1024];
            in.read(buff);
            in.close();
            AssetServiceImplTest.assertEquals((String)MYFILE1, (String)new String(buff, 0, MYFILE1.length()));
            String MYFILE1_MODIFIED = "This is myFile1 ... modified";
            writer = this.assetService.getContentWriter(myFile1Asset);
            writer.setMimetype("text/plain");
            writer.setEncoding("UTF-8");
            writer.putContent("This is myFile1 ... modified");
            reader = this.assetService.getContentReader(myFile1Asset);
            in = reader.getContentInputStream();
            buff = new byte[1024];
            in.read(buff);
            in.close();
            AssetServiceImplTest.assertEquals((String)"This is myFile1 ... modified", (String)new String(buff, 0, "This is myFile1 ... modified".length()));
            HashMap<QName, Serializable> newProps = new HashMap<QName, Serializable>(2);
            newProps.put(ContentModel.PROP_TITLE, (Serializable)((Object)"folder title"));
            newProps.put(ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"folder description"));
            this.assetService.updateAssetProperties(myFolder1Asset, newProps);
            Map<QName, Serializable> props = this.assetService.getAssetProperties(myFolder1Asset);
            AssetServiceImplTest.assertEquals((Object)"folder title", (Object)props.get(ContentModel.PROP_TITLE));
            AssetServiceImplTest.assertEquals((Object)"folder description", (Object)props.get(ContentModel.PROP_DESCRIPTION));
            this.assetService.deleteAsset(myFile1Asset);
            this.assetService.deleteAsset(myFolder1Asset);
        } else {
            try {
                this.assetService.createFolderWebApp(sbStoreId, defaultWebApp, "/", user);
                AssetServiceImplTest.fail((String)("User " + user + " with role " + role + " should not be able to create folder"));
            }
            catch (AccessDeniedException ade) {
                // empty catch block
            }
            try {
                this.assetService.createFileWebApp(sbStoreId, defaultWebApp, "/", "file-" + user);
                AssetServiceImplTest.fail((String)("User " + user + " with role " + role + " should not be able to create file"));
            }
            catch (AccessDeniedException ade) {
                // empty catch block
            }
        }
        AssetServiceImplTest.assertEquals((int)1, (int)this.assetService.listAssetsWebApp(sbStoreId, defaultWebApp, "/created-by-admin-" + user, false).size());
        AssetInfo existingFolder1Asset = this.assetService.getAssetWebApp(sbStoreId, defaultWebApp, "/created-by-admin-" + user);
        this.checkAssetInfo(existingFolder1Asset, PREFIX + user, path + "/" + PREFIX + user, AuthenticationUtil.getAdminUserName(), false, true, false, false, null);
        AssetInfo existingFile1Asset = this.assetService.getAssetWebApp(sbStoreId, defaultWebApp, "/created-by-admin-" + user + "/fileA");
        this.checkAssetInfo(existingFile1Asset, "fileA", path + "/" + PREFIX + user + "/fileA", AuthenticationUtil.getAdminUserName(), true, false, false, false, null);
        ContentReader reader = this.assetService.getContentReader(existingFile1Asset);
        InputStream in = reader.getContentInputStream();
        byte[] buff = new byte[1024];
        in.read(buff);
        in.close();
        AssetServiceImplTest.assertEquals((String)FILE, (String)new String(buff, 0, FILE.length()));
        if (canUpdateExisting) {
            String MYFILE1_MODIFIED = "This is myFile1 ... modified";
            ContentWriter writer = this.assetService.getContentWriter(existingFile1Asset);
            writer.setMimetype("text/plain");
            writer.setEncoding("UTF-8");
            writer.putContent("This is myFile1 ... modified");
            reader = this.assetService.getContentReader(existingFile1Asset);
            in = reader.getContentInputStream();
            buff = new byte[1024];
            in.read(buff);
            in.close();
            AssetServiceImplTest.assertEquals((String)"This is myFile1 ... modified", (String)new String(buff, 0, "This is myFile1 ... modified".length()));
            HashMap<Object, Serializable> newProps = new HashMap<QName, Serializable>(2);
            newProps.put(ContentModel.PROP_TITLE, (Serializable)((Object)"file title"));
            newProps.put(ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"file description"));
            this.assetService.updateAssetProperties(existingFile1Asset, newProps);
            Map<QName, Serializable> props = this.assetService.getAssetProperties(existingFile1Asset);
            AssetServiceImplTest.assertEquals((Object)"file title", (Object)props.get(ContentModel.PROP_TITLE));
            AssetServiceImplTest.assertEquals((Object)"file description", (Object)props.get(ContentModel.PROP_DESCRIPTION));
            newProps = new HashMap(2);
            newProps.put(ContentModel.PROP_TITLE, (Serializable)((Object)"folder title"));
            newProps.put(ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"folder description"));
            this.assetService.updateAssetProperties(existingFolder1Asset, newProps);
            props = this.assetService.getAssetProperties(existingFolder1Asset);
            AssetServiceImplTest.assertEquals((Object)"folder title", (Object)props.get(ContentModel.PROP_TITLE));
            AssetServiceImplTest.assertEquals((Object)"folder description", (Object)props.get(ContentModel.PROP_DESCRIPTION));
        } else {
            HashMap<QName, Serializable> newProps;
            try {
                this.assetService.getContentWriter(existingFile1Asset);
                AssetServiceImplTest.fail((String)("User " + user + " with role " + role + " should not be able to update existing file"));
            }
            catch (AccessDeniedException ade) {
                // empty catch block
            }
            try {
                newProps = new HashMap<QName, Serializable>(2);
                newProps.put(ContentModel.PROP_TITLE, (Serializable)((Object)"file title"));
                newProps.put(ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"file description"));
                this.assetService.updateAssetProperties(existingFile1Asset, newProps);
                AssetServiceImplTest.fail((String)("User " + user + " with role " + role + " should not be able to update existing file properties"));
            }
            catch (AccessDeniedException ade) {
                // empty catch block
            }
            try {
                newProps = new HashMap(2);
                newProps.put(ContentModel.PROP_TITLE, (Serializable)((Object)"folder title"));
                newProps.put(ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"folder description"));
                this.assetService.updateAssetProperties(existingFolder1Asset, newProps);
                AssetServiceImplTest.fail((String)("User " + user + " with role " + role + " should not be able to update existing folder properties"));
            }
            catch (AccessDeniedException ade) {
                // empty catch block
            }
        }
        if (canDeleteExisting) {
            this.assetService.deleteAsset(existingFile1Asset);
            this.assetService.deleteAsset(existingFolder1Asset);
        } else {
            try {
                this.assetService.deleteAsset(existingFile1Asset);
                AssetServiceImplTest.fail((String)("User " + user + " with role " + role + " should not be able to delete existing file"));
            }
            catch (AVMNotFoundException nfe) {
                // empty catch block
            }
            try {
                this.assetService.deleteAsset(existingFolder1Asset);
                AssetServiceImplTest.fail((String)("User " + user + " with role " + role + " should not be able to delete existing folder"));
            }
            catch (AVMNotFoundException ade) {
                // empty catch block
            }
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        int snapCnt = this.sbService.listSnapshots(wpStoreId, false).size();
        AuthenticationUtil.setFullyAuthenticatedUser((String)user);
        this.sbService.submitWebApp(sbStoreId, defaultWebApp, "some updates by " + user, null);
        this.pollForSnapshotCount(stagingStoreId, snapCnt + 1);
    }

    public void testRenameFile() {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-renamefile", TEST_WEBPROJ_NAME + "-renamefile", "This is my title", "This is my description", "ROOT", false, null);
        String defaultWebApp = wpInfo.getDefaultWebApp();
        this.wpService.inviteWebUser(wpInfo.getStoreId(), USER_ONE, "ContentManager", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpInfo.getStoreId());
        String sbStoreId = sbInfo.getSandboxId();
        String path = sbInfo.getSandboxRootPath() + "/" + defaultWebApp;
        this.assetService.createFolder(sbStoreId, path, "myFolder1", null);
        this.assetService.createFolder(sbStoreId, path + "/myFolder1", "myFolder2", null);
        this.assetService.createFile(sbStoreId, path + "/myFolder1/myFolder2", "myFile1", null);
        AssetInfo myFile1Asset = this.assetService.getAsset(sbStoreId, path + "/myFolder1/myFolder2/myFile1");
        this.checkAssetInfo(myFile1Asset, "myFile1", path + "/myFolder1/myFolder2/myFile1", USER_ONE, true, false, false, true, USER_ONE);
        myFile1Asset = this.assetService.renameAsset(myFile1Asset, "myFile1Renamed");
        this.checkAssetInfo(myFile1Asset, "myFile1Renamed", path + "/myFolder1/myFolder2/myFile1Renamed", USER_ONE, true, false, false, true, USER_ONE);
    }

    public void testRenameFolder() {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-renamefolder", TEST_WEBPROJ_NAME + "-renamefolder", "This is my title", "This is my description", "ROOT", false, null);
        String defaultWebApp = wpInfo.getDefaultWebApp();
        this.wpService.inviteWebUser(wpInfo.getStoreId(), USER_ONE, "ContentManager", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpInfo.getStoreId());
        String sbStoreId = sbInfo.getSandboxId();
        String path = sbInfo.getSandboxRootPath() + "/" + defaultWebApp;
        this.assetService.createFolder(sbStoreId, path, "myFolder1", null);
        this.assetService.createFolder(sbStoreId, path + "/myFolder1", "myFolder2", null);
        AssetInfo myFolder1Asset = this.assetService.getAsset(sbStoreId, path + "/myFolder1");
        this.checkAssetInfo(myFolder1Asset, "myFolder1", path + "/myFolder1", USER_ONE, false, true, false, false, null);
        AssetInfo myFolder2Asset = this.assetService.getAsset(sbStoreId, path + "/myFolder1/myFolder2");
        this.checkAssetInfo(myFolder2Asset, "myFolder2", path + "/myFolder1/myFolder2", USER_ONE, false, true, false, false, null);
        myFolder1Asset = this.assetService.renameAsset(myFolder1Asset, "myFolder1Renamed");
        this.checkAssetInfo(myFolder1Asset, "myFolder1Renamed", path + "/myFolder1Renamed", USER_ONE, false, true, false, false, null);
        myFolder2Asset = this.assetService.getAsset(sbStoreId, path + "/myFolder1Renamed/myFolder2");
        this.checkAssetInfo(myFolder2Asset, "myFolder2", path + "/myFolder1Renamed/myFolder2", USER_ONE, false, true, false, false, null);
        myFolder2Asset = this.assetService.renameAsset(myFolder2Asset, "myFolder2Renamed");
        this.checkAssetInfo(myFolder2Asset, "myFolder2Renamed", path + "/myFolder1Renamed/myFolder2Renamed", USER_ONE, false, true, false, false, null);
    }

    public void testCopyFile() {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-copyfile", TEST_WEBPROJ_NAME + "-copyfile", "This is my title", "This is my description", "ROOT", false, null);
        String defaultWebApp = wpInfo.getDefaultWebApp();
        this.wpService.inviteWebUser(wpInfo.getStoreId(), USER_ONE, "ContentManager", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpInfo.getStoreId());
        String sbStoreId = sbInfo.getSandboxId();
        String path = sbInfo.getSandboxRootPath() + "/" + defaultWebApp;
        this.assetService.createFolder(sbStoreId, path, "myFolder1", null);
        this.assetService.createFolder(sbStoreId, path + "/myFolder1", "myFolder2", null);
        String MYFILE1 = "This is myFile1";
        ContentWriter writer = this.assetService.createFile(sbStoreId, path + "/myFolder1/myFolder2", "myFile1", null);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is myFile1");
        AssetInfo myFile1Asset = this.assetService.getAsset(sbStoreId, path + "/myFolder1/myFolder2/myFile1");
        this.checkAssetInfo(myFile1Asset, "myFile1", path + "/myFolder1/myFolder2/myFile1", USER_ONE, true, false, false, true, USER_ONE);
        myFile1Asset = this.assetService.copyAsset(myFile1Asset, path + "/myFolder1");
        this.checkAssetInfo(myFile1Asset, "myFile1", path + "/myFolder1/myFile1", USER_ONE, true, false, false, false, null);
    }

    public void testCopyFolder() {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-copyfolder", TEST_WEBPROJ_NAME + "-copyfolder", "This is my title", "This is my description", "ROOT", false, null);
        String defaultWebApp = wpInfo.getDefaultWebApp();
        this.wpService.inviteWebUser(wpInfo.getStoreId(), USER_ONE, "ContentManager", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpInfo.getStoreId());
        String sbStoreId = sbInfo.getSandboxId();
        String path = sbInfo.getSandboxRootPath() + "/" + defaultWebApp;
        this.assetService.createFolder(sbStoreId, path, "myFolder1", null);
        this.assetService.createFolder(sbStoreId, path + "/myFolder1", "myFolder2", null);
        String MYFILE1 = "This is myFile1";
        ContentWriter writer = this.assetService.createFile(sbStoreId, path + "/myFolder1/myFolder2", "myFile1", null);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is myFile1");
        AssetInfo myFile1Asset = this.assetService.getAsset(sbStoreId, path + "/myFolder1/myFolder2/myFile1");
        this.checkAssetInfo(myFile1Asset, "myFile1", path + "/myFolder1/myFolder2/myFile1", USER_ONE, true, false, false, true, USER_ONE);
        AssetInfo myFolder2Asset = this.assetService.getAsset(sbStoreId, path + "/myFolder1/myFolder2");
        this.checkAssetInfo(myFolder2Asset, "myFolder2", path + "/myFolder1/myFolder2", USER_ONE, false, true, false, false, null);
        myFolder2Asset = this.assetService.copyAsset(myFolder2Asset, path);
        this.checkAssetInfo(myFolder2Asset, "myFolder2", path + "/myFolder2", USER_ONE, false, true, false, false, null);
        AssetInfo myCopiedFolder2Asset = this.assetService.getAsset(sbStoreId, path + "/myFolder2");
        this.checkAssetInfo(myCopiedFolder2Asset, "myFolder2", path + "/myFolder2", USER_ONE, false, true, false, false, null);
        AssetInfo myCopiedFile1Asset = this.assetService.getAsset(sbStoreId, path + "/myFolder2/myFile1");
        this.checkAssetInfo(myCopiedFile1Asset, "myFile1", path + "/myFolder2/myFile1", USER_ONE, true, false, false, false, null);
    }

    public void testMoveFile() {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-movefile", TEST_WEBPROJ_NAME + "-movefile", "This is my title", "This is my description", "ROOT", false, null);
        String defaultWebApp = wpInfo.getDefaultWebApp();
        this.wpService.inviteWebUser(wpInfo.getStoreId(), USER_ONE, "ContentManager", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpInfo.getStoreId());
        String sbStoreId = sbInfo.getSandboxId();
        String path = sbInfo.getSandboxRootPath() + "/" + defaultWebApp;
        this.assetService.createFolder(sbStoreId, path, "myFolder1", null);
        this.assetService.createFolder(sbStoreId, path + "/myFolder1", "myFolder2", null);
        this.assetService.createFile(sbStoreId, path + "/myFolder1/myFolder2", "myFile1", null);
        AssetInfo myFile1Asset = this.assetService.getAsset(sbStoreId, path + "/myFolder1/myFolder2/myFile1");
        this.checkAssetInfo(myFile1Asset, "myFile1", path + "/myFolder1/myFolder2/myFile1", USER_ONE, true, false, false, true, USER_ONE);
        myFile1Asset = this.assetService.moveAsset(myFile1Asset, path + "/myFolder1");
        this.checkAssetInfo(myFile1Asset, "myFile1", path + "/myFolder1/myFile1", USER_ONE, true, false, false, true, USER_ONE);
    }

    public void testMoveFolder() {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-movefolder", TEST_WEBPROJ_NAME + "-movefolder", "This is my title", "This is my description", "ROOT", false, null);
        String defaultWebApp = wpInfo.getDefaultWebApp();
        this.wpService.inviteWebUser(wpInfo.getStoreId(), USER_ONE, "ContentManager", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpInfo.getStoreId());
        String sbStoreId = sbInfo.getSandboxId();
        String path = sbInfo.getSandboxRootPath() + "/" + defaultWebApp;
        this.assetService.createFolder(sbStoreId, path, "myFolder1", null);
        this.assetService.createFolder(sbStoreId, path + "/myFolder1", "myFolder2", null);
        this.assetService.createFile(sbStoreId, path + "/myFolder1/myFolder2", "myFile1", null);
        AssetInfo myFile1Asset = this.assetService.getAsset(sbStoreId, path + "/myFolder1/myFolder2/myFile1");
        this.checkAssetInfo(myFile1Asset, "myFile1", path + "/myFolder1/myFolder2/myFile1", USER_ONE, true, false, false, true, USER_ONE);
        AssetInfo myFolder2Asset = this.assetService.getAsset(sbStoreId, path + "/myFolder1/myFolder2");
        this.checkAssetInfo(myFolder2Asset, "myFolder2", path + "/myFolder1/myFolder2", USER_ONE, false, true, false, false, null);
        myFolder2Asset = this.assetService.moveAsset(myFolder2Asset, path);
        this.checkAssetInfo(myFolder2Asset, "myFolder2", path + "/myFolder2", USER_ONE, false, true, false, false, null);
        AssetInfo myMovedFolder2Asset = this.assetService.getAsset(sbStoreId, path + "/myFolder2");
        this.checkAssetInfo(myMovedFolder2Asset, "myFolder2", path + "/myFolder2", USER_ONE, false, true, false, false, null);
        AssetInfo myMovedFile1Asset = this.assetService.getAsset(sbStoreId, path + "/myFolder2/myFile1");
        this.checkAssetInfo(myMovedFile1Asset, "myFile1", path + "/myFolder2/myFile1", USER_ONE, true, false, false, false, null);
    }

    public void testProperties() throws InterruptedException {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-properties", TEST_WEBPROJ_NAME + "-properties", "This is my title", "This is my description", "ROOT", false, null);
        String defaultWebApp = wpInfo.getDefaultWebApp();
        String stagingStoreId = this.sbService.getStagingSandbox(wpInfo.getStoreId()).getSandboxId();
        this.wpService.inviteWebUser(wpInfo.getStoreId(), USER_ONE, "ContentContributor", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpInfo.getStoreId());
        String sbStoreId = sbInfo.getSandboxId();
        String path = sbInfo.getSandboxRootPath() + "/" + defaultWebApp;
        this.assetService.createFolderWebApp(sbStoreId, defaultWebApp, "/", "myFolder1");
        AssetInfo myFolder1Asset = this.assetService.getAssetWebApp(sbStoreId, defaultWebApp, "/myFolder1");
        this.checkAssetInfo(myFolder1Asset, "myFolder1", path + "/myFolder1", USER_ONE, false, true, false, false, null);
        Map<QName, Serializable> props = this.assetService.getAssetProperties(myFolder1Asset);
        AssetServiceImplTest.assertNotNull(props);
        int countFolderInbuiltProps = props.size();
        this.assetService.createFileWebApp(sbStoreId, defaultWebApp, "/myFolder1", "myFile1");
        AssetInfo myFile1Asset = this.assetService.getAssetWebApp(sbStoreId, defaultWebApp, "/myFolder1/myFile1");
        this.checkAssetInfo(myFile1Asset, "myFile1", path + "/myFolder1/myFile1", USER_ONE, true, false, false, true, USER_ONE);
        props = this.assetService.getAssetProperties(myFile1Asset);
        AssetServiceImplTest.assertNotNull(props);
        int countFileInbuiltProps = props.size();
        AssetServiceImplTest.assertEquals((String)USER_ONE, (String)this.assetService.getLockOwner(myFile1Asset));
        this.sbService.submitWebApp(sbStoreId, defaultWebApp, "submit1 label", "submit1 comment");
        this.pollForSnapshotCount(stagingStoreId, 1);
        AssetServiceImplTest.assertNull((Object)this.assetService.getLockOwner(myFile1Asset));
        HashMap<Object, Serializable> newProps = new HashMap<QName, Serializable>(2);
        newProps.put(ContentModel.PROP_TITLE, (Serializable)((Object)"folder title"));
        newProps.put(ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"folder description"));
        this.assetService.updateAssetProperties(myFolder1Asset, newProps);
        props = this.assetService.getAssetProperties(myFolder1Asset);
        AssetServiceImplTest.assertEquals((int)(countFolderInbuiltProps + 2), (int)props.size());
        AssetServiceImplTest.assertEquals((Object)"folder title", (Object)props.get(ContentModel.PROP_TITLE));
        AssetServiceImplTest.assertEquals((Object)"folder description", (Object)props.get(ContentModel.PROP_DESCRIPTION));
        newProps = new HashMap(1);
        newProps.put(ContentModel.PROP_TITLE, (Serializable)((Object)"folder title2"));
        this.assetService.setAssetProperties(myFolder1Asset, newProps);
        props = this.assetService.getAssetProperties(myFolder1Asset);
        AssetServiceImplTest.assertEquals((int)(countFolderInbuiltProps + 1), (int)props.size());
        AssetServiceImplTest.assertEquals((Object)"folder title2", (Object)props.get(ContentModel.PROP_TITLE));
        AssetServiceImplTest.assertNull((Object)props.get(ContentModel.PROP_DESCRIPTION));
        newProps = new HashMap(2);
        newProps.put(ContentModel.PROP_TITLE, (Serializable)((Object)"file title"));
        newProps.put(ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"file description"));
        this.assetService.setAssetProperties(myFile1Asset, newProps);
        props = this.assetService.getAssetProperties(myFile1Asset);
        AssetServiceImplTest.assertEquals((int)(countFileInbuiltProps + 2), (int)props.size());
        AssetServiceImplTest.assertEquals((Object)"file title", (Object)props.get(ContentModel.PROP_TITLE));
        AssetServiceImplTest.assertEquals((Object)"file description", (Object)props.get(ContentModel.PROP_DESCRIPTION));
        AssetServiceImplTest.assertEquals((String)USER_ONE, (String)this.assetService.getLockOwner(myFile1Asset));
    }

    public void testAspects() {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-aspects", TEST_WEBPROJ_NAME + "-aspects", "This is my title", "This is my description", "ROOT", false, null);
        String defaultWebApp = wpInfo.getDefaultWebApp();
        this.wpService.inviteWebUser(wpInfo.getStoreId(), USER_ONE, "ContentContributor", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpInfo.getStoreId());
        String sbStoreId = sbInfo.getSandboxId();
        String path = sbInfo.getSandboxRootPath() + "/" + defaultWebApp;
        this.assetService.createFolderWebApp(sbStoreId, defaultWebApp, "/", "myFolder1");
        AssetInfo myFolder1Asset = this.assetService.getAssetWebApp(sbStoreId, defaultWebApp, "/myFolder1");
        this.checkAssetInfo(myFolder1Asset, "myFolder1", path + "/myFolder1", USER_ONE, false, true, false, false, null);
        int folderAspectCnt = this.assetService.getAspects(myFolder1Asset).size();
        this.assetService.createFileWebApp(sbStoreId, defaultWebApp, "/myFolder1", "myFile1");
        AssetInfo myFile1Asset = this.assetService.getAssetWebApp(sbStoreId, defaultWebApp, "/myFolder1/myFile1");
        this.checkAssetInfo(myFile1Asset, "myFile1", path + "/myFolder1/myFile1", USER_ONE, true, false, false, true, USER_ONE);
        int fileAspectCnt = this.assetService.getAspects(myFile1Asset).size();
        AssetServiceImplTest.assertFalse((boolean)this.assetService.hasAspect(myFolder1Asset, ContentModel.ASPECT_TITLED));
        HashMap<Object, Serializable> newProps = new HashMap<QName, Serializable>(2);
        newProps.put(ContentModel.PROP_TITLE, (Serializable)((Object)"folder title"));
        newProps.put(ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"folder description"));
        this.assetService.addAspect(myFolder1Asset, ContentModel.ASPECT_TITLED, newProps);
        AssetServiceImplTest.assertEquals((int)(folderAspectCnt + 1), (int)this.assetService.getAspects(myFolder1Asset).size());
        AssetServiceImplTest.assertTrue((boolean)this.assetService.hasAspect(myFolder1Asset, ContentModel.ASPECT_TITLED));
        this.assetService.removeAspect(myFolder1Asset, ContentModel.ASPECT_TITLED);
        AssetServiceImplTest.assertEquals((int)folderAspectCnt, (int)this.assetService.getAspects(myFolder1Asset).size());
        AssetServiceImplTest.assertFalse((boolean)this.assetService.hasAspect(myFolder1Asset, ContentModel.ASPECT_TITLED));
        AssetServiceImplTest.assertFalse((boolean)this.assetService.hasAspect(myFile1Asset, ContentModel.ASPECT_TITLED));
        newProps = new HashMap(2);
        newProps.put(ContentModel.PROP_TITLE, (Serializable)((Object)"file title"));
        newProps.put(ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"file description"));
        this.assetService.addAspect(myFile1Asset, ContentModel.ASPECT_TITLED, newProps);
        AssetServiceImplTest.assertEquals((int)(fileAspectCnt + 1), (int)this.assetService.getAspects(myFile1Asset).size());
        AssetServiceImplTest.assertTrue((boolean)this.assetService.hasAspect(myFile1Asset, ContentModel.ASPECT_TITLED));
        this.assetService.removeAspect(myFile1Asset, ContentModel.ASPECT_TITLED);
        AssetServiceImplTest.assertEquals((int)fileAspectCnt, (int)this.assetService.getAspects(myFile1Asset).size());
        AssetServiceImplTest.assertFalse((boolean)this.assetService.hasAspect(myFile1Asset, ContentModel.ASPECT_TITLED));
    }

    public void testSimpleLockFile() throws InterruptedException {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-simpleLock", TEST_WEBPROJ_NAME + "-simpleLock", "This is my title", "This is my description", "ROOT", false, null);
        String defaultWebApp = wpInfo.getDefaultWebApp();
        String stagingStoreId = this.sbService.getStagingSandbox(wpInfo.getStoreId()).getSandboxId();
        this.wpService.inviteWebUser(wpInfo.getStoreId(), USER_ONE, "ContentContributor", true);
        this.wpService.inviteWebUser(wpInfo.getStoreId(), USER_TWO, "ContentContributor", true);
        this.wpService.inviteWebUser(wpInfo.getStoreId(), USER_THREE, "ContentManager", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpInfo.getStoreId());
        String sbStoreId = sbInfo.getSandboxId();
        String path = sbInfo.getSandboxRootPath() + "/" + defaultWebApp;
        this.assetService.createFileWebApp(sbStoreId, defaultWebApp, "/", "myFile1");
        AssetInfo myFile1Asset = this.assetService.getAssetWebApp(sbStoreId, defaultWebApp, "myFile1");
        this.checkAssetInfo(myFile1Asset, "myFile1", path + "/myFile1", USER_ONE, true, false, false, true, USER_ONE);
        AssetServiceImplTest.assertEquals((String)USER_ONE, (String)this.assetService.getLockOwner(myFile1Asset));
        AssetServiceImplTest.assertTrue((boolean)this.assetService.hasLockAccess(myFile1Asset));
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        AssetServiceImplTest.assertEquals((String)USER_ONE, (String)this.assetService.getLockOwner(myFile1Asset));
        AssetServiceImplTest.assertFalse((boolean)this.assetService.hasLockAccess(myFile1Asset));
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_THREE);
        AssetServiceImplTest.assertEquals((String)USER_ONE, (String)this.assetService.getLockOwner(myFile1Asset));
        AssetServiceImplTest.assertTrue((boolean)this.assetService.hasLockAccess(myFile1Asset));
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        this.sbService.submitWebApp(sbStoreId, defaultWebApp, "submit1 label", "submit1 comment");
        this.pollForSnapshotCount(stagingStoreId, 1);
        AssetServiceImplTest.assertNull((Object)this.assetService.getLockOwner(myFile1Asset));
        AssetServiceImplTest.assertTrue((boolean)this.assetService.hasLockAccess(myFile1Asset));
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        AssetServiceImplTest.assertNull((Object)this.assetService.getLockOwner(myFile1Asset));
        AssetServiceImplTest.assertTrue((boolean)this.assetService.hasLockAccess(myFile1Asset));
    }

    public void testSimpleLockFile2() throws InterruptedException {
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ADMIN);
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-partialSubmitWithNewFolder", TEST_WEBPROJ_NAME + "-partialSubmitWithNewFolder", "This is my title", "This is my description", "ROOT", false, null);
        String defaultWebApp = wpInfo.getDefaultWebApp();
        String stagingStoreId = this.sbService.getStagingSandbox(wpInfo.getStoreId()).getSandboxId();
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpInfo.getStoreId());
        String sbStoreId = sbInfo.getSandboxId();
        String path = sbInfo.getSandboxRootPath() + "/" + defaultWebApp;
        this.assetService.createFolderWebApp(sbStoreId, defaultWebApp, "/", "myDir1");
        AssetInfo myDir1Asset = this.assetService.getAssetWebApp(sbStoreId, defaultWebApp, "myDir1");
        this.checkAssetInfo(myDir1Asset, "myDir1", path + "/myDir1", USER_ADMIN, false, true, false, false, null);
        AssetServiceImplTest.assertNull((Object)this.assetService.getLockOwner(myDir1Asset));
        AssetServiceImplTest.assertTrue((boolean)this.assetService.hasLockAccess(myDir1Asset));
        this.assetService.createFileWebApp(sbStoreId, defaultWebApp, "/myDir1", "myFile1");
        this.assetService.createFileWebApp(sbStoreId, defaultWebApp, "/myDir1", "myFile2");
        AssetInfo myFile1Asset = this.assetService.getAssetWebApp(sbStoreId, defaultWebApp, "myDir1/myFile1");
        this.checkAssetInfo(myFile1Asset, "myFile1", path + "/myDir1/myFile1", USER_ADMIN, true, false, false, true, USER_ADMIN);
        AssetServiceImplTest.assertEquals((String)USER_ADMIN, (String)this.assetService.getLockOwner(myFile1Asset));
        AssetServiceImplTest.assertTrue((boolean)this.assetService.hasLockAccess(myFile1Asset));
        AssetInfo myFile2Asset = this.assetService.getAssetWebApp(sbStoreId, defaultWebApp, "myDir1/myFile2");
        this.checkAssetInfo(myFile2Asset, "myFile2", path + "/myDir1/myFile2", USER_ADMIN, true, false, false, true, USER_ADMIN);
        AssetServiceImplTest.assertEquals((String)USER_ADMIN, (String)this.assetService.getLockOwner(myFile2Asset));
        AssetServiceImplTest.assertTrue((boolean)this.assetService.hasLockAccess(myFile2Asset));
        List<AssetInfo> changedAssets = this.sbService.listChangedWebApp(sbStoreId, defaultWebApp, false);
        AssetServiceImplTest.assertEquals((int)1, (int)changedAssets.size());
        myDir1Asset = changedAssets.get(0);
        this.checkAssetInfo(myDir1Asset, "myDir1", path + "/myDir1", USER_ADMIN, false, true, false, false, null);
        ArrayList<AssetInfo> selectedAssetsToSubmit = new ArrayList<AssetInfo>(1);
        selectedAssetsToSubmit.add(myFile1Asset);
        this.sbService.submitListAssets(sbStoreId, selectedAssetsToSubmit, "submit1 label", "submit1 comment");
        this.pollForSnapshotCount(stagingStoreId, 1);
        changedAssets = this.sbService.listChangedWebApp(sbStoreId, defaultWebApp, false);
        AssetServiceImplTest.assertEquals((int)1, (int)changedAssets.size());
        myFile2Asset = changedAssets.get(0);
        this.checkAssetInfo(myFile2Asset, "myFile2", path + "/myDir1/myFile2", USER_ADMIN, true, false, false, true, USER_ADMIN);
        AssetServiceImplTest.assertEquals((String)USER_ADMIN, (String)this.assetService.getLockOwner(myFile2Asset));
        AssetServiceImplTest.assertTrue((boolean)this.assetService.hasLockAccess(myFile2Asset));
    }

    public void testImportAndSubmit1() throws InterruptedException {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-simpleImport", TEST_WEBPROJ_NAME + "-simpleImport", "This is my title", "This is my description", "ROOT", false, null);
        String defaultWebApp = wpInfo.getDefaultWebApp();
        SandboxInfo stagingInfo = this.sbService.getStagingSandbox(wpInfo.getStoreId());
        String stagingStoreId = stagingInfo.getSandboxId();
        this.wpService.inviteWebUser(wpInfo.getStoreId(), USER_ONE, "ContentContributor", true);
        AssetServiceImplTest.assertEquals((int)0, (int)this.sbService.listSnapshots(stagingStoreId, false).size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpInfo.getStoreId());
        String sbStoreId = sbInfo.getSandboxId();
        String path = sbInfo.getSandboxRootPath() + "/" + defaultWebApp;
        AssetServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(stagingStoreId, path, false).size());
        AssetServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(sbStoreId, path, false).size());
        AssetServiceImplTest.assertEquals((int)0, (int)this.sbService.listChanged(sbStoreId, path, false).size());
        this.assetService.createFolder(sbStoreId, path, "myFolder1", null);
        AssetInfo myFolder1Asset = this.assetService.getAsset(sbStoreId, path + "/myFolder1");
        AssetServiceImplTest.assertEquals((int)1, (int)this.sbService.listChanged(sbStoreId, path, false).size());
        AssetServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(stagingStoreId, path, false).size());
        AssetServiceImplTest.assertEquals((int)1, (int)this.assetService.listAssets(sbStoreId, path, false).size());
        AssetServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(sbStoreId, path + "/myFolder1", false).size());
        String testFile = System.getProperty("user.dir") + "/source/test-resources/module/test.war";
        File zipFile = new File(testFile);
        this.assetService.bulkImport(sbStoreId, myFolder1Asset.getPath(), zipFile, false);
        AssetServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(stagingStoreId, path, false).size());
        AssetServiceImplTest.assertEquals((int)1, (int)this.assetService.listAssets(sbStoreId, path, false).size());
        AssetServiceImplTest.assertEquals((int)9, (int)this.assetService.listAssets(sbStoreId, path + "/myFolder1", false).size());
        AssetServiceImplTest.assertEquals((int)1, (int)this.sbService.listChanged(sbStoreId, path, false).size());
        this.sbService.submitWebApp(sbStoreId, defaultWebApp, "s1", "s1");
        this.pollForSnapshotCount(stagingStoreId, 1);
        AssetServiceImplTest.assertEquals((int)1, (int)this.assetService.listAssets(stagingStoreId, path, false).size());
        AssetServiceImplTest.assertEquals((int)9, (int)this.assetService.listAssets(stagingStoreId, path + "/myFolder1", false).size());
        AssetServiceImplTest.assertEquals((int)1, (int)this.assetService.listAssets(sbStoreId, path, false).size());
        AssetServiceImplTest.assertEquals((int)9, (int)this.assetService.listAssets(sbStoreId, path + "/myFolder1", false).size());
        AssetServiceImplTest.assertEquals((int)0, (int)this.sbService.listChanged(sbStoreId, path, false).size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        AssetServiceImplTest.assertEquals((int)1, (int)this.sbService.listSnapshots(stagingStoreId, false).size());
    }

    public void testImportAndSubmit2() throws InterruptedException {
        int totalCnt;
        long start = System.currentTimeMillis();
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-import", TEST_WEBPROJ_NAME + "-import", "This is my title", "This is my description", "ROOT", false, null);
        logger.debug((Object)("create web project in " + (System.currentTimeMillis() - start) + " msecs"));
        String defaultWebApp = wpInfo.getDefaultWebApp();
        SandboxInfo stagingInfo = this.sbService.getStagingSandbox(wpInfo.getStoreId());
        String stagingStoreId = stagingInfo.getSandboxId();
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpInfo.getStoreId());
        String sbStoreId = sbInfo.getSandboxId();
        String path = sbInfo.getSandboxRootPath() + "/" + defaultWebApp;
        AssetServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(stagingStoreId, path, false).size());
        AssetServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(sbStoreId, path, false).size());
        AssetServiceImplTest.assertEquals((int)0, (int)this.sbService.listSnapshots(stagingStoreId, false).size());
        String testFile = System.getProperty("user.dir") + "/source/test-resources/module/test.war";
        start = System.currentTimeMillis();
        File zipFile = new File(testFile);
        this.assetService.bulkImport(sbStoreId, path, zipFile, false);
        logger.debug((Object)("bulk import in " + (System.currentTimeMillis() - start) + " msecs"));
        int expectedChangeCnt = totalCnt = this.assetService.listAssets(sbStoreId, path, false).size();
        int expectedSnapCnt = 0;
        int expectedStageCnt = 0;
        for (int i = 1; i <= totalCnt; ++i) {
            AssetServiceImplTest.assertEquals((int)expectedStageCnt, (int)this.assetService.listAssets(stagingStoreId, path, false).size());
            AssetServiceImplTest.assertEquals((int)totalCnt, (int)this.assetService.listAssets(sbStoreId, path, false).size());
            AssetServiceImplTest.assertEquals((int)expectedSnapCnt, (int)this.sbService.listSnapshots(stagingStoreId, false).size());
            List<AssetInfo> assets = this.sbService.listChanged(sbStoreId, path, false);
            AssetServiceImplTest.assertEquals((int)expectedChangeCnt, (int)assets.size());
            ArrayList<AssetInfo> submitAssets = new ArrayList<AssetInfo>(1);
            submitAssets.add(assets.get(0));
            start = System.currentTimeMillis();
            this.sbService.submitListAssets(sbStoreId, submitAssets, "s1", "s1");
            logger.debug((Object)("initiated submit of item " + i + " in " + (System.currentTimeMillis() - start) + " msecs"));
            start = System.currentTimeMillis();
            this.pollForSnapshotCount(stagingStoreId, ++expectedSnapCnt);
            --expectedChangeCnt;
            ++expectedStageCnt;
        }
    }
}

