/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.config;

import java.util.List;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.ServerProperties;
import org.springframework.extensions.config.element.ConfigElementAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConfigElement
extends ConfigElementAdapter
implements ServerProperties {
    public static final String CONFIG_ELEMENT_ID = "server";
    private String scheme = null;
    private String hostname = null;
    private Integer port = null;

    public ServerConfigElement() {
        super(CONFIG_ELEMENT_ID);
    }

    public ServerConfigElement(String name) {
        super(name);
    }

    public List<ConfigElement> getChildren() {
        throw new ConfigException("Reading the Server config via the generic interfaces is not supported");
    }

    public ConfigElement combine(ConfigElement configElement) {
        ServerConfigElement newElement = (ServerConfigElement)configElement;
        ServerConfigElement combinedElement = new ServerConfigElement();
        combinedElement.setScheme(newElement.getScheme());
        combinedElement.setHostName(newElement.getHostName());
        combinedElement.setPort(newElement.getPort());
        return combinedElement;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    @Override
    public String getHostName() {
        return this.hostname;
    }

    public void setHostName(String hostname) {
        this.hostname = hostname;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }
}

