/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.atom;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.abdera.model.Feed;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.Format;
import org.springframework.extensions.webscripts.FormatReader;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.atom.AbderaService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomFeedReader
implements FormatReader<Feed> {
    protected AbderaService abderaService;

    public void setAbderaService(AbderaService abderaService) {
        this.abderaService = abderaService;
    }

    @Override
    public Class<Feed> getDestinationClass() {
        return Feed.class;
    }

    @Override
    public String getSourceMimetype() {
        return Format.ATOMFEED.mimetype();
    }

    @Override
    public Feed read(WebScriptRequest req) {
        Content content = req.getContent();
        if (content == null) {
            throw new WebScriptException("Failed to convert request to Atom Feed");
        }
        try {
            return this.abderaService.parseFeed(content.getReader(), req.getServerPath() + URLEncoder.encodeUri((String)req.getServicePath()));
        }
        catch (IOException e) {
            throw new WebScriptException("Failed to convert request to Atom Feed", e);
        }
    }

    @Override
    public Map<String, Object> createScriptParameters(WebScriptRequest req, WebScriptResponse res) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("feed", this.read(req));
        return params;
    }
}

