/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.connector;

import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.webscripts.connector.Credentials;
import org.springframework.extensions.webscripts.connector.CredentialsImpl;
import org.springframework.extensions.webscripts.connector.SimpleCredentialVault;

public abstract class AbstractPersistentCredentialVault
extends SimpleCredentialVault {
    protected ConfigService configService;

    public AbstractPersistentCredentialVault(String id) {
        super(id);
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    public void store(Credentials credentials) {
        String endpointId = credentials.getEndpointId();
        RemoteConfigElement.EndpointDescriptor descriptor = this.getRemoteConfig().getEndpointDescriptor(endpointId);
        if (descriptor != null) {
            ((CredentialsImpl)credentials).persistent = descriptor.getPersistent();
        }
        super.store(credentials);
    }

    protected RemoteConfigElement getRemoteConfig() {
        RemoteConfigElement remoteConfig = (RemoteConfigElement)this.configService.getConfig((Object)"Remote").getConfigElement("remote");
        return remoteConfig;
    }

    public String toString() {
        return "PersistentCredentialVault - " + this.id;
    }
}

