/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.processor;

import freemarker.cache.CacheStorage;
import freemarker.cache.MruCacheStorage;
import freemarker.cache.StrongCacheStorage;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.element.GenericConfigElement;
import org.springframework.extensions.webscripts.TemplateConfigModel;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.json.JSONUtils;
import org.springframework.extensions.webscripts.processor.AbstractTemplateProcessor;

public class FTLTemplateProcessor
extends AbstractTemplateProcessor {
    private static final Log logger = LogFactory.getLog(FTLTemplateProcessor.class);
    private String defaultEncoding;
    private Configuration templateConfig;
    private Configuration stringConfig;
    private int updateDelay = 0;
    private int cacheSize = 256;
    private static final Class<?>[] INTROSPECT_CLASSES = new Class[]{TemplateConfigModel.class, GenericConfigElement.class, JSONUtils.class};

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setUpdateDelay(int updateDelay) {
        this.updateDelay = updateDelay;
    }

    public void setCacheSize(int cacheSize) {
        if (cacheSize >= 0) {
            this.cacheSize = cacheSize;
        }
    }

    public void init() {
        super.init();
        this.initConfig();
    }

    public String getExtension() {
        return "ftl";
    }

    public String getName() {
        return "freemarker";
    }

    public void process(String template, Object model, Writer out) {
        if (template == null || template.length() == 0) {
            throw new IllegalArgumentException("Template name is mandatory.");
        }
        if (model == null) {
            throw new IllegalArgumentException("Model is mandatory.");
        }
        if (out == null) {
            throw new IllegalArgumentException("Output Writer is mandatory.");
        }
        try {
            long startTime = 0L;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing template: " + template));
                startTime = System.nanoTime();
            }
            this.addProcessorModelExtensions(model);
            Template t = this.templateConfig.getTemplate(template);
            if (t != null) {
                try {
                    t.process(model, out);
                }
                catch (Throwable err) {
                    throw new WebScriptException("Failed to process template " + template, err);
                }
            } else {
                throw new WebScriptException("Cannot find template " + template);
            }
            if (logger.isDebugEnabled()) {
                long endTime = System.nanoTime();
                logger.debug((Object)("Time to execute template: " + (float)(endTime - startTime) / 1000000.0f + "ms"));
            }
        }
        catch (IOException ioerr) {
            throw new WebScriptException("Failed to process template " + template, ioerr);
        }
    }

    public void processString(String template, Object model, Writer out) {
        if (template == null || template.length() == 0) {
            throw new IllegalArgumentException("Template is mandatory.");
        }
        if (model == null) {
            throw new IllegalArgumentException("Model is mandatory.");
        }
        if (out == null) {
            throw new IllegalArgumentException("Output Writer is mandatory.");
        }
        long startTime = 0L;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing template: " + template));
            startTime = System.nanoTime();
        }
        this.addProcessorModelExtensions(model);
        try {
            Template t = new Template("name", (Reader)new StringReader(template), this.stringConfig);
            t.process(model, out);
            if (logger.isDebugEnabled()) {
                long endTime = System.nanoTime();
                logger.debug((Object)("Time to execute template: " + (float)(endTime - startTime) / 1000000.0f + "ms"));
            }
        }
        catch (Throwable err) {
            throw new WebScriptException("Failed to process template " + template, err);
        }
    }

    public void reset() {
        this.init();
        if (this.templateConfig != null) {
            this.templateConfig.clearTemplateCache();
        }
    }

    public boolean hasTemplate(String templatePath) {
        boolean hasTemplate = false;
        try {
            Template template = this.templateConfig.getTemplate(templatePath);
            hasTemplate = template != null;
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            throw new WebScriptException("Failed to retrieve template " + templatePath, e);
        }
        return hasTemplate;
    }

    protected void initConfig() {
        Configuration config = new Configuration();
        NonBlockingObjectWrapper objectWrapper = new NonBlockingObjectWrapper();
        config.setObjectWrapper((ObjectWrapper)objectWrapper);
        config.setCacheStorage((CacheStorage)new StrongCacheStorage());
        config.setTemplateUpdateDelay(this.updateDelay);
        config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        config.setLocalizedLookup(false);
        config.setOutputEncoding("UTF-8");
        if (this.defaultEncoding != null) {
            config.setDefaultEncoding(this.defaultEncoding);
        }
        if (this.getTemplateLoader() != null) {
            config.setTemplateLoader(this.getTemplateLoader());
        }
        this.templateConfig = config;
        this.stringConfig = new Configuration();
        this.stringConfig.setObjectWrapper((ObjectWrapper)objectWrapper);
        this.stringConfig.setCacheStorage((CacheStorage)new MruCacheStorage(2, 0));
        this.stringConfig.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.stringConfig.setOutputEncoding("UTF-8");
        if (this.defaultEncoding != null) {
            this.stringConfig.setDefaultEncoding(this.defaultEncoding);
        }
    }

    public static class NonBlockingObjectWrapper
    implements ObjectWrapper {
        private final ThreadLocal<ObjectWrapper> threadWrappers = new ThreadLocal<ObjectWrapper>(){

            @Override
            protected ObjectWrapper initialValue() {
                return new DefaultObjectWrapper();
            }
        };

        public NonBlockingObjectWrapper() {
            this.threadWrappers.get();
            for (Class type : INTROSPECT_CLASSES) {
                try {
                    Introspector.getBeanInfo(type);
                }
                catch (IntrospectionException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public TemplateModel wrap(Object obj) throws TemplateModelException {
            return this.threadWrappers.get().wrap(obj);
        }
    }
}

