/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.flow.InlineLevel;
import org.apache.fop.fo.properties.LengthRangeProperty;

public class Leader
extends InlineLevel {
    private Length alignmentAdjust;
    private int alignmentBaseline;
    private Length baselineShift;
    private int dominantBaseline;
    private int leaderAlignment;
    private LengthRangeProperty leaderLength;
    private int leaderPattern;
    private Length leaderPatternWidth;
    private int ruleStyle;
    private Length ruleThickness;

    public Leader(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        super.bind(pList);
        this.alignmentAdjust = pList.get(3).getLength();
        this.alignmentBaseline = pList.get(4).getEnum();
        this.baselineShift = pList.get(15).getLength();
        this.dominantBaseline = pList.get(82).getEnum();
        this.leaderAlignment = pList.get(123).getEnum();
        this.leaderLength = pList.get(124).getLengthRange();
        this.leaderPattern = pList.get(125).getEnum();
        this.leaderPatternWidth = pList.get(126).getLength();
        switch (this.leaderPattern) {
            case 134: {
                break;
            }
            case 123: {
                this.ruleStyle = pList.get(191).getEnum();
                this.ruleThickness = pList.get(192).getLength();
                break;
            }
            case 35: {
                break;
            }
            case 158: {
                break;
            }
            default: {
                throw new RuntimeException("Invalid leader pattern: " + this.leaderPattern);
            }
        }
    }

    public int getRuleStyle() {
        return this.ruleStyle;
    }

    public Length getRuleThickness() {
        return this.ruleThickness;
    }

    public int getLeaderAlignment() {
        return this.leaderAlignment;
    }

    public LengthRangeProperty getLeaderLength() {
        return this.leaderLength;
    }

    public int getLeaderPattern() {
        return this.leaderPattern;
    }

    public Length getLeaderPatternWidth() {
        return this.leaderPatternWidth;
    }

    public Length getAlignmentAdjust() {
        return this.alignmentAdjust;
    }

    public int getAlignmentBaseline() {
        return this.alignmentBaseline;
    }

    public Length getBaselineShift() {
        return this.baselineShift;
    }

    public int getDominantBaseline() {
        return this.dominantBaseline;
    }

    public String getLocalName() {
        return "leader";
    }

    public int getNameId() {
        return 19;
    }
}

