/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.api;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacebookParam
extends Enum<FacebookParam>
implements CharSequence {
    public static final /* enum */ FacebookParam SIGNATURE = new FacebookParam();
    public static final /* enum */ FacebookParam USER = new FacebookParam("user");
    public static final /* enum */ FacebookParam SESSION_KEY = new FacebookParam("session_key");
    public static final /* enum */ FacebookParam EXPIRES = new FacebookParam("expires");
    public static final /* enum */ FacebookParam IN_CANVAS = new FacebookParam("in_canvas");
    public static final /* enum */ FacebookParam IN_IFRAME = new FacebookParam("in_iframe");
    public static final /* enum */ FacebookParam IN_PROFILE = new FacebookParam("profile");
    public static final /* enum */ FacebookParam TIME = new FacebookParam("time");
    public static final /* enum */ FacebookParam FRIENDS = new FacebookParam("friends");
    public static final /* enum */ FacebookParam ADDED = new FacebookParam("added");
    public static final /* enum */ FacebookParam PROFILE_UPDATE_TIME = new FacebookParam("profile_udpate_time");
    public static final /* enum */ FacebookParam API_KEY = new FacebookParam("api_key");
    private static Map<String, FacebookParam> _lookupTable;
    private String _paramName;
    private String _signatureName;
    private static final /* synthetic */ FacebookParam[] ENUM$VALUES;

    static {
        ENUM$VALUES = new FacebookParam[]{SIGNATURE, USER, SESSION_KEY, EXPIRES, IN_CANVAS, IN_IFRAME, IN_PROFILE, TIME, FRIENDS, ADDED, PROFILE_UPDATE_TIME, API_KEY};
        _lookupTable = new HashMap<String, FacebookParam>(FacebookParam.values().length);
        FacebookParam[] facebookParamArray = FacebookParam.values();
        int n = facebookParamArray.length;
        int n2 = 0;
        while (n2 < n) {
            FacebookParam param = facebookParamArray[n2];
            _lookupTable.put(param.toString(), param);
            ++n2;
        }
    }

    public static FacebookParam get(String key) {
        return FacebookParam.isInNamespace(key) ? _lookupTable.get(key) : null;
    }

    public static boolean isInNamespace(String key) {
        return key != null && key.startsWith(SIGNATURE.toString());
    }

    public static boolean isSignature(String key) {
        return SIGNATURE.equals(FacebookParam.get(key));
    }

    private FacebookParam() {
        this._paramName = "fb_sig";
    }

    private FacebookParam(String name) {
        this._signatureName = name;
        this._paramName = "fb_sig_" + name;
    }

    @Override
    public char charAt(int index) {
        return this._paramName.charAt(index);
    }

    @Override
    public int length() {
        return this._paramName.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this._paramName.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this._paramName;
    }

    public String getSignatureName() {
        return this._signatureName;
    }

    public static String stripSignaturePrefix(String paramName) {
        if (paramName != null && paramName.startsWith("fb_sig_")) {
            return paramName.substring(7);
        }
        return paramName;
    }

    public static void main(String[] args) {
        System.out.println(FacebookParam.isSignature("fb_sig"));
        System.out.println(!FacebookParam.isSignature("fb_sig_something"));
        assert (false);
    }

    public static FacebookParam[] values() {
        FacebookParam[] facebookParamArray = ENUM$VALUES;
        int n = facebookParamArray.length;
        FacebookParam[] facebookParamArray2 = new FacebookParam[n];
        System.arraycopy(ENUM$VALUES, 0, facebookParamArray2, 0, n);
        return facebookParamArray2;
    }

    public static FacebookParam valueOf(String string) {
        return Enum.valueOf(FacebookParam.class, string);
    }
}

