/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.util.DataModelTestApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class MimetypeMapTest
extends TestCase {
    private static ApplicationContext ctx = DataModelTestApplicationContextHelper.getApplicationContext();
    private MimetypeService mimetypeService;

    public void setUp() throws Exception {
        this.mimetypeService = (MimetypeService)ctx.getBean("mimetypeService");
    }

    public void testExtensions() throws Exception {
        Map<String, String> extensionsByMimetype = this.mimetypeService.getExtensionsByMimetype();
        Map<String, String> mimetypesByExtension = this.mimetypeService.getMimetypesByExtension();
        MimetypeMapTest.assertEquals((String)"txt", (String)extensionsByMimetype.get("text/plain"));
        MimetypeMapTest.assertEquals((String)"text/plain", (String)mimetypesByExtension.get("txt"));
        MimetypeMapTest.assertEquals((String)"text/plain", (String)mimetypesByExtension.get("java"));
        MimetypeMapTest.assertEquals((String)"text/csv", (String)mimetypesByExtension.get("csv"));
        MimetypeMapTest.assertEquals((String)"text/html", (String)mimetypesByExtension.get("html"));
        MimetypeMapTest.assertEquals((String)"jpg", (String)extensionsByMimetype.get("image/jpeg"));
        MimetypeMapTest.assertEquals((String)"image/jpeg", (String)mimetypesByExtension.get("jpg"));
        MimetypeMapTest.assertEquals((String)"image/jpeg", (String)mimetypesByExtension.get("jpeg"));
        MimetypeMapTest.assertEquals((String)"image/jpeg", (String)mimetypesByExtension.get("jpe"));
        MimetypeMapTest.assertEquals((String)"doc", (String)extensionsByMimetype.get("application/msword"));
        MimetypeMapTest.assertEquals((String)"application/msword", (String)mimetypesByExtension.get("doc"));
        MimetypeMapTest.assertEquals((String)"sds", (String)extensionsByMimetype.get("application/vnd.stardivision.chart"));
    }

    public void testIsText() throws Exception {
        MimetypeMapTest.assertTrue((boolean)this.mimetypeService.isText("text/html"));
    }

    public void testGetContentCharsetFinder() throws Exception {
        MimetypeMapTest.assertNotNull((String)"No charset finder", (Object)this.mimetypeService.getContentCharsetFinder());
    }

    public void testMimetypeFromExtension() throws Exception {
        MimetypeMapTest.assertEquals((String)"application/msword", (String)this.mimetypeService.getMimetype("doc"));
        MimetypeMapTest.assertEquals((String)"application/msword", (String)this.mimetypeService.getMimetype("DOC"));
        MimetypeMapTest.assertEquals((String)"application/octet-stream", (String)this.mimetypeService.getMimetype(null));
        MimetypeMapTest.assertEquals((String)"application/octet-stream", (String)this.mimetypeService.getMimetype("unknownext"));
    }

    public void testGuessMimetypeForFilename() throws Exception {
        MimetypeMapTest.assertEquals((String)"application/msword", (String)this.mimetypeService.guessMimetype("something.doc"));
        MimetypeMapTest.assertEquals((String)"application/msword", (String)this.mimetypeService.guessMimetype("SOMETHING.DOC"));
        MimetypeMapTest.assertEquals((String)"application/octet-stream", (String)this.mimetypeService.guessMimetype("noextension"));
        MimetypeMapTest.assertEquals((String)"application/octet-stream", (String)this.mimetypeService.guessMimetype("file.unknownext"));
    }
}

