/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.tenant.TenantDeployer;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryComponent
implements DictionaryService,
TenantDeployer {
    private DictionaryDAO dictionaryDAO;

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    @Override
    public Collection<QName> getAllModels() {
        return this.dictionaryDAO.getModels();
    }

    @Override
    public ModelDefinition getModel(QName model) {
        return this.dictionaryDAO.getModel(model);
    }

    @Override
    public Collection<QName> getAllDataTypes() {
        ArrayList<QName> propertyTypes = new ArrayList<QName>();
        for (QName model : this.getAllModels()) {
            propertyTypes.addAll(this.getDataTypes(model));
        }
        return propertyTypes;
    }

    @Override
    public Collection<QName> getDataTypes(QName model) {
        Collection<DataTypeDefinition> propertyTypes = this.dictionaryDAO.getDataTypes(model);
        ArrayList<QName> qnames = new ArrayList<QName>(propertyTypes.size());
        for (DataTypeDefinition def : propertyTypes) {
            qnames.add(def.getName());
        }
        return qnames;
    }

    @Override
    public Collection<QName> getAllTypes() {
        ArrayList<QName> types = new ArrayList<QName>(100);
        for (QName model : this.getAllModels()) {
            types.addAll(this.getTypes(model));
        }
        return types;
    }

    @Override
    public Collection<QName> getSubTypes(QName superType, boolean follow) {
        return this.dictionaryDAO.getSubTypes(superType, follow);
    }

    @Override
    public Collection<QName> getTypes(QName model) {
        Collection<TypeDefinition> types = this.dictionaryDAO.getTypes(model);
        ArrayList<QName> qnames = new ArrayList<QName>(types.size());
        for (TypeDefinition def : types) {
            qnames.add(def.getName());
        }
        return qnames;
    }

    @Override
    public Collection<QName> getAllAspects() {
        ArrayList<QName> aspects = new ArrayList<QName>(64);
        for (QName model : this.getAllModels()) {
            aspects.addAll(this.getAspects(model));
        }
        return aspects;
    }

    @Override
    public Collection<QName> getAllAssociations() {
        ArrayList<QName> associations = new ArrayList<QName>(64);
        for (QName model : this.getAllModels()) {
            associations.addAll(this.getAssociations(model));
        }
        return associations;
    }

    @Override
    public Collection<QName> getSubAspects(QName superAspect, boolean follow) {
        return this.dictionaryDAO.getSubAspects(superAspect, follow);
    }

    @Override
    public Collection<QName> getAspects(QName model) {
        Collection<AspectDefinition> aspects = this.dictionaryDAO.getAspects(model);
        ArrayList<QName> qnames = new ArrayList<QName>(aspects.size());
        for (AspectDefinition def : aspects) {
            qnames.add(def.getName());
        }
        return qnames;
    }

    @Override
    public Collection<QName> getAssociations(QName model) {
        Collection<AssociationDefinition> associations = this.dictionaryDAO.getAssociations(model);
        ArrayList<QName> qnames = new ArrayList<QName>(associations.size());
        for (AssociationDefinition def : associations) {
            qnames.add(def.getName());
        }
        return qnames;
    }

    @Override
    public boolean isSubClass(QName className, QName ofClassName) {
        ParameterCheck.mandatory((String)"className", (Object)className);
        ParameterCheck.mandatory((String)"ofClassName", (Object)ofClassName);
        ClassDefinition classDef = this.getClass(className);
        if (classDef == null) {
            return false;
        }
        ClassDefinition ofClassDef = this.getClass(ofClassName);
        if (ofClassDef == null) {
            return false;
        }
        boolean subClassOf = false;
        if (classDef.isAspect() == ofClassDef.isAspect()) {
            while (classDef != null) {
                if (classDef.equals(ofClassDef)) {
                    subClassOf = true;
                    break;
                }
                QName parentClassName = classDef.getParentName();
                classDef = parentClassName == null ? null : this.getClass(parentClassName);
            }
        }
        return subClassOf;
    }

    @Override
    public DataTypeDefinition getDataType(QName name) {
        return this.dictionaryDAO.getDataType(name);
    }

    @Override
    public DataTypeDefinition getDataType(Class javaClass) {
        return this.dictionaryDAO.getDataType(javaClass);
    }

    @Override
    public TypeDefinition getType(QName name) {
        return this.dictionaryDAO.getType(name);
    }

    @Override
    public AspectDefinition getAspect(QName name) {
        return this.dictionaryDAO.getAspect(name);
    }

    @Override
    public ClassDefinition getClass(QName name) {
        return this.dictionaryDAO.getClass(name);
    }

    @Override
    public TypeDefinition getAnonymousType(QName type, Collection<QName> aspects) {
        return this.dictionaryDAO.getAnonymousType(type, aspects);
    }

    @Override
    public PropertyDefinition getProperty(QName className, QName propertyName) {
        PropertyDefinition propDef = null;
        ClassDefinition classDef = this.dictionaryDAO.getClass(className);
        if (classDef != null) {
            Map<QName, PropertyDefinition> propDefs = classDef.getProperties();
            propDef = propDefs.get(propertyName);
        }
        return propDef;
    }

    @Override
    public Map<QName, PropertyDefinition> getPropertyDefs(QName className) {
        ClassDefinition classDef = this.dictionaryDAO.getClass(className);
        if (classDef != null) {
            return classDef.getProperties();
        }
        return null;
    }

    @Override
    public PropertyDefinition getProperty(QName propertyName) {
        return this.dictionaryDAO.getProperty(propertyName);
    }

    @Override
    public AssociationDefinition getAssociation(QName associationName) {
        return this.dictionaryDAO.getAssociation(associationName);
    }

    @Override
    public Collection<QName> getAllProperties(QName dataType) {
        HashSet<QName> aspects = new HashSet<QName>(64);
        for (QName model : this.getAllModels()) {
            aspects.addAll(this.getProperties(model, dataType));
        }
        return aspects;
    }

    @Override
    public Collection<QName> getProperties(QName model, QName dataType) {
        Collection<PropertyDefinition> propDefs = this.dictionaryDAO.getProperties(model, dataType);
        HashSet<QName> props = new HashSet<QName>(propDefs.size());
        for (PropertyDefinition def : propDefs) {
            props.add(def.getName());
        }
        return props;
    }

    @Override
    public Collection<QName> getProperties(QName model) {
        Collection<PropertyDefinition> propDefs = this.dictionaryDAO.getProperties(model);
        HashSet<QName> props = new HashSet<QName>(propDefs.size());
        for (PropertyDefinition def : propDefs) {
            props.add(def.getName());
        }
        return props;
    }

    @Override
    public ConstraintDefinition getConstraint(QName constraintQName) {
        return this.dictionaryDAO.getConstraint(constraintQName);
    }

    @Override
    public Collection<ConstraintDefinition> getConstraints(QName model) {
        return this.dictionaryDAO.getConstraints(model);
    }

    @Override
    public Collection<ConstraintDefinition> getConstraints(QName model, boolean referenceableDefsOnly) {
        return this.dictionaryDAO.getConstraints(model, referenceableDefsOnly);
    }

    @Override
    public void init() {
        this.dictionaryDAO.init();
    }

    @Override
    public void destroy() {
        this.dictionaryDAO.destroy();
    }

    @Override
    public void onEnableTenant() {
        this.dictionaryDAO.reset();
    }

    @Override
    public void onDisableTenant() {
        this.dictionaryDAO.destroy();
    }
}

