/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.MemoryCache;
import org.alfresco.repo.dictionary.CompiledModel;
import org.alfresco.repo.dictionary.DictionaryBootstrap;
import org.alfresco.repo.dictionary.DictionaryDAOImpl;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2ModelDiff;
import org.alfresco.repo.dictionary.NamespaceDAOImpl;
import org.alfresco.repo.tenant.SingleTServiceImpl;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffModelTest
extends TestCase {
    public static final String MODEL1_XML = "<model name=\"test1:model1\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>           <property name=\"test1:prop2\">              <type>d:int</type>           </property>        </properties>      </type>      <type name=\"test1:type2\">        <title>Base</title>        <description>The Base Type 2</description>        <properties>           <property name=\"test1:prop3\">              <type>d:text</type>           </property>           <property name=\"test1:prop4\">              <type>d:int</type>           </property>        </properties>      </type>      <type name=\"test1:type3\">        <title>Base</title>        <description>The Base Type 3</description>        <properties>           <property name=\"test1:prop5\">              <type>d:text</type>           </property>           <property name=\"test1:prop6\">              <type>d:int</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>           <property name=\"test1:prop10\">              <type>d:int</type>           </property>        </properties>      </aspect>      <aspect name=\"test1:aspect2\">        <title>Base</title>        <description>The Base Aspect 2</description>        <properties>           <property name=\"test1:prop11\">              <type>d:text</type>           </property>           <property name=\"test1:prop12\">              <type>d:int</type>           </property>        </properties>      </aspect>      <aspect name=\"test1:aspect3\">        <title>Base</title>        <description>The Base Aspect 3</description>        <properties>           <property name=\"test1:prop13\">              <type>d:text</type>           </property>           <property name=\"test1:prop14\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>";
    public static final String MODEL1_UPDATE1_XML = "<model name=\"test1:model1\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>           <property name=\"test1:prop2\">              <type>d:int</type>           </property>        </properties>      </type>      <type name=\"test1:type3\">        <title>Base</title>        <description>The Base Type 3</description>        <properties>           <property name=\"test1:prop5\">              <type>d:text</type>           </property>        </properties>      </type>      <type name=\"test1:type4\">        <title>Base</title>        <description>The Base Type 4</description>        <properties>           <property name=\"test1:prop7\">              <type>d:text</type>           </property>           <property name=\"test1:prop8\">              <type>d:int</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>           <property name=\"test1:prop10\">              <type>d:int</type>           </property>        </properties>      </aspect>      <aspect name=\"test1:aspect3\">        <title>Base</title>        <description>The Base Aspect 3</description>        <properties>           <property name=\"test1:prop13\">              <type>d:int</type>           </property>           <property name=\"test1:prop14\">              <type>d:int</type>           </property>        </properties>      </aspect>      <aspect name=\"test1:aspect4\">        <title>Base</title>        <description>The Base Aspect 4</description>        <properties>           <property name=\"test1:prop15\">              <type>d:text</type>           </property>           <property name=\"test1:prop16\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>";
    public static final String MODEL2_XML = "<model name=\"test1:model2\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>           <property name=\"test1:prop2\">              <type>d:int</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>           <property name=\"test1:prop10\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>";
    public static final String MODEL2_EXTRA_PROPERTIES_XML = "<model name=\"test1:model2\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>           <property name=\"test1:prop2\">              <type>d:int</type>           </property>           <property name=\"test1:prop3\">              <type>d:date</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop11\">              <type>d:boolean</type>           </property>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>           <property name=\"test1:prop10\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>";
    public static final String MODEL3_XML = "<model name=\"test1:model3\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>           <property name=\"test1:prop2\">              <type>d:int</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>           <property name=\"test1:prop10\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>";
    public static final String MODEL3_EXTRA_TYPES_AND_ASPECTS_XML = "<model name=\"test1:model3\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>           <property name=\"test1:prop2\">              <type>d:int</type>           </property>        </properties>      </type>      <type name=\"test1:type2\">        <title>Base</title>        <description>The Base Type 2</description>        <properties>           <property name=\"test1:prop3\">              <type>d:text</type>           </property>           <property name=\"test1:prop4\">              <type>d:int</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>           <property name=\"test1:prop10\">              <type>d:int</type>           </property>        </properties>      </aspect>      <aspect name=\"test1:aspect2\">        <title>Base</title>        <description>The Base Aspect 2</description>        <properties>           <property name=\"test1:prop11\">              <type>d:text</type>           </property>           <property name=\"test1:prop12\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>";
    public static final String MODEL4_XML = "<model name=\"test1:model4\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>        </properties>      </aspect>   </aspects></model>";
    public static final String MODEL4_EXTRA_DEFAULT_ASPECT_XML = "<model name=\"test1:model4\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>        </properties>        <mandatory-aspects>           <aspect>test1:aspect1</aspect>        </mandatory-aspects>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>        </properties>      </aspect>   </aspects></model>";
    public static final String MODEL5_XML = "<model name=\"test1:model5\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>        </properties>      </type>      <type name=\"test1:type2\">        <title>Base</title>        <description>The Base Type 2</description>        <properties>           <property name=\"test1:prop3\">              <type>d:text</type>           </property>           <property name=\"test1:prop4\">              <type>d:int</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>        </properties>      </aspect>      <aspect name=\"test1:aspect2\">        <title>Base</title>        <description>The Base Aspect 2</description>        <properties>           <property name=\"test1:prop11\">              <type>d:text</type>           </property>           <property name=\"test1:prop12\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>";
    public static final String MODEL5_EXTRA_ASSOCIATIONS_XML = "<model name=\"test1:model5\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>        </properties>        <associations>           <child-association name=\"test1:assoc1\">               <source>                   <mandatory>false</mandatory>                   <many>false</many>               </source>               <target>                   <class>test1:type2</class>                   <mandatory>false</mandatory>                   <many>false</many>               </target>           </child-association>        </associations>      </type>      <type name=\"test1:type2\">        <title>Base</title>        <description>The Base Type 2</description>        <properties>           <property name=\"test1:prop3\">              <type>d:text</type>           </property>           <property name=\"test1:prop4\">              <type>d:int</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>        </properties>        <associations>           <association name=\"test1:assoc2\">               <source>                   <role>test1:role1</role>                   <mandatory>false</mandatory>                   <many>true</many>               </source>               <target>                   <class>test1:aspect2</class>                   <role>test1:role2</role>                   <mandatory>false</mandatory>                   <many>true</many>               </target>           </association>        </associations>      </aspect>      <aspect name=\"test1:aspect2\">        <title>Base</title>        <description>The Base Aspect 2</description>        <properties>           <property name=\"test1:prop11\">              <type>d:text</type>           </property>           <property name=\"test1:prop12\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>";
    public static final String MODEL6_XML = "<model name=\"test1:model6\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Type1 Title</title>        <description>Type1 Description</description>        <properties>           <property name=\"test1:prop1\">              <title>Prop1 Title</title>              <description>Prop1 Description</description>              <type>d:text</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Aspect1 Title</title>        <description>Aspect1 Description</description>        <properties>           <property name=\"test1:prop9\">              <title>Prop9 Title</title>              <description>Prop9 Description</description>              <type>d:text</type>           </property>        </properties>      </aspect>   </aspects></model>";
    public static final String MODEL6_UPDATE1_XML = "<model name=\"test1:model6\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description - UPDATE1</description>   <author>Alfresco - UPDATE1</author>   <published>2009-08-01</published>   <version>2.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Type1 Title - UPDATE1</title>        <description>Type1 Description - UPDATE1</description>        <properties>           <property name=\"test1:prop1\">              <title>Prop1 Title - UPDATE1</title>              <description>Prop1 Description - UPDATE1</description>              <type>d:text</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Aspect1 Title</title>        <description>Aspect1 Description</description>        <properties>           <property name=\"test1:prop9\">              <title>Prop9 Title - UPDATE1</title>              <description>Prop9 Description - UPDATE1</description>              <type>d:text</type>           </property>        </properties>      </aspect>   </aspects></model>";
    private DictionaryDAOImpl dictionaryDAO;

    protected void setUp() throws Exception {
        SingleTServiceImpl tenantService = new SingleTServiceImpl();
        NamespaceDAOImpl namespaceDAO = new NamespaceDAOImpl();
        namespaceDAO.setTenantService(tenantService);
        this.initNamespaceCaches(namespaceDAO);
        this.dictionaryDAO = new DictionaryDAOImpl(namespaceDAO);
        this.dictionaryDAO.setTenantService(tenantService);
        this.initDictionaryCaches(this.dictionaryDAO);
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel.xml");
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        bootstrap.setModels(bootstrapModels);
        bootstrap.setDictionaryDAO(this.dictionaryDAO);
        bootstrap.bootstrap();
    }

    private void initDictionaryCaches(DictionaryDAOImpl dictionaryDAO) {
        dictionaryDAO.setDictionaryRegistryCache(new MemoryCache<String, DictionaryDAOImpl.DictionaryRegistry>());
    }

    private void initNamespaceCaches(NamespaceDAOImpl namespaceDAO) {
        namespaceDAO.setNamespaceRegistryCache(new MemoryCache<String, NamespaceDAOImpl.NamespaceRegistry>());
    }

    public void testDeleteModel() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(MODEL1_XML.getBytes());
        M2Model model = M2Model.createModel(byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel previousVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List<M2ModelDiff> modelDiffs = this.dictionaryDAO.diffModel(previousVersion, null);
        for (M2ModelDiff modelDiff : modelDiffs) {
            System.out.println(modelDiff.toString());
        }
        DiffModelTest.assertEquals((int)6, (int)modelDiffs.size());
        DiffModelTest.assertEquals((int)3, (int)this.countDiffs(modelDiffs, "TYPE", "deleted"));
        DiffModelTest.assertEquals((int)3, (int)this.countDiffs(modelDiffs, "ASPECT", "deleted"));
    }

    public void testNoExistingModelToDelete() {
        try {
            List<M2ModelDiff> modelDiffs = this.dictionaryDAO.diffModel(null, null);
            DiffModelTest.assertTrue((String)"Should throw exeception that there is no previous version of the model to delete", (boolean)true);
        }
        catch (AlfrescoRuntimeException e) {
            DiffModelTest.assertTrue((String)"Wrong error message", (boolean)e.getMessage().equals("Invalid arguments - no previous version of model to delete"));
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(MODEL1_XML.getBytes());
        M2Model model = M2Model.createModel(byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel compiledModel = this.dictionaryDAO.getCompiledModel(modelName);
        try {
            List<M2ModelDiff> modelDiffs = this.dictionaryDAO.diffModel(null, compiledModel);
            DiffModelTest.assertTrue((String)"Should throw exeception that there is no previous version of the model to delete", (boolean)true);
        }
        catch (AlfrescoRuntimeException e) {
            DiffModelTest.assertTrue((String)"Wrong error message", (boolean)e.getMessage().equals("Invalid arguments - no previous version of model to delete"));
        }
    }

    public void testNewModel() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(MODEL1_XML.getBytes());
        M2Model model = M2Model.createModel(byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel newVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List<M2ModelDiff> modelDiffs = this.dictionaryDAO.diffModel(null, newVersion);
        for (M2ModelDiff modelDiff : modelDiffs) {
            System.out.println(modelDiff.toString());
        }
        DiffModelTest.assertEquals((int)6, (int)modelDiffs.size());
        DiffModelTest.assertEquals((int)3, (int)this.countDiffs(modelDiffs, "TYPE", "created"));
        DiffModelTest.assertEquals((int)3, (int)this.countDiffs(modelDiffs, "ASPECT", "created"));
    }

    public void testNonIncUpdateModel() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(MODEL1_XML.getBytes());
        M2Model model = M2Model.createModel(byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel previousVersion = this.dictionaryDAO.getCompiledModel(modelName);
        byteArrayInputStream = new ByteArrayInputStream(MODEL1_UPDATE1_XML.getBytes());
        model = M2Model.createModel(byteArrayInputStream);
        modelName = this.dictionaryDAO.putModel(model);
        CompiledModel newVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List<M2ModelDiff> modelDiffs = this.dictionaryDAO.diffModel(previousVersion, newVersion);
        for (M2ModelDiff M2ModelDiff2 : modelDiffs) {
            System.out.println(M2ModelDiff2.toString());
        }
        DiffModelTest.assertEquals((int)16, (int)modelDiffs.size());
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "TYPE", "created"));
        DiffModelTest.assertEquals((int)2, (int)this.countDiffs(modelDiffs, "TYPE", "unchanged"));
        DiffModelTest.assertEquals((int)0, (int)this.countDiffs(modelDiffs, "TYPE", "updated"));
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "TYPE", "deleted"));
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "ASPECT", "created"));
        DiffModelTest.assertEquals((int)2, (int)this.countDiffs(modelDiffs, "ASPECT", "unchanged"));
        DiffModelTest.assertEquals((int)0, (int)this.countDiffs(modelDiffs, "ASPECT", "updated"));
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "ASPECT", "deleted"));
        DiffModelTest.assertEquals((int)0, (int)this.countDiffs(modelDiffs, "PROPERTY", "created"));
        DiffModelTest.assertEquals((int)6, (int)this.countDiffs(modelDiffs, "PROPERTY", "unchanged"));
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "PROPERTY", "updated"));
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "PROPERTY", "deleted"));
    }

    public void testIncUpdatePropertiesAdded() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(MODEL2_XML.getBytes());
        M2Model model = M2Model.createModel(byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel previousVersion = this.dictionaryDAO.getCompiledModel(modelName);
        byteArrayInputStream = new ByteArrayInputStream(MODEL2_EXTRA_PROPERTIES_XML.getBytes());
        model = M2Model.createModel(byteArrayInputStream);
        modelName = this.dictionaryDAO.putModel(model);
        CompiledModel newVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List<M2ModelDiff> modelDiffs = this.dictionaryDAO.diffModel(previousVersion, newVersion);
        for (M2ModelDiff modelDiff : modelDiffs) {
            System.out.println(modelDiff.toString());
        }
        DiffModelTest.assertEquals((int)8, (int)modelDiffs.size());
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "TYPE", "unchanged"));
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "ASPECT", "unchanged"));
        DiffModelTest.assertEquals((int)4, (int)this.countDiffs(modelDiffs, "PROPERTY", "unchanged"));
        DiffModelTest.assertEquals((int)2, (int)this.countDiffs(modelDiffs, "PROPERTY", "created"));
    }

    public void testIncUpdateTypesAndAspectsAdded() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(MODEL3_XML.getBytes());
        M2Model model = M2Model.createModel(byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel previousVersion = this.dictionaryDAO.getCompiledModel(modelName);
        byteArrayInputStream = new ByteArrayInputStream(MODEL3_EXTRA_TYPES_AND_ASPECTS_XML.getBytes());
        model = M2Model.createModel(byteArrayInputStream);
        modelName = this.dictionaryDAO.putModel(model);
        CompiledModel newVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List<M2ModelDiff> modelDiffs = this.dictionaryDAO.diffModel(previousVersion, newVersion);
        for (M2ModelDiff modelDiff : modelDiffs) {
            System.out.println(modelDiff.toString());
        }
        DiffModelTest.assertEquals((int)8, (int)modelDiffs.size());
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "TYPE", "unchanged"));
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "ASPECT", "unchanged"));
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "TYPE", "created"));
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "ASPECT", "created"));
        DiffModelTest.assertEquals((int)4, (int)this.countDiffs(modelDiffs, "PROPERTY", "unchanged"));
    }

    public void testIncUpdateAssociationsAdded() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(MODEL5_XML.getBytes());
        M2Model model = M2Model.createModel(byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel previousVersion = this.dictionaryDAO.getCompiledModel(modelName);
        byteArrayInputStream = new ByteArrayInputStream(MODEL5_EXTRA_ASSOCIATIONS_XML.getBytes());
        model = M2Model.createModel(byteArrayInputStream);
        modelName = this.dictionaryDAO.putModel(model);
        CompiledModel newVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List<M2ModelDiff> modelDiffs = this.dictionaryDAO.diffModel(previousVersion, newVersion);
        for (M2ModelDiff modelDiff : modelDiffs) {
            System.out.println(modelDiff.toString());
        }
        DiffModelTest.assertEquals((int)12, (int)modelDiffs.size());
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "TYPE", "updated_inc"));
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "TYPE", "unchanged"));
        DiffModelTest.assertEquals((int)2, (int)this.countDiffs(modelDiffs, "ASPECT", "unchanged"));
        DiffModelTest.assertEquals((int)6, (int)this.countDiffs(modelDiffs, "PROPERTY", "unchanged"));
        DiffModelTest.assertEquals((int)2, (int)this.countDiffs(modelDiffs, "ASSOCIATION", "created"));
    }

    public void testIncUpdateTitleDescription() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(MODEL6_XML.getBytes());
        M2Model model = M2Model.createModel(byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel previousVersion = this.dictionaryDAO.getCompiledModel(modelName);
        byteArrayInputStream = new ByteArrayInputStream(MODEL6_UPDATE1_XML.getBytes());
        model = M2Model.createModel(byteArrayInputStream);
        modelName = this.dictionaryDAO.putModel(model);
        CompiledModel newVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List<M2ModelDiff> modelDiffs = this.dictionaryDAO.diffModel(previousVersion, newVersion);
        for (M2ModelDiff modelDiff : modelDiffs) {
            System.out.println(modelDiff.toString());
        }
        DiffModelTest.assertEquals((int)4, (int)modelDiffs.size());
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "TYPE", "updated_inc"));
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "ASPECT", "unchanged"));
        DiffModelTest.assertEquals((int)2, (int)this.countDiffs(modelDiffs, "PROPERTY", "updated_inc"));
    }

    public void testNonIncUpdatePropertiesRemoved() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(MODEL2_EXTRA_PROPERTIES_XML.getBytes());
        M2Model model = M2Model.createModel(byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel previousVersion = this.dictionaryDAO.getCompiledModel(modelName);
        byteArrayInputStream = new ByteArrayInputStream(MODEL2_XML.getBytes());
        model = M2Model.createModel(byteArrayInputStream);
        modelName = this.dictionaryDAO.putModel(model);
        CompiledModel newVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List<M2ModelDiff> modelDiffs = this.dictionaryDAO.diffModel(previousVersion, newVersion);
        for (M2ModelDiff modelDiff : modelDiffs) {
            System.out.println(modelDiff.toString());
        }
        DiffModelTest.assertEquals((int)8, (int)modelDiffs.size());
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "TYPE", "unchanged"));
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "ASPECT", "unchanged"));
        DiffModelTest.assertEquals((int)4, (int)this.countDiffs(modelDiffs, "PROPERTY", "unchanged"));
        DiffModelTest.assertEquals((int)2, (int)this.countDiffs(modelDiffs, "PROPERTY", "deleted"));
    }

    public void testNonIncUpdateTypesAndAspectsRemoved() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(MODEL3_EXTRA_TYPES_AND_ASPECTS_XML.getBytes());
        M2Model model = M2Model.createModel(byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel previousVersion = this.dictionaryDAO.getCompiledModel(modelName);
        byteArrayInputStream = new ByteArrayInputStream(MODEL3_XML.getBytes());
        model = M2Model.createModel(byteArrayInputStream);
        modelName = this.dictionaryDAO.putModel(model);
        CompiledModel newVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List<M2ModelDiff> modelDiffs = this.dictionaryDAO.diffModel(previousVersion, newVersion);
        for (M2ModelDiff modelDiff : modelDiffs) {
            System.out.println(modelDiff.toString());
        }
        DiffModelTest.assertEquals((int)8, (int)modelDiffs.size());
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "TYPE", "unchanged"));
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "ASPECT", "unchanged"));
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "TYPE", "deleted"));
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "ASPECT", "deleted"));
        DiffModelTest.assertEquals((int)4, (int)this.countDiffs(modelDiffs, "PROPERTY", "unchanged"));
    }

    public void testNonIncUpdateDefaultAspectAdded() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(MODEL4_XML.getBytes());
        M2Model model = M2Model.createModel(byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel previousVersion = this.dictionaryDAO.getCompiledModel(modelName);
        byteArrayInputStream = new ByteArrayInputStream(MODEL4_EXTRA_DEFAULT_ASPECT_XML.getBytes());
        model = M2Model.createModel(byteArrayInputStream);
        modelName = this.dictionaryDAO.putModel(model);
        CompiledModel newVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List<M2ModelDiff> modelDiffs = this.dictionaryDAO.diffModel(previousVersion, newVersion);
        for (M2ModelDiff modelDiff : modelDiffs) {
            System.out.println(modelDiff.toString());
        }
        DiffModelTest.assertEquals((int)4, (int)modelDiffs.size());
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "TYPE", "updated"));
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "ASPECT", "unchanged"));
        DiffModelTest.assertEquals((int)2, (int)this.countDiffs(modelDiffs, "PROPERTY", "unchanged"));
    }

    public void testNonIncUpdateAssociationsRemoved() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(MODEL5_EXTRA_ASSOCIATIONS_XML.getBytes());
        M2Model model = M2Model.createModel(byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel previousVersion = this.dictionaryDAO.getCompiledModel(modelName);
        byteArrayInputStream = new ByteArrayInputStream(MODEL5_XML.getBytes());
        model = M2Model.createModel(byteArrayInputStream);
        modelName = this.dictionaryDAO.putModel(model);
        CompiledModel newVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List<M2ModelDiff> modelDiffs = this.dictionaryDAO.diffModel(previousVersion, newVersion);
        for (M2ModelDiff modelDiff : modelDiffs) {
            System.out.println(modelDiff.toString());
        }
        DiffModelTest.assertEquals((int)12, (int)modelDiffs.size());
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "TYPE", "updated"));
        DiffModelTest.assertEquals((int)1, (int)this.countDiffs(modelDiffs, "TYPE", "unchanged"));
        DiffModelTest.assertEquals((int)2, (int)this.countDiffs(modelDiffs, "ASPECT", "unchanged"));
        DiffModelTest.assertEquals((int)6, (int)this.countDiffs(modelDiffs, "PROPERTY", "unchanged"));
        DiffModelTest.assertEquals((int)2, (int)this.countDiffs(modelDiffs, "ASSOCIATION", "deleted"));
    }

    private int countDiffs(List<M2ModelDiff> M2ModelDiffs, String elementType, String diffType) {
        int count = 0;
        for (M2ModelDiff modelDiff : M2ModelDiffs) {
            if (!modelDiff.getDiffType().equals(diffType) || !modelDiff.getElementType().equals(elementType)) continue;
            ++count;
        }
        return count;
    }
}

