/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.lucene;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.Constraint;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.impl.BaseDisjunction;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneDisjunction
extends BaseDisjunction
implements LuceneQueryBuilderComponent {
    public LuceneDisjunction(List<Constraint> constraints) {
        super(constraints);
    }

    @Override
    public Query addComponent(Set<String> selectors, Map<String, Argument> functionArgs, LuceneQueryBuilderContext luceneContext, FunctionEvaluationContext functionContext) throws ParseException {
        BooleanQuery query = new BooleanQuery();
        for (Constraint constraint : this.getConstraints()) {
            if (constraint instanceof LuceneQueryBuilderComponent) {
                LuceneQueryBuilderComponent luceneQueryBuilderComponent = (LuceneQueryBuilderComponent)((Object)constraint);
                Query constraintQuery = luceneQueryBuilderComponent.addComponent(selectors, functionArgs, luceneContext, functionContext);
                constraintQuery.setBoost(constraint.getBoost());
                if (constraintQuery != null) {
                    switch (constraint.getOccur()) {
                        case DEFAULT: 
                        case MANDATORY: 
                        case OPTIONAL: {
                            query.add(constraintQuery, BooleanClause.Occur.SHOULD);
                            break;
                        }
                        case EXCLUDE: {
                            BooleanQuery subQuery = new BooleanQuery();
                            TermQuery termQuery = new TermQuery(new Term("ISNODE", "T"));
                            termQuery.setBoost(constraintQuery.getBoost());
                            subQuery.add((Query)termQuery, BooleanClause.Occur.MUST);
                            subQuery.add(constraintQuery, BooleanClause.Occur.MUST_NOT);
                            subQuery.setBoost(constraintQuery.getBoost());
                            query.add((Query)subQuery, BooleanClause.Occur.SHOULD);
                        }
                    }
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            throw new UnsupportedOperationException();
        }
        return query;
    }
}

