/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.lucene.functions;

import java.util.Map;
import java.util.Set;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.impl.functions.FTSProximity;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderContext;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneFTSProximity
extends FTSProximity
implements LuceneQueryBuilderComponent {
    @Override
    public Query addComponent(Set<String> selectors, Map<String, Argument> functionArgs, LuceneQueryBuilderContext luceneContext, FunctionEvaluationContext functionContext) throws ParseException {
        Query query;
        PropertyArgument propArg;
        LuceneQueryParser lqp = luceneContext.getLuceneQueryParser();
        Argument argument = functionArgs.get("First");
        String first = (String)((Object)argument.getValue(functionContext));
        argument = functionArgs.get("Last");
        String last = (String)((Object)argument.getValue(functionContext));
        int slop = 100;
        argument = functionArgs.get("Slop");
        if (argument != null) {
            String val = (String)((Object)argument.getValue(functionContext));
            slop = Integer.parseInt(val);
        }
        if ((propArg = (PropertyArgument)functionArgs.get("Property")) != null) {
            String prop = propArg.getPropertyName();
            query = lqp.getSpanQuery(functionContext.getLuceneFieldName(prop), first, last, slop, true);
        } else {
            query = lqp.getSpanQuery(lqp.getField(), first, last, slop, true);
        }
        return query;
    }
}

