/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository.datatype;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.EntityRef;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.Period;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.Duration;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.cmr.repository.datatype.TypeConverter;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.VersionNumber;
import org.springframework.extensions.surf.exception.PlatformRuntimeException;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.ISO8601DateFormat;

public class DefaultTypeConverter {
    public static TypeConverter INSTANCE = new TypeConverter();

    static {
        INSTANCE.addConverter(String.class, Class.class, new TypeConverter.Converter<String, Class>(){

            @Override
            public Class convert(String source) {
                try {
                    return Class.forName(source);
                }
                catch (ClassNotFoundException e) {
                    throw new TypeConversionException("Failed to convert string to class: " + source, e);
                }
            }
        });
        INSTANCE.addConverter(String.class, Boolean.class, new TypeConverter.Converter<String, Boolean>(){

            @Override
            public Boolean convert(String source) {
                return Boolean.valueOf(source);
            }
        });
        INSTANCE.addConverter(String.class, Character.class, new TypeConverter.Converter<String, Character>(){

            @Override
            public Character convert(String source) {
                if (source == null || source.length() == 0) {
                    return null;
                }
                return Character.valueOf(source.charAt(0));
            }
        });
        INSTANCE.addConverter(String.class, Number.class, new TypeConverter.Converter<String, Number>(){

            @Override
            public Number convert(String source) {
                try {
                    return DecimalFormat.getNumberInstance().parse(source);
                }
                catch (ParseException e) {
                    throw new TypeConversionException("Failed to parse number " + source, e);
                }
            }
        });
        INSTANCE.addConverter(String.class, Byte.class, new TypeConverter.Converter<String, Byte>(){

            @Override
            public Byte convert(String source) {
                return Byte.valueOf(source);
            }
        });
        INSTANCE.addConverter(String.class, Short.class, new TypeConverter.Converter<String, Short>(){

            @Override
            public Short convert(String source) {
                return Short.valueOf(source);
            }
        });
        INSTANCE.addConverter(String.class, Integer.class, new TypeConverter.Converter<String, Integer>(){

            @Override
            public Integer convert(String source) {
                return Integer.valueOf(source);
            }
        });
        INSTANCE.addConverter(String.class, Long.class, new TypeConverter.Converter<String, Long>(){

            @Override
            public Long convert(String source) {
                return Long.valueOf(source);
            }
        });
        INSTANCE.addConverter(String.class, Float.class, new TypeConverter.Converter<String, Float>(){

            @Override
            public Float convert(String source) {
                return Float.valueOf(source);
            }
        });
        INSTANCE.addConverter(String.class, Double.class, new TypeConverter.Converter<String, Double>(){

            @Override
            public Double convert(String source) {
                return Double.valueOf(source);
            }
        });
        INSTANCE.addConverter(String.class, BigInteger.class, new TypeConverter.Converter<String, BigInteger>(){

            @Override
            public BigInteger convert(String source) {
                return new BigInteger(source);
            }
        });
        INSTANCE.addConverter(String.class, BigDecimal.class, new TypeConverter.Converter<String, BigDecimal>(){

            @Override
            public BigDecimal convert(String source) {
                return new BigDecimal(source);
            }
        });
        INSTANCE.addConverter(String.class, Date.class, new TypeConverter.Converter<String, Date>(){

            @Override
            public Date convert(String source) {
                try {
                    Date date = ISO8601DateFormat.parse((String)source);
                    return date;
                }
                catch (PlatformRuntimeException e) {
                    throw new TypeConversionException("Failed to convert date " + source + " to string", e);
                }
            }
        });
        INSTANCE.addConverter(String.class, Duration.class, new TypeConverter.Converter<String, Duration>(){

            @Override
            public Duration convert(String source) {
                return new Duration(source);
            }
        });
        INSTANCE.addConverter(String.class, QName.class, new TypeConverter.Converter<String, QName>(){

            @Override
            public QName convert(String source) {
                return QName.createQName(source);
            }
        });
        INSTANCE.addConverter(String.class, ContentData.class, new TypeConverter.Converter<String, ContentData>(){

            @Override
            public ContentData convert(String source) {
                return ContentData.createContentProperty(source);
            }
        });
        INSTANCE.addConverter(String.class, NodeRef.class, new TypeConverter.Converter<String, NodeRef>(){

            @Override
            public NodeRef convert(String source) {
                return new NodeRef(source);
            }
        });
        INSTANCE.addConverter(String.class, StoreRef.class, new TypeConverter.Converter<String, StoreRef>(){

            @Override
            public StoreRef convert(String source) {
                return new StoreRef(source);
            }
        });
        INSTANCE.addConverter(String.class, ChildAssociationRef.class, new TypeConverter.Converter<String, ChildAssociationRef>(){

            @Override
            public ChildAssociationRef convert(String source) {
                return new ChildAssociationRef(source);
            }
        });
        INSTANCE.addConverter(String.class, AssociationRef.class, new TypeConverter.Converter<String, AssociationRef>(){

            @Override
            public AssociationRef convert(String source) {
                return new AssociationRef(source);
            }
        });
        INSTANCE.addConverter(String.class, InputStream.class, new TypeConverter.Converter<String, InputStream>(){

            @Override
            public InputStream convert(String source) {
                try {
                    return new ByteArrayInputStream(source.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new TypeConversionException("Encoding not supported", e);
                }
            }
        });
        INSTANCE.addConverter(String.class, MLText.class, new TypeConverter.Converter<String, MLText>(){

            @Override
            public MLText convert(String source) {
                return new MLText(source);
            }
        });
        INSTANCE.addConverter(String.class, Locale.class, new TypeConverter.Converter<String, Locale>(){

            @Override
            public Locale convert(String source) {
                return I18NUtil.parseLocale((String)source);
            }
        });
        INSTANCE.addConverter(String.class, Period.class, new TypeConverter.Converter<String, Period>(){

            @Override
            public Period convert(String source) {
                return new Period(source);
            }
        });
        INSTANCE.addConverter(String.class, VersionNumber.class, new TypeConverter.Converter<String, VersionNumber>(){

            @Override
            public VersionNumber convert(String source) {
                return new VersionNumber(source);
            }
        });
        INSTANCE.addConverter(Locale.class, String.class, new TypeConverter.Converter<Locale, String>(){

            @Override
            public String convert(Locale source) {
                String localeStr = source.toString();
                if (localeStr.length() < 6) {
                    localeStr = localeStr + "_";
                }
                return localeStr;
            }
        });
        INSTANCE.addConverter(VersionNumber.class, String.class, new TypeConverter.Converter<VersionNumber, String>(){

            @Override
            public String convert(VersionNumber source) {
                return source.toString();
            }
        });
        INSTANCE.addConverter(MLText.class, String.class, new TypeConverter.Converter<MLText, String>(){

            @Override
            public String convert(MLText source) {
                return source.getDefaultValue();
            }
        });
        INSTANCE.addConverter(Enum.class, String.class, new TypeConverter.Converter<Enum, String>(){

            @Override
            public String convert(Enum source) {
                return source.toString();
            }
        });
        INSTANCE.addConverter(Period.class, String.class, new TypeConverter.Converter<Period, String>(){

            @Override
            public String convert(Period source) {
                return source.toString();
            }
        });
        INSTANCE.addConverter(Class.class, String.class, new TypeConverter.Converter<Class, String>(){

            @Override
            public String convert(Class source) {
                return source.getName();
            }
        });
        INSTANCE.addConverter(Number.class, Boolean.class, new TypeConverter.Converter<Number, Boolean>(){

            @Override
            public Boolean convert(Number source) {
                return new Boolean(source.longValue() > 0L);
            }
        });
        INSTANCE.addConverter(Number.class, Byte.class, new TypeConverter.Converter<Number, Byte>(){

            @Override
            public Byte convert(Number source) {
                return source.byteValue();
            }
        });
        INSTANCE.addConverter(Number.class, Short.class, new TypeConverter.Converter<Number, Short>(){

            @Override
            public Short convert(Number source) {
                return source.shortValue();
            }
        });
        INSTANCE.addConverter(Number.class, Integer.class, new TypeConverter.Converter<Number, Integer>(){

            @Override
            public Integer convert(Number source) {
                return source.intValue();
            }
        });
        INSTANCE.addConverter(Number.class, Long.class, new TypeConverter.Converter<Number, Long>(){

            @Override
            public Long convert(Number source) {
                return source.longValue();
            }
        });
        INSTANCE.addConverter(Number.class, Float.class, new TypeConverter.Converter<Number, Float>(){

            @Override
            public Float convert(Number source) {
                return Float.valueOf(source.floatValue());
            }
        });
        INSTANCE.addConverter(Number.class, Double.class, new TypeConverter.Converter<Number, Double>(){

            @Override
            public Double convert(Number source) {
                return source.doubleValue();
            }
        });
        INSTANCE.addConverter(Number.class, Date.class, new TypeConverter.Converter<Number, Date>(){

            @Override
            public Date convert(Number source) {
                return new Date(source.longValue());
            }
        });
        INSTANCE.addConverter(Number.class, String.class, new TypeConverter.Converter<Number, String>(){

            @Override
            public String convert(Number source) {
                return source.toString();
            }
        });
        INSTANCE.addConverter(Number.class, BigInteger.class, new TypeConverter.Converter<Number, BigInteger>(){

            @Override
            public BigInteger convert(Number source) {
                if (source instanceof BigDecimal) {
                    return ((BigDecimal)source).toBigInteger();
                }
                return BigInteger.valueOf(source.longValue());
            }
        });
        INSTANCE.addConverter(Number.class, BigDecimal.class, new TypeConverter.Converter<Number, BigDecimal>(){

            @Override
            public BigDecimal convert(Number source) {
                if (source instanceof BigInteger) {
                    return new BigDecimal((BigInteger)source);
                }
                return BigDecimal.valueOf(source.longValue());
            }
        });
        INSTANCE.addDynamicTwoStageConverter(Number.class, String.class, InputStream.class);
        INSTANCE.addConverter(Timestamp.class, Date.class, new TypeConverter.Converter<Timestamp, Date>(){

            @Override
            public Date convert(Timestamp source) {
                return new Date(source.getTime());
            }
        });
        INSTANCE.addConverter(Date.class, Number.class, new TypeConverter.Converter<Date, Number>(){

            @Override
            public Number convert(Date source) {
                return source.getTime();
            }
        });
        INSTANCE.addConverter(Date.class, String.class, new TypeConverter.Converter<Date, String>(){

            @Override
            public String convert(Date source) {
                try {
                    return ISO8601DateFormat.format((Date)source);
                }
                catch (PlatformRuntimeException e) {
                    throw new TypeConversionException("Failed to convert date " + source + " to string", e);
                }
            }
        });
        INSTANCE.addConverter(Date.class, Calendar.class, new TypeConverter.Converter<Date, Calendar>(){

            @Override
            public Calendar convert(Date source) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(source);
                return calendar;
            }
        });
        INSTANCE.addDynamicTwoStageConverter(Date.class, String.class, InputStream.class);
        final Long LONG_FALSE = new Long(0L);
        final Long LONG_TRUE = new Long(1L);
        INSTANCE.addConverter(Boolean.class, Long.class, new TypeConverter.Converter<Boolean, Long>(){

            @Override
            public Long convert(Boolean source) {
                return source != false ? LONG_TRUE : LONG_FALSE;
            }
        });
        INSTANCE.addConverter(Boolean.class, String.class, new TypeConverter.Converter<Boolean, String>(){

            @Override
            public String convert(Boolean source) {
                return source.toString();
            }
        });
        INSTANCE.addDynamicTwoStageConverter(Boolean.class, String.class, InputStream.class);
        INSTANCE.addConverter(Character.class, String.class, new TypeConverter.Converter<Character, String>(){

            @Override
            public String convert(Character source) {
                return source.toString();
            }
        });
        INSTANCE.addDynamicTwoStageConverter(Character.class, String.class, InputStream.class);
        INSTANCE.addConverter(Duration.class, String.class, new TypeConverter.Converter<Duration, String>(){

            @Override
            public String convert(Duration source) {
                return source.toString();
            }
        });
        INSTANCE.addDynamicTwoStageConverter(Duration.class, String.class, InputStream.class);
        INSTANCE.addConverter(Byte.class, String.class, new TypeConverter.Converter<Byte, String>(){

            @Override
            public String convert(Byte source) {
                return source.toString();
            }
        });
        INSTANCE.addDynamicTwoStageConverter(Byte.class, String.class, InputStream.class);
        INSTANCE.addConverter(Short.class, String.class, new TypeConverter.Converter<Short, String>(){

            @Override
            public String convert(Short source) {
                return source.toString();
            }
        });
        INSTANCE.addDynamicTwoStageConverter(Short.class, String.class, InputStream.class);
        INSTANCE.addConverter(Integer.class, String.class, new TypeConverter.Converter<Integer, String>(){

            @Override
            public String convert(Integer source) {
                return source.toString();
            }
        });
        INSTANCE.addDynamicTwoStageConverter(Integer.class, String.class, InputStream.class);
        INSTANCE.addConverter(Long.class, String.class, new TypeConverter.Converter<Long, String>(){

            @Override
            public String convert(Long source) {
                return source.toString();
            }
        });
        INSTANCE.addDynamicTwoStageConverter(Long.class, String.class, InputStream.class);
        INSTANCE.addConverter(Float.class, String.class, new TypeConverter.Converter<Float, String>(){

            @Override
            public String convert(Float source) {
                return source.toString();
            }
        });
        INSTANCE.addDynamicTwoStageConverter(Float.class, String.class, InputStream.class);
        INSTANCE.addConverter(Double.class, String.class, new TypeConverter.Converter<Double, String>(){

            @Override
            public String convert(Double source) {
                return source.toString();
            }
        });
        INSTANCE.addDynamicTwoStageConverter(Double.class, String.class, InputStream.class);
        INSTANCE.addConverter(BigInteger.class, String.class, new TypeConverter.Converter<BigInteger, String>(){

            @Override
            public String convert(BigInteger source) {
                return source.toString();
            }
        });
        INSTANCE.addDynamicTwoStageConverter(BigInteger.class, String.class, InputStream.class);
        INSTANCE.addConverter(Calendar.class, Date.class, new TypeConverter.Converter<Calendar, Date>(){

            @Override
            public Date convert(Calendar source) {
                return source.getTime();
            }
        });
        INSTANCE.addConverter(Calendar.class, String.class, new TypeConverter.Converter<Calendar, String>(){

            @Override
            public String convert(Calendar source) {
                try {
                    return ISO8601DateFormat.format((Date)source.getTime());
                }
                catch (PlatformRuntimeException e) {
                    throw new TypeConversionException("Failed to convert date " + source + " to string", e);
                }
            }
        });
        INSTANCE.addConverter(BigDecimal.class, String.class, new TypeConverter.Converter<BigDecimal, String>(){

            @Override
            public String convert(BigDecimal source) {
                return source.toString();
            }
        });
        INSTANCE.addDynamicTwoStageConverter(BigDecimal.class, String.class, InputStream.class);
        INSTANCE.addConverter(QName.class, String.class, new TypeConverter.Converter<QName, String>(){

            @Override
            public String convert(QName source) {
                return source.toString();
            }
        });
        INSTANCE.addDynamicTwoStageConverter(QName.class, String.class, InputStream.class);
        INSTANCE.addConverter(EntityRef.class, String.class, new TypeConverter.Converter<EntityRef, String>(){

            @Override
            public String convert(EntityRef source) {
                return source.toString();
            }
        });
        INSTANCE.addDynamicTwoStageConverter(EntityRef.class, String.class, InputStream.class);
        INSTANCE.addConverter(ContentData.class, String.class, new TypeConverter.Converter<ContentData, String>(){

            @Override
            public String convert(ContentData source) {
                return source.getInfoUrl();
            }
        });
        INSTANCE.addDynamicTwoStageConverter(ContentData.class, String.class, InputStream.class);
        INSTANCE.addConverter(Path.class, String.class, new TypeConverter.Converter<Path, String>(){

            @Override
            public String convert(Path source) {
                return source.toString();
            }
        });
        INSTANCE.addDynamicTwoStageConverter(Path.class, String.class, InputStream.class);
        INSTANCE.addConverter(ContentReader.class, InputStream.class, new TypeConverter.Converter<ContentReader, InputStream>(){

            @Override
            public InputStream convert(ContentReader source) {
                return source.getContentInputStream();
            }
        });
        INSTANCE.addConverter(ContentReader.class, String.class, new TypeConverter.Converter<ContentReader, String>(){

            @Override
            public String convert(ContentReader source) {
                return source.toString();
            }
        });
        INSTANCE.addConverter(ContentWriter.class, String.class, new TypeConverter.Converter<ContentWriter, String>(){

            @Override
            public String convert(ContentWriter source) {
                return source.toString();
            }
        });
        INSTANCE.addConverter(InputStream.class, String.class, new TypeConverter.Converter<InputStream, String>(){

            @Override
            public String convert(InputStream source) {
                try {
                    int read;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] buffer = new byte[8192];
                    while ((read = source.read(buffer)) > 0) {
                        out.write(buffer, 0, read);
                    }
                    byte[] data = out.toByteArray();
                    String string = new String(data, "UTF-8");
                    return string;
                }
                catch (UnsupportedEncodingException e) {
                    throw new TypeConversionException("Cannot convert input stream to String.", e);
                }
                catch (IOException e) {
                    throw new TypeConversionException("Conversion from stream to string failed", e);
                }
                finally {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        });
        INSTANCE.addDynamicTwoStageConverter(InputStream.class, String.class, Date.class);
        INSTANCE.addDynamicTwoStageConverter(InputStream.class, String.class, Double.class);
        INSTANCE.addDynamicTwoStageConverter(InputStream.class, String.class, Long.class);
        INSTANCE.addDynamicTwoStageConverter(InputStream.class, String.class, Boolean.class);
        INSTANCE.addDynamicTwoStageConverter(InputStream.class, String.class, QName.class);
        INSTANCE.addDynamicTwoStageConverter(InputStream.class, String.class, Path.class);
        INSTANCE.addDynamicTwoStageConverter(InputStream.class, String.class, NodeRef.class);
    }
}

