/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.xobject;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDIndexed;
import org.apache.pdfbox.pdmodel.graphics.predictor.PredictorAlgorithm;
import org.apache.pdfbox.pdmodel.graphics.xobject.CompositeImage;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class PDPixelMap
extends PDXObjectImage {
    private static final Log log = LogFactory.getLog(PDPixelMap.class);
    private BufferedImage image = null;

    public PDPixelMap(PDStream pdStream) {
        super(pdStream, "png");
    }

    public BufferedImage getRGBImage() throws IOException {
        if (this.image != null) {
            return this.image;
        }
        try {
            byte[] map;
            int width = this.getWidth();
            int height = this.getHeight();
            int bpc = this.getBitsPerComponent();
            int predictor = this.getPredictor();
            List filters = this.getPDStream().getFilters();
            byte[] array = this.getPDStream().getByteArray();
            PDColorSpace colorspace = this.getColorSpace();
            if (colorspace == null) {
                log.error((Object)("getColorSpace() returned NULL.  Predictor = " + this.getPredictor()));
                return null;
            }
            ColorModel cm = null;
            if (bpc == 1) {
                COSArray decode;
                map = null;
                map = colorspace instanceof PDDeviceGray ? ((decode = this.getDecode()) != null && decode.getInt(0) == 1 ? new byte[]{-1} : new byte[]{0, -1}) : (colorspace instanceof PDICCBased ? (((PDICCBased)colorspace).getNumberOfComponents() == 1 ? new byte[]{-1} : new byte[]{0, -1}) : new byte[]{0, -1});
                cm = new IndexColorModel(bpc, map.length, map, map, map, 1);
            } else if (colorspace instanceof PDICCBased) {
                if (((PDICCBased)colorspace).getNumberOfComponents() == 1) {
                    map = new byte[]{-1};
                    cm = new IndexColorModel(bpc, 1, map, map, map, 1);
                } else {
                    cm = colorspace.createColorModel(bpc);
                }
            } else if (colorspace instanceof PDIndexed) {
                PDIndexed csIndexed = (PDIndexed)colorspace;
                ColorModel baseColorModel = csIndexed.getBaseColorSpace().createColorModel(bpc);
                int size = csIndexed.getHighValue();
                byte[] index = csIndexed.getLookupData();
                COSArray decode = this.getDecode();
                boolean isOpaque = decode != null && decode.getInt(0) == 1;
                boolean hasAlpha = baseColorModel.hasAlpha();
                if (baseColorModel.getTransferType() != 0) {
                    throw new IOException("Not implemented");
                }
                byte[] r = new byte[size + 1];
                byte[] g = new byte[size + 1];
                byte[] b = new byte[size + 1];
                byte[] a = new byte[size + 1];
                byte[] inData = new byte[baseColorModel.getNumComponents()];
                for (int i = 0; i <= size; ++i) {
                    System.arraycopy(index, i * inData.length, inData, 0, inData.length);
                    r[i] = (byte)baseColorModel.getRed(inData);
                    g[i] = (byte)baseColorModel.getGreen(inData);
                    b[i] = (byte)baseColorModel.getBlue(inData);
                    a[i] = hasAlpha ? (int)baseColorModel.getAlpha(inData) : (isOpaque ? -1 : 0);
                }
                cm = new IndexColorModel(bpc, size + 1, r, g, b, a);
            } else {
                cm = colorspace.createColorModel(bpc);
            }
            log.info((Object)("ColorModel: " + cm.toString()));
            WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
            DataBufferByte buffer = (DataBufferByte)raster.getDataBuffer();
            byte[] bufferData = buffer.getData();
            if (predictor < 10 || filters == null || !filters.contains(COSName.LZW_DECODE.getName()) && !filters.contains(COSName.FLATE_DECODE.getName())) {
                PredictorAlgorithm filter = PredictorAlgorithm.getFilter(predictor);
                filter.setWidth(width);
                filter.setHeight(height);
                filter.setBpp(bpc * 3 / 8);
            }
            System.arraycopy(array, 0, bufferData, 0, array.length < bufferData.length ? array.length : bufferData.length);
            this.image = new BufferedImage(cm, raster, false, null);
            PDXObjectImage smask = this.getSMaskImage();
            if (smask != null) {
                BufferedImage smaskBI = smask.getRGBImage();
                COSArray decodeArray = smask.getDecode();
                CompositeImage compositeImage = new CompositeImage(this.image, smaskBI);
                BufferedImage rgbImage = compositeImage.createMaskedImage(decodeArray);
                return rgbImage;
            }
            return this.image;
        }
        catch (Exception exception) {
            log.error((Object)exception, (Throwable)exception);
            return null;
        }
    }

    public void write2OutputStream(OutputStream out) throws IOException {
        this.getRGBImage();
        if (this.image != null) {
            ImageIO.write((RenderedImage)this.image, "png", out);
        }
    }

    public COSDictionary getDecodeParams() {
        COSBase decodeParms = this.getCOSStream().getDictionaryObject(COSName.DECODE_PARMS);
        if (decodeParms != null) {
            if (decodeParms instanceof COSDictionary) {
                return (COSDictionary)decodeParms;
            }
            if (decodeParms instanceof COSArray) {
                return null;
            }
            return null;
        }
        return null;
    }

    public int getPredictor() {
        int i;
        COSDictionary decodeParms = this.getDecodeParams();
        if (decodeParms != null && (i = decodeParms.getInt(COSName.PREDICTOR)) != -1) {
            return i;
        }
        return 1;
    }
}

