/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encoding;

import com.glaforge.i18n.io.CharsetToolkit;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.alfresco.encoding.AbstractCharactersetFinder;

public class GuessEncodingCharsetFinder
extends AbstractCharactersetFinder {
    private static final Charset DUMMY_CHARSET = new DummyCharset();

    protected Charset detectCharsetImpl(byte[] buffer) throws Exception {
        CharsetToolkit charsetToolkit = new CharsetToolkit(buffer, DUMMY_CHARSET);
        charsetToolkit.setEnforce8Bit(true);
        Charset charset = charsetToolkit.guessEncoding();
        if (charset == DUMMY_CHARSET) {
            return null;
        }
        return charset;
    }

    public static class DummyCharset
    extends Charset {
        DummyCharset() {
            super("dummy", new String[0]);
        }

        public boolean contains(Charset cs) {
            throw new UnsupportedOperationException();
        }

        public CharsetDecoder newDecoder() {
            throw new UnsupportedOperationException();
        }

        public CharsetEncoder newEncoder() {
            throw new UnsupportedOperationException();
        }
    }
}

