/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.ibatis;

import com.ibatis.common.xml.NodeletException;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.engine.builder.xml.SqlMapParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.alfresco.ibatis.HierarchicalSqlMapConfigParser;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.resource.HierarchicalResourceLoader;
import org.springframework.core.NestedIOException;
import org.springframework.core.io.Resource;
import org.springframework.orm.ibatis.SqlMapClientFactoryBean;
import org.springframework.util.ObjectUtils;

public class HierarchicalSqlMapClientFactoryBean
extends SqlMapClientFactoryBean {
    private HierarchicalResourceLoader resourceLoader;

    public void setResourceLoader(HierarchicalResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, "resourceLoader", (Object)this.resourceLoader);
        super.afterPropertiesSet();
    }

    protected SqlMapClient buildSqlMapClient(Resource[] configLocations, Resource[] mappingLocations, Properties properties) throws IOException {
        if (ObjectUtils.isEmpty((Object[])configLocations)) {
            throw new IllegalArgumentException("At least 1 'configLocation' entry is required");
        }
        SqlMapClient client = null;
        HierarchicalSqlMapConfigParser configParser = new HierarchicalSqlMapConfigParser(this.resourceLoader);
        for (Resource configLocation : configLocations) {
            InputStream is = configLocation.getInputStream();
            try {
                client = properties == null ? configParser.parse(is) : configParser.parse(is, properties);
            }
            catch (RuntimeException ex) {
                throw new NestedIOException("Failed to parse config resource: " + configLocation, ex.getCause());
            }
        }
        if (mappingLocations != null) {
            SqlMapParser mapParser = new SqlMapParser(configParser.state);
            for (Resource mappingLocation : mappingLocations) {
                try {
                    mapParser.parse(mappingLocation.getInputStream());
                }
                catch (NodeletException ex) {
                    throw new NestedIOException("Failed to parse mapping resource: " + mappingLocation, (Throwable)ex);
                }
            }
        }
        return client;
    }
}

