/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.exec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.exec.RuntimeExec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeExecBootstrapBean
extends AbstractLifecycleBean {
    private static Log logger = LogFactory.getLog(RuntimeExecBootstrapBean.class);
    private List<RuntimeExec> startupCommands = Collections.emptyList();
    private boolean failOnError = true;
    private boolean killProcessesOnShutdown = true;
    private boolean enabled = true;
    private List<RuntimeExec.ExecutionResult> executionResults = new ArrayList<RuntimeExec.ExecutionResult>(1);
    private Thread shutdownThread;

    public void setStartupCommands(List<RuntimeExec> startupCommands) {
        this.startupCommands = startupCommands;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setKillProcessesOnShutdown(boolean killProcessesOnShutdown) {
        this.killProcessesOnShutdown = killProcessesOnShutdown;
    }

    public void setDisabledAtStartUp(String disabledAtStartUp) {
        boolean disabled = Boolean.parseBoolean(disabledAtStartUp);
        this.setEnabled(Boolean.toString(!disabled));
    }

    public void setEnabled(String enabled) {
        this.enabled = Boolean.parseBoolean(enabled);
    }

    protected synchronized void onBootstrap(ApplicationEvent event) {
        if (!this.enabled) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Bootstrap execution of " + this.startupCommands.size() + " was not enabled"));
            }
            return;
        }
        for (RuntimeExec command : this.startupCommands) {
            RuntimeExec.ExecutionResult result = command.execute();
            if (!result.getSuccess()) {
                String msg = "Bootstrap command failed: \n" + result;
                if (this.failOnError) {
                    throw new AlfrescoRuntimeException(msg);
                }
                logger.error((Object)msg);
                continue;
            }
            this.executionResults.add(result);
        }
        if (this.killProcessesOnShutdown) {
            this.shutdownThread = new KillProcessShutdownThread();
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bootstrap execution of " + this.startupCommands.size() + " commands was successful"));
        }
    }

    protected synchronized void onShutdown(ApplicationEvent event) {
        if (!this.enabled) {
            return;
        }
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            this.doShutdown();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void doShutdown() {
        if (!this.killProcessesOnShutdown) {
            return;
        }
        for (RuntimeExec.ExecutionResult executionResult : this.executionResults) {
            executionResult.killProcess();
        }
    }

    private class KillProcessShutdownThread
    extends Thread {
        private KillProcessShutdownThread() {
        }

        public void run() {
            RuntimeExecBootstrapBean.this.doShutdown();
        }
    }
}

