/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.exec;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import junit.framework.TestCase;
import org.alfresco.util.exec.RuntimeExec;

public class RuntimeExecTest
extends TestCase {
    public void testStreams() throws Exception {
        RuntimeExec exec = new RuntimeExec();
        HashMap<String, String[]> commandMap = new HashMap<String, String[]>(5);
        commandMap.put("*", new String[]{"find", "/", "-maxdepth", "1", "-name", "var"});
        commandMap.put("Windows.*", new String[]{"find", "/?"});
        exec.setCommandsAndArguments(commandMap);
        RuntimeExec.ExecutionResult ret = exec.execute();
        String out = ret.getStdOut();
        String err = ret.getStdErr();
        RuntimeExecTest.assertEquals((String)"Didn't expect error code", (int)0, (int)ret.getExitValue());
        RuntimeExecTest.assertEquals((String)"Didn't expect any error output", (int)0, (int)err.length());
        RuntimeExecTest.assertTrue((String)"No output found", (out.length() > 0 ? 1 : 0) != 0);
    }

    public void testWildcard() throws Exception {
        RuntimeExec exec = new RuntimeExec();
        HashMap<String, String[]> commandMap = new HashMap<String, String[]>(3, 1.0f);
        commandMap.put(".*", new String[]{"TEST"});
        exec.setCommandsAndArguments(commandMap);
        Object[] commandStr = exec.getCommand();
        RuntimeExecTest.assertTrue((String)"Expected default match to work", (boolean)Arrays.deepEquals(new String[]{"TEST"}, commandStr));
    }

    public void testWithProperties() throws Exception {
        RuntimeExec exec = new RuntimeExec();
        HashMap<String, String[]> commandMap = new HashMap<String, String[]>(3, 1.0f);
        commandMap.put("Windows.*", new String[]{"dir", "${path}"});
        commandMap.put("Linux", new String[]{"ls", "${path}"});
        commandMap.put("Mac OS X", new String[]{"ls", "${path}"});
        commandMap.put("*", new String[]{"wibble", "${path}"});
        exec.setCommandsAndArguments(commandMap);
        HashMap<String, String> defaultProperties = new HashMap<String, String>(1, 1.0f);
        defaultProperties.put("path", ".");
        exec.setDefaultProperties(defaultProperties);
        Object[] defaultCommand = exec.getCommand();
        Object[] dynamicCommand = exec.getCommand(Collections.singletonMap("path", "./"));
        String os = System.getProperty("os.name");
        Object[] defaultCommandCheck = null;
        Object[] dynamicCommandCheck = null;
        if (os.matches("Windows.*")) {
            defaultCommandCheck = new String[]{"dir", "."};
            dynamicCommandCheck = new String[]{"dir", "./"};
        } else if (os.equals("Linux") || os.equals("Mac OS X")) {
            defaultCommandCheck = new String[]{"ls", "."};
            dynamicCommandCheck = new String[]{"ls", "./"};
        } else {
            defaultCommandCheck = new String[]{"wibble", "."};
            dynamicCommandCheck = new String[]{"wibble", "./"};
        }
        RuntimeExecTest.assertTrue((String)("Default command for OS " + os + " is incorrect"), (boolean)Arrays.deepEquals(defaultCommandCheck, defaultCommand));
        RuntimeExecTest.assertTrue((String)("Dynamic command for OS " + os + " is incorrect"), (boolean)Arrays.deepEquals(dynamicCommandCheck, dynamicCommand));
    }
}

